<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Sign Up - MarketChain Educative Club</title>
  <meta name="description" content="Join MarketChain Educative Club by creating your account and unlock exclusive access to our educational platform.">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Black & White Theme CSS -->
  <style>
    /* Global Styles */
    body {
      margin: 0;
      padding: 0;
      background-color: #000;
      color: #fff;
      font-family: Arial, sans-serif;
    }
    .container {
      max-width: 600px;
      margin: 0 auto;
      padding: 20px;
    }
    h1 {
      text-align: center;
    }
    p {
      text-align: center;
    }
    /* Form Styles */
    form {
      margin-top: 20px;
    }
    .form-group {
      margin-bottom: 15px;
      position: relative;
    }
    label {
      display: block;
      margin-bottom: 5px;
    }
    input[type="text"],
    input[type="email"],
    input[type="password"],
    input[type="tel"],
    select {
      width: 100%;
      padding: 10px;
      border: 1px solid #fff;
      background: #000;
      color: #fff;
      border-radius: 4px;
      box-sizing: border-box;
    }
    .btn {
      background-color: #fff;
      color: #000;
      padding: 10px 20px;
      border: none;
      cursor: pointer;
      border-radius: 4px;
      width: 100%;
      font-size: 16px;
    }
    .btn:hover {
      opacity: 0.8;
    }
    /* Password Toggle Button */
    .password-toggle {
      position: absolute;
      right: 10px;
      top: 38px;
      cursor: pointer;
      font-size: 14px;
      color: #fff;
      background: none;
      border: none;
    }
    /* Password Strength Indicator */
    .password-strength {
      margin-top: 5px;
      font-size: 14px;
    }
    .strength-weak {
      color: red;
    }
    .strength-medium {
      color: orange;
    }
    .strength-strong {
      color: lime;
    }
    /* Country Dropdown Styles */
    .country-dropdown {
      position: relative;
    }
    .country-list {
      position: absolute;
      top: 100%;
      left: 0;
      right: 0;
      background: #000;
      border: 1px solid #fff;
      max-height: 150px;
      overflow-y: auto;
      z-index: 1000;
    }
    .country-item {
      padding: 10px;
      cursor: pointer;
    }
    .country-item:hover {
      background-color: #222;
    }
    /* Modal Styles */
    .modal {
      display: none;
      position: fixed;
      z-index: 2000;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      overflow: auto;
      background-color: rgba(0,0,0,0.8);
    }
    .modal-content {
      background-color: #000;
      margin: 10% auto;
      padding: 20px;
      border: 1px solid #fff;
      width: 80%;
      max-width: 500px;
      border-radius: 8px;
    }
    .close-modal {
      color: #fff;
      float: right;
      font-size: 28px;
      font-weight: bold;
      cursor: pointer;
    }
    .modal h2 {
      margin-top: 0;
    }
    /* Terms & Conditions Links */
    .terms-links {
      text-align: center;
      margin-top: 15px;
    }
    .terms-links a {
      color: #fff;
      text-decoration: underline;
      cursor: pointer;
    }
  </style>
</head>
<body>
  <div class="container">

    <div data-animation="default" data-collapse="all" data-duration="400" data-easing="ease" data-easing2="ease" role="banner" class="header-wrapper v3 w-nav">
        <div class="container-default w-container">
            <div data-w-id="8a509f85-669e-3811-d5fb-eaefc7533abf" class="header-container-wrapper center" style="opacity: 1;">
                <div class="logo-wrapper v1"><a href="/" class="logo-link w-inline-block">
                    <img src="https://marketchainx.com/logo-short.svg" loading="eager" alt="Header Logo"></a>
                </div>
            </div>
        </div>
        <div class="w-nav-overlay" data-wf-ignore="" id="w-nav-overlay-0"></div>
    </div>
    <h1>Create an Account</h1>
    <p>Join MarketChain Educative Club. Fill in your details below to get started!</p>


    <form id="signup-form" method="post" action="signup.php">
      <!-- Full Name -->
      <div class="form-group">
        <label for="fullname">Full Name</label>
        <input type="text" id="fullname" name="fullname" required placeholder="Enter your full name">
      </div>
      <!-- Username -->
      <div class="form-group">
        <label for="username">Username</label>
        <input type="text" id="username" name="username" required placeholder="Choose a username">
      </div>
      <!-- Email -->
      <div class="form-group">
        <label for="email">Email address</label>
        <input type="email" id="email" name="email" required placeholder="Enter your email address">
      </div>
      <!-- Country (Searchable with Flags) -->
      <div class="form-group country-dropdown">
        <label for="country">Country</label>
        <input type="text" id="country" name="country" autocomplete="off" placeholder="Search for your country" required>
        <div id="country-list" class="country-list"></div>
      </div>
      <!-- Currency -->
      <div class="form-group">
        <label for="currency">Select Currency</label>
        <select id="currency" name="currency" required>
          <option value="">Choose your currency</option>
          <option value="USD">USD ($)</option>
          <option value="EUR">EUR (€)</option>
          <option value="GBP">GBP (£)</option>
          <option value="JPY">JPY (¥)</option>
          <option value="AUD">AUD (A$)</option>
          <option value="CAD">CAD (C$)</option>
          <option value="CHF">CHF (₣)</option>
          <option value="CNY">CNY (¥)</option>
        </select>
      </div>
      <!-- Phone -->
      <div class="form-group">
        <label for="phone">Phone</label>
        <input type="tel" id="phone" name="phone" required placeholder="Enter your phone number">
      </div>
      <!-- Password with Strength Indicator and Toggle -->
      <div class="form-group">
        <label for="password">Password</label>
        <input type="password" id="password" name="password" required placeholder="Enter your password">
        <button type="button" class="password-toggle" id="toggle-password">Show</button>
        <div id="password-strength-text" class="password-strength"></div>
      </div>
      <!-- Confirm Password with Toggle -->
      <div class="form-group">
        <label for="confirm_password">Confirm Password</label>
        <input type="password" id="confirm_password" name="confirm_password" required placeholder="Re-enter your password">
        <button type="button" class="password-toggle" id="toggle-confirm-password">Show</button>
      </div>
      <!-- Terms and Conditions Agreement -->
      <div class="form-group">
        <input type="checkbox" id="agree" name="agree" required>
        <label for="agree" style="display: inline;">
          I agree to the <a href="#" class="open-modal">Terms &amp; Conditions</a> and 
          <a href="#" class="open-modal">Privacy Policy</a>.
        </label>
      </div>
      <input type="submit" class="btn" value="Sign Up">
    </form>
  </div>

  <!-- Modal for T&C and Privacy Policy -->
  <div id="modal-tc" class="modal">
    <div class="modal-content">
      <span class="close-modal" id="close-modal">&times;</span>
      <h2>Terms &amp; Conditions and Privacy Policy</h2>
      <p>
        Welcome to MarketChain Educative Club. These Terms &amp; Conditions and Privacy Policy govern your use of our platform for trading and education in both the forex and cryptocurrency markets. Please read them carefully before using our services.
      </p>
      <p>
        By creating an account, you agree to abide by these policies. We ensure that your data is securely stored and that your trading information is treated with the utmost confidentiality.
      </p>
      <p>
        Please note that trading in forex and crypto involves significant risk. It is your responsibility to understand and mitigate these risks.
      </p>
    </div>
  </div>

  <!-- JavaScript Code -->
  <script>
    // ===== Country Dropdown with Search and Flags =====
    const countries = [
  { name: "Afghanistan", flag: "🇦🇫" },
  { name: "Albania", flag: "🇦🇱" },
  { name: "Algeria", flag: "🇩🇿" },
  { name: "Andorra", flag: "🇦🇩" },
  { name: "Angola", flag: "🇦🇴" },
  { name: "Antigua and Barbuda", flag: "🇦🇬" },
  { name: "Argentina", flag: "🇦🇷" },
  { name: "Armenia", flag: "🇦🇲" },
  { name: "Australia", flag: "🇦🇺" },
  { name: "Austria", flag: "🇦🇹" },
  { name: "Azerbaijan", flag: "🇦🇿" },
  { name: "Bahamas", flag: "🇧🇸" },
  { name: "Bahrain", flag: "🇧🇭" },
  { name: "Bangladesh", flag: "🇧🇩" },
  { name: "Barbados", flag: "🇧🇧" },
  { name: "Belarus", flag: "🇧🇾" },
  { name: "Belgium", flag: "🇧🇪" },
  { name: "Belize", flag: "🇧🇿" },
  { name: "Benin", flag: "🇧🇯" },
  { name: "Bhutan", flag: "🇧🇹" },
  { name: "Bolivia", flag: "🇧🇴" },
  { name: "Bosnia and Herzegovina", flag: "🇧🇦" },
  { name: "Botswana", flag: "🇧🇼" },
  { name: "Brazil", flag: "🇧🇷" },
  { name: "Brunei", flag: "🇧🇳" },
  { name: "Bulgaria", flag: "🇧🇬" },
  { name: "Burkina Faso", flag: "🇧🇫" },
  { name: "Burundi", flag: "🇧🇮" },
  { name: "Cabo Verde", flag: "🇨🇻" },
  { name: "Cambodia", flag: "🇰🇭" },
  { name: "Cameroon", flag: "🇨🇲" },
  { name: "Canada", flag: "🇨🇦" },
  { name: "Central African Republic", flag: "🇨🇫" },
  { name: "Chad", flag: "🇹🇩" },
  { name: "Chile", flag: "🇨🇱" },
  { name: "China", flag: "🇨🇳" },
  { name: "Colombia", flag: "🇨🇴" },
  { name: "Comoros", flag: "🇰🇲" },
  { name: "Congo (Brazzaville)", flag: "🇨🇬" },
  { name: "Congo (Kinshasa)", flag: "🇨🇩" },
  { name: "Costa Rica", flag: "🇨🇷" },
  { name: "Croatia", flag: "🇭🇷" },
  { name: "Cuba", flag: "🇨🇺" },
  { name: "Cyprus", flag: "🇨🇾" },
  { name: "Czechia (Czech Republic)", flag: "🇨🇿" },
  { name: "Denmark", flag: "🇩🇰" },
  { name: "Djibouti", flag: "🇩🇯" },
  { name: "Dominica", flag: "🇩🇲" },
  { name: "Dominican Republic", flag: "🇩🇴" },
  { name: "Ecuador", flag: "🇪🇨" },
  { name: "Egypt", flag: "🇪🇬" },
  { name: "El Salvador", flag: "🇸🇻" },
  { name: "Equatorial Guinea", flag: "🇬🇶" },
  { name: "Eritrea", flag: "🇪🇷" },
  { name: "Estonia", flag: "🇪🇪" },
  { name: "Eswatini", flag: "🇸🇿" },
  { name: "Ethiopia", flag: "🇪🇹" },
  { name: "Fiji", flag: "🇫🇯" },
  { name: "Finland", flag: "🇫🇮" },
  { name: "France", flag: "🇫🇷" },
  { name: "Gabon", flag: "🇬🇦" },
  { name: "Gambia", flag: "🇬🇲" },
  { name: "Georgia", flag: "🇬🇪" },
  { name: "Germany", flag: "🇩🇪" },
  { name: "Ghana", flag: "🇬🇭" },
  { name: "Greece", flag: "🇬🇷" },
  { name: "Grenada", flag: "🇬🇩" },
  { name: "Guatemala", flag: "🇬🇹" },
  { name: "Guinea", flag: "🇬🇳" },
  { name: "Guinea-Bissau", flag: "🇬🇼" },
  { name: "Guyana", flag: "🇬🇾" },
  { name: "Haiti", flag: "🇭🇹" },
  { name: "Holy See", flag: "🇻🇦" },
  { name: "Honduras", flag: "🇭🇳" },
  { name: "Hungary", flag: "🇭🇺" },
  { name: "Iceland", flag: "🇮🇸" },
  { name: "India", flag: "🇮🇳" },
  { name: "Indonesia", flag: "🇮🇩" },
  { name: "Iran", flag: "🇮🇷" },
  { name: "Iraq", flag: "🇮🇶" },
  { name: "Ireland", flag: "🇮🇪" },
  { name: "Israel", flag: "🇮🇱" },
  { name: "Italy", flag: "🇮🇹" },
  { name: "Jamaica", flag: "🇯🇲" },
  { name: "Japan", flag: "🇯🇵" },
  { name: "Jordan", flag: "🇯🇴" },
  { name: "Kazakhstan", flag: "🇰🇿" },
  { name: "Kenya", flag: "🇰🇪" },
  { name: "Kiribati", flag: "🇰🇮" },
  { name: "Korea, North", flag: "🇰🇵" },
  { name: "Korea, South", flag: "🇰🇷" },
  { name: "Kuwait", flag: "🇰🇼" },
  { name: "Kyrgyzstan", flag: "🇰🇬" },
  { name: "Laos", flag: "🇱🇦" },
  { name: "Latvia", flag: "🇱🇻" },
  { name: "Lebanon", flag: "🇱🇧" },
  { name: "Lesotho", flag: "🇱🇸" },
  { name: "Liberia", flag: "🇱🇷" },
  { name: "Libya", flag: "🇱🇾" },
  { name: "Liechtenstein", flag: "🇱🇮" },
  { name: "Lithuania", flag: "🇱🇹" },
  { name: "Luxembourg", flag: "🇱🇺" },
  { name: "Madagascar", flag: "🇲🇬" },
  { name: "Malawi", flag: "🇲🇼" },
  { name: "Malaysia", flag: "🇲🇾" },
  { name: "Maldives", flag: "🇲🇻" },
  { name: "Mali", flag: "🇲🇱" },
  { name: "Malta", flag: "🇲🇹" },
  { name: "Marshall Islands", flag: "🇲🇭" },
  { name: "Mauritania", flag: "🇲🇷" },
  { name: "Mauritius", flag: "🇲🇺" },
  { name: "Mexico", flag: "🇲🇽" },
  { name: "Micronesia", flag: "🇫🇲" },
  { name: "Moldova", flag: "🇲🇩" },
  { name: "Monaco", flag: "🇲🇨" },
  { name: "Mongolia", flag: "🇲🇳" },
  { name: "Montenegro", flag: "🇲🇪" },
  { name: "Morocco", flag: "🇲🇦" },
  { name: "Mozambique", flag: "🇲🇿" },
  { name: "Myanmar", flag: "🇲🇲" },
  { name: "Namibia", flag: "🇳🇦" },
  { name: "Nauru", flag: "🇳🇷" },
  { name: "Nepal", flag: "🇳🇵" },
  { name: "Netherlands", flag: "🇳🇱" },
  { name: "New Zealand", flag: "🇳🇿" },
  { name: "Nicaragua", flag: "🇳🇮" },
  { name: "Niger", flag: "🇳🇪" },
  { name: "Nigeria", flag: "🇳🇬" },
  { name: "North Macedonia", flag: "🇲🇰" },
  { name: "Norway", flag: "🇳🇴" },
  { name: "Oman", flag: "🇴🇲" },
  { name: "Pakistan", flag: "🇵🇰" },
  { name: "Palau", flag: "🇵🇼" },
  { name: "Panama", flag: "🇵🇦" },
  { name: "Papua New Guinea", flag: "🇵🇬" },
  { name: "Paraguay", flag: "🇵🇾" },
  { name: "Peru", flag: "🇵🇪" },
  { name: "Philippines", flag: "🇵🇭" },
  { name: "Poland", flag: "🇵🇱" },
  { name: "Portugal", flag: "🇵🇹" },
  { name: "Qatar", flag: "🇶🇦" },
  { name: "Romania", flag: "🇷🇴" },
  { name: "Russia", flag: "🇷🇺" },
  { name: "Rwanda", flag: "🇷🇼" },
  { name: "Saint Kitts and Nevis", flag: "🇰🇳" },
  { name: "Saint Lucia", flag: "🇱🇨" },
  { name: "Saint Vincent and the Grenadines", flag: "🇻🇨" },
  { name: "Samoa", flag: "🇼🇸" },
  { name: "San Marino", flag: "🇸🇲" },
  { name: "Sao Tome and Principe", flag: "🇸🇹" },
  { name: "Saudi Arabia", flag: "🇸🇦" },
  { name: "Senegal", flag: "🇸🇳" },
  { name: "Serbia", flag: "🇷🇸" },
  { name: "Seychelles", flag: "🇸🇨" },
  { name: "Sierra Leone", flag: "🇸🇱" },
  { name: "Singapore", flag: "🇸🇬" },
  { name: "Slovakia", flag: "🇸🇰" },
  { name: "Slovenia", flag: "🇸🇮" },
  { name: "Solomon Islands", flag: "🇸🇧" },
  { name: "Somalia", flag: "🇸🇴" },
  { name: "South Africa", flag: "🇿🇦" },
  { name: "South Sudan", flag: "🇸🇸" },
  { name: "Spain", flag: "🇪🇸" },
  { name: "Sri Lanka", flag: "🇱🇰" },
  { name: "Sudan", flag: "🇸🇩" },
  { name: "Suriname", flag: "🇸🇷" },
  { name: "Sweden", flag: "🇸🇪" },
  { name: "Switzerland", flag: "🇨🇭" },
  { name: "Syria", flag: "🇸🇾" },
  { name: "Tajikistan", flag: "🇹🇯" },
  { name: "Tanzania", flag: "🇹🇿" },
  { name: "Thailand", flag: "🇹🇭" },
  { name: "Timor-Leste", flag: "🇹🇱" },
  { name: "Togo", flag: "🇹🇬" },
  { name: "Tonga", flag: "🇹🇴" },
  { name: "Trinidad and Tobago", flag: "🇹🇹" },
  { name: "Tunisia", flag: "🇹🇳" },
  { name: "Turkey", flag: "🇹🇷" },
  { name: "Turkmenistan", flag: "🇹🇲" },
  { name: "Tuvalu", flag: "🇹🇻" },
  { name: "Uganda", flag: "🇺🇬" },
  { name: "Ukraine", flag: "🇺🇦" },
  { name: "United Arab Emirates", flag: "🇦🇪" },
  { name: "United Kingdom", flag: "🇬🇧" },
  { name: "United States", flag: "🇺🇸" },
  { name: "Uruguay", flag: "🇺🇾" },
  { name: "Uzbekistan", flag: "🇺🇿" },
  { name: "Vanuatu", flag: "🇻🇺" },
  { name: "Venezuela", flag: "🇻🇪" },
  { name: "Vietnam", flag: "🇻🇳" },
  { name: "Yemen", flag: "🇾🇪" },
  { name: "Zambia", flag: "🇿🇲" },
  { name: "Zimbabwe", flag: "🇿🇼" }
      // Add more countries as needed
    ];

    const countryInput = document.getElementById('country');
    const countryList = document.getElementById('country-list');

    countryInput.addEventListener('input', function () {
      const filter = countryInput.value.toLowerCase();
      countryList.innerHTML = '';
      countries.forEach(country => {
        if (country.name.toLowerCase().indexOf(filter) > -1) {
          const div = document.createElement('div');
          div.classList.add('country-item');
          div.textContent = country.flag + ' ' + country.name;
          div.addEventListener('click', function () {
            countryInput.value = country.flag + ' ' + country.name;
            countryList.innerHTML = '';
          });
          countryList.appendChild(div);
        }
      });
    });

    document.addEventListener('click', function(e) {
      if (e.target !== countryInput) {
        countryList.innerHTML = '';
      }
    });

    // ===== Password Strength Indicator & Toggle =====
    const passwordInput = document.getElementById('password');
    const passwordStrengthText = document.getElementById('password-strength-text');
    const togglePassword = document.getElementById('toggle-password');
    const confirmPasswordInput = document.getElementById('confirm_password');
    const toggleConfirmPassword = document.getElementById('toggle-confirm-password');

    function checkPasswordStrength(password) {
      let strength = 0;
      if (password.length >= 8) strength++;
      if (password.match(/[a-z]/)) strength++;
      if (password.match(/[A-Z]/)) strength++;
      if (password.match(/[0-9]/)) strength++;
      if (password.match(/[\W_]/)) strength++;
      return strength;
    }

    passwordInput.addEventListener('input', function() {
      const password = passwordInput.value;
      const strength = checkPasswordStrength(password);
      if (strength <= 2) {
        passwordStrengthText.textContent = 'Weak password';
        passwordStrengthText.className = 'password-strength strength-weak';
      } else if (strength <= 4) {
        passwordStrengthText.textContent = 'Medium password';
        passwordStrengthText.className = 'password-strength strength-medium';
      } else {
        passwordStrengthText.textContent = 'Strong password';
        passwordStrengthText.className = 'password-strength strength-strong';
      }
    });

    togglePassword.addEventListener('click', function() {
      if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        togglePassword.textContent = 'Hide';
      } else {
        passwordInput.type = 'password';
        togglePassword.textContent = 'Show';
      }
    });

    toggleConfirmPassword.addEventListener('click', function() {
      if (confirmPasswordInput.type === 'password') {
        confirmPasswordInput.type = 'text';
        toggleConfirmPassword.textContent = 'Hide';
      } else {
        confirmPasswordInput.type = 'password';
        toggleConfirmPassword.textContent = 'Show';
      }
    });

    // ===== Modal for Terms & Conditions and Privacy Policy =====
    const modal = document.getElementById('modal-tc');
    const openModalLinks = document.querySelectorAll('.open-modal');
    const closeModal = document.getElementById('close-modal');

    openModalLinks.forEach(link => {
      link.addEventListener('click', function(e) {
        e.preventDefault();
        modal.style.display = 'block';
      });
    });

    closeModal.addEventListener('click', function() {
      modal.style.display = 'none';
    });

    window.addEventListener('click', function(e) {
      if (e.target === modal) {
        modal.style.display = 'none';
      }
    });
  </script>
</body>
</html>
