<?php
session_start();
include 'dbconnection.php';
include 'checklogin.php';
check_login();

if (isset($_POST['Submit'])) {
    // Get and sanitize form inputs
    $newProfitAmount = floatval($_POST['balance']); // Input for profit
    $userid = intval($_POST['userid']);
    $email = mysqli_real_escape_string($con, $_POST['email']);
    $status = mysqli_real_escape_string($con, $_POST['status']);
    $description = mysqli_real_escape_string($con, $_POST['description']);
    $date = date('Y-m-d');

    // Fetch current balance from the database
    $result = mysqli_query($con, "SELECT balance FROM users WHERE id='$userid'");
    if ($row = mysqli_fetch_assoc($result)) {
        $current_balance = floatval($row['balance']);
    } else {
        die("User not found");
    }

    // Calculate new balance
    $newBalance = $current_balance + $newProfitAmount;

    // Update the user's balance in the database
    mysqli_query($con, "UPDATE users SET balance='$newBalance' WHERE id='$userid'") or die(mysqli_error($con));

    // Generate a unique transaction ID and insert into transaction table
    $transid = uniqid('TRX');
    $transaction_query = "INSERT INTO transaction (transdate, transid, email, deposit, profit, withdraw, balance, description) 
                          VALUES ('$date', '$transid', '$email', 0, '$newProfitAmount', 0, '$newBalance', '$description')";
    mysqli_query($con, $transaction_query) or die("Transaction Insert Error: " . mysqli_error($con));

    // Insert into user_trans table
    $transtype = "profit";
    $credit = $newProfitAmount;
    $debit = 0;
    $transid = uniqid('TRX');
    $user_trans_query = "INSERT INTO user_trans(transid, account, date, description, balance, transtype, status, credit, debit, amount, email)
                        VALUES ('$transid', '$email', '$date', '$description', '$newBalance', '$transtype', '$status', '$credit', '$debit', '$newProfitAmount', '$email')";
    mysqli_query($con, $user_trans_query) or die("User Trans Insert Error: " . mysqli_error($con));

    $_SESSION['msg'] = "Client Profit Updated successfully";
}
?>
<!DOCTYPE html>
<html lang="en" x-data="{ sidebarOpen: false }">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin Deposit Update</title>
  <link rel="shortcut icon" type="image/png" href="assetss/images/logos/favicon.png">
  <!-- Tailwind CSS CDN -->
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  <!-- Boxicons CDN -->
  <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
  <!-- Alpine.js for interactivity -->
  <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.12.0/dist/cdn.min.js" defer></script>
  <style>
    #toast {
      transition: opacity 0.5s ease;
    }
  </style>
</head>
<body class="bg-gray-100 text-lg">
  <!-- Toast Alert -->
  <?php if(isset($_SESSION['msg'])): ?>
    <div id="toast" class="fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded shadow-lg z-50">
      <?php 
        echo $_SESSION['msg']; 
        unset($_SESSION['msg']);
      ?>
    </div>
  <?php endif; ?>

  <div class="flex min-h-screen">
    <!-- Desktop Sidebar -->
    <aside class="hidden md:block md:w-64 bg-white shadow-md">
      <div class="p-6">
        <a href="index.php" class="block mb-8">
          <img src="assetss/images/logos/dark-logo.svg" alt="Logo" class="w-48">
        </a>
         <nav>
          <ul class="space-y-4">
            <!-- Reordered nav items for desktop with active highlighting -->
            <li>
              <a href="manage-users.php" class="flex items-center <?php echo ($activePage=='manage-users.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-user text-2xl mr-3"></i> Manage Users
              </a>
            </li>
            <li>
              <a href="manage-deposit.php" class="flex items-center <?php echo ($activePage=='manage-deposit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-plus-circle text-2xl mr-3"></i> Add Deposit
              </a>
            </li>
            <li>
              <a href="deposit_mark.php" class="flex items-center <?php echo ($activePage=='deposit_mark.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-wallet-alt text-2xl mr-3"></i> View Deposit
              </a>
            </li>
            <li>
              <a href="manage-transaction.php" class="flex items-center <?php echo ($activePage=='manage-transaction.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-credit-card text-2xl mr-3"></i> View Transaction
              </a>
            </li>
            <li>
              <a href="manage-wallet.php" class="flex items-center <?php echo ($activePage=='manage-wallet.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-upload text-2xl mr-3"></i> Wallet Upload
              </a>
            </li>
            <li>
              <a href="manage-profit.php" class="flex items-center <?php echo ($activePage=='manage-profit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-dollar text-2xl mr-3"></i> Add Profit
              </a>
            </li>
            <li>
              <a href="manage-withdraw.php" class="flex items-center <?php echo ($activePage=='manage-withdraw.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-bank text-2xl mr-3"></i> View Withdrawal
              </a>
            </li>
            <li>
              <a href="manage-traders.php" class="flex items-center <?php echo ($activePage=='manage-traders.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-group text-2xl mr-3"></i> Manage Traders
              </a>
            </li>
            <li>
              <a href="manage-upgrade.php" class="flex items-center <?php echo ($activePage=='manage-upgrade.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-trending-up text-2xl mr-3"></i> Upgrade Client Account
              </a>
            </li>
            <li>
              <a href="manage-id.php" class="flex items-center <?php echo ($activePage=='manage-id.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-id-card text-2xl mr-3"></i> KYC
              </a>
            </li>
            <li>
              <a href="manage-limit.php" class="flex items-center <?php echo ($activePage=='manage-limit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-slider-alt text-2xl mr-3"></i> Withdrawal Limits
              </a>
            </li>
            <li>
              <a href="livechatupdate.php" class="flex items-center <?php echo ($activePage=='livechatupdate.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-chat text-2xl mr-3"></i> Livechat Update
              </a>
            </li>
            <li>
              <a href="change-password.php" class="flex items-center <?php echo ($activePage=='change-password.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-key text-2xl mr-3"></i> Change Password/MTC Code
              </a>
            </li>
            <li>
              <a href="support.php" class="flex items-center <?php echo ($activePage=='support.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-envelope text-2xl mr-3"></i> Send Email
              </a>
            </li>
            <li>
              <a href="logout.php" class="flex items-center <?php echo ($activePage=='logout.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-log-out text-2xl mr-3"></i> Logout
              </a>
            </li>
          </ul>
        </nav>
      </div>
    </aside>
    
    <!-- Mobile Sidebar (optional, if you want one on mobile as well) -->
    <aside class="md:hidden" x-show="sidebarOpen" x-transition>
      <div class="fixed inset-0 z-40 flex">
        <div x-show="sidebarOpen" x-transition.opacity class="fixed inset-0 bg-black bg-opacity-25" @click="sidebarOpen = false"></div>
        <div x-show="sidebarOpen" x-transition class="relative flex-1 flex flex-col max-w-xs w-full bg-white">
          <div class="absolute top-0 right-0 -mr-12 pt-2">
            <button @click="sidebarOpen = false" class="ml-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:bg-gray-600">
              <span class="sr-only">Close sidebar</span>
              <i class="bx bx-x text-2xl text-white"></i>
            </button>
          </div>
          <div class="p-6">
            <a href="index.php" class="block mb-8">
              <img src="assetss/images/logos/dark-logo.svg" alt="Logo" class="w-40">
            </a>
            <nav>
              <ul class="space-y-4">
                <!-- Mobile nav items, reordered by importance -->
                <li>
                  <a href="manage-users.php" class="flex items-center <?php echo ($activePage=='manage-users.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-user text-xl mr-2"></i> Manage Users
                  </a>
                </li>
                <li>
                  <a href="manage-deposit.php" class="flex items-center <?php echo ($activePage=='manage-deposit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-plus-circle text-xl mr-2"></i> Add Deposit
                  </a>
                </li>
                <li>
                  <a href="deposit_mark.php" class="flex items-center <?php echo ($activePage=='deposit_mark.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-wallet-alt text-xl mr-2"></i> View Deposit
                  </a>
                </li>
                <li>
                  <a href="manage-transaction.php" class="flex items-center <?php echo ($activePage=='manage-transaction.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-credit-card text-xl mr-2"></i> View Transaction
                  </a>
                </li>
                <li>
                  <a href="manage-wallet.php" class="flex items-center <?php echo ($activePage=='manage-wallet.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-upload text-xl mr-2"></i> Wallet Upload
                  </a>
                </li>
                <li>
                  <a href="manage-profit.php" class="flex items-center <?php echo ($activePage=='manage-profit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-dollar text-xl mr-2"></i> Add Profit
                  </a>
                </li>
                <li>
                  <a href="manage-withdraw.php" class="flex items-center <?php echo ($activePage=='manage-withdraw.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-bank text-xl mr-2"></i> View Withdrawal
                  </a>
                </li>
                <li>
                  <a href="manage-traders.php" class="flex items-center <?php echo ($activePage=='manage-traders.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-group text-xl mr-2"></i> Manage Traders
                  </a>
                </li>
                <li>
                  <a href="manage-upgrade.php" class="flex items-center <?php echo ($activePage=='manage-upgrade.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-trending-up text-xl mr-2"></i> Upgrade Client Account
                  </a>
                </li>
                <li>
                  <a href="manage-id.php" class="flex items-center <?php echo ($activePage=='manage-id.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-id-card text-xl mr-2"></i> KYC
                  </a>
                </li>
                <li>
                  <a href="manage-limit.php" class="flex items-center <?php echo ($activePage=='manage-limit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-slider-alt text-xl mr-2"></i> Withdrawal Limits
                  </a>
                </li>
                <li>
                  <a href="livechatupdate.php" class="flex items-center <?php echo ($activePage=='livechatupdate.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-chat text-xl mr-2"></i> Livechat Update
                  </a>
                </li>
                <li>
                  <a href="change-password.php" class="flex items-center <?php echo ($activePage=='change-password.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-key text-xl mr-2"></i> Change Password/MTC Code
                  </a>
                </li>
                <li>
                  <a href="logout.php" class="flex items-center <?php echo ($activePage=='logout.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-log-out text-xl mr-2"></i> Logout
                  </a>
                </li>
              </ul>
            </nav>
      </div>
    </aside>
    
    <!-- Main Wrapper -->
    <div class="body-wrapper flex-1">
      <!-- Header (Left aligned) -->
         <header class="bg-white shadow-md w-full">
        <div class="flex items-center px-4 py-4">
          <button @click="sidebarOpen = true" class="md:hidden text-gray-500 hover:text-gray-700 focus:outline-none mr-4">
            <i class='bx bx-menu text-3xl'></i>
          </button>
          <h1 class="text-2xl font-bold text-gray-800">Manage Deposit</h1>
        </div>
      </header>
      
      <!-- Main Content -->
      <main class="flex-1 p-6 overflow-y-auto">
        <!-- Action Link -->
        <div class="mb-4">
          <a href="connwall.php" class="inline-block bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
            View Connected Wallets
          </a>
        </div>
        <!-- Manage Profit Update Form -->
        <div class="bg-white shadow-lg rounded-lg p-8">
          <?php 
            $uid = isset($_GET['uid']) ? intval($_GET['uid']) : 0;
            $ret = mysqli_query($con, "SELECT * FROM users WHERE id='$uid'");
            while($row = mysqli_fetch_array($ret)) {
          ?>  
            <h2 class="text-2xl font-semibold text-gray-700 mb-6"><?php echo $row['firstname']; ?> Profit Update</h2>
            <a href="manage_percentage.php" target="_blank" class="mb-4 inline-block bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
              Percent Update
            </a>
            <form class="space-y-6" name="form1" method="post" action="">
              <!-- Hidden Fields -->
              <input type="hidden" name="userid" value="<?php echo $row['id']; ?>">
              <input type="hidden" name="email" value="<?php echo $row['email']; ?>">
              <input type="hidden" name="profit" value="0">
              <input type="hidden" name="status" value="active">
              <input type="hidden" name="percentage" value="0">
              <input type="hidden" name="description" value="Deposit update">
              
              <div class="mb-4">
                <label class="block text-gray-600 font-medium">Full Name</label>
                <input type="text" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-gray-100" name="lname" value="<?php echo $row['fullname'];?>" readonly disabled>
              </div>
              
              <div class="mb-4">
                <label class="block text-gray-600 font-medium">Email Address</label>
                <input type="text" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-gray-100" name="email" value="<?php echo $row['email'];?>" readonly>
              </div>
              
              <div class="mb-4">
                <label class="block text-gray-600 font-medium">Previous Balance</label>
                <input type="text" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-gray-100" name="deposit" value="<?php echo $row['balance'];?>" onkeyup="sum()" id="txt1" readonly disabled>
              </div>
              
              <div class="mb-4">
                <label class="block text-gray-600 font-medium">Profit</label>
                <input type="text" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-white" name="balance" onkeyup="sum()" id="txt2">
              </div>
              
              <div class="mb-4">
                <label class="block text-gray-600 font-medium">UserID</label>
                <input type="text" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-gray-100" name="userid" value="<?php echo $row['userid'];?>" readonly disabled>
              </div>
              
              <div class="mb-4">
                <label class="block text-gray-600 font-medium">Description</label>
                <select name="description" id="all-in-one-dropdown" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-white">
                  <option value="btc">Bitcoin (BTC)</option>
                  <option value="eth">Ethereum (ETH)</option>
                  <option value="bnb">Binance Coin (BNB)</option>
                  <option value="xrp">Ripple (XRP)</option>
                  <option value="ada">Cardano (ADA)</option>
                  <option value="aapl">Apple Inc. (AAPL)</option>
                  <option value="amzn">Amazon.com Inc. (AMZN)</option>
                  <option value="tsla">Tesla Inc. (TSLA)</option>
                  <option value="msft">Microsoft Corporation (MSFT)</option>
                  <option value="googl">Alphabet Inc. (GOOGL)</option>
                  <option value="sp500">S&P 500 Index</option>
                  <option value="djia">Dow Jones Industrial Average (DJIA)</option>
                  <option value="nasdaq">NASDAQ Composite Index</option>
                  <option value="ftse100">FTSE 100 Index</option>
                  <option value="nikkei225">Nikkei 225 Index</option>
                  <option value="eurusd">EUR/USD (Euro/US Dollar)</option>
                  <option value="usdjpy">USD/JPY (US Dollar/Japanese Yen)</option>
                  <option value="gbpusd">GBP/USD (British Pound/US Dollar)</option>
                  <option value="audusd">AUD/USD (Australian Dollar/US Dollar)</option>
                </select>
              </div>
              
              <div class="mb-4">
                <label class="block text-gray-600 font-medium">Deposit Status</label>
                <div class="mt-1">
                  <label class="inline-flex items-center mr-4">
                    <input type="radio" name="status" value="LOSS" class="form-radio text-blue-500">
                    <span class="ml-2">LOSS</span>
                  </label>
                  <label class="inline-flex items-center mr-4">
                    <input type="radio" name="status" value="WIN" class="form-radio text-blue-500">
                    <span class="ml-2">WIN</span>
                  </label>
                  <label class="inline-flex items-center mr-4">
                    <input type="radio" name="status" value="REFUND" class="form-radio text-blue-500">
                    <span class="ml-2">REFUND</span>
                  </label>
                </div>
                <p class="mt-1 text-red-500 font-bold">REQUIRED</p>
              </div>
              
              <button type="submit" name="Submit" class="w-full bg-blue-500 hover:bg-blue-600 text-white py-3 rounded font-semibold">
                Submit
              </button>
            </form>
          <?php } ?>
        </div>
      </main>
    </div>
  </div>

  <script>
    function sum() {
      var txtFirstNumberValue = document.getElementById('txt1').value;
      var txtSecondNumberValue = document.getElementById('txt2').value;
      var result = parseInt(txtFirstNumberValue) + parseInt(txtSecondNumberValue);
      if (!isNaN(result)) {
        if(document.getElementById('txt3')){
          document.getElementById('txt3').value = result;
        }
      }
    }
    
    // Auto-dismiss toast after 3 seconds
    document.addEventListener("DOMContentLoaded", function(){
      var toast = document.getElementById("toast");
      if(toast){
        setTimeout(function(){
          toast.classList.add("opacity-0");
          setTimeout(function(){ toast.remove(); }, 500);
        }, 3000);
      }
    });
    
    // Generate a Client ID if needed
    function generateCID() {
      const randomClientId = Math.floor(Math.random() * 1000);
      return 'CID' + randomClientId;
    }
    window.onload = function() {
      if(document.getElementById('cidInput')){
        document.getElementById('cidInput').value = generateCID();
      }
    };
  </script>

  <!-- Optional JS Libraries -->
  <script src="assetss/libs/jquery/dist/jquery.min.js"></script>
  <script src="assetss/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
  <script src="assetss/js/sidebarmenu.js"></script>
  <script src="assetss/js/app.min.js"></script>
  <script src="assetss/libs/simplebar/dist/simplebar.js"></script>
</body>
</html>
