<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Update Profile Photo</title>
  <!-- FontAwesome CSS for default icon -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" 
        integrity="sha512-a+Yf6Zj7X47Pm6U4K/3G84bBd+TEG8ufYcRj8uXjI+IEU4Qv0By3vDlmVCkrJkSQyN+5E4VoFvYhXH6Nqz5rNQ==" 
        crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background: #f4f4f4;">
  <div style="max-width: 600px; margin: 50px auto; padding: 20px; background: #fff; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
    <form id="photoForm" action="upload.php" method="POST" enctype="multipart/form-data" style="text-align: center;">
      <div style="display: inline-block; text-align: center;">
        <!-- Clicking this label will trigger the hidden file input -->
        <label for="profileImage" style="cursor: pointer; display: inline-block;">
          <div style="width: 200px; height: 200px; border: 2px dashed #ccc; border-radius: 15px; overflow: hidden; position: relative; display: flex; align-items: center; justify-content: center; transition: border-color 0.3s;">
            <!-- Image preview container -->
            <img id="previewImage" class="object-cover" alt="Profile Image Preview" style="width: 100%; height: 100%; object-fit: cover; display: none;" />
            <!-- Default FontAwesome icon (grey) if no image is present -->
            <div id="defaultIcon" style="color: #ccc; font-size: 60px;">
              <i class="fa-solid fa-user"></i>
            </div>
          </div>
        </label>
        <!-- Hidden file input accepts any image type -->
        <input type="file" name="profileImage" id="profileImage" accept="image/*" style="display: none;" />
        <!-- Upload button -->
        <button type="submit" id="submitButton" style="margin-top: 20px; padding: 10px 20px; background: #007BFF; color: #fff; border: none; border-radius: 5px; cursor: pointer; display: none;">
          Upload Photo
        </button>
      </div>
    </form>
  </div>

  <script>
    // Listen for changes on the file input
    document.getElementById('profileImage').addEventListener('change', function(e) {
      const file = e.target.files[0];
      if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
          const previewImage = document.getElementById('previewImage');
          previewImage.src = e.target.result;
          previewImage.style.display = 'block';
          // Hide the default icon when a preview is available
          document.getElementById('defaultIcon').style.display = 'none';
        };
        reader.readAsDataURL(file);
        // Reveal the submit button so the user can confirm the upload
        document.getElementById('submitButton').style.display = 'inline-block';
      }
    });
  </script>
</body>
</html>
