<?php include './includes/header.php'; ?>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Crypto Dashboard & Investment</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.0.0/axios.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.1/chart.min.js"></script>
</head>
<body class="transition-colors duration-200" id="mainBody">
  <div class="container mx-auto px-4 py-8">
    <!-- Header with Theme Toggle -->
    <div class="flex justify-between items-center mb-8">
      <a href="./dashboard.php">
    <img src="assets/images/logo/logo-white.svg" alt="Logo" class="text-2xl font-bold dark:text-white" id="mainHeading" style="filter: grayscale(100%)">
</a>

      <div class="flex items-center">
        <span class="mr-2 text-sm dark:text-white" id="themeLabel">Light Mode</span>
        <button id="themeToggle" class="w-12 h-6 rounded-full bg-gray-300 flex items-center transition duration-300 focus:outline-none shadow">
          <div id="toggleCircle" class="w-4 h-4 relative ml-1 bg-white rounded-full transition duration-300 transform"></div>
        </button>
      </div>
       
    </div>
    
    <div class="flex justify-center py-8">
      <a href="#" id="discoverMoreBtn">
        <div class="w-48 h-14 flex justify-center items-center rounded-lg bg-yellow-400 hover:bg-yellow-300 transition duration-300 ease-in-out">
          <span class="text-gray-900 text-sm font-bold">View/Buy Plans</span>
        </div>
      </a>
    </div>

    <!-- Market Overview -->
    <div class="mb-8 p-4 rounded-lg shadow bg-white dark:bg-gray-800" id="marketOverview">
      <h2 class="text-xl font-semibold mb-4 dark:text-white">Market Overview</h2>
      <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <div class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg">
          <div class="text-sm text-gray-500 dark:text-gray-300">Global Market Cap</div>
          <div class="text-xl font-bold dark:text-white" id="globalMarketCap">$0</div>
          <div class="flex items-center text-red-500" id="marketCapChange">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
            </svg>
            <span>0%</span>
          </div>
        </div>
        <div class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg">
          <div class="text-sm text-gray-500 dark:text-gray-300">24h Trading Volume</div>
          <div class="text-xl font-bold dark:text-white" id="tradingVolume">$0</div>
        </div>
        <div class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg">
          <div class="text-sm text-gray-500 dark:text-gray-300">Bitcoin Dominance</div>
          <div class="text-xl font-bold dark:text-white" id="btcDominance">0%</div>
        </div>
      </div>
    </div>

    <!-- Charts and Tables -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
      <!-- Price Chart -->
      <div class="lg:col-span-2 bg-white dark:bg-gray-800 p-4 rounded-lg shadow">
        <div class="flex justify-between items-center mb-4">
          <h2 class="text-xl font-semibold dark:text-white">BTC Price</h2>
          <div class="flex">
            <button class="timeframe-btn px-2 py-1 text-sm rounded mr-1 bg-blue-500 text-white">1D</button>
            <button class="timeframe-btn px-2 py-1 text-sm rounded mr-1 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-white">7D</button>
            <button class="timeframe-btn px-2 py-1 text-sm rounded mr-1 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-white">1M</button>
            <button class="timeframe-btn px-2 py-1 text-sm rounded bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-white">1Y</button>
          </div>
        </div>
        <div class="h-64">
          <canvas id="priceChart"></canvas>
        </div>
      </div>

      <!-- Top Gainers -->
      <div class="bg-white dark:bg-gray-800 p-4 rounded-lg shadow">
        <div class="flex justify-between items-center mb-4">
          <h2 class="text-xl font-semibold dark:text-white">Top Gainers</h2>
          <a href="#" class="text-blue-500 text-sm">View more</a>
        </div>
        <div class="space-y-4" id="topGainers">
          <!-- Will be populated via JavaScript -->
        </div>
      </div>
    </div>

    <!-- Crypto Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow mb-8">
      <div class="p-4 border-b dark:border-gray-700">
        <h2 class="text-xl font-semibold dark:text-white">Top Cryptocurrencies</h2>
      </div>
      <div class="overflow-x-auto">
        <table class="min-w-full">
          <thead>
            <tr class="text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
              <th class="p-4">#</th>
              <th class="p-4">Coin</th>
              <th class="p-4">Price</th>
              <th class="p-4">1h</th>
              <th class="p-4">24h</th>
              <th class="p-4">7d</th>
              <th class="p-4">24h Volume</th>
              <th class="p-4">Market Cap</th>
              <th class="p-4">Last 7 Days</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-200 dark:divide-gray-700" id="cryptoTableBody">
            <!-- Will be populated via JavaScript -->
          </tbody>
        </table>
      </div>
    </div>

    <!-- Investment Button -->
   
  </div>

  <!-- Modal Overlay -->
  <div id="modalOverlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden flex justify-center items-center">
    <!-- Modal -->
    <div id="cryptoModal" class="bg-gray-800 text-white rounded-lg shadow-lg w-full max-w-lg mx-4 z-50 max-h-screen overflow-y-auto">
      <!-- Modal Header -->
      <div class="px-6 py-4 border-b border-gray-700 flex justify-between items-center">
        <h3 class="text-xl font-bold">Investment Plans</h3>
        <button id="closeModal" class="text-gray-400 hover:text-white">
          <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
          </svg>
        </button>
      </div>

      <!-- Modal Body -->
      <div class="p-6">
        <!-- Step Indicator -->
        <div class="flex justify-between mb-8">
          <div class="flex flex-col items-center">
            <div id="step1Circle" class="w-8 h-8 rounded-full bg-yellow-400 text-gray-900 flex items-center justify-center font-bold">1</div>
            <span class="text-xs mt-1">Select Plan</span>
          </div>
          <div class="flex-1 h-0.5 bg-gray-600 self-center mx-2"></div>
          <div class="flex flex-col items-center">
            <div id="step2Circle" class="w-8 h-8 rounded-full bg-gray-600 text-white flex items-center justify-center font-bold">2</div>
            <span class="text-xs mt-1">Payment</span>
          </div>
          <div class="flex-1 h-0.5 bg-gray-600 self-center mx-2"></div>
          <div class="flex flex-col items-center">
            <div id="step3Circle" class="w-8 h-8 rounded-full bg-gray-600 text-white flex items-center justify-center font-bold">3</div>
            <span class="text-xs mt-1">Confirmation</span>
          </div>
        </div>

        <!-- Step 1: Select Plan -->
        <div id="step1" class="step-content">
          <h4 class="text-lg font-medium mb-4">Choose Your Investment Plan</h4>
          <div class="grid grid-cols-2 gap-4 mb-6">
            <div class="plan-option p-4 border border-gray-700 rounded-lg cursor-pointer hover:bg-gray-700 transition" data-plan="Basic" data-min="500" data-max="2999" data-return="5">
              <h5 class="font-bold">Basic</h5>
              <p class="text-sm text-gray-400">$500 - $2,999</p>
              <p class="text-xs mt-1 text-gray-400">Returns: 5% weekly</p>
            </div>
            <div class="plan-option p-4 border border-gray-700 rounded-lg cursor-pointer hover:bg-gray-700 transition" data-plan="Silver" data-min="3000" data-max="9999" data-return="7">
              <h5 class="font-bold">Silver</h5>
              <p class="text-sm text-gray-400">$3,000 - $9,999</p>
              <p class="text-xs mt-1 text-gray-400">Returns: 7% weekly</p>
            </div>
            <div class="plan-option p-4 border border-gray-700 rounded-lg cursor-pointer hover:bg-gray-700 transition" data-plan="Gold" data-min="10000" data-max="29999" data-return="10">
              <h5 class="font-bold">Gold</h5>
              <p class="text-sm text-gray-400">$10,000 - $29,999</p>
              <p class="text-xs mt-1 text-gray-400">Returns: 10% weekly</p>
            </div>
            <div class="plan-option p-4 border border-gray-700 rounded-lg cursor-pointer hover:bg-gray-700 transition" data-plan="Ultimate" data-min="30000" data-max="49999" data-return="12">
              <h5 class="font-bold">Ultimate</h5>
              <p class="text-sm text-gray-400">$30,000 - $49,999</p>
              <p class="text-xs mt-1 text-gray-400">Returns: 12% weekly</p>
            </div>
            <div class="plan-option p-4 border border-gray-700 rounded-lg cursor-pointer hover:bg-gray-700 transition" data-plan="Premium" data-min="50000" data-max="99999" data-return="15">
              <h5 class="font-bold">Premium</h5>
              <p class="text-sm text-gray-400">$50,000 - $99,999</p>
              <p class="text-xs mt-1 text-gray-400">Returns: 15% weekly</p>
            </div>
            <div class="plan-option p-4 border border-gray-700 rounded-lg cursor-pointer hover:bg-gray-700 transition" data-plan="VIP" data-min="100000" data-max="100000000" data-return="20">
              <h5 class="font-bold">VIP</h5>
              <p class="text-sm text-gray-400">$100,000+</p>
              <p class="text-xs mt-1 text-gray-400">Returns: 20% weekly</p>
            </div>
          </div>
          <div class="flex justify-end">
            <button id="toStep2" class="px-6 py-2 bg-yellow-400 text-gray-900 rounded font-medium hover:bg-yellow-300 transition disabled:opacity-50 disabled:cursor-not-allowed" disabled>Continue</button>
          </div>
        </div>

        <!-- Step 2: Payment Details -->
        <div id="step2" class="step-content hidden">
          <h4 class="text-lg font-medium mb-4">Payment Details</h4>
          <!-- Selected Plan Summary -->
          <div class="bg-gray-700 p-4 rounded-lg mb-6">
            <div class="flex justify-between mb-2">
              <span>Selected Plan:</span>
              <span id="selectedPlanName" class="font-bold"></span>
            </div>
            <div class="flex justify-between mb-2">
              <span>Investment Range:</span>
              <span id="selectedPlanRange"></span>
            </div>
            <div class="flex justify-between mb-2">
              <span>Weekly Return:</span>
              <span id="selectedPlanReturn" class="font-bold text-green-400"></span>
            </div>
            <div class="flex justify-between mb-2">
              <span>Monthly Return:</span>
              <span id="selectedPlanMonthlyReturn" class="font-bold text-green-400"></span>
            </div>
          </div>
          <!-- Amount Input -->
          <div class="mb-6">
            <label class="block text-sm font-medium mb-2">Amount (USD)</label>
            <input type="number" id="amountInput" class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white" placeholder="Enter amount" min="0">
            <p id="amountError" class="text-red-500 text-xs mt-1 hidden">Amount must be within the selected plan range</p>
          </div>
          <!-- Currency Display -->
          <div class="mb-6">
            <label class="block text-sm font-medium mb-2">Equivalent In Other Currencies</label>
            <div class="grid grid-cols-2 gap-4">
              <div class="bg-gray-700 p-3 rounded">
                <div class="text-xs text-gray-400">BTC Value</div>
                <div id="btcValue" class="font-medium"></div>
              </div>
              <div class="bg-gray-700 p-3 rounded">
                <div class="text-xs text-gray-400">ETH Value</div>
                <div id="ethValue" class="font-medium"></div>
              </div>
            </div>
          </div>
          <!-- Select Cryptocurrency -->
          <div class="mb-6">
            <label class="block text-sm font-medium mb-2">Select Cryptocurrency</label>
            <div class="relative">
              <select id="cryptoSelect" class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white appearance-none pr-8">
                <option value="BTC" data-address="bc1q9um44d7qzsmhdq3uuv0fey3s407y0csmpwrnqy">Bitcoin (BTC)</option>
                <option value="ETH" data-address="0x2CcbaFBc53738687c5A08093895Add677f3fF515">Ethereum (ETH)</option>
                <option value="USDT" data-address="0x2CcbaFBc53738687c5A08093895Add677f3fF515">USDT (TRC20)</option>
              </select>
              <div class="absolute inset-y-0 right-0 flex items-center px-2 pointer-events-none">
                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                  <path d="M7 7l3-3 3 3m0 6l-3 3-3-3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                </svg>
              </div>
            </div>
          </div>
          <div class="flex justify-between">
            <button id="backToStep1" class="px-6 py-2 bg-gray-700 text-white rounded font-medium hover:bg-gray-600 transition">Back</button>
            <button id="toStep3" class="px-6 py-2 bg-yellow-400 text-gray-900 rounded font-medium hover:bg-yellow-300 transition">Continue</button>
          </div>
        </div>

        <!-- Step 3: Payment Confirmation -->
        <div id="step3" class="step-content hidden">
          <h4 class="text-lg font-medium mb-4">Payment Instructions</h4>
          <!-- Payment Summary -->
          <div class="bg-gray-700 p-4 rounded-lg mb-6">
            <div class="flex justify-between mb-2">
              <span>Plan:</span>
              <span id="confirmPlan" class="font-bold"></span>
            </div>
            <div class="flex justify-between mb-2">
              <span>Amount:</span>
              <span id="confirmAmount" class="font-bold"></span>
            </div>
            <div class="flex justify-between mb-2">
              <span>Payment Method:</span>
              <span id="confirmCrypto" class="font-bold"></span>
            </div>
            <div class="flex justify-between mb-2">
              <span>Weekly Return:</span>
              <span id="confirmReturn" class="font-bold text-green-400"></span>
            </div>
          </div>
          <!-- Crypto Address -->
          <div class="mb-6">
            <label class="block text-sm font-medium mb-2">Send Payment To This Address:</label>
            <div class="bg-gray-700 p-3 rounded flex items-center">
              <input id="walletAddress" type="text" class="bg-transparent flex-1 outline-none" readonly>
              <button id="copyAddress" class="ml-2 p-1 hover:bg-gray-600 rounded">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                </svg>
              </button>
            </div>
          </div>
          <!-- QR Code -->
          <div class="mb-6">
            <label class="block text-sm font-medium mb-2">Scan QR Code:</label>
            <div class="flex justify-center bg-white p-4 rounded">
              <div id="qrcode"></div>
            </div>
          </div>
          <div class="bg-yellow-100 text-yellow-800 p-4 rounded-lg mb-6">
            <p class="text-sm"><strong>Important:</strong> After sending payment, please contact support with your transaction ID for faster confirmation.</p>
          </div>
          <div class="flex justify-between">
            <button id="backToStep2" class="px-6 py-2 bg-gray-700 text-white rounded font-medium hover:bg-gray-600 transition">Back</button>
            <form id="paymentForm" action="pdeposit.php" method="post">
              <input type="hidden" name="plan" id="formPlan">
              <input type="hidden" name="amt" id="formAmount">
              <input type="hidden" name="depositmethod" id="formCrypto">
              <input type="hidden" name="selectedaddress" id="formAddress">
              <button type="submit" class="px-6 py-2 bg-green-500 text-white rounded font-medium hover:bg-green-600 transition">Confirm Payment</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Theme handling
      const themeToggle = document.getElementById('themeToggle');
      const toggleCircle = document.getElementById('toggleCircle');
      const mainBody = document.getElementById('mainBody');
      const themeLabel = document.getElementById('themeLabel');
      const savedTheme = localStorage.getItem('theme') || 'light';

      if (savedTheme === 'dark') {
        enableDarkMode();
      }

      function enableDarkMode() {
        mainBody.classList.add('bg-gray-900');
        document.querySelectorAll('h1, h2, p, span:not(.bg-green-500):not(.bg-red-500)').forEach(el => {
          if (!el.classList.contains('text-gray-400') && !el.classList.contains('text-green-400')) {
            el.classList.add('text-white');
          }
        });
        toggleCircle.classList.add('translate-x-6');
        themeToggle.classList.add('bg-blue-600');
        themeLabel.textContent = 'Dark Mode';
        localStorage.setItem('theme', 'dark');
      }

      function disableDarkMode() {
        mainBody.classList.remove('bg-gray-900');
        document.querySelectorAll('h1, h2, p, span').forEach(el => {
          el.classList.remove('text-white');
        });
        toggleCircle.classList.remove('translate-x-6');
        themeToggle.classList.remove('bg-blue-600');
        themeLabel.textContent = 'Light Mode';
        localStorage.setItem('theme', 'light');
      }

      themeToggle.addEventListener('click', function() {
        if (localStorage.getItem('theme') === 'light') {
          enableDarkMode();
        } else {
          disableDarkMode();
        }
      });

      // API Base URL
      const apiBaseUrl = 'https://api.coingecko.com/api/v3';

      // Fetch top cryptocurrencies
      async function fetchTopCryptos() {
        try {
          const response = await axios.get(`${apiBaseUrl}/coins/markets`, {
            params: {
              vs_currency: 'usd',
              order: 'market_cap_desc',
              per_page: 10,
              page: 1,
              sparkline: true,
              price_change_percentage: '1h,24h,7d'
            }
          });
          populateCryptoTable(response.data);
          // Use first coin (BTC assumed) for price chart
          createPriceChart(response.data[0]);
        } catch (error) {
          console.error('Error fetching crypto data:', error);
        }
      }

      // Fetch top gainers
      async function fetchTopGainers() {
        try {
          const response = await axios.get(`${apiBaseUrl}/coins/markets`, {
            params: {
              vs_currency: 'usd',
              order: 'price_change_percentage_24h_desc',
              per_page: 5,
              page: 1
            }
          });
          populateTopGainers(response.data);
        } catch (error) {
          console.error('Error fetching top gainers:', error);
        }
      }

      // Fetch global stats
      async function fetchGlobalStats() {
        try {
          const response = await axios.get(`${apiBaseUrl}/global`);
          const data = response.data.data;
          document.getElementById('globalMarketCap').textContent = '$' + Number(data.total_market_cap.usd).toLocaleString();
          document.getElementById('tradingVolume').textContent = '$' + Number(data.total_volume.usd).toLocaleString();
          document.getElementById('btcDominance').textContent = data.market_cap_percentage.btc.toFixed(1) + '%';
        } catch (error) {
          console.error('Error fetching global stats:', error);
        }
      }

      // Populate crypto table
      function populateCryptoTable(cryptos) {
        const tableBody = document.getElementById('cryptoTableBody');
        tableBody.innerHTML = '';
        cryptos.forEach((crypto, index) => {
          const row = document.createElement('tr');
          row.className = 'hover:bg-gray-100 dark:hover:bg-gray-700';

          const priceChangeClass1h = crypto.price_change_percentage_1h_in_currency > 0 ? 'text-green-500' : 'text-red-500';
          const priceChangeClass24h = crypto.price_change_percentage_24h > 0 ? 'text-green-500' : 'text-red-500';
          const priceChangeClass7d = crypto.price_change_percentage_7d_in_currency > 0 ? 'text-green-500' : 'text-red-500';

          const sparklinePoints = generateSparklinePoints(crypto.sparkline_in_7d.price);
          const sparklineColor = crypto.price_change_percentage_7d_in_currency > 0 ? '#10B981' : '#EF4444';

          row.innerHTML = `
            <td class="p-4 dark:text-white">${index + 1}</td>
            <td class="p-4">
              <div class="flex items-center">
                <img src="${crypto.image}" alt="${crypto.name}" class="w-6 h-6 mr-2">
                <div>
                  <div class="font-medium dark:text-white">${crypto.name}</div>
                  <div class="text-sm text-gray-500 dark:text-gray-400">${crypto.symbol.toUpperCase()}</div>
                </div>
              </div>
            </td>
            <td class="p-4 dark:text-white">$${crypto.current_price.toLocaleString()}</td>
            <td class="p-4 ${priceChangeClass1h}">${crypto.price_change_percentage_1h_in_currency?.toFixed(2) || 0}%</td>
            <td class="p-4 ${priceChangeClass24h}">${crypto.price_change_percentage_24h?.toFixed(2) || 0}%</td>
            <td class="p-4 ${priceChangeClass7d}">${crypto.price_change_percentage_7d_in_currency?.toFixed(2) || 0}%</td>
            <td class="p-4 dark:text-white">$${crypto.total_volume.toLocaleString()}</td>
            <td class="p-4 dark:text-white">$${crypto.market_cap.toLocaleString()}</td>
            <td class="p-4">
              <svg width="120" height="40" class="sparkline">
                <path d="${sparklinePoints}" stroke="${sparklineColor}" stroke-width="2" fill="none"/>
              </svg>
            </td>
          `;
          tableBody.appendChild(row);
        });
      }

      // Populate top gainers
      function populateTopGainers(gainers) {
        const gainersContainer = document.getElementById('topGainers');
        gainersContainer.innerHTML = '';
        gainers.forEach(gainer => {
          const priceChangeClass = gainer.price_change_percentage_24h > 0 ? 'text-green-500' : 'text-red-500';
          const gainersItem = document.createElement('div');
          gainersItem.className = 'flex items-center justify-between';
          gainersItem.innerHTML = `
            <div class="flex items-center">
              <img src="${gainer.image}" alt="${gainer.name}" class="w-6 h-6 mr-2">
              <div>
                <div class="font-medium dark:text-white">${gainer.name}</div>
                <div class="text-sm text-gray-500 dark:text-gray-400">${gainer.symbol.toUpperCase()}</div>
              </div>
            </div>
            <div>
              <div class="font-medium dark:text-white">$${gainer.current_price.toLocaleString()}</div>
              <div class="text-sm ${priceChangeClass} text-right">${gainer.price_change_percentage_24h.toFixed(2)}%</div>
            </div>
          `;
          gainersContainer.appendChild(gainersItem);
        });
      }

      // Create price chart using Chart.js
      function createPriceChart(crypto) {
        const ctx = document.getElementById('priceChart').getContext('2d');
        const labels = crypto.sparkline_in_7d.price.map((_, index) => index);
        const data = {
          labels: labels,
          datasets: [{
            label: `${crypto.name} Price`,
            data: crypto.sparkline_in_7d.price,
            borderColor: crypto.price_change_percentage_7d_in_currency > 0 ? '#10B981' : '#EF4444',
            backgroundColor: 'rgba(0,0,0,0)',
            fill: false,
            tension: 0.1
          }]
        };
        new Chart(ctx, {
          type: 'line',
          data: data,
          options: {
            responsive: true,
            scales: {
              x: { display: false },
              y: { display: true }
            }
          }
        });
      }

      // Generate sparkline SVG path points
      function generateSparklinePoints(data) {
        const width = 120, height = 40;
        const max = Math.max(...data);
        const min = Math.min(...data);
        const step = width / (data.length - 1);
        let path = '';
        data.forEach((point, i) => {
          const x = i * step;
          const y = height - ((point - min) / (max - min)) * height;
          path += (i === 0 ? `M ${x} ${y}` : ` L ${x} ${y}`);
        });
        return path;
      }

      // Modal and Investment Plan handling
      const discoverMoreBtn = document.getElementById('discoverMoreBtn');
      const modalOverlay = document.getElementById('modalOverlay');
      const closeModal = document.getElementById('closeModal');
      const step1 = document.getElementById('step1');
      const step2 = document.getElementById('step2');
      const step3 = document.getElementById('step3');
      const toStep2 = document.getElementById('toStep2');
      const backToStep1 = document.getElementById('backToStep1');
      const toStep3 = document.getElementById('toStep3');
      const backToStep2 = document.getElementById('backToStep2');
      const planOptions = document.querySelectorAll('.plan-option');

      let selectedPlan = null;

      // Open modal on Invest Now click
      discoverMoreBtn.addEventListener('click', function(e) {
        e.preventDefault();
        modalOverlay.classList.remove('hidden');
      });

      // Close modal when clicking close button
      closeModal.addEventListener('click', function() {
        modalOverlay.classList.add('hidden');
        resetModal();
      });

      // Reset modal to step 1
      function resetModal() {
        step1.classList.remove('hidden');
        step2.classList.add('hidden');
        step3.classList.add('hidden');
        toStep2.disabled = true;
        planOptions.forEach(option => option.classList.remove('bg-gray-600'));
        document.getElementById('amountInput').value = '';
        document.getElementById('amountError').classList.add('hidden');
      }

      // Plan selection
      planOptions.forEach(option => {
        option.addEventListener('click', function() {
          planOptions.forEach(opt => opt.classList.remove('bg-gray-600'));
          this.classList.add('bg-gray-600');
          selectedPlan = {
            name: this.getAttribute('data-plan'),
            min: parseFloat(this.getAttribute('data-min')),
            max: parseFloat(this.getAttribute('data-max')),
            weeklyReturn: parseFloat(this.getAttribute('data-return'))
          };
          toStep2.disabled = false;
        });
      });

      // Move from Step 1 to Step 2
      toStep2.addEventListener('click', function() {
        if (!selectedPlan) return;
        // Populate selected plan summary in step 2
        document.getElementById('selectedPlanName').textContent = selectedPlan.name;
        document.getElementById('selectedPlanRange').textContent = `$${selectedPlan.min.toLocaleString()} - $${selectedPlan.max === 100000000 ? '∞' : selectedPlan.max.toLocaleString()}`;
        document.getElementById('selectedPlanReturn').textContent = selectedPlan.weeklyReturn + '%';
        document.getElementById('selectedPlanMonthlyReturn').textContent = (selectedPlan.weeklyReturn * 4) + '%';
        step1.classList.add('hidden');
        step2.classList.remove('hidden');
      });

      // Back from Step 2 to Step 1
      backToStep1.addEventListener('click', function() {
        step2.classList.add('hidden');
        step1.classList.remove('hidden');
      });

      // Move from Step 2 to Step 3
      toStep3.addEventListener('click', function() {
        const amountValue = parseFloat(document.getElementById('amountInput').value);
        if (isNaN(amountValue) || amountValue < selectedPlan.min || amountValue > selectedPlan.max) {
          document.getElementById('amountError').classList.remove('hidden');
          return;
        } else {
          document.getElementById('amountError').classList.add('hidden');
        }

        // Update currency equivalents (for simplicity, using fixed conversion rates)
        // In a real scenario, you would fetch current conversion rates.
        document.getElementById('btcValue').textContent = (amountValue / 30000).toFixed(8) + ' BTC';
        document.getElementById('ethValue').textContent = (amountValue / 2000).toFixed(8) + ' ETH';

        // Populate confirmation details
        document.getElementById('confirmPlan').textContent = selectedPlan.name;
        document.getElementById('confirmAmount').textContent = '$' + amountValue.toLocaleString();
        document.getElementById('confirmReturn').textContent = selectedPlan.weeklyReturn + '%';

        // Get selected cryptocurrency details
        const cryptoSelect = document.getElementById('cryptoSelect');
        const selectedOption = cryptoSelect.options[cryptoSelect.selectedIndex];
        const cryptoName = selectedOption.value;
        document.getElementById('confirmCrypto').textContent = cryptoName;

        // Update wallet address and hidden form fields
        const walletAddress = selectedOption.getAttribute('data-address');
        document.getElementById('walletAddress').value = walletAddress;
        document.getElementById('formPlan').value = selectedPlan.name;
        document.getElementById('formAmount').value = amountValue;
        document.getElementById('formCrypto').value = cryptoName;
        document.getElementById('formAddress').value = walletAddress;

        // Generate QR code
        document.getElementById('qrcode').innerHTML = '';
        new QRCode(document.getElementById("qrcode"), {
          text: walletAddress,
          width: 128,
          height: 128
        });

        step2.classList.add('hidden');
        step3.classList.remove('hidden');
      });

      // Back from Step 3 to Step 2
      backToStep2.addEventListener('click', function() {
        step3.classList.add('hidden');
        step2.classList.remove('hidden');
      });

      // Copy wallet address to clipboard
      document.getElementById('copyAddress').addEventListener('click', function() {
        const walletInput = document.getElementById('walletAddress');
        walletInput.select();
        walletInput.setSelectionRange(0, 99999); // For mobile devices
        document.execCommand("copy");
        alert("Wallet address copied!");
      });

      // Initial API calls
      fetchTopCryptos();
      fetchTopGainers();
      fetchGlobalStats();
    });
  </script>
</body>
</html>
