<?php
// Start session only if it hasn't already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Database credentials - consider moving these to a config file for better security
$servername = "localhost";
$username = "rhyigjwq_userm";
$password = "PfNLDqaoRSXY";
$dbname = "rhyigjwq_dbm";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    error_log("Connection failed: " . $conn->connect_error);
    $_SESSION['notification_message'] = "System error. Please contact support.";
    $_SESSION['notification_color'] = "red";
    echo "System error. Please contact support.";
    exit();
}

// Process the form if the request method is POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get and sanitize inputs
    $special_number = trim(htmlspecialchars($_POST['special_number']));
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['notification_message'] = "Invalid email format.";
        $_SESSION['notification_color'] = "red";
        header("Location: idcard.php");
        exit();
    }
    
    // Check if image was uploaded
    if (!isset($_FILES['image']) || $_FILES['image']['error'] !== 0) {
        $error_messages = [
            1 => "The uploaded file exceeds the upload_max_filesize directive.",
            2 => "The uploaded file exceeds the MAX_FILE_SIZE directive.",
            3 => "The uploaded file was only partially uploaded.",
            4 => "No file was uploaded.",
            6 => "Missing a temporary folder.",
            7 => "Failed to write file to disk.",
            8 => "A PHP extension stopped the file upload."
        ];
        
        // Using isset() to replace the null coalescing operator
        $error_code = isset($_FILES['image']['error']) ? $_FILES['image']['error'] : 4;
        $error_message = isset($error_messages[$error_code]) ? $error_messages[$error_code] : "Unknown upload error.";
        
        $_SESSION['notification_message'] = "Image upload failed: $error_message";
        $_SESSION['notification_color'] = "red";
        header("Location: idcard.php");
        exit();
    }
    
    // Get image details
    $image = $_FILES['image'];
    $fileType = strtolower(pathinfo($image['name'], PATHINFO_EXTENSION));
    
    // Validate file type
    $allowedTypes = ['jpg', 'jpeg', 'png', 'webp', 'svg'];
    if (!in_array($fileType, $allowedTypes)) {
        $_SESSION['notification_message'] = "Only JPG, JPEG, PNG, WEBP and SVG files are allowed.";
        $_SESSION['notification_color'] = "red";
        header("Location: idcard.php");
        exit();
    }
    
    // Validate file size (2MB limit)
    if ($image['size'] > 2097152) { // 2MB in bytes
        $_SESSION['notification_message'] = "Image size must be less than 2MB.";
        $_SESSION['notification_color'] = "red";
        header("Location: idcard.php");
        exit();
    }
    
    // Create a secure filename
    $image_new_name = bin2hex(random_bytes(16)) . '.' . $fileType;
    $upload_directory = 'uploads/';
    $image_destination = $upload_directory . $image_new_name;
    
    // Make sure the upload directory exists
    if (!file_exists($upload_directory)) {
        if (!mkdir($upload_directory, 0755, true)) {
            error_log("Failed to create upload directory");
            $_SESSION['notification_message'] = "System error. Please contact support.";
            $_SESSION['notification_color'] = "red";
            header("Location: idcard.php");
            exit();
        }
    }
    
    // Move uploaded file
    if (move_uploaded_file($image['tmp_name'], $image_destination)) {
        error_log("Image uploaded successfully: $image_destination");
        
        // Validate against special number (mtccode)
        try {
            // Prepare statement for mtccode validation
            $stmt = $conn->prepare("SELECT mtccode FROM admin WHERE mtccode = ?");
            if (!$stmt) {
                throw new Exception("Database error: " . $conn->error);
            }
            
            $stmt->bind_param("s", $special_number);
            if (!$stmt->execute()) {
                throw new Exception("Query execution failed: " . $stmt->error);
            }
            
            $stmt->store_result();
            
            if ($stmt->num_rows === 0) {
                // Invalid special number
                unlink($image_destination); // Delete the uploaded file
                throw new Exception("Invalid ID special Tag.");
            }
            
            $stmt->close();
            
            // Update user's image
            $update_stmt = $conn->prepare("UPDATE users SET image = ? WHERE email = ?");
            if (!$update_stmt) {
                throw new Exception("Database error: " . $conn->error);
            }
            
            $update_stmt->bind_param("ss", $image_new_name, $email);
            if (!$update_stmt->execute()) {
                throw new Exception("Failed to update profile: " . $update_stmt->error);
            }
            
            // Check if any rows were affected
            if ($update_stmt->affected_rows === 0) {
                unlink($image_destination); // Delete the uploaded file
                throw new Exception("No user found with this email address.");
            }
            
            $update_stmt->close();
            
            // Success
            $_SESSION['notification_message'] = "ID Card successfully created!";
            $_SESSION['notification_color'] = "green";
            header("Location: idcc.php"); // Redirect to ID card display page
            exit();
            
        } catch (Exception $e) {
            error_log("Error in ID card processing: " . $e->getMessage());
            $_SESSION['notification_message'] = $e->getMessage();
            $_SESSION['notification_color'] = "red";
            header("Location: idcard.php");
            exit();
        }
    } else {
        $err = error_get_last();
        error_log("Failed to move uploaded file: " . (isset($err['message']) ? $err['message'] : 'Unknown error'));
        $_SESSION['notification_message'] = "Failed to upload image. Please try again.";
        $_SESSION['notification_color'] = "red";
        header("Location: idcard.php");
        exit();
    }
}

// If the request method is GET, display the form
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create ID Card</title>
</head>
<body>
    <?php
    // Display any notification message if set in the session
    if (isset($_SESSION['notification_message'])) {
        $color = isset($_SESSION['notification_color']) ? $_SESSION['notification_color'] : "black";
        echo "<p style='color: $color;'>" . htmlspecialchars($_SESSION['notification_message']) . "</p>";
        // Clear the notification message after displaying it
        unset($_SESSION['notification_message'], $_SESSION['notification_color']);
    }
    ?>
    <h1>Create ID Card</h1>
    <form action="idcard.php" method="post" enctype="multipart/form-data">
        <label for="special_number">Special Number (MTC Code):</label>
        <input type="text" id="special_number" name="special_number" required>
        <br><br>
        <label for="email">Email Address:</label>
        <input type="email" id="email" name="email" required>
        <br><br>
        <label for="image">Upload Image (JPG, JPEG, PNG, WEBP, SVG):</label>
        <input type="file" id="image" name="image" accept=".jpg, .jpeg, .png, .webp, .svg" required>
        <br><br>
        <input type="submit" value="Create ID Card">
    </form>
</body>
</html>
<?php
// Close database connection
$conn->close();
?>
