<?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>

<main class="w-full px-6 pb-6 pt-[100px] sm:pt-[156px] xl:px-[48px] xl:pb-[48px]">
<?php
require('connect.php');
session_start();

if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit();
}

$SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);

// Query to get withdrawal data
$withdrawalQuery = mysqli_query($connection, 
    "SELECT transid, email, amount, date, status, currency, withmethod 
    FROM withdrawal 
    WHERE email='$SEshopmail'
    ORDER BY date DESC") or die(mysqli_error($connection));

// Query to get deposit data
$depositQuery = mysqli_query($connection, 
    "SELECT transid, email, amount, date, status, currenc, depositmethod 
    FROM deposit 
    WHERE userid='$SEshopmail'
    ORDER BY date DESC") or die(mysqli_error($connection));

$totalWithdrawal = 0;
$totalDeposit = 0;

// Calculating total withdrawal amount
while ($row = mysqli_fetch_assoc($withdrawalQuery)) {
    $totalWithdrawal += $row['amount'];
}
// Reset pointer to be able to loop later
mysqli_data_seek($withdrawalQuery, 0);

// Calculating total deposit amount
while ($row = mysqli_fetch_assoc($depositQuery)) {
    $totalDeposit += $row['amount'];
}
// Reset pointer to be able to loop later
mysqli_data_seek($depositQuery, 0);

// Get the currency for withdrawals
$withdrawalCurrency = '$'; // default value in case no record is found
if (mysqli_num_rows($withdrawalQuery) > 0) {
    $firstWithdrawal = mysqli_fetch_assoc($withdrawalQuery);
    $withdrawalCurrency = $firstWithdrawal['currency'];
    // Rewind to loop over the results later if needed
    mysqli_data_seek($withdrawalQuery, 0);
}

// Get the currency for deposits
$depositCurrency = '$'; // default value in case no record is found
if (mysqli_num_rows($depositQuery) > 0) {
    $firstDeposit = mysqli_fetch_assoc($depositQuery);
    $depositCurrency = $firstDeposit['currency'];
    mysqli_data_seek($depositQuery, 0);
}
?>

<!-- ... Your HTML code continues ... -->

<script src="https://cdn.tailwindcss.com"></script>

<div class="w-full rounded-lg bg-white px-[24px] py-[20px] dark:bg-darkblack-600">
  <div class="flex flex-col space-y-8">

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
      <div class="bg-red-50 p-6 rounded-xl dark:bg-darkblack-500">
        <h3 class="text-lg font-bold text-red-600 dark:text-red-400">Total Withdrawals</h3>
        <p class="text-3xl font-semibold mt-2 text-red-700 dark:text-red-300">
          <?php echo htmlspecialchars($withdrawalCurrency); ?>
          <?php echo number_format($totalWithdrawal, 2); ?>
        </p>
      </div>
      <div class="bg-green-50 p-6 rounded-xl dark:bg-darkblack-500">
        <h3 class="text-lg font-bold text-green-600 dark:text-green-400">Total Deposits</h3>
        <p class="text-3xl font-semibold mt-2 text-green-700 dark:text-green-300">
          <?php echo htmlspecialchars($depositCurrency); ?>
          <?php echo number_format($totalDeposit, 2); ?>
        </p>
      </div>
    </div>

    <!-- Withdrawals Section -->
    <div>
      <h2 class="text-lg font-bold dark:text-white mb-3">Withdrawal Transactions</h2>
      <div class="table-content w-full overflow-x-auto">
        <table class="w-full">
          <thead>
            <tr class="border-b border-bgray-300 dark:border-darkblack-400">
              <th class="py-4">Select</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Transaction ID</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Amount</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Date</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Status</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Method</th>
            </tr>
          </thead>
          <tbody>
            <?php if (mysqli_num_rows($withdrawalQuery) > 0): ?>
              <?php while ($row = mysqli_fetch_assoc($withdrawalQuery)): ?>
                <tr class="border-b border-bgray-300 dark:border-darkblack-400">
                  <td class="py-4"><input type="checkbox" class="h-5 w-5"></td>
                  <td class="px-6 py-4 text-red-600 dark:text-red-400 font-mono">
                    <?php echo htmlspecialchars($row['transid']); ?>
                  </td>
                  <td class="px-6 py-4 text-red-600 dark:text-red-400 font-semibold">
                    <?php echo htmlspecialchars($row['currency']); ?>
                    <?php echo number_format($row['amount'], 2); ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo date('M j, Y H:i', strtotime($row['date'])); ?>
                  </td>
                  <td class="px-6 py-4">
                    <?php 
                    switch($row['status']) {
                      case 'Completed':
                        echo '<span class="px-3 py-1 rounded-full bg-red-100 text-red-800 text-sm">Completed</span>';
                        break;
                      case 'Pending':
                        echo '<span class="px-3 py-1 rounded-full bg-yellow-100 text-yellow-800 text-sm">Pending</span>';
                        break;
                      case 'Failed':
                        echo '<span class="px-3 py-1 rounded-full bg-gray-100 text-gray-800 text-sm">Failed</span>';
                        break;
                      default:
                        echo '<span class="px-3 py-1 rounded-full bg-red-100 text-red-800 text-sm">'.htmlspecialchars($row['status']).'</span>';
                    } 
                    ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo htmlspecialchars($row['withmethod']); ?>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" class="py-6 text-center text-gray-500 dark:text-bgray-50">
                  No withdrawal transactions found.
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Deposits Section -->
    <div>
      <h2 class="text-lg font-bold dark:text-white mb-3">Deposit Transactions</h2>
      <div class="table-content w-full overflow-x-auto">
        <table class="w-full">
          <thead>
            <tr class="border-b border-bgray-300 dark:border-darkblack-400">
              <th class="py-4">Select</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Transaction ID</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Amount</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Date</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Status</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Method</th>
            </tr>
          </thead>
          <tbody>
            <?php if (mysqli_num_rows($depositQuery) > 0): ?>
              <?php while ($row = mysqli_fetch_assoc($depositQuery)): ?>
                <tr class="border-b border-bgray-300 dark:border-darkblack-400">
                  <td class="py-4"><input type="checkbox" class="h-5 w-5"></td>
                  <td class="px-6 py-4 text-green-600 dark:text-green-400 font-mono">
                    <?php echo htmlspecialchars($row['transid']); ?>
                  </td>
                  <td class="px-6 py-4 text-green-600 dark:text-green-400 font-semibold">
                    <?php echo htmlspecialchars($row['currency']); ?>
                    <?php echo number_format($row['amount'], 2); ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo date('M j, Y H:i', strtotime($row['date'])); ?>
                  </td>
                  <td class="px-6 py-4">
                    <?php 
                    switch($row['status']) {
                      case 'Completed':
                        echo '<span class="px-3 py-1 rounded-full bg-green-100 text-green-800 text-sm">Completed</span>';
                        break;
                      case 'Pending':
                        echo '<span class="px-3 py-1 rounded-full bg-yellow-100 text-yellow-800 text-sm">Pending</span>';
                        break;
                      case 'Failed':
                        echo '<span class="px-3 py-1 rounded-full bg-gray-100 text-gray-800 text-sm">Failed</span>';
                        break;
                      default:
                        echo '<span class="px-3 py-1 rounded-full bg-green-100 text-green-800 text-sm">'.htmlspecialchars($row['status']).'</span>';
                    } 
                    ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo htmlspecialchars($row['depositmethod']); ?>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" class="py-6 text-center text-gray-500 dark:text-bgray-50">
                  No deposit transactions found.
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

  </div>
</div>

  </div>
</main>

  <script>
    // Helper functions
    function abbreviateNumber(num) {
      if (num >= 1e12) return (num / 1e12).toFixed(2) + "T";
      if (num >= 1e9) return (num / 1e9).toFixed(2) + "B";
      if (num >= 1e6) return (num / 1e6).toFixed(2) + "M";
      if (num >= 1e3) return (num / 1e3).toFixed(2) + "K";
      return num.toString();
    }

    function formatCurrency(value) {
      return '$' + abbreviateNumber(parseFloat(value));
    }

    function formatPercentage(value) {
      const num = parseFloat(value);
      return (num >= 0 ? '+' : '') + num.toFixed(2) + '%';
    }

    function getPercentageClass(value) {
      return parseFloat(value) >= 0 ? 'positive' : 'negative';
    }

    function createSimpleLineChart(ctx, data, color) {
      return new Chart(ctx, {
        type: 'line',
        data: {
          labels: Array(data.length).fill(''),
          datasets: [{
            data: data,
            borderColor: color,
            borderWidth: 2,
            pointRadius: 0,
            tension: 0.1,
            fill: false
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: { legend: { display: false } },
          scales: {
            x: { display: false },
            y: { display: false }
          },
          animation: false
        }
      });
    }

    // Update Fear & Greed Index based on a given value (0-100)
    function updateFearGreedIndex(value) {
      const indicator = document.getElementById('fearGreedIndicator');
      const valueEl = document.getElementById('fearGreedValue');
      const labelEl = document.getElementById('fearGreedLabel');
      valueEl.textContent = value;
      let label = '';
      if (value < 20) label = 'Extreme Fear';
      else if (value < 40) label = 'Fear';
      else if (value < 60) label = 'Neutral';
      else if (value < 80) label = 'Greed';
      else label = 'Extreme Greed';
      labelEl.textContent = label;
      // Adjust indicator position based on value (0-100 scale)
      const meter = document.querySelector('.fear-greed-meter');
      if(meter) {
        const meterWidth = meter.offsetWidth;
        const position = (value / 100) * meterWidth;
        indicator.style.left = `${position}px`;
      }
    }

    // Initialize charts with placeholder data
    const chartData = [65, 59, 80, 81, 56, 55, 40, 45, 60, 70, 75, 72];
    const btcChartCtx = document.getElementById('btcChart').getContext('2d');
    const mcapChartCtx = document.getElementById('mcapChart').getContext('2d');
    const volumeChartCtx = document.getElementById('volumeChart').getContext('2d');
    
    createSimpleLineChart(btcChartCtx, chartData, '#22C55E');
    createSimpleLineChart(mcapChartCtx, chartData, '#22C55E');
    createSimpleLineChart(volumeChartCtx, chartData, '#22C55E');

    // Fetch API data
    async function fetchGlobalData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/global');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Update market cap
        const marketCapUSD = data.data.total_market_cap.usd;
        document.getElementById('marketCap').textContent = formatCurrency(marketCapUSD);
        
        // Update market cap change
        const marketCapChange = data.data.market_cap_change_percentage_24h_usd;
        const marketCapChangeEl = document.getElementById('marketCapChange');
        marketCapChangeEl.textContent = formatPercentage(marketCapChange);
        marketCapChangeEl.className = getPercentageClass(marketCapChange) + ' text-sm font-medium';
        
        // Update trading volume
        const volumeUSD = data.data.total_volume.usd;
        document.getElementById('tradingVolume').textContent = formatCurrency(volumeUSD);
        
        // Placeholder for volume change since API doesn't provide it directly
        document.getElementById('volumeChange').textContent = '+3.25%';
        
        // Update Fear & Greed Index (using a random value for demonstration)
        updateFearGreedIndex(Math.floor(Math.random() * 100));
        
      } catch (error) {
        console.error('Error fetching global data:', error);
      }
    }

    async function fetchBitcoinData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/coins/bitcoin?localization=false&tickers=false&market_data=true&community_data=false&developer_data=false');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Update Bitcoin price
        const price = data.market_data.current_price.usd;
        document.getElementById('btcPrice').textContent = '$' + price.toLocaleString();
        
        // Update Bitcoin price change
        const priceChange = data.market_data.price_change_percentage_24h;
        const btcChangeEl = document.getElementById('btcChange');
        btcChangeEl.textContent = formatPercentage(priceChange);
        btcChangeEl.className = getPercentageClass(priceChange) + ' text-sm font-medium';
        
      } catch (error) {
        console.error('Error fetching Bitcoin data:', error);
      }
    }

    async function fetchMarketData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&order=market_cap_desc&per_page=25&page=1&sparkline=false&price_change_percentage=1h,24h,7d');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Populate coins table
        renderCoinsTable(data);
        
        // Populate top gainers
        renderTopGainers(data);
        
      } catch (error) {
        console.error('Error fetching market data:', error);
      }
    }

    function renderCoinsTable(coins) {
      const container = document.getElementById('coinTableContainer');
      
      const table = document.createElement('table');
      table.className = 'market-table';
      
      // Create table header
      const thead = document.createElement('thead');
      thead.innerHTML = `
        <tr>
          <th>#</th>
          <th>Name</th>
          <th>Price</th>
          <th>1h %</th>
          <th>24h %</th>
          <th>7d %</th>
          <th>Market Cap</th>
          <th>Volume(24h)</th>
        </tr>
      `;
      table.appendChild(thead);
      
      // Create table body
      const tbody = document.createElement('tbody');
      
      coins.forEach((coin, index) => {
        const tr = document.createElement('tr');
        
        tr.innerHTML = `
          <td>${index + 1}</td>
          <td>
            <div class="coin-info">
              <img src="${coin.image}" alt="${coin.name}" class="coin-icon">
              <div>
                <div>${coin.name}</div>
                <div style="color: var(--text-gray);">${coin.symbol.toUpperCase()}</div>
              </div>
            </div>
          </td>
          <td>$${coin.current_price.toLocaleString()}</td>
          <td class="${getPercentageClass(coin.price_change_percentage_1h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_1h_in_currency)}
          </td>
          <td class="${getPercentageClass(coin.price_change_percentage_24h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_24h_in_currency)}
          </td>
          <td class="${getPercentageClass(coin.price_change_percentage_7d_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_7d_in_currency)}
          </td>
          <td>${formatCurrency(coin.market_cap)}</td>
          <td>${formatCurrency(coin.total_volume)}</td>
        `;
        
        tbody.appendChild(tr);
      });
      
      table.appendChild(tbody);
      
      // Replace loading message with table
      container.innerHTML = '';
      container.appendChild(table);
      
      // Add pagination
      const pagination = document.createElement('div');
      pagination.className = 'pagination';
      pagination.innerHTML = `
        <div class="page-btn">Prev</div>
        <div class="page-btn active">1</div>
        <div class="page-btn">2</div>
        <div class="page-btn">3</div>
        <div class="page-btn">4</div>
        <div class="page-btn">5</div>
        <div class="page-btn">Next</div>
      `;
      container.appendChild(pagination);
    }

    function renderTopGainers(coins) {
      // Sort coins by 24h price change
      const gainers = [...coins]
        .sort((a, b) => b.price_change_percentage_24h_in_currency - a.price_change_percentage_24h_in_currency)
        .slice(0, 5);
      
      const container = document.getElementById('gainersContainer');
      container.innerHTML = '';
      
      gainers.forEach(coin => {
        const gainItem = document.createElement('div');
        gainItem.style.display = 'flex';
        gainItem.style.justifyContent = 'space-between';
        gainItem.style.alignItems = 'center';
        gainItem.style.padding = '10px 0';
        gainItem.style.borderBottom = '1px solid rgba(255,255,255,0.1)';
        
        gainItem.innerHTML = `
          <div class="coin-info">
            <img src="${coin.image}" alt="${coin.name}" class="coin-icon">
            <div>
              <div>${coin.name}</div>
              <div style="color: var(--text-gray);">${coin.symbol.toUpperCase()}</div>
            </div>
          </div>
          <div class="${getPercentageClass(coin.price_change_percentage_24h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_24h_in_currency)}
          </div>
        `;
        container.appendChild(gainItem);
      });
    }

    // Initialize data fetching once the page loads
    window.addEventListener('load', () => {
      fetchGlobalData();
      fetchBitcoinData();
      fetchMarketData();
    });
  </script>
  
      <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/flatpickr.js"></script>
    <script>
      // min-calender
      $("#min-calender").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        inline: true,
      });
    </script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script>
      AOS.init();
    </script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/chart.js"></script>
    <script>
      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });


      //totalEarnBar
      const ctx_bids = document
              .getElementById("totalEarnBar")
              .getContext("2d");
      const bitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const bitsData = [10, 20, 15, 50, 40, 25];
      let totalEarnBar = new Chart(ctx_bids, {
        type: "bar",
        data: {
          labels: bitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: bitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //totalSpend
      let totalSpend = document
              .getElementById("totalSpendingBar")
              .getContext("2d");
      const SpendingCharbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const SpendingCharbitsData = [10, 20, 15, 50, 40, 25];
      const totalSpendingChartBar = new Chart(totalSpend, {
        type: "bar",
        data: {
          labels: SpendingCharbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: SpendingCharbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });


      // totalGoalBar
      let totalGoalBarSelect = document.getElementById("totalGoalBar").getContext("2d");
      const totalGoalBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const totalGoalBarbitsData = [10, 20, 15, 50, 40, 25];
      const totalGoalBar = new Chart(totalGoalBarSelect, {
        type: "bar",
        data: {
          labels: totalGoalBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: totalGoalBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //monthSpendingBar
      let monthSpendingBarSelect = document
              .getElementById("monthSpendingBar")
              .getContext("2d");
      const monthSpendingBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const monthSpendingBarbitsData = [10, 20, 15, 50, 40, 25];
      const monthSpendingBar = new Chart(monthSpendingBarSelect, {
        type: "bar",
        data: {
          labels: monthSpendingBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: monthSpendingBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //revenueFlowBar
      let revenueFlowElement = document
              .getElementById("revenueFlowBar")
              .getContext("2d");
      let revenueFlowBarmonth = [
        "Jan",
        "Feb",
        "Mar",
        "April",
        "May",
        "Jun",
        "July",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec",
      ];
      let revenueDark = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueLight = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueFlow = new Chart(revenueFlowElement, {
        type: "bar",
        data: {
          labels: revenueFlowBarmonth,
          datasets: revenueLight,
        },
        options: {
          maintainAspectRatio: false,
          scales: {
            y: {
              beginAtZero: true,
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
              ticks: {
                callback(value) {
                  return `${value}% `;
                },
              },
            },
            x: {
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
            },
          },
          plugins: {
            legend: {
              display: false,
            },
          },
          // x: {
          //   stacked: true,
          // },
          // y: {
          //   stacked: true,
          // },
        },
      });


      function pieChart() {
        let pieChart = document.getElementById("pie_chart").getContext("2d");

        const data = {
          labels: [10, 20, 30],
          datasets: [
            {
              label: "My First Dataset",
              data: [15, 20, 35, 40],
              backgroundColor: ["#1A202C", "#61C660", "#F8CC4B", "#EDF2F7"],
              borderColor: ["#ffffff", "#ffffff", "#ffffff", "#1A202C"],
              hoverOffset: 18,
              borderWidth: 0,
            },
          ],
        };
        const customDatalabels = {
          id: "customDatalabels",
          afterDatasetsDraw(chart, args, pluginOptions) {
            const {
              ctx,
              data,
              chartArea: { top, bottom, left, right, width, height },
            } = chart;
            ctx.save();
            data.datasets[0].data.forEach((datapoint, index) => {
              const { x, y } = chart
                .getDatasetMeta(0)
                .data[index].tooltipPosition();
              ctx.font = "bold 12px sans-serif";
              ctx.fillStyle = data.datasets[0].borderColor[index];
              ctx.textAlign = "center";
              ctx.textBaseline = "middle";
              ctx.fillText(`${datapoint}%`, x, y);
            });
          },
        };
        const config = {
          type: "doughnut",
          data,
          options: {
            maintainAspectRatio: false,
            layout: {
              padding: {
                left: 10,
                right: 10,
                top: 10,
                bottom: 10,
              },
            },
            plugins: {
              legend: {
                display: false,
              },
            },
          },
          plugins: [customDatalabels],
        };

        let pieChartConfiig = new Chart(pieChart, config);
      }
      pieChart();

      //dark chart

      let themeToggleSwitch = document.getElementById('theme-toggle');

      //onclick
      if(themeToggleSwitch){
        themeToggleSwitch.addEventListener('click', function() {
          if(document.documentElement.classList[0]==='dark' || localStorage.theme === 'dark'){
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            revenueFlow.data.datasets=revenueDark;
            revenueFlow.options.scales.y.ticks.color='white';
            revenueFlow.options.scales.x.ticks.color='white';
            revenueFlow.options.scales.x.grid.color='#222429';
            revenueFlow.options.scales.y.grid.color='#222429';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }else{
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            revenueFlow.data.datasets=revenueLight;
            revenueFlow.options.scales.y.ticks.color='black';
            revenueFlow.options.scales.x.ticks.color='black';
            revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
            revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }
        });
      }


      //initial load
      if (localStorage.theme === 'dark' || (window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        revenueFlow.data.datasets=revenueDark;
        revenueFlow.options.scales.y.ticks.color='white';
        revenueFlow.options.scales.x.ticks.color='white';
        revenueFlow.options.scales.x.grid.color='#222429';
        revenueFlow.options.scales.y.grid.color='#222429';
      } else {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        revenueFlow.data.datasets=revenueLight;
        revenueFlow.options.scales.y.ticks.color='black';
        revenueFlow.options.scales.x.ticks.color='black';
        revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
        revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
      }
      totalEarnBar.update();
      totalSpendingChartBar.update();

      totalGoalBar.update();
      monthSpendingBar.update();
      revenueFlow.update();

    </script>


</body>
</html>
