<?php
// Don't start a new session since check-login.php already starts one
// session_start(); - removed this line

// Include database connection file
include_once("z_db.php");

// Set error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include login check
include 'action/check-login.php';

// Check if user is logged in
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    print "<script language='javascript'>window.location = 'logout.php';</script>";
    exit;
}

// Check if email session exists
if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit;
}

$SEshopmail = $_SESSION['email'];

// Establish database connection - we'll use the connection from the included file
// Make sure $con is defined in z_db.php
// If not already defined, create it here:
if (!isset($con)) {
    $servername = "localhost";
    $username = "rhyigjwq_userm";
    $password = "PfNLDqaoRSXY";
    $dbname = "rhyigjwq_dbm";

    // Create connection
    $con = new mysqli($servername, $username, $password, $dbname);

    // Check connection
    if ($con->connect_error) {
        die("Connection failed: " . $con->connect_error);
    }
}

// Check if user needs to complete OTP verification
$query = "SELECT * FROM `users` WHERE email='$SEshopmail' and upgrade='notupdated'";
$result = mysqli_query($con, $query) or die(mysqli_error($con));

if (mysqli_num_rows($result) > 0) {
    $_SESSION['email'] = $SEshopmail;
    echo ("<SCRIPT LANGUAGE='JavaScript'>window.location.href='../otp.php';</SCRIPT>");
    exit;
}

// Get user ID from email
$getUserQuery = "SELECT id FROM users WHERE email = '$SEshopmail'";
$userResult = mysqli_query($con, $getUserQuery);
$userData = mysqli_fetch_assoc($userResult);
$userId = $userData['id'];

// Configuration
$uploadDir = 'uploads/profile_images/';
$maxFileSize = 5 * 1024 * 1024; // 5MB in bytes
$allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/bmp', 'image/webp'];

// Create upload directory if it doesn't exist
if (!is_dir($uploadDir)) {
    if (!mkdir($uploadDir, 0755, true)) {
        redirect('error', 'Failed to create upload directory. Please contact administrator.');
    }
}

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if file was uploaded successfully
    if (isset($_FILES['profileImage']) && $_FILES['profileImage']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['profileImage'];
        
        // Validate file size
        if ($file['size'] > $maxFileSize) {
            redirect('error', 'File size exceeds the maximum allowed limit (5MB).');
        }
        
        // Validate file type
        $fileType = mime_content_type($file['tmp_name']);
        if (!in_array($fileType, $allowedTypes)) {
            redirect('error', 'Invalid file type. Please upload a JPG, JPEG, PNG, GIF, BMP or WEBP file.');
        }
        
        // Generate unique filename
        $fileExtension = pathinfo($file['name'], PATHINFO_EXTENSION);
        $newFilename = $userId . '_' . time() . '.' . $fileExtension;
        $targetFile = $uploadDir . $newFilename;
        
        // Move uploaded file to target directory
        if (move_uploaded_file($file['tmp_name'], $targetFile)) {
            // Update user profile in database
            // Using the existing connection rather than creating a new PDO connection
            $updateQuery = "UPDATE users SET profile_image = '$newFilename', updated_at = NOW() WHERE id = $userId";
            if (mysqli_query($con, $updateQuery)) {
                // If previous profile image exists, delete it
                deletePreviousProfileImage($userId, $newFilename);
                
                // Redirect with success message
                redirect('success', 'Profile image updated successfully!');
            } else {
                // Database update failed, delete the uploaded file
                if (file_exists($targetFile)) {
                    unlink($targetFile);
                }
                redirect('error', 'Failed to update profile in database: ' . mysqli_error($con));
            }
        } else {
            redirect('error', 'Failed to upload file. Please try again.');
        }
    } else {
        // Handle file upload errors
        $uploadError = $_FILES['profileImage']['error'];
        $errorMessage = getUploadErrorMessage($uploadError);
        redirect('error', $errorMessage);
    }
} else {
    // Not a POST request, redirect to profile page
    header("Location: profile.php");
    exit;
}

/**
 * Delete previous profile image
 * 
 * @param int $userId User ID
 * @param string $newFilename New filename to exclude from deletion
 * @return void
 */
function deletePreviousProfileImage($userId, $newFilename) {
    global $uploadDir;
    
    // Find and delete old profile images for this user
    $pattern = $uploadDir . $userId . '_*';
    $files = glob($pattern);
    
    foreach ($files as $file) {
        $filename = basename($file);
        if ($filename !== $newFilename && file_exists($file)) {
            unlink($file);
        }
    }
}

/**
 * Get meaningful error message for file upload errors
 * 
 * @param int $errorCode PHP file upload error code
 * @return string Human-readable error message
 */
function getUploadErrorMessage($errorCode) {
    switch ($errorCode) {
        case UPLOAD_ERR_INI_SIZE:
            return 'The uploaded file exceeds the upload_max_filesize directive in php.ini.';
        case UPLOAD_ERR_FORM_SIZE:
            return 'The uploaded file exceeds the MAX_FILE_SIZE directive in the HTML form.';
        case UPLOAD_ERR_PARTIAL:
            return 'The uploaded file was only partially uploaded.';
        case UPLOAD_ERR_NO_FILE:
            return 'No file was uploaded. Please select an image file.';
        case UPLOAD_ERR_NO_TMP_DIR:
            return 'Missing a temporary folder. Please contact the administrator.';
        case UPLOAD_ERR_CANT_WRITE:
            return 'Failed to write file to disk. Please contact the administrator.';
        case UPLOAD_ERR_EXTENSION:
            return 'A PHP extension stopped the file upload. Please contact the administrator.';
        default:
            return 'Unknown upload error. Please try again.';
    }
}

/**
 * Redirect with status and message
 * 
 * @param string $status Success or error
 * @param string $message Message to display
 * @return void
 */
function redirect($status, $message) {
    $message = urlencode($message);
    header("Location: profile.php?status=$status&message=$message");
    exit;
}
?>