
    <?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>

        
  
  
          <main class="w-full xl:px-[48px] px-6 pb-6 xl:pb-[48px] sm:pt-[156px] pt-[100px]">
            <!-- write your code here-->
            <div class="2xl:flex 2xl:space-x-[48px]">
              <section class="2xl:flex-1 2xl:mb-0 mb-6">
                <!-- revenue, flow -->
                <div class="w-full mb-[24px] xl:flex xl:space-x-[24px]">
                  <div class="xl:w-66 w-full bg-white dark:bg-darkblack-600 flex flex-col justify-between rounded-lg px-6 py-3">
                    <div class="flex justify-between items-center pb-2 mb-2 border-b border-bgray-300">
                      <h3 class="text-bgray-900 dark:text-white sm:text-2xl text-xl font-bold">
                        Summary
                      </h3>
                      <div class="sm:flex hidden space-x-[28px] items-center">
                        <div class="flex space-x-2 items-center">
                          <div class="w-3 h-3 bg-success-300 rounded-full"></div>
                          <span class="text-bgray-700 dark:text-bgray-50 text-sm font-medium">Signed
                          </span>
                        </div>
                        <div class="flex space-x-2 items-center">
                          <div class="w-3 h-3 bg-orange rounded-full"></div>
                          <span class="text-bgray-700 dark:text-bgray-50 text-sm font-medium">Lost
                          </span>
                        </div>
                      </div>
                      <div class="date-filter relative">
                        <button onclick="dateFilterAction('#date-filter-body')" type="button" class="px-3 py-2 bg-bgray-100 dark:bg-darkblack-500  flex space-x-1 items-center rounded-lg overflow-hidden">
                          <span class="text-sm font-medium text-bgray-900 dark:text-white">Jan 10 - Jan 16</span>
                          <span>
                            <svg class="stroke-bgray-900 dark:stroke-gray-50" width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path d="M4 6.5L8 10.5L12 6.5" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                          </span>
                        </button>
                        <div id="date-filter-body" class="rounded-lg shadow-lg bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-[44px] hidden overflow-hidden">
                        <ul>
                          <li onclick="dateFilterAction('#paymentFilter')" class="text-sm  text-bgray-90 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 font-semibold">
                            Jan 10 - Jan 16
                          </li>
                          <li onclick="dateFilterAction('#paymentFilter')" class="text-sm  text-bgray-900 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 font-semibold">
                            Jan 10 - Jan 16
                          </li>
                          <li onclick="dateFilterAction('#paymentFilter')" class="text-sm  text-bgray-900 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 font-semibold">
                            Jan 10 - Jan 16
                          </li>
                        </ul>
                        </div>
                      </div>
                    </div>
                    <div class="w-full">
                      <canvas id="revenueFlowLine" height="382" width="990" style="display: block; box-sizing: border-box; height: 254.667px; width: 660px;"></canvas>
                    </div>
                  </div>
                  <div class="flex-1 xl:block hidden">
                    <div class="bg-white dark:bg-darkblack-600 rounded-lg">
                      <div class="flex px-[20px] py-[12px] justify-between items-center border-b border-bgray-300 dark:border-darkblack-400">
                        <h3 class="text-bgray-900 dark:text-white text-xl font-bold">
                          Trade Efficiency
                        </h3>
                        
                        
                        
                        
                        
        <script>
            function updateSelection(value) {
                window.location.href = '?view=' + value;
            }
        </script>
<!-- Dropdown Menu -->
<div class="date-filter relative">
    <button onclick="dateFilterAction('#month-filter')" type="button" class="flex space-x-1 items-center">
        <span class="text-base font-semibold text-bgray-900 dark:text-white">
            Balance        </span>
        <span>
            <svg class="stroke-bgray-900 dark:stroke-bgray-50" width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M4 6.5L8 10.5L12 6.5" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
        </span>
    </button>
    <div id="month-filter" class="rounded-lg shadow-lg bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-5 overflow-hidden hidden">
        <ul>
            <li onclick="updateSelection('balance'); dateFilterAction('#month-filter')" class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold dark:text-white hover:dark:bg-darkblack-600">
                Balance
            </li>
            <li onclick="updateSelection('profit'); dateFilterAction('#month-filter')" class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold dark:text-white hover:dark:bg-darkblack-600">
                Profit
            </li>
            <li onclick="updateSelection('bonus'); dateFilterAction('#month-filter')" class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold dark:text-white hover:dark:bg-darkblack-600">
                Bonus
            </li>
        </ul>
    </div>
</div>

<!-- Display the value with formatting -->
<p class="text-success-300 text-lg font-bold">
   </p>

                        
                        
                        
                        
                       
                      </div>
                      <div class="px-[20px] py-[12px]">
                        <div class="flex space-x-8 items-center mb-4">
                          <div class="w-[180px] relative">
                            <canvas id="pie_chart" height="252" width="270" style="display: block; box-sizing: border-box; height: 168px; width: 180px;"></canvas>
                            <div class="w-[34px] h-[34px] bg-[#EDF2F7] absolute z-0 rounded-full" style="
                                left: calc(50% - 17px);
                                top: calc(50% - 17px);
                              "></div>
                          </div>
                          <div class="counting">
                            <div class="mb-6">
                              <div class="flex items-center space-x-[2px]">
                               
                                <span><svg width="14" height="12" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7749 0.558058C10.5309 0.313981 10.1351 0.313981 9.89107 0.558058L7.39107 3.05806C7.14699 3.30214 7.14699 3.69786 7.39107 3.94194C7.63514 4.18602 8.03087 4.18602 8.27495 3.94194L9.70801 2.50888V11C9.70801 11.3452 9.98783 11.625 10.333 11.625C10.6782 11.625 10.958 11.3452 10.958 11V2.50888L12.3911 3.94194C12.6351 4.18602 13.0309 4.18602 13.2749 3.94194C13.519 3.69786 13.519 3.30214 13.2749 3.05806L10.7749 0.558058Z" fill="#22C55E"></path>
                                    <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M3.22407 11.4419C3.46815 11.686 3.86388 11.686 4.10796 11.4419L6.60796 8.94194C6.85203 8.69786 6.85203 8.30214 6.60796 8.05806C6.36388 7.81398 5.96815 7.81398 5.72407 8.05806L4.29102 9.49112L4.29101 1C4.29101 0.654823 4.01119 0.375001 3.66602 0.375001C3.32084 0.375001 3.04102 0.654823 3.04102 1L3.04102 9.49112L1.60796 8.05806C1.36388 7.81398 0.968151 7.81398 0.724074 8.05806C0.479996 8.30214 0.479996 8.69786 0.724074 8.94194L3.22407 11.4419Z" fill="#22C55E"></path>
                                  </svg>
                                </span>
                              </div>
                              <p class="text-bgray-600 text-base font-medium">
                                Arrival
                              </p>
                            </div>
                            <div>
                              <div class="flex items-center space-x-[2px]">
                                <p class="text-bgray-900 dark:text-white text-lg font-bold">
                                  $6,230
                                </p>
                                <span>
                                  <svg class="fill-bgray-900 dark:fill-bgray-50" width="14" height="12" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7749 0.558058C10.5309 0.313981 10.1351 0.313981 9.89107 0.558058L7.39107 3.05806C7.14699 3.30214 7.14699 3.69786 7.39107 3.94194C7.63514 4.18602 8.03087 4.18602 8.27495 3.94194L9.70801 2.50888V11C9.70801 11.3452 9.98783 11.625 10.333 11.625C10.6782 11.625 10.958 11.3452 10.958 11V2.50888L12.3911 3.94194C12.6351 4.18602 13.0309 4.18602 13.2749 3.94194C13.519 3.69786 13.519 3.30214 13.2749 3.05806L10.7749 0.558058Z"></path>
                                    <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M3.22407 11.4419C3.46815 11.686 3.86388 11.686 4.10796 11.4419L6.60796 8.94194C6.85203 8.69786 6.85203 8.30214 6.60796 8.05806C6.36388 7.81398 5.96815 7.81398 5.72407 8.05806L4.29102 9.49112L4.29101 1C4.29101 0.654823 4.01119 0.375001 3.66602 0.375001C3.32084 0.375001 3.04102 0.654823 3.04102 1L3.04102 9.49112L1.60796 8.05806C1.36388 7.81398 0.968151 7.81398 0.724074 8.05806C0.479996 8.30214 0.479996 8.69786 0.724074 8.94194L3.22407 11.4419Z"></path>
                                  </svg>
                                </span>
                              </div>
                              <p class="text-bgray-600 dark:text-bgray-50 text-base font-medium">
                                Capital
                              </p>
                            </div>
                          </div>
                        </div>
                        <div class="status">
                          <div class="flex justify-between items-center mb-1.5">
                            <div class="flex space-x-3 items-center">
                              <div class="w-2.5 h-2.5 rounded-full bg-success-300"></div>
                              <span class="text-sm text-bgray-600 dark:text-bgray-50 font-medium">Profit</span>
                            </div>
                            <p class="text-bgray-900 font-bold text-sm dark:text-bgray-50">13%</p>
                          </div>
                          <div class="flex justify-between items-center mb-1.5">
                            <div class="flex space-x-3 items-center">
                              <div class="w-2.5 h-2.5 rounded-full bg-warning-300"></div>
                              <span class="text-sm text-bgray-600 dark:text-white font-medium">Capital</span>
                            </div>
                            <p class="text-bgray-900 font-bold text-sm dark:text-bgray-50">28%</p>
                          </div>
                          <div class="flex justify-between items-center mb-1.5">
                            <div class="flex space-x-3 items-center">
                              <div class="w-2.5 h-2.5 rounded-full bg-bgray-200"></div>
                              <span class="text-sm text-bgray-600 dark:text-white font-medium">Others</span>
                            </div>
                            <p class="text-bgray-900 font-bold text-sm dark:text-bgray-50">59%</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>                  </div>
                </div>
                <!-- most location and task summery-->
                <div class="w-full xl:flex xl:space-x-[24px] mb-[48px]">
                  <div class="xl:w-66 w-full rounded-lg bg-white dark:bg-darkblack-600 p-6">
                    <div class="flex justify-between items-center mb-4">
                      <h3 class="text-bgray-900 dark:text-white sm:text-2xl text-xl font-bold">
                        Most locations
                      </h3>
                      <div class="date-filter relative">
                        <button onclick="dateFilterAction('#location-filter')" type="button" class="p-3.5 border border-bgray-300 dark:border-darkblack-400 flex space-x-1 items-center rounded-lg overflow-hidden">
                          <span class="text-sm font-medium text-bgray-900 dark:text-white">This Year</span>
                          <span>
                            <svg class="stroke-bgray-900 dark:stroke-white" width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path d="M4 6.5L8 10.5L12 6.5" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                          </span>
                        </button>
                        <div id="location-filter" class="rounded-lg w-[150px] shadow-lg bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-ful hidden overflow-hidden">
                          <ul>
                            <li onclick="dateFilterAction('#location-filter')" class="text-sm  text-bgray-90 cursor-pointer px-5 py-2 hover:bg-bgray-100 dark:text-white hover:dark:bg-darkblack-600 font-semibold">
                              Jan 10 - Jan 16
                            </li>
                            <li onclick="dateFilterAction('#location-filter')" class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 dark:text-white hover:dark:bg-darkblack-600 font-semibold">
                              Jan 10 - Jan 16
                            </li>
                            <li onclick="dateFilterAction('#location-filter')" class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 dark:text-white hover:dark:bg-darkblack-600 font-semibold">
                              Jan 10 - Jan 16
                            </li>
                          </ul>
                        </div>
                      </div>
                    </div>
                    <div class="xl:flex xl:space-x-[26px] items-center">
                      <div class="xl:flex-1 w-full mb-4 xl:mb-0">
                        <div class="flex space-x-2 items-end mb-1">
                          <h1 class="text-2xl dark:text-white font-bold leading-[30px] text-bgray-900">
                            76,345
                          </h1>
                          <div class="w-[60px] h-[22px] rounded-full bg-success-400 flex justify-center items-center">
                            <div class="flex space-x-1 items-center">
                              <span>
                                <svg width="10" height="7" viewBox="0 0 10 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <path d="M0.5 5.89575L3.5 2.89575L5.5 4.89575L9.5 0.895752" stroke="white" stroke-linecap="round" stroke-linejoin="round"></path>
                                  <path d="M6 0.895752H9.5V4.39575" stroke="white" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                              </span>
                              <span class="text-white text-xs font-medium">12,00%</span>
                            </div>
                          </div>
                        </div>
                        <p class="text-sm text-bgray-600 dark:text-darkblack-300 mb-7">
                          Compared to last month
                        </p>
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                       <?php
require('connect.php');

// Query to fetch country names and count the number of users per country
$userquery = mysqli_query($connection, "SELECT country, COUNT(*) as user_count FROM users GROUP BY country") or die(mysqli_error($connection));

// Prepare an array for the JavaScript map markers and an array for the HTML list
$markers = [];
$country_list = "";

// Fetching data from the database
while ($row = mysqli_fetch_array($userquery)) {
    $country = htmlspecialchars($row['country']);
    $user_count = $row['user_count'];

    // Generate dynamic markers
    $coords = []; // Default empty
    switch ($country) {
        case 'United States':
            $coords = [37.0902, -95.7129];
            $color = 'bg-success-300';
            break;
        case 'California':
            $coords = [36.7783, -119.4179];
            $color = 'bg-warning-300';
            break;
        case 'Dhaka':
            $coords = [23.8103, 90.4125];
            $color = 'bg-purple';
            break;
        case 'Los Angeles':
            $coords = [34.0522, -118.2437];
            $color = 'bg-error-300';
            break;
        default:
            $coords = [0, 0]; // Default
            $color = 'bg-bgray-100'; // Default color
            break;
    }

    // Add to markers array
    $markers[] = [
        'name' => $country,
        'coords' => $coords,
    ];

    // Generate HTML list dynamically
    $country_list .= '
    <div class="w-full h-[32px] px-2 bg-bgray-100 dark:bg-darkblack-500 rounded-lg flex justify-between items-center">
        <div class="flex space-x-2 items-center">
            <div class="w-2 h-2 rounded-full ' . $color . '"></div>
            <span class="text-bgray-900 dark:text-white text-sm font-medium">' . $country . '</span>
        </div>
        <span class="text-bgray-600 text-sm font-medium">' . $user_count . '</span>
    </div>';
}
?>

    <script src="jsvector-map.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        /* Additional styling if required */
    </style>

    <div id="world-map" style="width: 100%; height: 300px;"></div>

    <!-- Dynamic Country List -->
    <div class="flex flex-col space-y-2.5">
        <?php echo $country_list; ?>
    </div>

   

                      </div>
                     </div>
                     
                  </div>
                  <div class="flex-1 xl:block hidden">
                    <div class="w-full rounded-lg px-5 py-6 bg-white dark:bg-darkblack-600 h-full">
                      <div class="flex justify-between items-center mb-8">
                        <h2 class="text-base xl:text-2xl text-bgray-900 dark:text-white font-bold">
                          Trade Summary
                        </h2>
                        <span>
                          <svg width="14" height="4" viewBox="0 0 14 4" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M2.33317 2.66659C2.70136 2.66659 2.99984 2.36811 2.99984 1.99992C2.99984 1.63173 2.70136 1.33325 2.33317 1.33325C1.96498 1.33325 1.6665 1.63173 1.6665 1.99992C1.6665 2.36811 1.96498 2.66659 2.33317 2.66659Z" stroke="#64748B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M6.99967 2.66659C7.36786 2.66659 7.66634 2.36811 7.66634 1.99992C7.66634 1.63173 7.36786 1.33325 6.99967 1.33325C6.63148 1.33325 6.33301 1.63173 6.33301 1.99992C6.33301 2.36811 6.63148 2.66659 6.99967 2.66659Z" stroke="#64748B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M11.6667 2.66659C12.0349 2.66659 12.3333 2.36811 12.3333 1.99992C12.3333 1.63173 12.0349 1.33325 11.6667 1.33325C11.2985 1.33325 11 1.63173 11 1.99992C11 2.36811 11.2985 2.66659 11.6667 2.66659Z" stroke="#64748B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                          </svg>
                        </span>
                      </div>
                      <div class="flex space-x-3 mb-10">
                        <div class="w-full h-[128px] bg-success-300 flex justify-center items-center rounded-md">
                          <div>
                            <div class="flex justify-center mb-3">
                              <span><svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <circle opacity="0.5" cx="20" cy="20" r="19.5" class="stroke-white dark:stroke-bgray-900"></circle>
                                  <path opacity="0.4" d="M21 16.86L21 14.3567C21 13.2506 20.1046 12.354 19 12.354L17.6667 12.354C17.2339 12.354 16.8129 12.2135 16.4667 11.9535L15.5333 11.2526C15.1871 10.9926 14.7661 10.8521 14.3333 10.8521L13 10.8521C11.8954 10.8521 11 11.7487 11 12.8547L11 16.86C11 17.966 11.8954 18.8626 13 18.8626L19 18.8626C20.1046 18.8626 21 17.966 21 16.86Z" class="fill-white dark:fill-bgray-900"></path>
                                  <path opacity="0.4" d="M29 28.8758L29 26.3725C29 25.2665 28.1046 24.3699 27 24.3699L25.6667 24.3699C25.2339 24.3699 24.8129 24.2294 24.4667 23.9694L23.5333 23.2684C23.1871 23.0085 22.7661 22.8679 22.3333 22.8679L21 22.8679C19.8954 22.8679 19 23.7645 19 24.8706L19 28.8758C19 29.9819 19.8954 30.8785 21 30.8785L27 30.8785C28.1046 30.8785 29 29.9819 29 28.8758Z" class="fill-white dark:fill-bgray-900"></path>
                                  <path fill-rule="evenodd" clip-rule="evenodd" d="M22.25 14.8572C22.25 14.4424 22.5858 14.1062 23 14.1062L25 14.1062C26.5188 14.1062 27.75 15.339 27.75 16.8598L27.75 22.3671C27.75 22.7819 27.4142 23.1181 27 23.1181C26.5858 23.1181 26.25 22.7819 26.25 22.3671L26.25 16.8598C26.25 16.1686 25.6904 15.6082 25 15.6082L23 15.6082C22.5858 15.6082 22.25 15.272 22.25 14.8572ZM13 20.1141C13.4142 20.1141 13.75 20.4504 13.75 20.8651L13.75 24.8704C13.75 25.5617 14.3096 26.1221 15 26.1221L17 26.1221C17.4142 26.1221 17.75 26.4583 17.75 26.873C17.75 27.2878 17.4142 27.624 17 27.624L15 27.624C13.4812 27.624 12.25 26.3912 12.25 24.8704L12.25 20.8651C12.25 20.4504 12.5858 20.1141 13 20.1141Z" class="fill-white dark:fill-bgray-900"></path>
                                </svg>
                              </span>
                            </div>
                            <p class="text-white  dark:text-bgray-900 text-xs text-center">
                              Trades WON
                            </p>
                            <p class="text-base dark:text-bgray-900 font-bold text-white text-center">
                           <?php
require('connect.php'); // Include your database connection details
session_start(); // Start the session to access session variables

if (isset($_SESSION['email'])) {
    // Escape the email to prevent SQL injection
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);
    
    // Query to count the number of times status is 'WIN'
    $query = "SELECT COUNT(*) AS win_count FROM user_trans WHERE email='$SEshopmail' AND status='WIN'";
    $result = mysqli_query($connection, $query) or die(mysqli_error($connection));

    // Fetch the count
    $row = mysqli_fetch_assoc($result);
    $winCount = $row['win_count'];

    echo  $winCount;
}
?>

                            </p>
                          </div>
                        </div>
                        <div class="w-full h-[128px] bg-success-200 flex justify-center items-center rounded-md">
                          <div>
                            <div class="flex justify-center mb-3">
                                  <span><svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <circle opacity="0.5" cx="20" cy="20" r="19.5" class="stroke-white dark:stroke-bgray-900"></circle>
                                  <path opacity="0.4" d="M21 16.86L21 14.3567C21 13.2506 20.1046 12.354 19 12.354L17.6667 12.354C17.2339 12.354 16.8129 12.2135 16.4667 11.9535L15.5333 11.2526C15.1871 10.9926 14.7661 10.8521 14.3333 10.8521L13 10.8521C11.8954 10.8521 11 11.7487 11 12.8547L11 16.86C11 17.966 11.8954 18.8626 13 18.8626L19 18.8626C20.1046 18.8626 21 17.966 21 16.86Z" class="fill-white dark:fill-bgray-900"></path>
                                  <path opacity="0.4" d="M29 28.8758L29 26.3725C29 25.2665 28.1046 24.3699 27 24.3699L25.6667 24.3699C25.2339 24.3699 24.8129 24.2294 24.4667 23.9694L23.5333 23.2684C23.1871 23.0085 22.7661 22.8679 22.3333 22.8679L21 22.8679C19.8954 22.8679 19 23.7645 19 24.8706L19 28.8758C19 29.9819 19.8954 30.8785 21 30.8785L27 30.8785C28.1046 30.8785 29 29.9819 29 28.8758Z" class="fill-white dark:fill-bgray-900"></path>
                                  <path fill-rule="evenodd" clip-rule="evenodd" d="M22.25 14.8572C22.25 14.4424 22.5858 14.1062 23 14.1062L25 14.1062C26.5188 14.1062 27.75 15.339 27.75 16.8598L27.75 22.3671C27.75 22.7819 27.4142 23.1181 27 23.1181C26.5858 23.1181 26.25 22.7819 26.25 22.3671L26.25 16.8598C26.25 16.1686 25.6904 15.6082 25 15.6082L23 15.6082C22.5858 15.6082 22.25 15.272 22.25 14.8572ZM13 20.1141C13.4142 20.1141 13.75 20.4504 13.75 20.8651L13.75 24.8704C13.75 25.5617 14.3096 26.1221 15 26.1221L17 26.1221C17.4142 26.1221 17.75 26.4583 17.75 26.873C17.75 27.2878 17.4142 27.624 17 27.624L15 27.624C13.4812 27.624 12.25 26.3912 12.25 24.8704L12.25 20.8651C12.25 20.4504 12.5858 20.1141 13 20.1141Z" class="fill-white dark:fill-bgray-900"></path>
                                </svg>
                              </span>
                            </div>
                            <p class="text-white dark:text-bgray-900 text-xs text-center">
                              LOSS
                            </p>
                            <p class="text-base dark:text-bgray-900 font-bold text-white text-center">
                              <?php
require('connect.php'); // Include your database connection details
session_start(); // Start the session to access session variables

if (isset($_SESSION['email'])) {
    // Escape the email to prevent SQL injection
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);
    
    // Query to count the number of times status is 'WIN'
    $query = "SELECT COUNT(*) AS loss_count FROM user_trans WHERE email='$SEshopmail' AND status='LOSS'";
    $result = mysqli_query($connection, $query) or die(mysqli_error($connection));

    // Fetch the count
    $row = mysqli_fetch_assoc($result);
    $winCount = $row['loss_count'];

    echo  $winCount;
}
?>

                            </p>
                          </div>
                        </div>
                        <div class="w-full h-[128px] bg-bgray-50 dark:bg-darkblack-700 flex justify-center items-center rounded-md">
                          <div>
                            <div class="flex justify-center mb-3">
                              <span>
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <circle opacity="0.5" cx="20" cy="20" r="19.5" stroke="#CBD5E1"></circle>
                                  <path opacity="0.4" d="M29 25V18C29 15.7909 27.2987 14 25.2 14H22.6667C21.8445 14 21.0444 13.7193 20.3867 13.2L18.6133 11.8C17.9556 11.2807 17.1555 11 16.3333 11H13.8C11.7013 11 10 12.7909 10 15V25C10 27.2091 11.7013 29 13.8 29H25.2C27.2987 29 29 27.2091 29 25Z" fill="#22C55E"></path>
                                  <path fill-rule="evenodd" clip-rule="evenodd" d="M23.4939 18.4356C23.8056 18.7083 23.8372 19.1822 23.5645 19.4939L20.6946 22.7738C20.0779 23.4786 19.0156 23.5729 18.2843 22.9879L16.5315 21.5857C16.2081 21.3269 16.1556 20.8549 16.4144 20.5315C16.6731 20.208 17.1451 20.1556 17.4685 20.4144L19.2214 21.8166C19.3258 21.9002 19.4776 21.8867 19.5657 21.786L22.4356 18.5061C22.7084 18.1944 23.1822 18.1628 23.4939 18.4356Z" fill="#22C55E"></path>
                                </svg>
                              </span>
                            </div>
                            <p class="text-bgray-500 text-xs text-center dark:text-bgray-50">
                              Completed
                            </p>
                            <p class="text-base font-bold text-bgray-900 dark:text-white text-center">
                              <?php
require('connect.php'); // Include your database connection details
session_start(); // Start the session to access session variables

if (isset($_SESSION['email'])) {
    // Escape the email to prevent SQL injection
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);
    
    // Query to count all transactions for the user
    $query = "SELECT COUNT(*) AS total_count FROM user_trans WHERE email='$SEshopmail'";
    $result = mysqli_query($connection, $query) or die(mysqli_error($connection));

    // Fetch the count
    $row = mysqli_fetch_assoc($result);
    $totalCount = $row['total_count'];

    echo $totalCount;
}
?>

                            </p>
                          </div>
                        </div>
                      </div>
                      <div>
        <?php
require('connect.php');
session_start(); // Start session

if (isset($_SESSION['email'])) {
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);

    // Fetch user trade signal percentage and currency
    $query = "SELECT percent, currency FROM users WHERE email='$SEshopmail'";
    $userquery = mysqli_query($connection, $query) or die(mysqli_error($connection));

    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_assoc($userquery);
        $tradeSignalPercentage = (float)$row['percent'];
        $currency = $row['currency'];
    } else {
        die("User not found or query failed.");
    }

    // Get total balance
    $balanceQuery = mysqli_query($connection, "SELECT SUM(balance + deposit + bitcoin + ethereum + tether) AS total FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));

    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $totalBalance = $balanceRow['total'];
        $totalBalanceFormatted = number_format($totalBalance, 2);
    } else {
        die("Balance query failed.");
    }

    // Ensure percentage is between 0 and 100
    $progressPercent = min(100, max(0, $tradeSignalPercentage));

    // Determine progress bar color and badge text
    $barColor = $progressPercent <= 5 ? '#FF0000' : '#00C566';
    $badgeText = $progressPercent <= 5 ? 'Inactive' : 'Active';
?>

    <style>
        .progress-container {
            width: 100%;
            background-color: #ddd;
            border-radius: 10px;
            overflow: hidden;
            margin-top: 10px;
        }

        .progress-bar {
            height: 20px;
            text-align: center;
            line-height: 20px;
            color: white;
            font-weight: bold;
            transition: width 0.5s ease-in-out;
        }

        .badge {
            padding: 5px 10px;
            font-size: 14px;
            font-weight: bold;
            border-radius: 5px;
            color: white;
            display: inline-block;
        }

        .inactive {
            background-color: #FF0000;
        }

        .active {
            background-color: #00C566;
        }
    </style>



    <!-- On-time Completion Rate Label -->
    <p class="text-xs text-bgray-500 dark:text-white mb-2">On-time Completion Rate</p>

    <h2 class="text-lg font-bold dark:text-white">Trade Signal Progress</h2>

    <!-- Percentage Display with Custom Styles -->
    <div class="flex space-x-4 items-end">
        <span class="text-bgray-900 dark:text-white font-bold text-2xl leading-[30px]"><?= $progressPercent ?>%</span>
        <span class="text-xs font-medium text-success-300">+2.5%</span>
    </div>

    <!-- Progress Bar -->
    <div class="progress-container">
        <div class="progress-bar" style="width: <?= $progressPercent ?>%; background-color: <?= $barColor ?>;">
            <span class="text-xs font-bold dark:text-white"><?= $progressPercent ?>%</span>
        </div>
    </div>

    <!-- Badge for Active/Inactive -->
    <p class="text-sm dark:text-white">Status: <span class="badge <?= $progressPercent <= 5 ? 'inactive' : 'active' ?>"><?= $badgeText ?></span></p>

    <!-- Total Balance -->
    <p class="text-sm font-semibold dark:text-white">Total Balance: <strong><?= $currency ?> <?= $totalBalanceFormatted ?></strong></p>



<?php
} else {
    die("User session not found.");
}
?>

                      </div>
                    </div>
                  </div>
                </div>
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
             <?php
require('connect.php');
session_start();

if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit();
}

$SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);

// Query to get withdrawal data
$withdrawalQuery = mysqli_query($connection, 
    "SELECT transid, email, amount, date, status, currency, withmethod 
    FROM withdrawal 
    WHERE email='$SEshopmail'
    ORDER BY date DESC") or die(mysqli_error($connection));

// Query to get deposit data
$depositQuery = mysqli_query($connection, 
    "SELECT transid, email, amount, date, status, currenc, depositmethod 
    FROM deposit 
    WHERE userid='$SEshopmail'
    ORDER BY date DESC") or die(mysqli_error($connection));

$totalWithdrawal = 0;
$totalDeposit = 0;

// Calculating total withdrawal amount
while ($row = mysqli_fetch_assoc($withdrawalQuery)) {
    $totalWithdrawal += $row['amount'];
}
// Reset pointer to be able to loop later
mysqli_data_seek($withdrawalQuery, 0);

// Calculating total deposit amount
while ($row = mysqli_fetch_assoc($depositQuery)) {
    $totalDeposit += $row['amount'];
}
// Reset pointer to be able to loop later
mysqli_data_seek($depositQuery, 0);

// Get the currency for withdrawals
$withdrawalCurrency = '$'; // default value in case no record is found
if (mysqli_num_rows($withdrawalQuery) > 0) {
    $firstWithdrawal = mysqli_fetch_assoc($withdrawalQuery);
    $withdrawalCurrency = $firstWithdrawal['currency'];
    // Rewind to loop over the results later if needed
    mysqli_data_seek($withdrawalQuery, 0);
}

// Get the currency for deposits
$depositCurrency = '$'; // default value in case no record is found
if (mysqli_num_rows($depositQuery) > 0) {
    $firstDeposit = mysqli_fetch_assoc($depositQuery);
    $depositCurrency = $firstDeposit['currency'];
    mysqli_data_seek($depositQuery, 0);
}
?>

<!-- ... Your HTML code continues ... -->

<script src="https://cdn.tailwindcss.com"></script>

<div class="w-full rounded-lg bg-white px-[24px] py-[20px] dark:bg-darkblack-600">
  <div class="flex flex-col space-y-8">

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
      <div class="bg-red-50 p-6 rounded-xl dark:bg-darkblack-500">
        <h3 class="text-lg font-bold text-red-600 dark:text-red-400">Total Withdrawals</h3>
        <p class="text-3xl font-semibold mt-2 text-red-700 dark:text-red-300">
          <?php echo htmlspecialchars($withdrawalCurrency); ?>
          <?php echo number_format($totalWithdrawal, 2); ?>
        </p>
      </div>
      <div class="bg-green-50 p-6 rounded-xl dark:bg-darkblack-500">
        <h3 class="text-lg font-bold text-green-600 dark:text-green-400">Total Deposits</h3>
        <p class="text-3xl font-semibold mt-2 text-green-700 dark:text-green-300">
          <?php echo htmlspecialchars($depositCurrency); ?>
          <?php echo number_format($totalDeposit, 2); ?>
        </p>
      </div>
    </div>

    <!-- Withdrawals Section -->
    <div>
      <h2 class="text-lg font-bold dark:text-white mb-3">Withdrawal Transactions</h2>
      <div class="table-content w-full overflow-x-auto">
        <table class="w-full">
          <thead>
            <tr class="border-b border-bgray-300 dark:border-darkblack-400">
              <th class="py-4">Select</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Transaction ID</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Amount</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Date</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Status</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Method</th>
            </tr>
          </thead>
          <tbody>
            <?php if (mysqli_num_rows($withdrawalQuery) > 0): ?>
              <?php while ($row = mysqli_fetch_assoc($withdrawalQuery)): ?>
                <tr class="border-b border-bgray-300 dark:border-darkblack-400">
                  <td class="py-4"><input type="checkbox" class="h-5 w-5"></td>
                  <td class="px-6 py-4 text-red-600 dark:text-red-400 font-mono">
                    <?php echo htmlspecialchars($row['transid']); ?>
                  </td>
                  <td class="px-6 py-4 text-red-600 dark:text-red-400 font-semibold">
                    <?php echo htmlspecialchars($row['currency']); ?>
                    <?php echo number_format($row['amount'], 2); ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo date('M j, Y H:i', strtotime($row['date'])); ?>
                  </td>
                  <td class="px-6 py-4">
                    <?php 
                    switch($row['status']) {
                      case 'Completed':
                        echo '<span class="px-3 py-1 rounded-full bg-red-100 text-red-800 text-sm">Completed</span>';
                        break;
                      case 'Pending':
                        echo '<span class="px-3 py-1 rounded-full bg-yellow-100 text-yellow-800 text-sm">Pending</span>';
                        break;
                      case 'Failed':
                        echo '<span class="px-3 py-1 rounded-full bg-gray-100 text-gray-800 text-sm">Failed</span>';
                        break;
                      default:
                        echo '<span class="px-3 py-1 rounded-full bg-red-100 text-red-800 text-sm">'.htmlspecialchars($row['status']).'</span>';
                    } 
                    ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo htmlspecialchars($row['withmethod']); ?>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" class="py-6 text-center text-gray-500 dark:text-bgray-50">
                  No withdrawal transactions found.
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Deposits Section -->
    <div>
      <h2 class="text-lg font-bold dark:text-white mb-3">Deposit Transactions</h2>
      <div class="table-content w-full overflow-x-auto">
        <table class="w-full">
          <thead>
            <tr class="border-b border-bgray-300 dark:border-darkblack-400">
              <th class="py-4">Select</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Transaction ID</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Amount</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Date</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Status</th>
              <th class="px-6 py-4 font-medium dark:text-bgray-50">Method</th>
            </tr>
          </thead>
          <tbody>
            <?php if (mysqli_num_rows($depositQuery) > 0): ?>
              <?php while ($row = mysqli_fetch_assoc($depositQuery)): ?>
                <tr class="border-b border-bgray-300 dark:border-darkblack-400">
                  <td class="py-4"><input type="checkbox" class="h-5 w-5"></td>
                  <td class="px-6 py-4 text-green-600 dark:text-green-400 font-mono">
                    <?php echo htmlspecialchars($row['transid']); ?>
                  </td>
                  <td class="px-6 py-4 text-green-600 dark:text-green-400 font-semibold">
                    <?php echo htmlspecialchars($row['currency']); ?>
                    <?php echo number_format($row['amount'], 2); ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo date('M j, Y H:i', strtotime($row['date'])); ?>
                  </td>
                  <td class="px-6 py-4">
                    <?php 
                    switch($row['status']) {
                      case 'Completed':
                        echo '<span class="px-3 py-1 rounded-full bg-green-100 text-green-800 text-sm">Completed</span>';
                        break;
                      case 'Pending':
                        echo '<span class="px-3 py-1 rounded-full bg-yellow-100 text-yellow-800 text-sm">Pending</span>';
                        break;
                      case 'Failed':
                        echo '<span class="px-3 py-1 rounded-full bg-gray-100 text-gray-800 text-sm">Failed</span>';
                        break;
                      default:
                        echo '<span class="px-3 py-1 rounded-full bg-green-100 text-green-800 text-sm">'.htmlspecialchars($row['status']).'</span>';
                    } 
                    ?>
                  </td>
                  <td class="px-6 py-4 text-gray-600 dark:text-bgray-50">
                    <?php echo htmlspecialchars($row['depositmethod']); ?>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="6" class="py-6 text-center text-gray-500 dark:text-bgray-50">
                  No deposit transactions found.
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

  </div>
</div>

  


              </section>
              
            </div>
            <!-- write your code here-->
          </main>
        </div>
      </div>
    </div>
    <!-- layout end -->

    <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/jsvectormap.js"></script>
    <script src="assets/js/world.js"></script>
    <script src="assets/js/world-merc.js"></script>
   
   <?php
require('connect.php');

// Assuming $SEshopmail is already defined or retrieved in your session

// Fetching all users from the database
$userquery = mysqli_query($connection, "SELECT * FROM users") or die(mysqli_error($connection));

// Array to store marker data
$markers = [];

// Fetching countries and coordinates
while ($row = mysqli_fetch_array($userquery)) {
    $country = htmlspecialchars($row['country']); // Assuming 'country' is a column in your 'users' table
    $coords = []; // Define coordinates array

    // Add more conditions to retrieve specific coordinates for each country if available
    switch ($country) {
        case 'Palestine':
            $coords = [31.5, 34.8];
            break;
        case 'Russia':
            $coords = [61, 105];
            break;
        case 'Greenland':
            $coords = [72, -42];
            break;
        case 'Canada':
            $coords = [56, -106];
            break;
        case 'Australia':
            $coords = [-25, 140];
            break;
        // Add more cases as needed for other countries
        default:
            // Default coordinates if specific coordinates are not found
            $coords = [0, 0]; // Default coordinates
            break;
    }

    // Push marker data to the markers array
    $markers[] = [
        'name' => $country,
        'coords' => $coords,
    ];
}

?>

    <!-- Include necessary JS libraries -->
    <script src="jsvector-map.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Include CSS styles -->
    
    



    <script>
        var markers = <?php echo json_encode($markers); ?>;

        const map = new jsVectorMap({
            map: "world",
            selector: "#world-map",
            backgroundColor: "#F7FAFC",
            markerStyle: {
                initial: {
                    fill: "#22C55E",
                    r: 4,
                },
            },
            markersSelectable: true,
            markers: markers,
            draggable: true,
            zoomButtons: false,
            zoomOnScroll: true,
            zoomOnScrollSpeed: 3,
            zoomMax: 12,
            zoomMin: 1,
            zoomAnimate: true,
            showTooltip: true,
            zoomStep: 1.5,
            bindTouchEvents: true,
            regionStyle: {
                initial: {
                    fill: "#DBE7FA",
                    fillOpacity: 1,
                    stroke: "none",
                    strokeWidth: 0,
                    strokeOpacity: 1,
                },
                hover: {
                    fillOpacity: 0.7,
                    cursor: "pointer",
                    fill: "#22C55E",
                },
                selected: {
                    fill: "#000",
                },
                selectedHover: {},
            },
            visualizeData: {
                scale: ["#22C55E", "#DBEAFE"],
                values: {
                    US: 29, // Example values, replace with your data
                    CA: 190,
                },
            },
        });
    </script>



    <script src="assets/js/flatpickr.js"></script>
    <script>
      // min-calender
      $("#min-calender").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        inline: true,
      });
    </script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script>
      AOS.init();
    </script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/chart.js"></script>
      <script>
     $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });
      function totalEarn() {
        const ctx_bids = document.getElementById("totalEarn").getContext("2d");
        const bitsMonth = [
          "Jan",
          "Feb",
          "Mar",
          "Afril",
          "May",
          "Jan",
          "Feb",
          "Mar",
          "Afril",
          "May",
          "Feb",
          "Mar",
          "Afril",
          "May",
        ];
        const bitsData = [
          0, 10, 0, 65, 0, 25, 0, 35, 20, 100, 40, 75, 50, 85, 60,
        ];
        const totalEarn = new Chart(ctx_bids, {
          type: "line",
          data: {
            labels: bitsMonth,
            datasets: [
              {
                label: "Visitor",
                data: bitsData,
                backgroundColor: () => {
                  const chart = document
                    .getElementById("totalEarn")
                    .getContext("2d");
                  const gradient = chart.createLinearGradient(0, 0, 0, 450);
                  gradient.addColorStop(0, "rgba(34, 197, 94,0.41)");
                  gradient.addColorStop(0.2, "rgba(255, 255, 255, 0)");

                  return gradient;
                },
                borderColor: "#22C55E",
                pointRadius: 0,
                pointBackgroundColor: "#fff",
                pointBorderColor: "#22C55E",
                borderWidth: 1,
                fill: true,
                fillColor: "#fff",
                tension: 0.4,
              },
            ],
          },
          options: {
            layout: {
              padding: {
                bottom: -20,
              },
            },
            maintainAspectRatio: false,
            responsive: true,
            scales: {
              x: {
                grid: {
                  display: false,
                  drawBorder: false,
                },
                ticks: {
                  display: false,
                },
              },
              y: {
                grid: {
                  display: false,
                  drawBorder: false,
                },
                ticks: {
                  display: false,
                },
              },
            },

            plugins: {
              legend: {
                position: "top",
                display: false,
              },
              title: {
                display: false,
                text: "Visitor: 2k",
              },
              tooltip: {
                enabled: false,
              },
            },
          },
        });
      }
      totalEarn();
      function totalSpendingChart() {
        let ctx_bids = document
          .getElementById("totalSpending")
          .getContext("2d");
        let bitsMonth = [
          "Jan",
          "Feb",
          "Mar",
          "Afril",
          "May",
          "Jan",
          "Feb",
          "Mar",
          "Afril",
          "May",
          "Feb",
          "Mar",
          "Afril",
          "May",
        ];
        let bitsData = [
          0, 10, 0, 65, 0, 25, 0, 35, 20, 100, 40, 75, 50, 85, 60,
        ];
        let totalEarn = new Chart(ctx_bids, {
          type: "line",
          data: {
            labels: bitsMonth,
            datasets: [
              {
                label: "Visitor",
                data: bitsData,
                backgroundColor: () => {
                  const chart = document
                    .getElementById("totalEarn")
                    .getContext("2d");
                  const gradient = chart.createLinearGradient(0, 0, 0, 450);
                  gradient.addColorStop(0, "rgba(34, 197, 94,0.41)");
                  gradient.addColorStop(0.2, "rgba(255, 255, 255, 0)");

                  return gradient;
                },
                borderColor: "#22C55E",
                pointRadius: 0,
                pointBackgroundColor: "#fff",
                pointBorderColor: "#22C55E",
                borderWidth: 1,
                fill: true,
                fillColor: "#fff",
                tension: 0.4,
              },
            ],
          },
          options: {
            layout: {
              padding: {
                bottom: -20,
              },
            },
            maintainAspectRatio: false,
            responsive: true,
            scales: {
              x: {
                grid: {
                  display: false,
                  drawBorder: false,
                },
                ticks: {
                  display: false,
                },
              },
              y: {
                grid: {
                  display: false,
                  drawBorder: false,
                },
                ticks: {
                  display: false,
                },
              },
            },

            plugins: {
              legend: {
                position: "top",
                display: false,
              },
              title: {
                display: false,
                text: "Visitor: 2k",
              },
              tooltip: {
                enabled: false,
              },
            },
          },
        });
      }
      totalSpendingChart();
      function totalGoal() {
        let ctx_bids = document.getElementById("totalGoal").getContext("2d");
        let bitsMonth = [
          "Jan",
          "Feb",
          "Mar",
          "Afril",
          "May",
          "Jan",
          "Feb",
          "Mar",
          "Afril",
          "May",
          "Feb",
          "Mar",
          "Afril",
          "May",
        ];
        let bitsData = [
          0, 10, 0, 65, 0, 25, 0, 35, 20, 100, 40, 75, 50, 85, 60,
        ];
        let totalEarn = new Chart(ctx_bids, {
          type: "line",
          data: {
            labels: bitsMonth,
            datasets: [
              {
                label: "Visitor",
                data: bitsData,
                backgroundColor: () => {
                  const chart = document
                    .getElementById("totalGoal")
                    .getContext("2d");
                  const gradient = chart.createLinearGradient(0, 0, 0, 450);
                  gradient.addColorStop(0, "rgba(34, 197, 94,0.41)");
                  gradient.addColorStop(0.2, "rgba(255, 255, 255, 0)");

                  return gradient;
                },
                borderColor: "#22C55E",
                pointRadius: 0,
                pointBackgroundColor: "#fff",
                pointBorderColor: "#22C55E",
                borderWidth: 1,
                fill: true,
                fillColor: "#fff",
                tension: 0.4,
              },
            ],
          },
          options: {
            layout: {
              padding: {
                bottom: -20,
              },
            },
            maintainAspectRatio: false,
            responsive: true,
            scales: {
              x: {
                grid: {
                  display: false,
                  drawBorder: false,
                },
                ticks: {
                  display: false,
                },
              },
              y: {
                grid: {
                  display: false,
                  drawBorder: false,
                },
                ticks: {
                  display: false,
                },
              },
            },

            plugins: {
              legend: {
                position: "top",
                display: false,
              },
              title: {
                display: false,
                text: "Visitor: 2k",
              },
              tooltip: {
                enabled: false,
              },
            },
          },
        });
      }
      totalGoal();


 
 
     
     

     
       
    </script>
    
    <script>
      function revenueFlowLine() {

      }
      revenueFlowLine();

      let revenueFlowElement = document
              .getElementById("revenueFlowLine")
              .getContext("2d");
      let month = [
        "Jan",
        "Feb",
        "Mar",
        "April",
        "May",
        "Jun",
        "July",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec",
      ];
      let revenueFlow = new Chart(revenueFlowElement, {
        type: "line",
        plugins: [
          {
            beforeDatasetsDraw(chart) {
              chart.ctx.shadowColor = "rgba(37, 99, 235, 0.14)";
              chart.ctx.shadowBlur = 8;
            },
            afterDatasetsDraw(chart) {
              chart.ctx.shadowColor = "rgba(0, 0, 0, 0)";
              chart.ctx.shadowBlur = 0;
            },
          },
        ],
        data: {
          labels: month,
          datasets: [
            {
              label: "Signed",
              data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
              backgroundColor: () => {
                const chart = document
                        .getElementById("revenueFlowLine")
                        .getContext("2d");
                const gradient = chart.createLinearGradient(0, 0, 0, 450);
                gradient.addColorStop(0, "rgba(34, 197, 94,0.41)");
                gradient.addColorStop(0.6, "rgba(255, 255, 255, 0)");
                return gradient;
              },
              borderColor: "#22C55E",
              // pointRadius: 5,
              pointBorderColor: "#ffffff",
              pointBackgroundColor: "#22C55E",
              pointBorderWidth: 4,
              borderWidth: 2,
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
            },
          ],
        },
        options: {
          // layout: {
          //   padding: {
          //     bottom: -20,
          //   },
          // },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
            },
            y: {
              beginAtZero: true,
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
              ticks: {
                callback(value) {
                  return `${value}% `;
                },
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            // tooltip: {
            //   enabled: false,
            // },
          },
          elements: {
            point: {
              radius: [0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0],
              hoverRadius: 6,
            },
          },
        },
      });


      function pieChart() {
        let pieChart = document.getElementById("pie_chart").getContext("2d");

        const data = {
          labels: [10, 20, 30],
          datasets: [
            {
              label: "My First Dataset",
              data: [15, 20, 35, 40],
              backgroundColor: ["#1A202C", "#61C660", "#F8CC4B", "#EDF2F7"],
              borderColor: ["#ffffff", "#ffffff", "#ffffff", "#1A202C"],
              hoverOffset: 18,
              borderWidth: 0,
            },
          ],
        };
        const customDatalabels = {
          id: "customDatalabels",
          afterDatasetsDraw(chart, args, pluginOptions) {
            const {
              ctx,
              data,
              chartArea: { top, bottom, left, right, width, height },
            } = chart;
            ctx.save();
            data.datasets[0].data.forEach((datapoint, index) => {
              const { x, y } = chart
                .getDatasetMeta(0)
                .data[index].tooltipPosition();
              ctx.font = "bold 12px sans-serif";
              ctx.fillStyle = data.datasets[0].borderColor[index];
              ctx.textAlign = "center";
              ctx.textBaseline = "middle";
              ctx.fillText(`${datapoint}%`, x, y);
            });
          },
        };
        const config = {
          type: "doughnut",
          data,
          options: {
            maintainAspectRatio: false,
            layout: {
              padding: {
                left: 10,
                right: 10,
                top: 10,
                bottom: 10,
              },
            },
            plugins: {
              legend: {
                display: false,
              },
            },
          },
          plugins: [customDatalabels],
        };

        let pieChartConfiig = new Chart(pieChart, config);
      }
      pieChart();


      let themeToggleSwitch = document.getElementById('theme-toggle');

      //onclick
      if(themeToggleSwitch){
        themeToggleSwitch.addEventListener('click', function() {
          if(document.documentElement.classList[0]==='dark' || localStorage.theme === 'dark'){
            revenueFlow.options.scales.y.ticks.color = 'white';
            revenueFlow.options.scales.x.ticks.color = 'white';
            revenueFlow.options.scales.x.grid.color = '#242830';
            revenueFlow.options.scales.y.grid.color = '#242830';
            revenueFlow.update();
          }else{
            revenueFlow.options.scales.y.ticks.color = 'black';
            revenueFlow.options.scales.x.ticks.color = 'black';
            revenueFlow.options.scales.x.grid.color = 'rgb(243 ,246, 255 ,1)';
            revenueFlow.options.scales.y.grid.color = 'rgb(243 ,246, 255 ,1)';
            revenueFlow.update();
          }

        });
      }


      //initial load
      if (localStorage.theme === 'dark' || (window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        revenueFlow.options.scales.y.ticks.color='white';
        revenueFlow.options.scales.x.ticks.color='white';
        revenueFlow.options.scales.x.grid.color='#242830';
        revenueFlow.options.scales.y.grid.color='#242830';

      } else {
        revenueFlow.options.scales.y.ticks.color='black';
        revenueFlow.options.scales.x.ticks.color='black';
        revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
        revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
      }
      revenueFlow.update();

      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });
    </script>
    
    <script>
  // Function to initialize the revenue flow chart with API data
async function initializeRevenueFlowChart() {
  // Get the canvas element
  const revenueFlowCanvas = document.getElementById("revenueFlow");
  
  if (!revenueFlowCanvas) {
    console.error("Revenue flow chart canvas not found");
    return;
  }
  
  const ctx = revenueFlowCanvas.getContext("2d");
  
  try {
    // Fetch cryptocurrency data from CoinGecko API
    // We'll get Bitcoin, Ethereum and Tether historical data for the last year
    const coins = ['bitcoin', 'ethereum', 'tether'];
    const today = new Date();
    const oneYearAgo = new Date(today.setFullYear(today.getFullYear() - 1));
    const fromTimestamp = Math.floor(oneYearAgo.getTime() / 1000);
    const toTimestamp = Math.floor(Date.now() / 1000);
    
    // Initialize data arrays
    let bitcoinData = [];
    let etherData = [];
    let tetherData = [];
    let months = [];
    
    // Fetch data for each coin
    const responses = await Promise.all(
      coins.map(coin => 
        fetch(`https://api.coingecko.com/api/v3/coins/${coin}/market_chart/range?vs_currency=usd&from=${fromTimestamp}&to=${toTimestamp}`)
          .then(response => {
            if (!response.ok) {
              throw new Error(`Error fetching ${coin} data: ${response.status}`);
            }
            return response.json();
          })
      )
    );
    
    // Process the responses
    const [bitcoinResponse, etherResponse, tetherResponse] = responses;
    
    // Get monthly data points (one per month)
    const monthlyPrices = (priceData) => {
      const monthly = [];
      const monthMap = {};
      
      // Group by month
      priceData.prices.forEach(([timestamp, price]) => {
        const date = new Date(timestamp);
        const monthYear = `${date.getMonth()}-${date.getFullYear()}`;
        
        if (!monthMap[monthYear]) {
          monthMap[monthYear] = {
            date,
            prices: [],
          };
        }
        
        monthMap[monthYear].prices.push(price);
      });
      
      // Get the average price for each month
      Object.values(monthMap).forEach(({ date, prices }) => {
        const avg = prices.reduce((sum, price) => sum + price, 0) / prices.length;
        monthly.push({
          date,
          price: avg,
        });
      });
      
      // Sort by date
      return monthly.sort((a, b) => a.date - b.date);
    };
    
    const bitcoinMonthly = monthlyPrices(bitcoinResponse);
    const etherMonthly = monthlyPrices(etherResponse);
    const tetherMonthly = monthlyPrices(tetherResponse);
    
    // Get month labels
    months = bitcoinMonthly.map(item => {
      const date = item.date;
      return date.toLocaleString('default', { month: 'short' });
    });
    
    // Get price data
    bitcoinData = bitcoinMonthly.map(item => item.price);
    etherData = etherMonthly.map(item => item.price);
    tetherData = tetherMonthly.map(item => item.price);
    
    // Calculate percentage changes for visualization
    const normalizeData = (data) => {
      const baseValue = data[0];
      return data.map(value => ((value - baseValue) / baseValue * 100).toFixed(2));
    };
    
    const bitcoinPercentages = normalizeData(bitcoinData);
    const etherPercentages = normalizeData(etherData);
    const tetherPercentages = normalizeData(tetherData);
    
    // Create the chart
    const revenueFlowChart = new Chart(ctx, {
      type: 'line',
      data: {
        labels: months,
        datasets: [
          {
            label: 'Bitcoin',
            data: bitcoinPercentages,
            borderColor: '#FACC15', // Yellow
            backgroundColor: 'rgba(250, 204, 21, 0.1)',
            borderWidth: 2,
            tension: 0.4,
            pointRadius: 3,
            pointBackgroundColor: '#FACC15',
            pointBorderColor: '#FFFFFF',
            pointBorderWidth: 1,
            fill: false
          },
          {
            label: 'Ethereum',
            data: etherPercentages,
            borderColor: '#204E84', // Blue
            backgroundColor: 'rgba(32, 78, 132, 0.1)',
            borderWidth: 2,
            tension: 0.4,
            pointRadius: 3,
            pointBackgroundColor: '#204E84',
            pointBorderColor: '#FFFFFF',
            pointBorderWidth: 1,
            fill: false
          },
          {
            label: 'Tether',
            data: tetherPercentages,
            borderColor: '#22C55E', // Green
            backgroundColor: 'rgba(34, 197, 94, 0.1)',
            borderWidth: 2,
            tension: 0.4,
            pointRadius: 3,
            pointBackgroundColor: '#22C55E',
            pointBorderColor: '#FFFFFF',
            pointBorderWidth: 1,
            fill: false
          }
        ]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        interaction: {
          intersect: false,
          mode: 'index',
        },
        scales: {
          y: {
            beginAtZero: false,
            grid: {
              color: document.documentElement.classList.contains('dark') ? '#222429' : 'rgb(243, 246, 255, 1)',
              drawBorder: false,
            },
            ticks: {
              color: document.documentElement.classList.contains('dark') ? '#fff' : '#000',
              callback: function(value) {
                return value + '%';
              }
            }
          },
          x: {
            grid: {
              display: false,
              drawBorder: false,
            },
            ticks: {
              color: document.documentElement.classList.contains('dark') ? '#fff' : '#000',
            }
          }
        },
        plugins: {
          legend: {
            display: false,
          },
          tooltip: {
            backgroundColor: document.documentElement.classList.contains('dark') ? '#1e1e2d' : '#ffffff',
            titleColor: document.documentElement.classList.contains('dark') ? '#ffffff' : '#1e1e2d',
            bodyColor: document.documentElement.classList.contains('dark') ? '#ffffff' : '#1e1e2d',
            borderColor: document.documentElement.classList.contains('dark') ? '#2a313c' : '#e9ecef',
            borderWidth: 1,
            padding: 12,
            displayColors: true,
            callbacks: {
              label: function(context) {
                let label = context.dataset.label || '';
                if (label) {
                  label += ': ';
                }
                if (context.parsed.y !== null) {
                  label += context.parsed.y + '%';
                }
                return label;
              }
            }
          }
        }
      }
    });
    
    // Handle dark mode toggle
    const themeToggleSwitch = document.getElementById('theme-toggle');
    if (themeToggleSwitch) {
      themeToggleSwitch.addEventListener('click', function() {
        if (document.documentElement.classList[0] === 'dark' || localStorage.theme === 'dark') {
          revenueFlowChart.options.scales.y.grid.color = '#222429';
          revenueFlowChart.options.scales.y.ticks.color = '#fff';
          revenueFlowChart.options.scales.x.ticks.color = '#fff';
          revenueFlowChart.options.plugins.tooltip.backgroundColor = '#1e1e2d';
          revenueFlowChart.options.plugins.tooltip.titleColor = '#ffffff';
          revenueFlowChart.options.plugins.tooltip.bodyColor = '#ffffff';
          revenueFlowChart.options.plugins.tooltip.borderColor = '#2a313c';
        } else {
          revenueFlowChart.options.scales.y.grid.color = 'rgb(243, 246, 255, 1)';
          revenueFlowChart.options.scales.y.ticks.color = '#000';
          revenueFlowChart.options.scales.x.ticks.color = '#000';
          revenueFlowChart.options.plugins.tooltip.backgroundColor = '#ffffff';
          revenueFlowChart.options.plugins.tooltip.titleColor = '#1e1e2d';
          revenueFlowChart.options.plugins.tooltip.bodyColor = '#1e1e2d';
          revenueFlowChart.options.plugins.tooltip.borderColor = '#e9ecef';
        }
        revenueFlowChart.update();
      });
    }
    
    // Initial setting for dark mode
    if (localStorage.theme === 'dark' || window.matchMedia('(prefers-color-scheme: dark)').matches) {
      revenueFlowChart.options.scales.y.grid.color = '#222429';
      revenueFlowChart.options.scales.y.ticks.color = '#fff';
      revenueFlowChart.options.scales.x.ticks.color = '#fff';
      revenueFlowChart.options.plugins.tooltip.backgroundColor = '#1e1e2d';
      revenueFlowChart.options.plugins.tooltip.titleColor = '#ffffff';
      revenueFlowChart.options.plugins.tooltip.bodyColor = '#ffffff';
      revenueFlowChart.options.plugins.tooltip.borderColor = '#2a313c';
    }
    
    revenueFlowChart.update();
    
  } catch (error) {
    console.error("Error initializing revenue flow chart:", error);
    
    // Fallback to sample data if API fetch fails
    const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    
    // Sample price movements for cryptocurrencies
    const bitcoinData = [42000, 45000, 48000, 44000, 46000, 51000, 49000, 52000, 54000, 53000, 56000, 58000];
    const etherData = [3200, 3400, 3600, 3300, 3500, 3800, 3700, 4000, 4200, 4100, 4300, 4500];
    const tetherData = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]; // Tether is a stablecoin pegged to $1
    
    // Calculate percentage changes for visualization
    const normalizeData = (data) => {
      const baseValue = data[0];
      return data.map(value => ((value - baseValue) / baseValue * 100).toFixed(2));
    };
    
    const bitcoinPercentages = normalizeData(bitcoinData);
    const etherPercentages = normalizeData(etherData);
    const tetherPercentages = normalizeData(tetherData);
    
    // Create the chart with fallback data
    const revenueFlowChart = new Chart(ctx, {
      type: 'line',
      data: {
        labels: months,
        datasets: [
          {
            label: 'Bitcoin',
            data: bitcoinPercentages,
            borderColor: '#FACC15', // Yellow
            backgroundColor: 'rgba(250, 204, 21, 0.1)',
            borderWidth: 2,
            tension: 0.4,
            pointRadius: 3,
            pointBackgroundColor: '#FACC15',
            pointBorderColor: '#FFFFFF',
            pointBorderWidth: 1,
            fill: false
          },
          {
            label: 'Ethereum',
            data: etherPercentages,
            borderColor: '#204E84', // Blue
            backgroundColor: 'rgba(32, 78, 132, 0.1)',
            borderWidth: 2,
            tension: 0.4,
            pointRadius: 3,
            pointBackgroundColor: '#204E84',
            pointBorderColor: '#FFFFFF',
            pointBorderWidth: 1,
            fill: false
          },
          {
            label: 'Tether',
            data: tetherPercentages,
            borderColor: '#22C55E', // Green
            backgroundColor: 'rgba(34, 197, 94, 0.1)',
            borderWidth: 2,
            tension: 0.4,
            pointRadius: 3,
            pointBackgroundColor: '#22C55E',
            pointBorderColor: '#FFFFFF',
            pointBorderWidth: 1,
            fill: false
          }
        ]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        interaction: {
          intersect: false,
          mode: 'index',
        },
        scales: {
          y: {
            beginAtZero: false,
            grid: {
              color: document.documentElement.classList.contains('dark') ? '#222429' : 'rgb(243, 246, 255, 1)',
              drawBorder: false,
            },
            ticks: {
              color: document.documentElement.classList.contains('dark') ? '#fff' : '#000',
              callback: function(value) {
                return value + '%';
              }
            }
          },
          x: {
            grid: {
              display: false,
              drawBorder: false,
            },
            ticks: {
              color: document.documentElement.classList.contains('dark') ? '#fff' : '#000',
            }
          }
        },
        plugins: {
          legend: {
            display: false,
          },
          tooltip: {
            backgroundColor: document.documentElement.classList.contains('dark') ? '#1e1e2d' : '#ffffff',
            titleColor: document.documentElement.classList.contains('dark') ? '#ffffff' : '#1e1e2d',
            bodyColor: document.documentElement.classList.contains('dark') ? '#ffffff' : '#1e1e2d',
            borderColor: document.documentElement.classList.contains('dark') ? '#2a313c' : '#e9ecef',
            borderWidth: 1,
            padding: 12,
            displayColors: true,
            callbacks: {
              label: function(context) {
                let label = context.dataset.label || '';
                if (label) {
                  label += ': ';
                }
                if (context.parsed.y !== null) {
                  label += context.parsed.y + '%';
                }
                return label;
              }
            }
          }
        }
      }
    });
  }
}

// Call this function when the document is ready
document.addEventListener('DOMContentLoaded', function() {
  initializeRevenueFlowChart();
});

// Function to initialize the pie chart
function initializePieChart() {
  // Get the canvas element
  const pieChartCanvas = document.getElementById("pie_chart");
  
  if (!pieChartCanvas) {
    console.error("Pie chart canvas not found");
    return;
  }
  
  const ctx = pieChartCanvas.getContext("2d");
  
  // Data based on the percentages shown in your HTML
  const data = {
    labels: ['Profit', 'Capital', 'Others'],
    datasets: [
      {
        data: [13, 28, 59],
        backgroundColor: [
          '#22C55E', // success-300 - Profit (green)
          '#FACC15', // warning-300 - Capital (yellow)
          '#E2E8F0'  // bgray-200 - Others (gray)
        ],
        borderWidth: 0,
        cutout: '80%', // Makes it a donut chart
        radius: '90%'
      }
    ]
  };
  
  // Chart configuration
  const config = {
    type: 'doughnut',
    data: data,
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        },
        tooltip: {
          enabled: true,
          backgroundColor: document.documentElement.classList.contains('dark') ? '#1e1e2d' : '#ffffff',
          titleColor: document.documentElement.classList.contains('dark') ? '#ffffff' : '#1e1e2d',
          bodyColor: document.documentElement.classList.contains('dark') ? '#ffffff' : '#1e1e2d',
          borderColor: document.documentElement.classList.contains('dark') ? '#2a313c' : '#e9ecef',
          borderWidth: 1,
          padding: 12,
          displayColors: true,
          callbacks: {
            label: function(context) {
              const label = context.label || '';
              const value = context.formattedValue;
              return `${label}: ${value}%`;
            }
          }
        }
      },
      animation: {
        animateScale: true,
        animateRotate: true
      }
    }
  };
  
  // Create the chart
  const pieChart = new Chart(ctx, config);
  
  // Handle dark mode toggle
  const themeToggleSwitch = document.getElementById('theme-toggle');
  if (themeToggleSwitch) {
    themeToggleSwitch.addEventListener('click', function() {
      if (document.documentElement.classList[0] === 'dark' || localStorage.theme === 'dark') {
        pieChart.options.plugins.tooltip.backgroundColor = '#1e1e2d';
        pieChart.options.plugins.tooltip.titleColor = '#ffffff';
        pieChart.options.plugins.tooltip.bodyColor = '#ffffff';
        pieChart.options.plugins.tooltip.borderColor = '#2a313c';
      } else {
        pieChart.options.plugins.tooltip.backgroundColor = '#ffffff';
        pieChart.options.plugins.tooltip.titleColor = '#1e1e2d';
        pieChart.options.plugins.tooltip.bodyColor = '#1e1e2d';
        pieChart.options.plugins.tooltip.borderColor = '#e9ecef';
      }
      pieChart.update();
    });
  }
  
  // Initial setting for dark mode
  if (localStorage.theme === 'dark' || window.matchMedia('(prefers-color-scheme: dark)').matches) {
    pieChart.options.plugins.tooltip.backgroundColor = '#1e1e2d';
    pieChart.options.plugins.tooltip.titleColor = '#ffffff';
    pieChart.options.plugins.tooltip.bodyColor = '#ffffff';
    pieChart.options.plugins.tooltip.borderColor = '#2a313c';
    pieChart.update();
  }
  
  return pieChart;
}

// Function to handle the month filter dropdown
function dateFilterAction(filterId) {
  const filterElement = document.querySelector(filterId);
  if (filterElement) {
    filterElement.classList.toggle('hidden');
  }
}

// Call this function when the document is ready
document.addEventListener('DOMContentLoaded', function() {
  initializePieChart();
  
  // Make the dateFilterAction function globally available
  window.dateFilterAction = dateFilterAction;
});
    </script>


  



<div class="jvm-tooltip" style="top: 741px; left: 635.125px;">Australia</div></body>
</html>