<?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>

          <main
            class="w-full xl:px-[48px] px-6 pb-6 xl:pb-[48px] sm:pt-[156px] pt-[100px]"
          >
            <!-- write your code here-->
            <div class="2xl:flex 2xl:space-x-[48px]">
              <div class="2xl:w-[424px]">
                <div class="w-full rounded-xl bg-white dark:bg-darkblack-600 px-7 py-11 mb-[48px]">
                  <div class="border border-bgray-300 dark:border-darkblack-400 rounded-lg p-8 pb-12">
                    <h3 class="text-2xl font-semibold text-bgray-900 dark:text-white">
                      Total Balance
                    </h3>
                    <h2
                      class="text-4xl font-bold font-poppins text-bgray-900 dark:text-white mb-2"
                    >


<?php
session_start();
require('connect.php');

// Check if the user is logged in
if (!isset($_SESSION['email'])) {
    die("User is not logged in.");
}

$SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);

// Fetch user data: trade signal percentage and currency
$query = "SELECT percent, currency FROM users WHERE email='$SEshopmail'";
$userquery = mysqli_query($connection, $query);

if (!$userquery) {
    die("User query failed: " . mysqli_error($connection));
}

if (mysqli_num_rows($userquery) == 0) {
    die("No user found with the provided email.");
}

$row = mysqli_fetch_assoc($userquery);
$tradeSignalPercentage = (float)$row['percent'];
$currency = htmlspecialchars($row['currency'], ENT_QUOTES, 'UTF-8');

// Get total balance
$balanceQuery = "SELECT (balance + deposit + bitcoin + ethereum + tether) AS total FROM users WHERE email='$SEshopmail'";
$balanceResult = mysqli_query($connection, $balanceQuery);

if (!$balanceResult) {
    die("Balance query failed: " . mysqli_error($connection));
}

if (mysqli_num_rows($balanceResult) == 0) {
    die("No balance information found for the provided email.");
}

$balanceRow = mysqli_fetch_assoc($balanceResult);
$totalBalance = $balanceRow['total'];
$totalBalanceFormatted = number_format($totalBalance, 2);

// Ensure the percentage is between 0 and 100
$progressPercent = min(100, max(0, $tradeSignalPercentage));

// Determine the progress bar color and badge text
$barColor = $progressPercent <= 5 ? '#FF0000' : '#00C566';
$badgeText = $progressPercent <= 5 ? 'Inactive' : 'Active';
?>


    <style>
        .progress-bar {
            width: 100%;
            background-color: #e0e0e0;
            border-radius: 5px;
            overflow: hidden;
        }
        .progress-fill {
            height: 20px;
            width: <?php echo $progressPercent; ?>%;
            background-color: <?php echo $barColor; ?>;
            text-align: center;
            line-height: 20px;
            color: white;
        }
        .badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 12px;
            background-color: <?php echo $barColor; ?>;
            color: white;
            font-size: 0.9em;
        }
    </style>


    <h2 class="text-4xl font-bold font-poppins text-bgray-900 dark:text-white mb-2">
        <?php echo $currency . ' ' . $totalBalanceFormatted; ?>
    </h2>
    <div class="progress-bar">
        <div class="progress-fill"><?php echo $progressPercent; ?>%</div>
    </div>
    <span class="badge"><?php echo $badgeText; ?></span>
</body>
</html>
                 <span
                        class="text-base font-medium uppercase text-bgray-500"
                        >USD</span
                      >
                    </h2>
                    <div class="flex gap-4">
                    
    
    <!-- Span element where the current date will be inserted -->
    <span id="current-date" class="text-base font-medium text-bgray-500 dark:text-darkblack-300"></span>

    <script>
        // Array of month names for formatting
        const monthNames = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];

        // Function to update the date
        function updateDate() {
            const now = new Date();
            const day = now.getDate();
            const month = monthNames[now.getMonth()];
            const year = now.getFullYear();
            const formattedDate = `${day} ${month} ${year}`;

            // Insert the formatted date into the span element
            const dateElement = document.getElementById('current-date');
            if (dateElement) {
                dateElement.textContent = formattedDate;
            }
        }

        // Call the function to set the date when the page loads
        updateDate();
    </script>



                      <span class="flex"
                        ><svg
                          width="20"
                          height="20"
                          viewBox="0 0 20 20"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M17.5 5.83325L10.8333 12.4999L7.5 9.16659L2.5 14.1666M10.8333 5.83325H17.5H10.8333ZM17.5 5.83325V12.4999V5.83325Z"
                            stroke="#00C566"
                            stroke-width="1.5"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                          />
                        </svg>
                        <span class="text-base font-semibold text-success-300"
                          >2,05%</span
                        ></span
                      >
                    </div>
                  </div>
                  <div class="flex justify-center -mt-6">
                    <button
                      class="py-3 px-6 border bg-white border-bgray-500 rounded-lg text-sm font-medium text-bgray-600 dark:bg-darkblack-600 dark:text-white"
                    >
                      Withdraw All Earning
                    </button>
                  </div>
                  <button
                    class="bg-success-300 hover:bg-success-400 transition-all text-white py-4 w-full font-bold rounded-lg mt-14"
                  >
                    Add Money
                  </button>
                </div>
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                <div
                  class="w-full relative rounded-lg bg-white dark:bg-darkblack-600 dark:border dark:border-darkblack-400 px-[42px] py-5 mb-6"
                >
                  <div class="my-wallet w-full mb-8">
                    <div class="flex justify-between items-center mb-3">
                      <h3 class="text-lg font-bold text-bgray-900 dark:text-white">
                        My Wallet
                      </h3>
                      <div class="payment-select relative mb-3">
                        <button
                          onclick="dateFilterAction('#cardsOptions')"
                          type="button"
                        >
                          <svg
                            width="18"
                            height="4"
                            viewBox="0 0 18 4"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M8 2C8 2.55228 8.44772 3 9 3C9.55228 3 10 2.55228 10 2C10 1.44772 9.55228 1 9 1C8.44772 1 8 1.44772 8 2Z"
                              stroke="#CBD5E0"
                              stroke-width="2"
                              stroke-linecap="round"
                              stroke-linejoin="round"
                            />
                            <path
                              d="M1 2C1 2.55228 1.44772 3 2 3C2.55228 3 3 2.55228 3 2C3 1.44772 2.55228 1 2 1C1.44772 1 1 1.44772 1 2Z"
                              stroke="#CBD5E0"
                              stroke-width="2"
                              stroke-linecap="round"
                              stroke-linejoin="round"
                            />
                            <path
                              d="M15 2C15 2.55228 15.4477 3 16 3C16.5523 3 17 2.55228 17 2C17 1.44772 16.5523 1 16 1C15.4477 1 15 1.44772 15 2Z"
                              stroke="#CBD5E0"
                              stroke-width="2"
                              stroke-linecap="round"
                              stroke-linejoin="round"
                            />
                          </svg>
                        </button>
                        <div
                          id="cardsOptions"
                          class="rounded-lg shadow-lg min-w-[150px] bg-white absolute right-0 z-10 top-full hidden overflow-hidden"
                        >
                          <ul>
                            <li
                              onclick="dateFilterAction('#cardsOptions')"
                              class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold"
                            >
                              Master Card
                            </li>
                            <li
                              onclick="dateFilterAction('#cardsOptions')"
                              class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold"
                            >
                              VISA Card
                            </li>
                            <li
                              onclick="dateFilterAction('#cardsOptions')"
                              class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold"
                            >
                              Others
                            </li>
                          </ul>
                        </div>
                      </div>
                    </div>
                    <div class="flex justify-center">
                      <div class="card-slider relative md:w-[340px] w-[280px]">
                        <div class="w-full">
                          <img
                            src="assets/images/payments/card-1.svg"
                            alt="card"
                          />
                        </div>
                        <div class="w-full">
                          <img
                            src="assets/images/payments/card-2.svg"
                            alt="card"
                          />
                        </div>
                        <div class="w-full">
                          <img
                            src="assets/images/payments/card-3.svg"
                            alt="card"
                          />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="w-full">
                    <h3 class="text-lg font-bold text-bgray-900 dark:text-white mb-4">
                      Quick Crypto Transfer
                    </h3>
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    <form action="process_crypto.php" method="post" class="needs-validation" novalidate>
  <div id="div1" class="content-div active w-full">
    <!-- Crypto Transfer Header -->
    <!-- Crypto Form Container -->
    <div class="w-full rounded-lg border border-bgray-200 dark:border-darkblack-400 p-4 flex flex-col space-y-4">
      
      <!-- Custom Dropdown with Icons -->
      <div class="relative">
        <div class="flex items-center border border-bgray-200 dark:border-darkblack-400 rounded-lg">
          <div class="absolute left-2 top-1/2 transform -translate-y-1/2 pointer-events-none">
            <img id="selectedCryptoImage" src="https://cryptologos.cc/logos/bitcoin-btc-logo.png?v=033" alt="Crypto Icon" class="w-6 h-6">
          </div>
          <select id="cryptoSelect" name="crypto_method" class="appearance-none w-full focus:outline-none dark:bg-darkblack-600 p-2 pl-10 pr-8 rounded-lg text-gray-500">
            <option value="Bitcoin" data-icon="https://cryptologos.cc/logos/bitcoin-btc-logo.png?v=033" selected>Bitcoin</option>
            <option value="Ethereum" data-icon="https://cryptologos.cc/logos/ethereum-eth-logo-diamond-purple.svg?v=033">Ethereum</option>
            <option value="USDT" data-icon="https://cryptologos.cc/logos/tether-usdt-logo.png?v=033">USDT</option>
            <option value="XRP" data-icon="https://cryptologos.cc/logos/xrp-xrp-logo.svg?v=033">XRP</option>
            <option value="Litecoin" data-icon="https://cryptologos.cc/logos/litecoin-ltc-logo.png?v=033">Litecoin</option>
            <option value="Cardano" data-icon="https://cryptologos.cc/logos/cardano-ada-logo.png?v=033">Cardano</option>
            <option value="Solana" data-icon="https://cryptologos.cc/logos/solana-sol-logo.png?v=033">Solana</option>
            <option value="Dogecoin" data-icon="https://cryptologos.cc/logos/dogecoin-doge-logo.png?v=033">Dogecoin</option>
            <option value="Polkadot" data-icon="https://cryptologos.cc/logos/polkadot-new-dot-logo.png?v=033">Polkadot</option>
            <option value="Binance Coin" data-icon="https://cryptologos.cc/logos/bnb-bnb-logo.png?v=033">Binance Coin</option>
          </select>
     
        </div>
      </div>
      
      <!-- Amount Field -->
      
      
      
       <div
                    class="w-full rounded-lg border border-bgray-200 dark:border-darkblack-400 focus-within:border-success-300 p-4 h-[98px] flex flex-col justify-between"
                  >
                    <p class="text-sm text-bgray-600 dark:text-bgray-50 font-medium">
                      Enter amount
                    </p>
                    <div
                      class="w-full h-[35px] flex justify-between items-center"
                    >
                      <span class="text-2xl text-bgray-900 dark:text-white font-bold">$</span>
                      <label class="w-full">
                        <input

                        name="crypto_amount" placeholder="Enter amount"
                          type="text"
                          class="focus:outline-none w-full dark:bg-darkblack-600 p-0 focus:ring-0 border-none text-2xl font-bold dark:border-darkblack-400 text-bgray-900 dark:text-white"
                        />
                      </label>
                     
                     
                    </div>
                  </div>
      <!-- Wallet Address Field -->
      <div>
        <label class="block text-sm font-medium text-gray-500">Wallet Address</label>
        <input type="text" name="walletadd" placeholder="Enter wallet address" class="mt-1 block w-full p-2 border border-bgray-200 dark:border-darkblack-400 rounded-lg focus:outline-none dark:bg-darkblack-600 text-gray-500">
      </div>
      
     
    </div>
  </div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    // Get the select element and create a custom dropdown
    const selectElement = document.getElementById('cryptoSelect');
    const dropdownContainer = selectElement.parentElement;
    
    // Create a custom dropdown element
    const customDropdown = document.createElement('div');
    customDropdown.className = 'custom-dropdown absolute left-0 top-full mt-1 w-full bg-white dark:bg-darkblack-600 border border-bgray-200 dark:border-darkblack-400 rounded-lg shadow-lg z-10 max-h-60 overflow-y-auto hidden';
    dropdownContainer.appendChild(customDropdown);
    
    // Populate the custom dropdown with options
    function populateCustomDropdown() {
      customDropdown.innerHTML = '';
      Array.from(selectElement.options).forEach((option, index) => {
        const iconUrl = option.getAttribute('data-icon');
        const optionElement = document.createElement('div');
        optionElement.className = 'flex items-center p-2 hover:bg-gray-100 dark:hover:bg-darkblack-500 cursor-pointer text-gray-500';
        if (index === selectElement.selectedIndex) {
          optionElement.classList.add('bg-gray-100', 'dark:bg-darkblack-500');
        }
        
        optionElement.innerHTML = `
          <img src="${iconUrl}" alt="${option.text}" class="w-6 h-6 mr-2">
          <span>${option.text}</span>
        `;
        
        optionElement.addEventListener('click', function() {
          selectElement.selectedIndex = index;
          document.getElementById('selectedCryptoImage').src = iconUrl;
          customDropdown.classList.add('hidden');
          
          // Trigger the change event on the select
          const event = new Event('change');
          selectElement.dispatchEvent(event);
        });
        
        customDropdown.appendChild(optionElement);
      });
    }
    
    // Toggle the custom dropdown
    selectElement.addEventListener('click', function(e) {
      e.stopPropagation();
      populateCustomDropdown();
      customDropdown.classList.toggle('hidden');
    });
    
    // Update the selected icon when the select changes
    selectElement.addEventListener('change', function() {
      const selectedOption = this.options[this.selectedIndex];
      const iconUrl = selectedOption.getAttribute('data-icon');
      document.getElementById('selectedCryptoImage').src = iconUrl;
    });
    
    // Close the dropdown when clicking outside
    document.addEventListener('click', function() {
      customDropdown.classList.add('hidden');
    });
    
    // Initialize the selected icon
    const selectedOption = selectElement.options[selectElement.selectedIndex];
    const iconUrl = selectedOption.getAttribute('data-icon');
    document.getElementById('selectedCryptoImage').src = iconUrl;
  });
</script>

<style>
  /* Hide default dropdown arrow in some browsers */
  select {
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
  }
  
  /* Custom scrollbar for the dropdown */
  .custom-dropdown::-webkit-scrollbar {
    width: 6px;
  }
  
  .custom-dropdown::-webkit-scrollbar-track {
    background: #f1f1f1;
  }
  
  .custom-dropdown::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 3px;
  }
  
  .custom-dropdown::-webkit-scrollbar-thumb:hover {
    background: #555;
  }
</style>
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                   
                   
                   
                    <button
                      data-target="#multi-step-modal"
                      class="bg-success-300 modal-open hover:bg-success-400 transition-all text-white py-4 w-full font-bold rounded-lg mt-7"
                    >
Proceed                    </button>
                    
                    
      
      </form>
                  </div>
                </div>
              </div>
              <div class="2xl:flex-1">
                <div class="w-full xl:flex xl:space-x-[24px]">
                  <div
                    class="xl:w-[613px] w-full bg-white dark:bg-darkblack-600 flex flex-col justify-between rounded-lg px-8 py-7 mb-12"
                  >
                    <div class="flex justify-between items-center pb-2 mb-2">
                      <div>
                        <span class="text-sm font-medium text-bgray-600 dark:text-white"
                          >Overall Balance</span
                        >
                        <div class="flex items-center space-x-2">
                          <h3
                            class="text-2xl text-bgray-900 font-bold leading-[36px] dark:text-white"
                          >
                              
                              <?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['currency'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>

  <?php
require('connect.php');

if (isset($_SESSION['email'])) {
    $email = mysqli_real_escape_string($connection, $_SESSION['email']);

    // Query to get the total balance for the logged in user
    $balanceQuery = mysqli_query($connection, "SELECT SUM(balance + deposit + bitcoin + ethereum + tether) AS total FROM users WHERE email='$email'") or die(mysqli_error($connection));

    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $totalBalance = $balanceRow['total'];
        // Format the balance to 2 decimal places and output it
        echo number_format($totalBalance, 2);
    } else {
        die("Balance query failed.");
    }
} else {
    die("User session not set.");
}
?>
              </h3>
                          <span class="text-sm font-medium text-success-300 dark:text-white"
                            >+20%</span
                          >
                        </div>
                      </div>
                      <div class="flex space-x-[28px] items-center">
                        <div class="flex space-x-2 items-center">
                          <div
                            class="w-3 h-3 bg-success-300 rounded-full"
                          ></div>
                          <span class="text-bgray-700 dark:text-white text-sm font-medium"
                            >Signed
                          </span>
                        </div>
                        <div class="flex space-x-2 items-center">
                          <div class="w-3 h-3 bg-orange rounded-full"></div>
                          <span class="text-bgray-700 text-sm font-medium"
                            >Lost
                          </span>
                        </div>
                      </div>
                      
                      
                      
                      
                      
                      
                      
                      
                    </div>
                    <div class="w-full">
                      <canvas id="overAllBalance" height="280"></canvas>
                    </div>
                  </div>

                  <div
                    class="flex-1 xl:block hidden bg-white dark:bg-darkblack-600  rounded-lg mb-12"
                  >
                  <div
                  class="flex px-5 py-3 justify-between items-center border-b border-bgray-300 dark:border-darkblack-400"
                >
                  <h3 class="text-bgray-900 dark:text-white text-xl font-bold">Efficiency</h3>
                  <div class="date-filter relative">
                    <button
                      onclick="dateFilterAction('#month-filter')"
                      type="button"
                      class="flex space-x-1 items-center"
                    >
                      <span class="text-base font-semibold text-bgray-900 dark:text-bgray-50"
                        >Monthly</span
                      >
                      <span>
                        <svg
                          class="stroke-bgray-900 dark:stroke-bgray-50"
                          width="16"
                          height="17"
                          viewBox="0 0 16 17"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M4 6.5L8 10.5L12 6.5"
                          
                            stroke-width="1.5"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                          />
                        </svg>
                      </span>
                    </button>
                    <div
                      id="month-filter"
                      class="rounded-lg shadow-lg bg-white dark:bg-darkblack-500  absolute right-0 z-10 top-5 overflow-hidden hidden"
                    >
                      
                      
                    </div>
                  </div>
                </div>
                <div class="px-[55px] py-6">
                  <div class="flex space-x-8 items-center mb-4">
                    <div class="w-[180px] relative">
                      <canvas id="pie_chart" height="168"></canvas>
                      <div
                        class="w-[34px] h-[34px] bg-[#F8F8FC] absolute z-0 rounded-full"
                        style="left: calc(50% - 17px); top: calc(50% - 17px)"
                      ></div>
                    </div>
                    <div class="counting">
                      <div class="mb-6">
                        <div class="flex items-center space-x-[2px]">
                          <p class="text-success-300 text-lg font-bold">

                          </p>
                          <span
                            ><svg
                              width="14"
                              height="12"
                              viewBox="0 0 14 12"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M10.7749 0.558058C10.5309 0.313981 10.1351 0.313981 9.89107 0.558058L7.39107 3.05806C7.14699 3.30214 7.14699 3.69786 7.39107 3.94194C7.63514 4.18602 8.03087 4.18602 8.27495 3.94194L9.70801 2.50888V11C9.70801 11.3452 9.98783 11.625 10.333 11.625C10.6782 11.625 10.958 11.3452 10.958 11V2.50888L12.3911 3.94194C12.6351 4.18602 13.0309 4.18602 13.2749 3.94194C13.519 3.69786 13.519 3.30214 13.2749 3.05806L10.7749 0.558058Z"
                                fill="#22C55E"
                              />
                              <path
                                opacity="0.4"
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M3.22407 11.4419C3.46815 11.686 3.86388 11.686 4.10796 11.4419L6.60796 8.94194C6.85203 8.69786 6.85203 8.30214 6.60796 8.05806C6.36388 7.81398 5.96815 7.81398 5.72407 8.05806L4.29102 9.49112L4.29101 1C4.29101 0.654823 4.01119 0.375001 3.66602 0.375001C3.32084 0.375001 3.04102 0.654823 3.04102 1L3.04102 9.49112L1.60796 8.05806C1.36388 7.81398 0.968151 7.81398 0.724074 8.05806C0.479996 8.30214 0.479996 8.69786 0.724074 8.94194L3.22407 11.4419Z"
                                fill="#22C55E"
                              />
                            </svg>
                          </span>
                        </div>
                        <p class="text-bgray-600 dark:text-bgray-50 text-base font-medium">
Cumulative profit                    </p>
                      </div>
                      <div>
                        <div class="flex items-center space-x-[2px]">
                          <p class="text-bgray-900 dark:text-white text-lg font-bold">
<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['currency'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>

  <?php
require('connect.php');

if (isset($_SESSION['email'])) {
    $email = mysqli_real_escape_string($connection, $_SESSION['email']);

    // Query to get the total balance for the logged in user
    $balanceQuery = mysqli_query($connection, "SELECT SUM(balance + deposit + bitcoin + ethereum + tether) AS total FROM users WHERE email='$email'") or die(mysqli_error($connection));

    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $totalBalance = $balanceRow['total'];
        // Format the balance to 2 decimal places and output it
        echo number_format($totalBalance, 2);
    } else {
        die("Balance query failed.");
    }
} else {
    die("User session not set.");
}
?>                          </p>
                          <span>
                            <svg
                              class="fill-bgray-900 dark:fill-bgray-50"
                              width="14"
                              height="12"
                              viewBox="0 0 14 12"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M10.7749 0.558058C10.5309 0.313981 10.1351 0.313981 9.89107 0.558058L7.39107 3.05806C7.14699 3.30214 7.14699 3.69786 7.39107 3.94194C7.63514 4.18602 8.03087 4.18602 8.27495 3.94194L9.70801 2.50888V11C9.70801 11.3452 9.98783 11.625 10.333 11.625C10.6782 11.625 10.958 11.3452 10.958 11V2.50888L12.3911 3.94194C12.6351 4.18602 13.0309 4.18602 13.2749 3.94194C13.519 3.69786 13.519 3.30214 13.2749 3.05806L10.7749 0.558058Z"
                               
                              />
                              <path
                                opacity="0.4"
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M3.22407 11.4419C3.46815 11.686 3.86388 11.686 4.10796 11.4419L6.60796 8.94194C6.85203 8.69786 6.85203 8.30214 6.60796 8.05806C6.36388 7.81398 5.96815 7.81398 5.72407 8.05806L4.29102 9.49112L4.29101 1C4.29101 0.654823 4.01119 0.375001 3.66602 0.375001C3.32084 0.375001 3.04102 0.654823 3.04102 1L3.04102 9.49112L1.60796 8.05806C1.36388 7.81398 0.968151 7.81398 0.724074 8.05806C0.479996 8.30214 0.479996 8.69786 0.724074 8.94194L3.22407 11.4419Z"
                                
                              />
                            </svg>
                          </span>
                        </div>
                        <p class="text-bgray-600 dark:text-bgray-50 text-base font-medium">
                          Spending
                        </p>
                      </div>
                    </div>
                  </div>
                  
                  
                  
                  
                  
                  
                  
                  <div class="conversion-unit">
    <h3 class="text-lg font-medium leading-[24px] dark:text-white text-bgray-900 pb-2.5">
        Conversion
    </h3>
    <form method="post" action="">
        <div class="flex space-x-3 mb-4 w-full h-[48px]">
            <div class="relative">
                <select name="from_currency" class="w-[80px] px-2.5 py-[14px] border rounded-lg border-bgray-300 dark:border-darkblack-400 dark:bg-darkblack-500 dark:text-white">
                    <option value="USD">USD</option>
                    <!-- Add more currencies as needed -->
                </select>
            </div>
            <div class="w-full h-full overflow-hidden">
                <input type="text" name="amount" placeholder="Amount" class="w-full h-full border border-bgray-300 rounded-lg focus:ring-0 dark:bg-darkblack-500 dark:border-darkblack-400 focus:border-none text-base text-bgray-900 dark:border dark:text-white" />
            </div>
        </div>
        <div class="flex space-x-3 w-full h-[48px]">
            <div class="relative">
                <select name="to_currency" class="w-[80px] px-2.5 py-[14px] border rounded-lg border-bgray-300 dark:border-darkblack-400 dark:bg-darkblack-500 dark:text-white">
                    <?php foreach ($targetCurrencies as $currency): ?>
                        <option value="<?php echo $currency; ?>"><?php echo $currency; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="w-full h-full overflow-hidden">
                <input type="text" name="converted_amount" placeholder="Converted Amount" class="w-full h-full border border-bgray-300 rounded-lg focus:ring-0 dark:bg-darkblack-500 dark:border-darkblack-400 focus:border-none text-base text-bgray-900 dark:border dark:text-white" readonly />
            </div>
        </div>
        <button type="submit" name="convert" class="mt-4 px-4 py-2 bg-blue-500 text-white rounded-lg">Convert</button>
    </form>
</div>

                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                </div>
                  </div>
                </div>
               
               
                  </div>
                  <div class="pagination-content w-full">
                    <div
                      class=""
                    >
                   
                   
                      <div

                    
                        <div class="flex items-center">
                         
                         


                      </div>
                    </div>
                  </div>
                </div>
              </div>
              </div>
            </div>
            <!-- write your code here-->
          </main>
        </div>
      </div>
    </div>
    <!-- layout end -->

    <!-- Modal -->
    <div
      class="modal hidden fixed inset-0 z-50 overflow-y-auto flex items-center justify-center"
      id="multi-step-modal"
    >
      <div class="modal-overlay absolute inset-0 bg-gray-500 opacity-75 dark:bg-bgray-900 dark:opacity-50"></div>
      <div
        class="modal-content flex justify-center w-full px-4 items-center mx-auto"
      >
        <!-- Step 1 -->
        <div class="step-content step-1">
          <div
            class="max-w-[550px] rounded-lg bg-white dark:bg-darkblack-600 p-8 pb-10 transition-all relative"
          >
            <button
              id="step-1-cancel"
              class="flex justify-center items-center absolute top-6 right-6"
            >
              <svg
                width="24"
                height="24"
                viewBox="0 0 24 24"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M16.9492 7.05029L7.04972 16.9498"
                  stroke="#22C55E"
                  stroke-width="2"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                />
                <path
                  d="M7.0498 7.05029L16.9493 16.9498"
                  stroke="#22C55E"
                  stroke-width="2"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                />
              </svg>
            </button>
            <header class="py-6 text-center px-8">
              <h3 class="text-2xl font-bold text-bgray-900 dark:text-white mb-3">Send Money</h3>
              <p class="text-sm font-medium text-bgray-600 dark:text-darkblack-300">
                Please enter user information that you want to send money and
                enter an amount
              </p>
            </header>
            <div class="flex justify-between items-center mb-6">
              <h4 class="text-base font-bold text-bgray-900 dark:text-white">Choose Method</h4>
              <button
                class="inline-flex items-center gap-x-1 text-xs font-medium rounded-full py-2 px-3 border border-bgray-200 text-bgray-900 dark:text-white"
              >
                <span>Add</span>
                <svg
                  class="stroke-bgray-900 dark:stroke-white"
                  width="14"
                  height="14"
                  viewBox="0 0 14 14"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M7 2.9165V11.0832"
                 
                    stroke-width="1.5"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                  />
                  <path
                    d="M2.91699 7H11.0837"
                   
                    stroke-width="1.5"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                  />
                </svg>
              </button>
            </div>
            <div
              class="flex flex-col md:flex-row justify-between gap-5 md:gap-x-8"
            >
              <div class="w-full md:w-1/2 space-y-3">
                <div
                  class="flex items-center py-3 px-4 rounded-lg border border-success-300 dark:border-darkblack-400"
                >
                  <div class="flex flex-1 space-x-3">
                    <div
                      class="w-12 h-12 rounded-full bg-bgray-100 flex items-center justify-center"
                    >
                      <img src="assets/images/payments/vis-xs.svg" alt="" />
                    </div>
                    <div>
                      <h4 class="font-bold text-bgray-900 dark:text-white text-sm">Visa</h4>
                      <span class="text-xs text-bgray-600 dark:text-bgray-50"> $24,098.00 </span>
                    </div>
                  </div>
                  <div>
                    <svg
                      width="16"
                      height="16"
                      viewBox="0 0 16 16"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <circle cx="8" cy="8" r="8" fill="#22C55E" />
                      <path
                        d="M5.27734 8.00011L7.22179 9.94455L11.1107 6.05566"
                        stroke="white"
                        stroke-width="1.5"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </div>
                </div>
                <div
                  class="flex items-center py-3 px-4 rounded-lg border border-bgray-300 dark:border-darkblack-400"
                >
                  <div class="flex flex-1 space-x-3">
                    <div
                      class="w-12 h-12 rounded-full bg-bgray-100 flex items-center justify-center"
                    >
                      <img
                        src="assets/images/payments/master-mini.svg"
                        alt=""
                      />
                    </div>
                    <div>
                      <h4 class="font-bold text-bgray-900 dark:text-white text-sm">
                        Mastercard
                      </h4>
                      <span class="text-xs text-bgray-600 dark:text-bgray-50"> $14,111.00 </span>
                    </div>
                  </div>
                  <div class="hidden">
                    <svg
                      width="16"
                      height="16"
                      viewBox="0 0 16 16"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <circle cx="8" cy="8" r="8" fill="#22C55E" />
                      <path
                        d="M5.27734 8.00011L7.22179 9.94455L11.1107 6.05566"
                        stroke="white"
                        stroke-width="1.5"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </div>
                </div>
                <div
                  class="flex items-center py-3 px-4 rounded-lg border border-bgray-300 dark:border-darkblack-400"
                >
                  <div class="flex flex-1 space-x-3">
                    <div
                      class="w-12 h-12 rounded-full bg-bgray-100 flex items-center justify-center"
                    >
                      <img src="assets/images/payments/payo-xs.svg" alt="" />
                    </div>
                    <div>
                      <h4 class="font-bold text-bgray-900 dark:text-white text-sm">Payoneer</h4>
                      <span class="text-xs text-bgray-600 dark:text-bgray-50"> $34,245.00 </span>
                    </div>
                  </div>
                  <div class="hidden">
                    <svg
                      width="16"
                      height="16"
                      viewBox="0 0 16 16"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <circle cx="8" cy="8" r="8" fill="#22C55E" />
                      <path
                        d="M5.27734 8.00011L7.22179 9.94455L11.1107 6.05566"
                        stroke="white"
                        stroke-width="1.5"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </div>
                </div>
              </div>
              <div class="w-full md:w-1/2">
                <div class="rounded mb-4">
                  <img
                    src="assets/images/payments/card-sm.png"
                    class="w-full"
                    alt=""
                  />
                </div>
                <div
                  class="w-full rounded-lg border border-bgray-200 dark:border-darkblack-400 focus-within:border-success-300 p-4 h-[98px] flex flex-col justify-between"
                >
                  <p class="text-xs text-bgray-600 dark:text-white font-medium">Enter amount</p>
                  <div
                    class="w-full h-[35px] flex justify-between items-center"
                  >
                    <span class="text-2xl text-bgray-900 dark:text-white font-bold">$</span>
                    <label class="w-full">
                      <input
                        type="text"
                        class="focus:outline-none dark:bg-darkblack-600 w-full p-0 focus:ring-0 border-none text-2xl font-bold text-bgray-900"
                      />
                    </label>
                    <div>
                      <img
                        src="assets/images/flag/us-circle.svg"
                        alt="members"
                      />
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <button
              id="step-1-next"
              class="bg-success-300 hover:bg-success-400 text-white font-semibold text-base py-4 flex justify-center items-center rounded-lg w-full mt-7"
            >
              Continue
            </button>
          </div>
        </div>
        <!-- Step 2 -->
        <div class="step-content step-2 hidden">
          <div
            class="max-w-[420px] rounded-lg bg-white dark:bg-darkblack-600 p-6 pb-10 transition-all relative"
          >
            <button
              id="step-2-cancel"
              class="w-6 h-6 bg-bgray-300 dark:bg-darkblack-500 rounded-full flex justify-center items-center absolute top-6 right-6"
            >
              <svg
                width="12"
                height="12"
                viewBox="0 0 12 12"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M10.9498 1.05029L1.05033 10.9498"
                  stroke="#718096"
                  stroke-width="1.5"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                />
                <path
                  d="M1.05029 1.05029L10.9498 10.9498"
                  stroke="#718096"
                  stroke-width="1.5"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                />
              </svg>
            </button>
            <header class="py-6 text-center mt-6">
              <h3 class="text-2xl font-bold text-bgray-900 dark:text-white mb-3">
                Add Currency
              </h3>
              <p class="text-xs font-medium text-bgray-600 dark:text-darkblack-300">
                When you add a currency, any payments you receive in that
                currency will be credited to that balance
              </p>
            </header>
            <form action="#">
              <div class="relative">
                <span class="absolute left-4 top-4">
                  <svg
                    class="stroke-bgray-900 dark:stroke-bgray-50"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <circle
                      cx="11.7666"
                      cy="11.7664"
                      r="8.98856"
                   
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    />
                    <path
                      d="M18.0183 18.4849L21.5423 21.9997"
                  
                      stroke-width="1.5"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    />
                  </svg>
                </span>
                <input
                  type="text"
                  class="p-4 pl-12 w-full rounded-lg border border-bgray-300 placeholder:text-bgray-500 focus:border-success-300 dark:border-darkblack-400 focus:ring-0 dark:bg-darkblack-600 dark:text-white dark:placeholder:text-bgray-50"
                  placeholder="Search"
                />
              </div>
            </form>
            <ul class="pt-6 space-y-1">
              <li class="flex justify-between items-center py-3">
                <label for="au" class="flex items-center space-x-4">
                  <img src="assets/images/flag/australia.svg" alt="" />
                  <span class="text-base font-semibold dark:text-white">Australian Dollar</span>
                </label>
                <input
                  type="checkbox"
                  id="au"
                  class="rounded-full w-6 h-6 border-bgray-300 focus:accent-success-300 text-success-300 focus:ring-transparent dark:bg-darkblack-600 dark:border-darkblack-400"
                />
              </li>
              <li class="flex justify-between items-center py-3">
                <label for="jp" class="flex items-center space-x-4">
                  <img src="assets/images/flag/japan.svg" alt="" />
                  <span class="text-base font-semibold dark:text-white">Japanese Yen</span>
                </label>
                <input
                  type="checkbox"
                  id="jp"
                  class="rounded-full w-6 h-6 border-bgray-300 focus:accent-success-300 text-success-300 focus:ring-transparent dark:bg-darkblack-600 dark:border-darkblack-400"
                />
              </li>
              <li class="flex justify-between items-center py-3">
                <label for="uk" class="flex items-center space-x-4">
                  <img src="assets/images/flag/uk.svg" alt="" />
                  <span class="text-base font-semibold dark:text-white">United Kingdom</span>
                </label>
                <input
                  type="checkbox"
                  id="uk"
                  class="rounded-full w-6 h-6 border-bgray-300 focus:accent-success-300 text-success-300 focus:ring-transparent dark:bg-darkblack-600 dark:border-darkblack-400"
                />
              </li>
            </ul>
            <button
              id="step-2-next"
              class="bg-success-300 hover:bg-success-400 text-white font-medium text-sm py-4 flex justify-center items-center rounded-lg w-full mt-7"
            >
              Add a Currency
            </button>
          </div>
        </div>
        <!-- Step 3 -->
        <div class="step-content step-3 hidden">
          <div
            class="max-w-xl w-full rounded-lg bg-white dark:bg-darkblack-600 p-5 md:px-14 md:py-8 transition-all"
          >
            <header class="flex flex-col items-center">
              <img src="assets/images/icons/invoice.svg" alt="" />
              <h2 class="text-4xl font-medium text-bgray-900 dark:text-white font-poppins">
                Payment successful
              </h2>
            </header>
            <ul class="py-6 mt-10 border-t border-b border-gray-200 dark:border-darkblack-400 space-y-4">
              <li class="flex justify-between">
                <span class="font-medium text-bgray-900 dark:text-white text-2xl"
                  >Payment type</span
                >
                <span class="text-2xl font-medium text-bgray-500 dark:text-bgray-50">
                  Net Banking</span
                >
              </li>
              <li class="flex justify-between">
                <span class="font-medium text-gray-900 dark:text-white text-2xl">Bank</span>
                <span class="text-2xl font-medium text-bgray-500 dark:text-bgray-50"> PayPal</span>
              </li>
              <li class="flex justify-between">
                <span class="font-medium text-gray-900 dark:text-white text-2xl">Mobile</span>
                <span class="text-2xl font-medium text-bgray-500 dark:text-bgray-50">
                  +1 707xxxxxxxx</span
                >
              </li>
              <li class="flex justify-between">
                <span class="font-medium text-gray-900 dark:text-white text-2xl">Email</span>
                <span class="text-2xl font-medium text-bgray-500 dark:text-bgray-50">
                  markparker@mail.com</span
                >
              </li>
            </ul>
            <ul class="pt-6 space-y-4">
              <li class="flex justify-between">
                <span class="font-bold text-gray-900 dark:text-white text-2xl"
                  >Amount paid</span
                >
                <span class="text-2xl font-bold text-bgray-900 dark:text-white"> $500.00</span>
              </li>
              <li class="flex justify-between">
                <span class="font-medium text-gray-900 dark:text-white text-2xl"
                  >Transaction id</span
                >
                <span class="text-2xl font-medium text-bgray-500 dark:text-white">
                  123694559z6465</span
                >
              </li>
            </ul>
            <div class="flex justify-center gap-8 mt-7">
              <button
                class="bg-success-300 hover:bg-success-400 text-white text-xl font-medium py-2 px-5 rounded-md"
              >
                Print
              </button>
              <button
                id="step-2-cancel"
                class="bg-success-300 hover:bg-success-400 text-white text-xl font-medium py-2 px-5 rounded-md"
              >
                Close
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script>
      AOS.init();
    </script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/chart.js"></script>
    <script>
      function pieChart() {
        let pieChart = document.getElementById("pie_chart").getContext("2d");

        const data = {
          labels: [10, 20, 30],
          datasets: [
            {
              label: "My First Dataset",
              data: [15, 20, 35, 40],
              backgroundColor: ["#1A202C", "#61C660", "#F8CC4B", "#EDF2F7"],
              borderColor: ["#ffffff", "#ffffff", "#ffffff", "#1A202C"],
              hoverOffset: 18,
              borderWidth: 0,
            },
          ],
        };
        const customDatalabels = {
          id: "customDatalabels",
          afterDatasetsDraw(chart, args, pluginOptions) {
            const {
              ctx,
              data,
              chartArea: { top, bottom, left, right, width, height },
            } = chart;
            ctx.save();
            data.datasets[0].data.forEach((datapoint, index) => {
              const { x, y } = chart
                .getDatasetMeta(0)
                .data[index].tooltipPosition();
              ctx.font = "bold 12px sans-serif";
              ctx.fillStyle = data.datasets[0].borderColor[index];
              ctx.textAlign = "center";
              ctx.textBaseline = "middle";
              ctx.fillText(`${datapoint}%`, x, y);
            });
          },
        };
        const config = {
          type: "doughnut",
          data,
          options: {
            maintainAspectRatio: false,
            layout: {
              padding: {
                left: 10,
                right: 10,
                top: 10,
                bottom: 10,
              },
            },
            plugins: {
              legend: {
                display: false,
              },
            },
          },
          plugins: [customDatalabels],
        };

        let pieChartConfiig = new Chart(pieChart, config);
      }
      pieChart();
      let revenueFlowElement = document
              .getElementById("overAllBalance")
              .getContext("2d");
      let month = [
        "Jan",
        "Feb",
        "Mar",
        "April",
        "May",
        "Jun",
        "July",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec",
      ];
      let revenueFlow = new Chart(revenueFlowElement, {
        type: "line",
        plugins: [
          {
            beforeDatasetsDraw(chart) {
              chart.ctx.shadowColor = "rgba(37, 99, 235, 0.14)";
              chart.ctx.shadowBlur = 8;
            },
            afterDatasetsDraw(chart) {
              chart.ctx.shadowColor = "rgba(0, 0, 0, 0)";
              chart.ctx.shadowBlur = 0;
            },
          },
        ],
        data: {
          labels: month,
          datasets: [
            {
              label: "Signed",
              data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
              backgroundColor: () => {
                const chart = document
                        .getElementById("overAllBalance")
                        .getContext("2d");
                const gradient = chart.createLinearGradient(0, 0, 0, 450);
                gradient.addColorStop(0, "rgba(34, 197, 94,0.41)");
                gradient.addColorStop(0.6, "rgba(255, 255, 255, 0)");
                return gradient;
              },
              borderColor: "#22C55E",
              // pointRadius: 5,
              pointBorderColor: "#ffffff",
              pointBackgroundColor: "#22C55E",
              pointBorderWidth: 4,
              borderWidth: 2,
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
            },
          ],
        },
        options: {
          // layout: {
          //   padding: {
          //     bottom: -20,
          //   },
          // },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
            },
            y: {
              beginAtZero: true,
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
              ticks: {
                callback(value) {
                  return `${value}K `;
                },
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            // tooltip: {
            //   enabled: false,
            // },
          },
          elements: {
            point: {
              radius: [0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0],
              hoverRadius: 6,
            },
          },
        },
      });


      //dark switch
      let themeToggleSwitch = document.getElementById('theme-toggle');
      //onclick
      if(themeToggleSwitch){
        themeToggleSwitch.addEventListener('click', function() {
          if(document.documentElement.classList[0]==='dark' || localStorage.theme === 'dark'){
            revenueFlow.options.scales.y.ticks.color = 'white';
            revenueFlow.options.scales.x.ticks.color = 'white';
            revenueFlow.options.scales.x.grid.color = '#242830';
            revenueFlow.options.scales.y.grid.color = '#242830';
            revenueFlow.update();
          }else{

            revenueFlow.options.scales.y.ticks.color = 'black';
            revenueFlow.options.scales.x.ticks.color = 'black';
            revenueFlow.options.scales.x.grid.color = 'rgb(243 ,246, 255 ,1)';
            revenueFlow.options.scales.y.grid.color = 'rgb(243 ,246, 255 ,1)';
            revenueFlow.update();
          }

        });
      }


      //initial load
      if (localStorage.theme === 'dark' || (window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        revenueFlow.options.scales.y.ticks.color='white';
        revenueFlow.options.scales.x.ticks.color='white';
        revenueFlow.options.scales.x.grid.color='#242830';
        revenueFlow.options.scales.y.grid.color='#242830';

      } else {
        revenueFlow.options.scales.y.ticks.color='black';
        revenueFlow.options.scales.x.ticks.color='black';
        revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
        revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
      }
      revenueFlow.update();
      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });
    </script>
    <script src="assets/js/quill.min.js"></script>

  </body>

</html>
