<?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    :root {
      --dark-bg: #121212;
      --card-bg: #1E1E1E;
      --text-light: #ffffff;
      --text-gray: #a0a0a0;
      --green: #22C55E;
      --red: #ef4444;
      --blue: #3b82f6;
    }
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    body {
      background-color: var(--dark-bg);
      color: var(--text-light);
    }
    
    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 20px;
    }
    
    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 15px 0;
      border-bottom: 1px solid rgba(255,255,255,0.1);
      margin-bottom: 24px;
    }
    
    .logo {
      font-size: 24px;
      font-weight: bold;
      color: var(--text-light);
    }
    
    .search-bar {
      flex-grow: 1;
      max-width: 400px;
      margin: 0 20px;
    }
    
    .search-bar input {
      width: 100%;
      padding: 10px 15px;
      border-radius: 20px;
      border: none;
      background-color: rgba(255,255,255,0.1);
      color: var(--text-light);
    }
    
    .nav-links {
      display: flex;
      gap: 20px;
    }
    
    .nav-links a {
      color: var(--text-gray);
      text-decoration: none;
      font-weight: 500;
    }
    
    .grid {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 24px;
      margin-bottom: 24px;
    }
    
    .card {
      background-color: var(--card-bg);
      border-radius: 10px;
      padding: 20px;
    }
    
    .card-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
    }
    
    .card-title {
      display: flex;
      align-items: center;
      gap: 7px;
      font-size: 18px;
      font-weight: 600;
    }
    
    .card-content {
      display: flex;
      justify-content: space-between;
      align-items: flex-end;
    }
    
    .value-area {
      flex-grow: 1;
    }
    
    .value {
      font-size: 28px;
      font-weight: bold;
      line-height: 48px;
      background-color: transparent;
    }
    
    .value.highlight {
      background-color: var(--green);
      color: white;
      font-weight: bold;
      padding: 5px;
      border-radius: 5px;
    }
    
    .change {
      display: flex;
      align-items: center;
      gap: 5px;
      color: var(--green);
      font-weight: 500;
    }
    
    .badge {
      display: inline-block;
      padding: 4px 8px;
      font-size: 12px;
      font-weight: 700;
      color: white;
      background-color: var(--green);
      border-radius: 4px;
      animation: blinker 1.5s linear infinite;
    }
    
    @keyframes blinker {
      50% {
        opacity: 0.5;
      }
    }
    
    .chart-area {
      width: 106px;
    }
    
    .icon-box {
      display: flex;
      flex-direction: column;
      align-items: center;
      margin-right: 10px;
      cursor: pointer;
    }
    
    .icon-link {
      display: flex;
      align-items: center;
      justify-content: center;
      width: 32px;
      height: 32px;
      border-radius: 50%;
      background-color: rgba(255,255,255,0.1);
      color: var(--text-light);
      margin-bottom: 5px;
    }
    
    .icon-text {
      font-size: 12px;
      color: var(--text-gray);
    }
    
    .market-table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    
    .market-table th, .market-table td {
      padding: 15px 10px;
      text-align: left;
      border-bottom: 1px solid rgba(255,255,255,0.1);
    }
    
    .market-table th {
      color: var(--text-gray);
      font-weight: 500;
    }
    
    .coin-info {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .coin-icon {
      width: 24px;
      height: 24px;
      border-radius: 50%;
    }
    
    .positive {
      color: var(--green);
    }
    
    .negative {
      color: var(--red);
    }
    
    .tabs {
      display: flex;
      gap: 20px;
      margin-bottom: 20px;
      border-bottom: 1px solid rgba(255,255,255,0.1);
      padding-bottom: 10px;
    }
    
    .tab {
      padding: 8px 16px;
      cursor: pointer;
      border-radius: 20px;
      background-color: transparent;
      color: var(--text-gray);
    }
    
    .tab.active {
      background-color: rgba(255,255,255,0.1);
      color: var(--text-light);
    }
    
    .settings {
      display: flex;
      gap: 15px;
      margin-bottom: 20px;
    }
    
    .filter-btn {
      display: flex;
      align-items: center;
      gap: 5px;
      padding: 8px 16px;
      border-radius: 20px;
      background-color: rgba(255,255,255,0.1);
      color: var(--text-light);
      cursor: pointer;
    }
    
    .pagination {
      display: flex;
      justify-content: center;
      gap: 10px;
      margin-top: 20px;
    }
    
    .page-btn {
      padding: 8px 12px;
      border-radius: 5px;
      background-color: rgba(255,255,255,0.1);
      color: var(--text-light);
      cursor: pointer;
    }
    
    .page-btn.active {
      background-color: var(--blue);
    }
    
    .fear-greed-meter {
      width: 100%;
      height: 50px;
      background: linear-gradient(to right, #ef4444, #eab308, #22C55E);
      border-radius: 25px;
      position: relative;
      margin-top: 20px;
    }
    
    .meter-indicator {
      position: absolute;
      width: 20px;
      height: 20px;
      background-color: white;
      border-radius: 50%;
      top: 15px;
      transform: translateX(-50%);
    }
    
    .meter-value {
      text-align: center;
      font-size: 24px;
      font-weight: bold;
      margin-top: 10px;
    }
    
    .meter-label {
      text-align: center;
      color: var(--text-gray);
    }
    
    .toggle-wrapper {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .data-sources {
      display: flex;
      gap: 10px;
      margin-top: 10px;
    }
    
    .data-source {
      width: 24px;
      height: 24px;
      border-radius: 50%;
      overflow: hidden;
    }
    
    .loading {
      text-align: center;
      padding: 20px;
      color: var(--text-gray);
    }
    
    @media (max-width: 768px) {
      .grid {
        grid-template-columns: 1fr;
      }
      
      .market-table th:nth-child(5),
      .market-table td:nth-child(5),
      .market-table th:nth-child(6),
      .market-table td:nth-child(6) {
        display: none;
      }
    }
  </style>
 <main
            class="w-full xl:px-[48px] px-6 pb-6 xl:pb-[48px] sm:pt-[156px] pt-[100px]"
          >
  <div class="container bg-white dark:bg-darkblack-600 rounded-lg">
    
    <div class="grid">
      <div p-5 rounded-lg bg-gray-100 dark:bg-darkblack-600>
        <div class="card-header">
          <div class="card-title text-lg text-bgray-900 dark:text-white font-semibold">
            <div class="icon">
              <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
              </svg>
            </div>
            <span>Bitcoin Price</span>
          </div>
          <div>
            <img src="https://cryptologos.cc/logos/bitcoin-btc-logo.png?v=040" alt="Bitcoin" class="coin-icon">
          </div>
        </div>
        <div class="card-content">
          <div class="value-area">
            <p class="value text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5" id="btcPrice">$0.00</p>
            <div class="change">
              <span>
                <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z" fill="#22C55E"></path>
                  <path opacity="0.4" d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z" fill="#22C55E"></path>
                </svg>
              </span>
              <span id="btcChange" class="text-success-300 text-sm font-medium">+0.00%</span>
            </div>
          </div>
          <div class="chart-area">
            <canvas id="btcChart"></canvas>
          </div>
        </div>
      </div>
      
      <div p-5 rounded-lg bg-gray-100 dark:bg-darkblack-600>
        <div class="card-header">
          <div class="card-title text-lg text-bgray-900 dark:text-white font-semibold">
            <div class="icon">
              <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
              </svg>
            </div>
            <span>Total Market Cap</span>
          </div>
          <div class="badge">Live</div>
        </div>
        <div class="card-content">
          <div class="value-area">
            <p class="value text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5" id="marketCap">$0.00</p>
            <div class="change">
              <span>
                <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z" fill="#22C55E"></path>
                  <path opacity="0.4" d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z" fill="#22C55E"></path>
                </svg>
              </span>
              <span id="marketCapChange" class="text-success-300 text-sm font-medium">+0.00%</span>
            </div>
          </div>
          <div class="chart-area">
            <canvas id="mcapChart"></canvas>
          </div>
        </div>
      </div>
      
      <div p-5 rounded-lg bg-gray-100 dark:bg-darkblack-600>
        <div class="card-header">
          <div class="card-title text-lg text-bgray-900 dark:text-white font-semibold">
            <div class="icon">
              <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M12 6V12L16 14" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
              </svg>
            </div>
            <span>Trading Volume 24h</span>
          </div>
          <div class="data-sources">
           
            <img src="./icons.png" alt="Source 3" class="data-source">
          </div>
        </div>
        <div class="card-content">
          <div class="value-area">
            <p class="value text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5" id="tradingVolume">$0.00</p>
            <div class="change">
              <span>
                <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z" fill="#22C55E"></path>
                  <path opacity="0.4" d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z" fill="#22C55E"></path>
                </svg>
              </span>
              <span id="volumeChange" class="text-success-300 text-sm font-medium">+0.00%</span>
            </div>
          </div>
          <div class="chart-area">
            <canvas id="volumeChart"></canvas>
          </div>
        </div>
      </div>
    </div>
    
    <div class="grid" style="grid-template-columns: 2fr 1fr;">
      <div p-5 rounded-lg bg-gray-100 dark:bg-darkblack-600>
        <div class="card-header">
          <div class="card-title text-lg text-bgray-900 dark:text-white font-semibold">Market Trends</div>
          <div class="toggle-wrapper">
            <span>USD</span>
            <div class="filter-btn">24h</div>
          </div>
        </div>
        
        <div class="tabs">
          <div class="tab active">All Cryptocurrencies</div>
          <div class="tab">DeFi</div>
          <div class="tab">NFTs</div>
          <div class="tab">Metaverse</div>
        </div>
        
        <div id="coinTableContainer">
          <p class="loading text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">Loading market data...</p>
        </div>
      </div>
      
      <div p-5 rounded-lg bg-gray-100 dark:bg-darkblack-600>
        <div class="card-header">
          <div class="card-title text-lg text-bgray-900 dark:text-white font-semibold">Fear & Greed Index</div>
        </div>
        <div class="meter-value" id="fearGreedValue">--</div>
        <div class="meter-label" id="fearGreedLabel">--</div>
        <div class="fear-greed-meter">
          <div class="meter-indicator" id="fearGreedIndicator" style="left: 50%;"></div>
        </div>
        
        <div class="card-header" style="margin-top: 30px;">
          <div class="card-title text-lg text-bgray-900 dark:text-white font-semibold">Top Gainers (24h)</div>
        </div>
        <div id="gainersContainer">
          <p class="loading text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">Loading gainers...</p>
        </div>
      </div>
    </div>
  </div>
</main>
  <script>
    // Helper functions
    function abbreviateNumber(num) {
      if (num >= 1e12) return (num / 1e12).toFixed(2) + "T";
      if (num >= 1e9) return (num / 1e9).toFixed(2) + "B";
      if (num >= 1e6) return (num / 1e6).toFixed(2) + "M";
      if (num >= 1e3) return (num / 1e3).toFixed(2) + "K";
      return num.toString();
    }

    function formatCurrency(value) {
      return '$' + abbreviateNumber(parseFloat(value));
    }

    function formatPercentage(value) {
      const num = parseFloat(value);
      return (num >= 0 ? '+' : '') + num.toFixed(2) + '%';
    }

    function getPercentageClass(value) {
      return parseFloat(value) >= 0 ? 'positive' : 'negative';
    }

    function createSimpleLineChart(ctx, data, color) {
      return new Chart(ctx, {
        type: 'line',
        data: {
          labels: Array(data.length).fill(''),
          datasets: [{
            data: data,
            borderColor: color,
            borderWidth: 2,
            pointRadius: 0,
            tension: 0.1,
            fill: false
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: { legend: { display: false } },
          scales: {
            x: { display: false },
            y: { display: false }
          },
          animation: false
        }
      });
    }

    // Update Fear & Greed Index based on a given value (0-100)
    function updateFearGreedIndex(value) {
      const indicator = document.getElementById('fearGreedIndicator');
      const valueEl = document.getElementById('fearGreedValue');
      const labelEl = document.getElementById('fearGreedLabel');
      valueEl.textContent = value;
      let label = '';
      if (value < 20) label = 'Extreme Fear';
      else if (value < 40) label = 'Fear';
      else if (value < 60) label = 'Neutral';
      else if (value < 80) label = 'Greed';
      else label = 'Extreme Greed';
      labelEl.textContent = label;
      // Adjust indicator position based on value (0-100 scale)
      const meter = document.querySelector('.fear-greed-meter');
      if(meter) {
        const meterWidth = meter.offsetWidth;
        const position = (value / 100) * meterWidth;
        indicator.style.left = `${position}px`;
      }
    }

    // Initialize charts with placeholder data
    const chartData = [65, 59, 80, 81, 56, 55, 40, 45, 60, 70, 75, 72];
    const btcChartCtx = document.getElementById('btcChart').getContext('2d');
    const mcapChartCtx = document.getElementById('mcapChart').getContext('2d');
    const volumeChartCtx = document.getElementById('volumeChart').getContext('2d');
    
    createSimpleLineChart(btcChartCtx, chartData, '#22C55E');
    createSimpleLineChart(mcapChartCtx, chartData, '#22C55E');
    createSimpleLineChart(volumeChartCtx, chartData, '#22C55E');

    // Fetch API data
    async function fetchGlobalData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/global');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Update market cap
        const marketCapUSD = data.data.total_market_cap.usd;
        document.getElementById('marketCap').textContent = formatCurrency(marketCapUSD);
        
        // Update market cap change
        const marketCapChange = data.data.market_cap_change_percentage_24h_usd;
        const marketCapChangeEl = document.getElementById('marketCapChange');
        marketCapChangeEl.textContent = formatPercentage(marketCapChange);
        marketCapChangeEl.className = getPercentageClass(marketCapChange) + ' text-sm font-medium';
        
        // Update trading volume
        const volumeUSD = data.data.total_volume.usd;
        document.getElementById('tradingVolume').textContent = formatCurrency(volumeUSD);
        
        // Placeholder for volume change since API doesn't provide it directly
        document.getElementById('volumeChange').textContent = '+3.25%';
        
        // Update Fear & Greed Index (using a random value for demonstration)
        updateFearGreedIndex(Math.floor(Math.random() * 100));
        
      } catch (error) {
        console.error('Error fetching global data:', error);
      }
    }

    async function fetchBitcoinData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/coins/bitcoin?localization=false&tickers=false&market_data=true&community_data=false&developer_data=false');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Update Bitcoin price
        const price = data.market_data.current_price.usd;
        document.getElementById('btcPrice').textContent = '$' + price.toLocaleString();
        
        // Update Bitcoin price change
        const priceChange = data.market_data.price_change_percentage_24h;
        const btcChangeEl = document.getElementById('btcChange');
        btcChangeEl.textContent = formatPercentage(priceChange);
        btcChangeEl.className = getPercentageClass(priceChange) + ' text-sm font-medium';
        
      } catch (error) {
        console.error('Error fetching Bitcoin data:', error);
      }
    }

    async function fetchMarketData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&order=market_cap_desc&per_page=25&page=1&sparkline=false&price_change_percentage=1h,24h,7d');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Populate coins table
        renderCoinsTable(data);
        
        // Populate top gainers
        renderTopGainers(data);
        
      } catch (error) {
        console.error('Error fetching market data:', error);
      }
    }

    function renderCoinsTable(coins) {
      const container = document.getElementById('coinTableContainer');
      
      const table = document.createElement('table');
      table.className = 'market-table';
      
      // Create table header
      const thead = document.createElement('thead');
      thead.innerHTML = `
        <tr>
          <th>#</th>
          <th>Name</th>
          <th>Price</th>
          <th>1h %</th>
          <th>24h %</th>
          <th>7d %</th>
          <th>Market Cap</th>
          <th>Volume(24h)</th>
        </tr>
      `;
      table.appendChild(thead);
      
      // Create table body
      const tbody = document.createElement('tbody');
      
      coins.forEach((coin, index) => {
        const tr = document.createElement('tr');
        
        tr.innerHTML = `
          <td>${index + 1}</td>
          <td>
            <div class="coin-info">
              <img src="${coin.image}" alt="${coin.name}" class="coin-icon">
              <div>
                <div>${coin.name}</div>
                <div style="color: var(--text-gray);">${coin.symbol.toUpperCase()}</div>
              </div>
            </div>
          </td>
          <td>$${coin.current_price.toLocaleString()}</td>
          <td class="${getPercentageClass(coin.price_change_percentage_1h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_1h_in_currency)}
          </td>
          <td class="${getPercentageClass(coin.price_change_percentage_24h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_24h_in_currency)}
          </td>
          <td class="${getPercentageClass(coin.price_change_percentage_7d_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_7d_in_currency)}
          </td>
          <td>${formatCurrency(coin.market_cap)}</td>
          <td>${formatCurrency(coin.total_volume)}</td>
        `;
        
        tbody.appendChild(tr);
      });
      
      table.appendChild(tbody);
      
      // Replace loading message with table
      container.innerHTML = '';
      container.appendChild(table);
      
      // Add pagination
      const pagination = document.createElement('div');
      pagination.className = 'pagination';
      pagination.innerHTML = `
        <div class="page-btn">Prev</div>
        <div class="page-btn active">1</div>
        <div class="page-btn">2</div>
        <div class="page-btn">3</div>
        <div class="page-btn">4</div>
        <div class="page-btn">5</div>
        <div class="page-btn">Next</div>
      `;
      container.appendChild(pagination);
    }

    function renderTopGainers(coins) {
      // Sort coins by 24h price change
      const gainers = [...coins]
        .sort((a, b) => b.price_change_percentage_24h_in_currency - a.price_change_percentage_24h_in_currency)
        .slice(0, 5);
      
      const container = document.getElementById('gainersContainer');
      container.innerHTML = '';
      
      gainers.forEach(coin => {
        const gainItem = document.createElement('div');
        gainItem.style.display = 'flex';
        gainItem.style.justifyContent = 'space-between';
        gainItem.style.alignItems = 'center';
        gainItem.style.padding = '10px 0';
        gainItem.style.borderBottom = '1px solid rgba(255,255,255,0.1)';
        
        gainItem.innerHTML = `
          <div class="coin-info">
            <img src="${coin.image}" alt="${coin.name}" class="coin-icon">
            <div>
              <div>${coin.name}</div>
              <div style="color: var(--text-gray);">${coin.symbol.toUpperCase()}</div>
            </div>
          </div>
          <div class="${getPercentageClass(coin.price_change_percentage_24h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_24h_in_currency)}
          </div>
        `;
        container.appendChild(gainItem);
      });
    }

    // Initialize data fetching once the page loads
    window.addEventListener('load', () => {
      fetchGlobalData();
      fetchBitcoinData();
      fetchMarketData();
    });
  </script>
  
      <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/flatpickr.js"></script>
    <script>
      // min-calender
      $("#min-calender").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        inline: true,
      });
    </script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script>
      AOS.init();
    </script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/chart.js"></script>
    <script>
      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });


      //totalEarnBar
      const ctx_bids = document
              .getElementById("totalEarnBar")
              .getContext("2d");
      const bitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const bitsData = [10, 20, 15, 50, 40, 25];
      let totalEarnBar = new Chart(ctx_bids, {
        type: "bar",
        data: {
          labels: bitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: bitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //totalSpend
      let totalSpend = document
              .getElementById("totalSpendingBar")
              .getContext("2d");
      const SpendingCharbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const SpendingCharbitsData = [10, 20, 15, 50, 40, 25];
      const totalSpendingChartBar = new Chart(totalSpend, {
        type: "bar",
        data: {
          labels: SpendingCharbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: SpendingCharbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });


      // totalGoalBar
      let totalGoalBarSelect = document.getElementById("totalGoalBar").getContext("2d");
      const totalGoalBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const totalGoalBarbitsData = [10, 20, 15, 50, 40, 25];
      const totalGoalBar = new Chart(totalGoalBarSelect, {
        type: "bar",
        data: {
          labels: totalGoalBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: totalGoalBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //monthSpendingBar
      let monthSpendingBarSelect = document
              .getElementById("monthSpendingBar")
              .getContext("2d");
      const monthSpendingBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const monthSpendingBarbitsData = [10, 20, 15, 50, 40, 25];
      const monthSpendingBar = new Chart(monthSpendingBarSelect, {
        type: "bar",
        data: {
          labels: monthSpendingBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: monthSpendingBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //revenueFlowBar
      let revenueFlowElement = document
              .getElementById("revenueFlowBar")
              .getContext("2d");
      let revenueFlowBarmonth = [
        "Jan",
        "Feb",
        "Mar",
        "April",
        "May",
        "Jun",
        "July",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec",
      ];
      let revenueDark = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueLight = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueFlow = new Chart(revenueFlowElement, {
        type: "bar",
        data: {
          labels: revenueFlowBarmonth,
          datasets: revenueLight,
        },
        options: {
          maintainAspectRatio: false,
          scales: {
            y: {
              beginAtZero: true,
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
              ticks: {
                callback(value) {
                  return `${value}% `;
                },
              },
            },
            x: {
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
            },
          },
          plugins: {
            legend: {
              display: false,
            },
          },
          // x: {
          //   stacked: true,
          // },
          // y: {
          //   stacked: true,
          // },
        },
      });


      function pieChart() {
        let pieChart = document.getElementById("pie_chart").getContext("2d");

        const data = {
          labels: [10, 20, 30],
          datasets: [
            {
              label: "My First Dataset",
              data: [15, 20, 35, 40],
              backgroundColor: ["#1A202C", "#61C660", "#F8CC4B", "#EDF2F7"],
              borderColor: ["#ffffff", "#ffffff", "#ffffff", "#1A202C"],
              hoverOffset: 18,
              borderWidth: 0,
            },
          ],
        };
        const customDatalabels = {
          id: "customDatalabels",
          afterDatasetsDraw(chart, args, pluginOptions) {
            const {
              ctx,
              data,
              chartArea: { top, bottom, left, right, width, height },
            } = chart;
            ctx.save();
            data.datasets[0].data.forEach((datapoint, index) => {
              const { x, y } = chart
                .getDatasetMeta(0)
                .data[index].tooltipPosition();
              ctx.font = "bold 12px sans-serif";
              ctx.fillStyle = data.datasets[0].borderColor[index];
              ctx.textAlign = "center";
              ctx.textBaseline = "middle";
              ctx.fillText(`${datapoint}%`, x, y);
            });
          },
        };
        const config = {
          type: "doughnut",
          data,
          options: {
            maintainAspectRatio: false,
            layout: {
              padding: {
                left: 10,
                right: 10,
                top: 10,
                bottom: 10,
              },
            },
            plugins: {
              legend: {
                display: false,
              },
            },
          },
          plugins: [customDatalabels],
        };

        let pieChartConfiig = new Chart(pieChart, config);
      }
      pieChart();

      //dark chart

      let themeToggleSwitch = document.getElementById('theme-toggle');

      //onclick
      if(themeToggleSwitch){
        themeToggleSwitch.addEventListener('click', function() {
          if(document.documentElement.classList[0]==='dark' || localStorage.theme === 'dark'){
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            revenueFlow.data.datasets=revenueDark;
            revenueFlow.options.scales.y.ticks.color='white';
            revenueFlow.options.scales.x.ticks.color='white';
            revenueFlow.options.scales.x.grid.color='#222429';
            revenueFlow.options.scales.y.grid.color='#222429';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }else{
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            revenueFlow.data.datasets=revenueLight;
            revenueFlow.options.scales.y.ticks.color='black';
            revenueFlow.options.scales.x.ticks.color='black';
            revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
            revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }
        });
      }


      //initial load
      if (localStorage.theme === 'dark' || (window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        revenueFlow.data.datasets=revenueDark;
        revenueFlow.options.scales.y.ticks.color='white';
        revenueFlow.options.scales.x.ticks.color='white';
        revenueFlow.options.scales.x.grid.color='#222429';
        revenueFlow.options.scales.y.grid.color='#222429';
      } else {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        revenueFlow.data.datasets=revenueLight;
        revenueFlow.options.scales.y.ticks.color='black';
        revenueFlow.options.scales.x.ticks.color='black';
        revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
        revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
      }
      totalEarnBar.update();
      totalSpendingChartBar.update();

      totalGoalBar.update();
      monthSpendingBar.update();
      revenueFlow.update();

    </script>


</body>
</html>
