<?php 
session_start();

// Check if the user is logged in
if (!isset($_SESSION['email'])) {
    echo "User not logged in.";
    exit;
}

// Database connection
$con = mysqli_connect("localhost", "rhyigjwq_userm", "PfNLDqaoRSXY", "rhyigjwq_dbm");

if (!$con) {
    die("Connection failed: " . mysqli_connect_error());
}

// Fetch session data
$SEshopmail = $_SESSION['email'];

// Fetch user details from the database
$query = mysqli_query($con, "SELECT * FROM users WHERE email = '$SEshopmail'");
$user = mysqli_fetch_array($query);

// Check if user data exists
if (!$user) {
    echo "User not found.";
    exit;
}

// Fetch account type (ensure this is in the database)
$accounttype = $user['accounttype']; 

// Close the database connection
mysqli_close($con);

// Check if uploads folder exists, create if not
$uploadDir = 'uploads';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// Get current date for expiry calculation
$currentDate = date('F Y');
$expiryDate = date('F Y', strtotime('+1 year'));
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Premium ID Card</title>
    <link rel="icon" href="https://www.marketchainx.com/favicon.png" type="image/png">
    <script src="https://cdn.jsdelivr.net/npm/qrcode"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700;800;900&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            background-color: #f0f0f0;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            flex-direction: column;
            font-family: 'Montserrat', sans-serif;
            padding: 20px;
        }
        
        .id-card-wrapper {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            align-items: center;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .id-card {
            width: 340px;
            height: 520px;
            border-radius: 16px;
            overflow: hidden;
            position: relative;
            background-color: #fff;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .id-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.4);
        }
        
        /* Card Header */
        .id-card .header {
            background: linear-gradient(135deg, #004d29 0%, #00331a 100%);
            color: #fff;
            padding: 25px 15px 60px;
            position: relative;
            text-align: center;
        }
        
        .id-card .header::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 45px;
            background: linear-gradient(90deg, #004d29 0%, #00cc66 50%, #004d29 100%);
            clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%, 15% 50%);
        }
        
        .id-card .logo {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
            font-size: 20px;
            font-weight: 700;
        }
        
        .id-card .logo img {
            width: 42px;
            margin-right: 12px;
            filter: drop-shadow(0 2px 5px rgba(0, 0, 0, 0.3));
        }
        
        /* Photo Frame */
        .id-card .photo-container {
            position: relative;
            width: 150px;
            height: 150px;
            margin: -50px auto 20px;
            z-index: 10;
        }
        
        .id-card .photo-frame {
            position: absolute;
            width: 150px;
            height: 150px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .id-card .photo-frame::before {
            content: "";
            position: absolute;
            width: 160px;
            height: 160px;
            background: linear-gradient(135deg, #00cc66 30%, #004d29 100%);
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            z-index: -1;
        }
        
        .id-card .photo-frame::after {
            content: "";
            position: absolute;
            width: 154px;
            height: 154px;
            background: linear-gradient(135deg, #d4af37 0%, #f9d773 50%, #b88a2c 100%);
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
            z-index: -2;
            animation: shimmer 3s infinite linear;
        }
        
        @keyframes shimmer {
            0% { opacity: 0.7; }
            50% { opacity: 1; }
            100% { opacity: 0.7; }
        }
        
        .id-card .user-image {
            width: 140px;
            height: 140px;
            object-fit: cover;
            border: 3px solid #fff;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
        }
        
        /* Name and Position */
        .id-card .name {
            text-align: center;
            font-size: 26px;
            font-weight: 800;
            text-transform: uppercase;
            margin: 10px 0 5px;
            letter-spacing: 1px;
            background: linear-gradient(to right, #333 0%, #000 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .id-card .position {
            text-align: center;
            background: linear-gradient(90deg, #00994d 0%, #00cc66 100%);
            color: white;
            font-size: 15px;
            font-weight: 600;
            padding: 6px 18px;
            border-radius: 20px;
            margin: 0 auto 15px;
            width: fit-content;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }
        
        /* Details Section */
        .id-card .details {
            padding: 0 25px;
            margin-bottom: 15px;
        }
        
        .id-card .details p {
            margin: 10px 0;
            font-size: 14px;
            display: flex;
            align-items: center;
            padding-bottom: 8px;
            border-bottom: 1px solid rgba(0, 0, 0, 0.08);
        }
        
        .id-card .details p:last-child {
            border-bottom: none;
        }
        
        .id-card .details .label {
            font-weight: 600;
            margin-right: 10px;
            width: 70px;
            display: inline-block;
            color: #00331a;
        }
        
        .id-card .details i {
            color: #00994d;
            margin-right: 10px;
            width: 16px;
            text-align: center;
        }
        
        /* Barcode & QR Section */
        .id-card .barcode {
            text-align: center;
            margin: 5px 0 15px;
            position: relative;
        }
        
        .id-card .barcode::before {
            content: "";
            position: absolute;
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80%;
            height: 1px;
            background: linear-gradient(to right, transparent, rgba(0, 0, 0, 0.1), transparent);
        }
        
        .id-card .barcode img {
            width: 90%;
            max-height: 60px;
            border-radius: 3px;
        }
        
        /* Back Card Specific */
        .id-card.back {
            background: linear-gradient(135deg, #f5f5f5 0%, #fff 100%);
        }
        
        .id-card.back .header {
            padding-bottom: 40px;
        }
        
        .id-card .chip {
            width: 55px;
            height: 40px;
            background: linear-gradient(135deg, #d4af37 0%, #f9d773 50%, #b88a2c 100%);
            border-radius: 8px;
            position: relative;
            margin: 15px auto;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }
        
        .id-card .chip::before {
            content: "";
            position: absolute;
            top: 8px;
            left: 8px;
            right: 8px;
            bottom: 8px;
            background: linear-gradient(135deg, #b88a2c 0%, #f9d773 50%, #d4af37 100%);
            border-radius: 3px;
            z-index: 1;
        }
        
        .id-card .chip::after {
            content: "";
            position: absolute;
            top: 15px;
            left: 5px;
            right: 5px;
            height: 10px;
            background-color: rgba(0, 0, 0, 0.2);
            border-radius: 2px;
            z-index: 2;
        }
        
        .id-card .qr-code {
            width: 120px;
            height: 120px;
            margin: 20px auto;
            padding: 5px;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
            border: 1px solid #eee;
        }
        
        .id-card .terms {
            font-size: 11px;
            text-align: center;
            color: #666;
            padding: 0 20px;
            margin: 10px 0;
            line-height: 1.5;
        }
        
        .id-card .validity {
            display: flex;
            justify-content: space-between;
            padding: 10px 25px;
            font-size: 12px;
            font-weight: 600;
            color: #00331a;
        }
        
        .id-card .signature {
            width: 90%;
            margin: 15px auto;
            padding: 10px;
            border-bottom: 2px solid #00331a;
            font-family: 'Dancing Script', cursive;
            font-size: 24px;
            color: #00331a;
            text-align: center;
        }
        
        /* Control Buttons */
        .control-buttons {
            margin-top: 20px;
            display: flex;
            gap: 15px;
        }
        
        .control-button {
            background: linear-gradient(135deg, #00994d 0%, #00cc66 100%);
            color: white;
            border: none;
            padding: 14px 28px;
            font-size: 16px;
            cursor: pointer;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .control-button:hover {
            background: linear-gradient(135deg, #00cc66 0%, #00994d 100%);
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
        }
        
        .control-button:active {
            transform: translateY(0);
        }
        
        .close-button {
            position: fixed;
            top: 20px;
            left: 20px;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #ff3333 0%, #cc0000 100%);
            color: white;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 24px;
            cursor: pointer;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            border: none;
            transition: all 0.3s ease;
        }
        
        .close-button:hover {
            transform: rotate(90deg);
            background: linear-gradient(135deg, #cc0000 0%, #ff3333 100%);
        }
        
        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            background: linear-gradient(135deg, #00994d 0%, #00cc66 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
            display: flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
        }
        
        .print-button:hover {
            background: linear-gradient(135deg, #00cc66 0%, #00994d 100%);
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
        }
        
        /* Company Logo Pulsating Effect */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .company-badge {
            position: absolute;
            bottom: 15px;
            right: 15px;
            background: linear-gradient(135deg, #d4af37 0%, #f9d773 50%, #b88a2c 100%);
            color: #00331a;
            font-size: 10px;
            font-weight: 700;
            padding: 5px 10px;
            border-radius: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
            animation: pulse 2s infinite ease-in-out;
        }
        
        /* Responsive Adjustments */
        @media (max-width: 767px) {
            .id-card {
                width: 300px;
                height: 480px;
            }
            
            .id-card .name {
                font-size: 22px;
            }
            
            .id-card .photo-container {
                width: 130px;
                height: 130px;
            }
            
            .id-card .photo-frame::before {
                width: 140px;
                height: 140px;
            }
            
            .id-card .photo-frame::after {
                width: 134px;
                height: 134px;
            }
            
            .id-card .user-image {
                width: 120px;
                height: 120px;
            }
        }
        
        @media print {
            .close-button, 
            .print-button, 
            .control-buttons {
                display: none;
            }
            
            body {
                padding: 0;
            }
            
            .id-card-wrapper {
                page-break-inside: avoid;
                gap: 0;
            }
            
            .id-card {
                box-shadow: none;
                margin: 0;
                page-break-inside: avoid;
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@600&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Close Button -->
    <a href="dashboard.php" class="close-button">
        <i class="fa fa-times" aria-hidden="true"></i>
    </a>

    <!-- Print Button -->
    <button onclick="window.print()" class="print-button">
        <i class="fa fa-print" aria-hidden="true"></i> Print ID Card
    </button>

    <div class="id-card-wrapper">
        <!-- Front Card -->
        <div class="id-card front">
            <div class="header">
                <div class="logo">
                    <img src="https://www.marketchainx.com/favicon.png" alt="marketchainx Logo">
                    <span>marketchainx International Co.</span>
                </div>
            </div>
            
            <div class="photo-container">
                <div class="photo-frame">
                    <img src="<?php echo 'uploads/' . $user['image']; ?>" alt="User Image" class="user-image">
                </div>
            </div>
            
            <div class="name"><?php echo $user['firstname'] . ' ' . $user['lastname']; ?></div>
            <div class="position"><?php echo $accounttype; ?></div>
            
            <div class="details">
                <p>
                    <i class="fas fa-id-card"></i>
                    <span class="label">ID No</span>: <?php echo $user['userid']; ?>
                </p>
                <p>
                    <i class="fas fa-envelope"></i>
                    <span class="label">E-mail</span>: <?php echo $user['email']; ?>
                </p>
                <p>
                    <i class="fas fa-phone"></i>
                    <span class="label">Phone</span>: <?php echo isset($user['phone']) ? $user['phone'] : '+123-456-7890'; ?>
                </p>
                <p>
                    <i class="fas fa-globe"></i>
                    <span class="label">Country</span>: <?php echo $user['country']; ?>
                </p>
            </div>
            
            <div class="barcode">
                <img src="https://barcode.tec-it.com/barcode.ashx?data=<?php echo $user['userid']; ?>&code=Code128&translate-esc=true" alt="Barcode">
            </div>
            
            <div class="company-badge">Official ID</div>
        </div>

        <!-- Back Card -->
        <div class="id-card back">
            <div class="header">
                <div class="logo">
                    <img src="https://www.marketchainx.com/favicon.png" alt="marketchainx Logo">
                    <span>marketchainx International Co.</span>
                </div>
            </div>
            
            <div class="chip"></div>
            
            <div class="qr-code" id="qr-code"></div>
            
            <div class="details">
                <p>
                    <i class="fas fa-wallet"></i>
                    <span class="label">Level</span>: <?php echo $accounttype; ?>
                </p>
                <p>
                    <i class="fas fa-coins"></i>
                    <span class="label">Currency</span>: <?php echo $user['currency']; ?>
                </p>
            </div>
            
            <div class="terms">
                This card is the property of marketchainx International Co. 
                If found, please return to the nearest office or contact support at support@marketchainx.com.online.
                Unauthorized use or alteration is strictly prohibited.
            </div>
            
            <div class="validity">
                <span>Issued: <?php echo $currentDate; ?></span>
                <span>Valid Until: <?php echo $expiryDate; ?></span>
            </div>
            
            <div class="signature">marketchainx Limited</div>
            
            <div class="company-badge">Verified</div>
        </div>
    </div>

    <div class="control-buttons">
        <button class="control-button" onclick="window.location.href='deposit.php';">
            <i class="fas fa-check-circle"></i> Activate Card
        </button>
    </div>

    <script>
        // Generate QR code
        window.onload = function() {
            var qrcode = new QRCode(document.getElementById("qr-code"), {
                text: "ID: <?php echo $user['userid']; ?>, Name: <?php echo $user['firstname'] . ' ' . $user['lastname']; ?>, Email: <?php echo $user['email']; ?>",
                width: 120,
                height: 120,
                colorDark: "#00331a",
                colorLight: "#ffffff",
                correctLevel: QRCode.CorrectLevel.H
            });
        };
    </script>
</body>
</html>