    <?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>

          <main
            class="w-full xl:px-[48px] px-6 pb-6 xl:pb-[48px] sm:pt-[156px] pt-[100px]"
          >
            <!-- write your code here-->
            <div class="2xl:flex 2xl:space-x-[48px]">
              <section class="flex-1 2xl:mb-0 mb-6">
                <div class="w-full bg-white dark:bg-darkblack-600 sm:px-10 sm:py-5 p-3 rounded-lg">
                  <div class="calender-wrapper w-full relative h-full">
                    <div class="w-full absolute -top-1 left-0">
                      <div class="flex justify-between items-center">
                        <div class="calender-title">
                          <h3
                            class="sm:text-2xl text-xl dark:text-white text-bgray-900 font-bold"
                          >
                            Calender
                          </h3>
                        </div>
                        <div class="flex space-x-2 items-center">
                          <button id="fc-prev-button" type="button">
                            <span>
                              <svg
                                width="28"
                                height="28"
                                viewBox="0 0 28 28"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                              >
                                <path
                                  d="M16.3334 8.16699L11.6667 14.0003L16.3334 19.8337"
                                  stroke="#718096"
                                  stroke-width="2"
                                  stroke-linecap="round"
                                  stroke-linejoin="round"
                                />
                              </svg>
                            </span>
                          </button>
                          <button id="fc-next-button" type="button">
                            <span>
                              <svg
                                width="28"
                                height="28"
                                viewBox="0 0 28 28"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                              >
                                <path
                                  d="M11.6666 19.833L16.3333 13.9997L11.6666 8.16634"
                                  stroke="#1A202C"
                                  stroke-width="2"
                                  stroke-linecap="round"
                                  stroke-linejoin="round"
                                />
                              </svg>
                            </span>
                          </button>
                        </div>
                      </div>
                    </div>
                    <div id="calendar"></div>
                  </div>
                </div>
              </section>
              <section
                class="2xl:w-[400px] w-full flex flex-col lg:flex-row 2xl:space-x-0 2xl:flex-col lg:space-x-6 space-x-0"
              >
                <div
                  class="2xl:w-full lg:w-1/2 w-full rounded-lg bg-white dark:bg-darkblack-600 dark:border dark:border-darkblack-400  px-[42px] py-5 2xl:mb-6 lg:mb-0 mb-6"
                >
                <div class="my-wallet w-full mb-8">
                  <div class="flex justify-between items-center mb-3">
                    <h3 class="text-lg font-bold text-bgray-900 dark:text-white">
                      My Wallet
                    </h3>
                    <div class="payment-select relative mb-3">
                      <button
                        onclick="dateFilterAction('#cardsOptions')"
                        type="button"
                      >
                        <svg
                          width="18"
                          height="4"
                          viewBox="0 0 18 4"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M8 2C8 2.55228 8.44772 3 9 3C9.55228 3 10 2.55228 10 2C10 1.44772 9.55228 1 9 1C8.44772 1 8 1.44772 8 2Z"
                            stroke="#CBD5E0"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                          />
                          <path
                            d="M1 2C1 2.55228 1.44772 3 2 3C2.55228 3 3 2.55228 3 2C3 1.44772 2.55228 1 2 1C1.44772 1 1 1.44772 1 2Z"
                            stroke="#CBD5E0"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                          />
                          <path
                            d="M15 2C15 2.55228 15.4477 3 16 3C16.5523 3 17 2.55228 17 2C17 1.44772 16.5523 1 16 1C15.4477 1 15 1.44772 15 2Z"
                            stroke="#CBD5E0"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                          />
                        </svg>
                      </button>
                      <div
                        id="cardsOptions"
                        class="rounded-lg shadow-lg min-w-[150px] bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-full hidden overflow-hidden"
                      >
                        <ul>
                          <li
                            onclick="dateFilterAction('#cardsOptions')"
                            class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 dark:text-white font-semibold"
                          >
                            Master Card
                          </li>
                          <li
                            onclick="dateFilterAction('#cardsOptions')"
                            class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 dark:text-white font-semibold"
                          >
                            VISA Card
                          </li>
                          <li
                            onclick="dateFilterAction('#cardsOptions')"
                            class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 dark:text-white font-semibold"
                          >
                            Others
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                  <div class="flex justify-center">
                    <div class="card-slider relative md:w-[340px] w-[280px]">
                      <div class="w-full">
                        <img
                          src="assets/images/payments/card-1.svg"
                          alt="card"
                        />
                      </div>
                      <div class="w-full">
                        <img
                          src="assets/images/payments/card-2.svg"
                          alt="card"
                        />
                      </div>
                      <div class="w-full">
                        <img
                          src="assets/images/payments/card-3.svg"
                          alt="card"
                        />
                      </div>
                    </div>
                  </div>
                </div>
                <div class="w-full">
                  <h3 class="text-lg font-bold text-bgray-900 dark:text-white mb-4">
                    Quick Transfer
                  </h3>
                  <div class="payment-select relative mb-3">
                    <button
                      onclick="dateFilterAction('#paymentFilter')"
                      type="button"
                      class="px-5 w-full h-[56px] border border-bgray-200 dark:border-darkblack-400 flex justify-between items-center rounded-lg overflow-hidden"
                    >
                      <div class="flex space-x-2 items-center">
                        <span>
                          <img
                            src="assets/images/payments/master-mini.svg"
                            alt="master"
                          />
                        </span>
                        <span class="text-sm font-medium text-bgray-900 dark:text-white"
                          >Debit</span
                        >
                      </div>
                      <div class="flex space-x-2 items-center">
                        <span class="text-sm font-bold text-bgray-900 dark:text-bgray-50">
                          $10,431
                        </span>
                        <span class="text-sm font-medium text-bgray-900">
                          <svg
                            width="16"
                            height="16"
                            viewBox="0 0 16 16"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M4 6L8 10L12 6"
                              stroke="#A0AEC0"
                              stroke-width="1.5"
                              stroke-linecap="round"
                              stroke-linejoin="round"
                            />
                          </svg>
                        </span>
                      </div>
                    </button>
                    <div
                      id="paymentFilter"
                      class="rounded-lg shadow-lg w-full bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-full hidden overflow-hidden"
                    >
                      <ul>
                        <li
                          onclick="dateFilterAction('#paymentFilter')"
                          class="text-sm  text-bgray-90 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 font-semibold"
                        >
                          Jan 10 - Jan 16
                        </li>
                        <li
                          onclick="dateFilterAction('#paymentFilter')"
                          class="text-sm  text-bgray-900 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 font-semibold"
                        >
                          Jan 10 - Jan 16
                        </li>
                        <li
                          onclick="dateFilterAction('#paymentFilter')"
                          class="text-sm  text-bgray-900 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 font-semibold"
                        >
                          Jan 10 - Jan 16
                        </li>
                      </ul>
                    </div>
                  </div>
                  <div
                    class="w-full rounded-lg border border-bgray-200 dark:border-darkblack-400 focus-within:border-success-300 p-4 h-[98px] flex flex-col justify-between"
                  >
                    <p class="text-sm text-bgray-600 dark:text-bgray-50 font-medium">
                      Enter amount
                    </p>
                    <div
                      class="w-full h-[35px] flex justify-between items-center"
                    >
                      <span class="text-2xl text-bgray-900 dark:text-white font-bold">$</span>
                      <label class="w-full">
                        <input
                          type="text"
                          class="focus:outline-none w-full dark:bg-darkblack-600 p-0 focus:ring-0 border-none text-2xl font-bold dark:border-darkblack-400 text-bgray-900 dark:text-white"
                        />
                      </label>
                      <div>
                        <img
                          src="assets/images/avatar/members-3.png"
                          alt="members"
                        />
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                <div class="2xl:w-full lg:w-1/2 w-full rounded-lg bg-white dark:bg-darkblack-600 p-5">
                  <div class="w-full">
                    <p class="text-lg font-semibold text-bgray-900 dark:text-white mb-5">
                      Select Date
                    </p>
                    <div class="w-full h-full relative mb-5">
                      <button
                        onclick="dateFilterAction('#date-selector-filter')"
                        type="button"
                        class="w-full h-full flex justify-center items-center"
                      >
                        <div class="flex justify-between w-full items-center">
                          <span class="text-base text-bgray-600 dark:text-bgray-50 font-semibold"
                            >June 2022</span
                          >
                          <span>
                            <svg
                              class="fill-bgray-900 dark:fill-white"
                              width="25"
                              height="24"
                              viewBox="0 0 25 24"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                d="M13.1901 15.1084L18.6831 9.60565C18.7742 9.51527 18.8466 9.40774 18.8959 9.28927C18.9453 9.1708 18.9707 9.04372 18.9707 8.91538C18.9707 8.78703 18.9453 8.65996 18.8959 8.54148C18.8466 8.42301 18.7742 8.31548 18.6831 8.2251C18.501 8.04402 18.2546 7.94238 17.9977 7.94238C17.7409 7.94238 17.4944 8.04402 17.3123 8.2251L12.4512 13.0376L7.63868 8.2251C7.45652 8.04402 7.21011 7.94238 6.95326 7.94238C6.69641 7.94238 6.45 8.04402 6.26785 8.2251C6.17598 8.31514 6.1029 8.42252 6.05283 8.54101C6.00277 8.6595 5.97671 8.78674 5.97618 8.91538C5.97671 9.04401 6.00277 9.17125 6.05283 9.28974C6.1029 9.40823 6.17598 9.51561 6.26785 9.60565L11.7609 15.1084C11.8519 15.2071 11.9624 15.2859 12.0854 15.3397C12.2084 15.3936 12.3412 15.4214 12.4755 15.4214C12.6097 15.4214 12.7426 15.3936 12.8655 15.3397C12.9885 15.2859 13.099 15.2071 13.1901 15.1084Z"
                              
                              />
                            </svg>
                          </span>
                        </div>
                      </button>
                      <div
                        id="date-selector-filter"
                        class="rounded-lg shadow-lg bg-white dark:bg-darkblack-500 w-full absolute right-0 z-10 top-5 overflow-hidden hidden"
                      >
                        <ul>
                          <li
                            onclick="dateFilterAction('#date-selector-filter')"
                            class="text-sm  text-bgray-90 cursor-pointer px-5 py-2 hover:dark:bg-darkblack-600 dark:text-white hover:bg-bgray-100 font-semibold"
                          >
                            January
                          </li>
                          <li
                            onclick="dateFilterAction('#date-selector-filter')"
                            class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:dark:bg-darkblack-600 dark:text-white hover:bg-bgray-100 font-semibold"
                          >
                            February
                          </li>

                          <li
                            onclick="dateFilterAction('#date-selector-filter')"
                            class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:dark:bg-darkblack-600 dark:text-white hover:bg-bgray-100 font-semibold"
                          >
                            March
                          </li>
                        </ul>
                      </div>
                    </div>
                    <div class="mini-calender-wrapper w-full">
                      <input type="text" id="min-calender" class="hidden" />
                    </div>
                  </div>
                </div>
              </section>
            </div>
            <!-- write your code here-->
          </main>
        </div>
      </div>
    </div>
    <!-- layout end -->
    <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/flatpickr.js"></script>
    <script>
      // min-calender
      $("#min-calender").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        inline: true,
      });
    </script>
    <script src="assets/js/calender.js"></script>
    <script>
      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });
      document.addEventListener("DOMContentLoaded", function () {
        var calendarEl = document.getElementById("calendar");
        function renderCalendar(view) {
          const calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: view,
            dateClick: function () {
              console.log("Add Event");
            },
            headerToolbar: {
              left: "dayGridMonth,timeGridWeek,timeGridDay,listMonth",
              center: "title",
              right: false,
            },
            initialDate: new Date(), // using new Date(); and set your scheduled on event array
            navLinks: true, // can click day/week names to navigate views
            businessHours: true, // display business hours
            editable: false,
            selectable: true,
            events: [
              {
                title: "Business",
                start: "2025-04-05T13:00:00",
                constraint: "businessHours",
                color: "#F5BA47",
              },
              {
                title: "Event",
                start: "2025-04-14T13:00:00",
                constraint: "businessHours",
                color: "#63C660",
              },
              {
                title: "Meeting",
                start: "2025-04-18T13:00:00",
                constraint: "availableForMeeting", // defined below
                color: "#936DFF",
              },
              {
                title: "Business",
                start: "2025-05-09T13:00:00",
                constraint: "businessHours",
                color: "#F5BA47",
              },
              {
                title: "Event",
                start: "2025-05-17T13:00:00",
                constraint: "businessHours",
                color: "#63C660",
              },
              {
                title: "Meeting",
                start: "2025-05-27T13:00:00",
                constraint: "availableForMeeting", // defined below
                color: "#936DFF",
              },
            ],
          });
          document
            .getElementById("fc-next-button")
            .addEventListener("click", function () {
              calendar.next();
            });
          document
            .getElementById("fc-prev-button")
            .addEventListener("click", function () {
              calendar.prev();
            });

          calendar.render();
        }
        renderCalendar("dayGridMonth");
      });
    </script>
    <script src="assets/js/main.js"></script>
  </body>

<!--calender.php by /3.x [XR&CO'2014], Fri, 28 Mar 2025 18:01:02 GMT -->
</html>
