<?php
session_start();
include_once("z_db.php");
include 'action/check-login.php';

/**
 * This function updates the amount status in the database.
 * @param string $newAmount The new amount to be updated in the database.
 * @return void
 */
function updateWithdrawStatus($newAmount) {
    global $conn; // Assuming $conn is your database connection object

    // Fetch the last amount entry
    $sql_last_amount = "SELECT amount, coinid FROM coinsent ORDER BY id DESC LIMIT 1";
    $result_last_amount = $conn->query($sql_last_amount);
    if ($result_last_amount->num_rows > 0) {
        $row = $result_last_amount->fetch_assoc();
        $coinid = $row['coinid']; // Fetch the coinid

        // Update the amount with the new value
        $sql_update = "UPDATE coinsent SET amount='$newAmount' WHERE coinid='$coinid'";
        if ($conn->query($sql_update) === TRUE) {
            header("Location: invoice.php");
            exit();
        } else {
            $_SESSION['flash_message'] = 'Error: ' . $conn->error;
        }
    } else {
        $_SESSION['flash_message'] = 'No amount entry found.';
    }
}

if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    header("Location: logout.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['amount'])) {
        $newAmount = $_POST['amount'];
        updateWithdrawStatus($newAmount);
    } else {
        $_SESSION['flash_message'] = 'Amount not set.';
    }
}

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->close();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Blocked Page</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            background-color: #0c0c0c;
            color: #f9f9f9;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            width: 90%;
            max-width: 600px;
            text-align: center;
            padding: 20px;
        }
        .frame {
            border: 1px solid #e60000;
            padding: 20px;
            margin: 20px auto;
            width: 100%;
            max-width: 400px;
            border-radius: 15px;
            position: relative;
            background: #000000;
        }
        .frame:before {
            content: "";
            position: absolute;
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 10px;
            background: #000000;
            border-radius: 10px 10px 0 0;
        }
        h1 {
            font-size: 4vw;
            font-weight: bold;
        }
        p {
            font-size: 3vw;
        }
        h2 {
            font-size: 4vw;
        }
        .frame img {
            width: 80px;
            height: 80px;
            display: block;
            margin: 0 auto;
        }
        a {
            color: rgb(0, 215, 50);
        }
        .alert {
            display: flex;
            align-items: center;
            padding: 16px;
            margin-bottom: 16px;
            text-align: left;
            border-radius: 8px;
        }
        .alert svg {
            margin-right: 12px;
        }
        /* Media queries for larger screens */
        @media (min-width: 768px) {
            h1 {
                font-size: 2vw;
            }
            p, h2 {
                font-size: 1.5vw;
            }
            .frame {
                max-width: 600px;
            }
        }
    </style>
    
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="https://financesynergys.com/index_files/logoc.svg" />
    <link rel="apple-touch-icon-precomposed" href="https://financesynergys.com/index_files/logoc.svg" />
    
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h1>Access Denied</h1>
        
        <?php
        if (isset($_SESSION['message'])) {
            echo "<div class='alert text-red-700 bg-red-100 dark:bg-red-200 dark:text-red-800' role='alert'>
                <svg class='w-5 h-5' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'><path fill-rule='evenodd' d='M8.257 3.099c.366-.446.991-.5 1.42-.123l.094.083 8 9a1 1 0 01.083 1.32l-.083.094-8 9a1 1 0 01-1.32.083l-.094-.083-8-9a1 1 0 01-.083-1.32l.083-.094 8-9zM9 11a1 1 0 100 2 1 1 0 000-2zM9 7a1 1 0 10-2 0v4a1 1 0 002 0V7z' clip-rule='evenodd'></path></svg>
                <div>".$_SESSION['message']."</div>
            </div>";
            unset($_SESSION['message']);
        }
        if (isset($_SESSION['action1'])) {
            echo "<div class='alert text-blue-700 bg-blue-100 dark:bg-blue-200 dark:text-blue-800' role='alert'>
                <svg class='w-5 h-5' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'><path fill-rule='evenodd' d='M18 8a6 6 0 10-12 0 6 6 0 0012 0zm-6 4a4 4 0 100-8 4 4 0 000 8zm-1-5a1 1 0 012 0v2a1 1 0 01-2 0V7zm0 4a1 1 0 012 0v2a1 1 0 01-2 0v-2z' clip-rule='evenodd'></path></svg>
                <div>".$_SESSION['action1']."</div>
            </div>";
            unset($_SESSION['action1']);
        }
        if (isset($_SESSION['success'])) {
            echo "<div class='alert text-blue-700 bg-blue-100 dark:bg-blue-200 dark:text-blue-800' role='alert'>
                <svg class='w-5 h-5' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'><path fill-rule='evenodd' d='M18 8a6 6 0 10-12 0 6 6 0 0012 0zm-6 4a4 4 0 100-8 4 4 0 000 8zm-1-5a1 1 0 012 0v2a1 1 0 01-2 0V7zm0 4a1 1 0 012 0v2a1 1 0 01-2 0v-2z' clip-rule='evenodd'></path></svg>
                <div>".htmlspecialchars($_SESSION['success'], ENT_QUOTES, 'UTF-8')."</div>
            </div>";
            unset($_SESSION['success']);
        }
        ?>

        <div class="frame">
            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/cc/Cross_red_circle.svg/768px-Cross_red_circle.svg.png?20181021160952" alt="Block Sign">
            <p>Sorry, you have been blocked from accessing this website.</p>
        </div>
        <h2>Why have I been blocked?</h2>
        <p>This website is using a security service to protect itself from online attacks. The action you just performed triggered the security solution. There are several actions that could trigger this block including submitting a certain word or phrase, a command or malformed data.</p>
        <h2><strong>What can I do to resolve this?</strong></h2>
        <p>You can email support at <strong><a href="mailto:complaint@financesynergys.com	.live" style="color:red;">Complaint</a></strong> to let them know you were blocked. Please include what you were doing when this page came up or click here: <strong><a href="./withdrawal.php" style="color:red;">Click to Unblock</a></strong>.</p>

        <h2>Your IP Address:</h2>
        <p id="ipAddress" style="color: rgb(255, 153, 0);"></p>
        <p>financesynergys.com	 Security Team • Performance & security by financesynergys.com	</p>
    </div>
    <script>
        fetch('https://api.ipify.org?format=json')
            .then(response => response.json())
            .then(data => {
                document.getElementById('ipAddress').textContent = data.ip;
            })
            .catch(error => {
                console.error('Error:', error);
            });
    </script>
</body>
</html>
