<?php
// Required files
require('db.php');
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Start the session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Display errors for debugging
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

include 'action/check-login.php';

// Redirect if not logged in
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    echo "
        <script language='javascript'>
            window.location = 'logout.php';
        </script>
    ";
    exit();
}
// Define variables from the session
$SEshopmail = isset($_SESSION['email']) ? $_SESSION['email'] : null;
$fullname = isset($_SESSION['fullname']) ? $_SESSION['fullname'] : null;
$email = isset($_SESSION['email']) ? $_SESSION['email'] : null;


// Check if the user has a locked withdrawal
$query = "SELECT * FROM `users` WHERE email='$SEshopmail' AND lockwithdraw ='yes'";
$result = mysqli_query($con, $query);
if (!$result) {
    die('Error: ' . mysqli_error($con));
}

if (mysqli_num_rows($result) > 0) {
    echo "
        <script language='JavaScript'>
            window.location.href='withdrawal.php';
        </script>
    ";
    exit();
}

// Handle withdrawal form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize input fields
    $withmethod = mysqli_real_escape_string($con, $_POST['withmethod']);
    $accountno = isset($_POST['accountno']) ? mysqli_real_escape_string($con, $_POST['accountno']) : '';
    $accountname = isset($_POST['accountname']) ? mysqli_real_escape_string($con, $_POST['accountname']) : '';
    $swiftcode = mysqli_real_escape_string($con, $_POST['swiftcode']);
    $city = mysqli_real_escape_string($con, $_POST['city']);
    $zipcode = mysqli_real_escape_string($con, $_POST['zipcode']);
    $bank = mysqli_real_escape_string($con, $_POST['bank']);
    $amount = (float) mysqli_real_escape_string($con, $_POST['amount']);
    $routingnumber = mysqli_real_escape_string($con, $_POST['routingnumber']);
    $walletadd = mysqli_real_escape_string($con, $_POST['walletadd']);
    $t_type = mysqli_real_escape_string($con, $_POST['t_type']);
    $assetamount = mysqli_real_escape_string($con, $_POST['assetamount']);
    $assetname = mysqli_real_escape_string($con, $_POST['assetname']);
    $narration = mysqli_real_escape_string($con, $_POST['narration']);
    $paypaltype = mysqli_real_escape_string($con, $_POST['paypaltype']);
    $tax = mysqli_real_escape_string($con, $_POST['tax']);
    $cardnum = mysqli_real_escape_string($con, $_POST['cardnum']);
    $cardholder = mysqli_real_escape_string($con, $_POST['cardholder']);
    $currency = mysqli_real_escape_string($con, $_POST['currency']);
    $country = mysqli_real_escape_string($con, $_POST['country']);

    $date = date('Y-m-d');
    $transid = substr(str_shuffle('29176573827673930057000463891234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 5);

    // Retrieve user's total balance
    $userquery = mysqli_query($con, "SELECT balance, deposit, bitcoin, tether, ethereum, solana FROM users WHERE email='$SEshopmail'");
    if (!$userquery) {
        die('Error: ' . mysqli_error($con));
    }

    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);

        // Fetch individual balances
        $balance = (float)$row['balance'];
        $deposit = (float)$row['deposit'];
        $bitcoin = (float)$row['bitcoin'];
        $tether = (float)$row['tether'];
        $ethereum = (float)$row['ethereum'];
        $solana = (float)$row['solana'];

        // Calculate total available amount
        $total_amount = $balance + $deposit + $bitcoin + $tether + $ethereum + $solana;
        $total_amount_formatted = number_format($total_amount, 2);

        // Check if sufficient funds for withdrawal
        if ($amount > $total_amount) {
            $_SESSION['flash_message'] = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>
                                            <strong>IMPORTANT NOTICE:</strong> Insufficient funds. Total available: $total_amount_formatted.
                                            <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                                                <span aria-hidden='true'>×</span>
                                            </button>
                                          </div>";
            header("Refresh: 1; url=withdrawal.php");
            exit();
        } else {
            // Deduct from balances
            $remaining_amount = $amount;

            // Deduction process for each balance field
            $balance = max(0, $balance - $remaining_amount);
            $remaining_amount -= min($balance, $remaining_amount);
            // Continue similarly for $deposit, $bitcoin, $tether, $ethereum, $solana...

            // Insert the withdrawal record
            $insert_withdrawal = "INSERT INTO withdrawal (date, email, withmethod, accountno, accountname, swiftcode, city, zipcode, bank, amount, routingnumber, walletadd, t_type, assetamount, assetname, narration, paypaltype, tax, cardnum, cardholder, currency, country, transid, status) 
                                   VALUES ('$date', '$SEshopmail', '$withmethod', '$accountno', '$accountname', '$swiftcode', '$city', '$zipcode', '$bank', '$amount', '$routingnumber', '$walletadd', '$t_type', '$assetamount', '$assetname', '$narration', '$paypaltype', '$tax', '$cardnum', '$cardholder', '$currency', '$country', '$transid', 'Processing')";

            if (mysqli_query($con, $insert_withdrawal)) {
                // Update user balance
                $update_balance = "UPDATE users SET balance='$balance', deposit='$deposit', bitcoin='$bitcoin', tether='$tether', ethereum='$ethereum', solana='$solana' WHERE email='$SEshopmail'";
                mysqli_query($con, $update_balance);

                // Send confirmation email
                $mail = new PHPMailer(true);
               try {
                    $mail->isSMTP();
                    $mail->Host = 'mail.financesynergys.com'; 
                    $mail->SMTPAuth = true;
                    $mail->Username = 'noreply@financesynergys.com'; 
                    $mail->Password = 'Cryt@504'; 
                    $mail->SMTPSecure = 'tls';
                    $mail->Port = 587;

                    $mail->setFrom('noreply@financesynergys.com', 'financesynergys');
                    $mail->addAddress($email, $fullname);
                    $mail->addReplyTo('noreply@financesynergys.com', 'No Reply');

                    $mail->isHTML(true);
                    $mail->Subject = 'Withdrawal Confirmation';
                  $mail->Body = '
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Withdrawal Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 90%;
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .header {
            background-color: #512eff; /* Header background color */
            padding: 20px;
            text-align: center;
            color: white; /* Logo text color */
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: bold;
        }
        .content {
            padding: 20px;
        }
        .content p {
            margin: 10px 0;
            font-size: 16px;
            color: #333333;
        }
        .footer {
            background-color: #f4f4f4;
            padding: 10px;
            text-align: center;
        }
        .footer h1 {
            margin: 0;
            font-size: 28px;
            font-weight: bold;
            color: #512eff; /* Footer text color */
        }
        .strong {
            font-weight: bold;
            color: #512eff; /* Use the same color for consistency */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>financesynergys</h1> <!-- Logo text -->
        </div>
        <div class="content">
            <h2>Withdrawal Request Confirmation</h2>
            <p>Your withdrawal request has been received.</p>
            <p>Transaction ID: <span class="strong">' . htmlspecialchars($transid) . '</span></p>
            <p>Amount:<span class="strong">' . htmlspecialchars($currency) . '</span> <span class="strong">' . htmlspecialchars($amount) . '</span></p>
            <p>Status: <span class="strong">Pending</span></p>
        </div>
        <div class="footer">
            <h1>financesynergys</h1> <!-- Logo text in footer -->
        </div>
    </div>
</body>
</html>
';


$mail->AltBody = 'Your withdrawal request has been received. Transaction ID: ' . htmlspecialchars($transid) . '. Amount: ' . htmlspecialchars($amount) . '. Status: pending.';


                    $mail->send();
                    
                } catch (Exception $e) {
                    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                }

                // Redirect with success message
                $_SESSION['flash_message'] = "<div class='alert alert-success alert-dismissible fade show' role='alert'>
                                                <strong>Success:</strong> Your withdrawal request of <strong>$currency</strong><strong>$amount</strong> using <strong>$withmethod</strong> has been submitted successfully. Transaction ID: <strong>$transid</strong>.
                                              </div>";
                header("Refresh: 1; url=withsuccess.php");
                exit();

            } else {
                die('Error: ' . mysqli_error($con));
            }
        }
    }
}
?>
