// Import Chart.js library (make sure you include it in your HTML)
const ctx = document.getElementById('myChart').getContext('2d');

// Initial data for the chart
const initialData = {
    labels: ['January', 'February', 'March', 'April', 'May'],
    datasets: [{
        label: 'Financial Data',
        data: [100, 150, 120, 200, 180],
        backgroundColor: 'rgba(75, 192, 192, 0.2)', // Background color
        borderColor: 'rgba(75, 192, 192, 1)', // Border color
        borderWidth: 1 // Border width
    }]
};

// Create the chart
const myChart = new Chart(ctx, {
    type: 'line', // Chart type (e.g., line, bar, pie)
    data: initialData,
});

// Update the chart when the admin clicks the "Update Chart" button
const updateChartButton = document.getElementById('updateChart');
const figureInput = document.getElementById('figureInput');

updateChartButton.addEventListener('click', () => {
    // Add the new figure to the chart's data
    myChart.data.labels.push('New Month');
    myChart.data.datasets[0].data.push(parseInt(figureInput.value));

    // Update the chart
    myChart.update();

    // Clear the input field
    figureInput.value = '';
});
