<?php
// Start session only if it hasn't already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Database credentials
$servername = "localhost";
$username = "hvjsvqui_uservv";
$password = "dSWLVwOUJvOQ";
$dbname = "hvjsvqui_dbvv";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    file_put_contents('log.txt', "Connection failed: " . $conn->connect_error . "\n", FILE_APPEND);
    die("Connection failed: " . $conn->connect_error);
}

// Form processing
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $special_number = trim($_POST['special_number']);
    $email = trim($_POST['email']);
    $image = $_FILES['image'];

    // Debugging: Log POST data
    file_put_contents('log.txt', "POST data: special_number=$special_number, email=$email\n", FILE_APPEND);
    file_put_contents('log.txt', "Image upload: " . print_r($image, true) . "\n", FILE_APPEND);

    if ($image['error'] === 0) {
        $image_new_name = uniqid('', true) . '.' . pathinfo($image['name'], PATHINFO_EXTENSION);
        $image_destination = 'uploads/' . $image_new_name;

        // Log image destination
        file_put_contents('log.txt', "Image destination: $image_destination\n", FILE_APPEND);

        if (move_uploaded_file($image['tmp_name'], $image_destination)) {
            file_put_contents('log.txt', "Image moved successfully to $image_destination\n", FILE_APPEND);

            // Prepare statement for mtccode validation
            if ($stmt = $conn->prepare("SELECT mtccode FROM admin WHERE mtccode = ?")) {
                $stmt->bind_param("s", $special_number);

                if ($stmt->execute()) {
                    // Use bind_result() to fetch results if get_result() is unavailable
                    $stmt->store_result(); // Store result to be fetched later
                    $stmt->bind_result($mtccode);

                    if ($stmt->fetch()) {
                        // If mtccode matches, proceed with updating the image
                        if ($update_stmt = $conn->prepare("UPDATE users SET image = ? WHERE email = ?")) {
                            $update_stmt->bind_param("ss", $image_new_name, $email);
                            if (!$update_stmt->execute()) {
                                file_put_contents('log.txt', "Error updating image in users table: " . $update_stmt->error . "\n", FILE_APPEND);
                                $_SESSION['notification_message'] = "Error updating image. Please try again.";
                                $_SESSION['notification_color'] = "red";
                            } else {
                                $_SESSION['notification_message'] = "ID successfully Created!";
                                $_SESSION['notification_color'] = "green";
                            }
                            $update_stmt->close();
                        }
                    } else {
                        file_put_contents('log.txt', "No matching mtccode found for $special_number\n", FILE_APPEND);
                        $_SESSION['notification_message'] = "Invalid ID special Tag.";
                        $_SESSION['notification_color'] = "red";
                    }
                }
                $stmt->close();
            } else {
                file_put_contents('log.txt', "Error preparing mtccode validation query: " . $conn->error . "\n", FILE_APPEND);
                $_SESSION['notification_message'] = "Database error. Please try again.";
                $_SESSION['notification_color'] = "red";
            }
        } else {
            file_put_contents('log.txt', "Error uploading the image: " . $image['error'] . "\n", FILE_APPEND);
            $_SESSION['notification_message'] = "There was an error uploading the image.";
            $_SESSION['notification_color'] = "red";
        }
    } else {
        file_put_contents('log.txt', "No image uploaded or invalid image: " . $image['error'] . "\n", FILE_APPEND);
        $_SESSION['notification_message'] = "Please upload a valid image file.";
        $_SESSION['notification_color'] = "red";
    }

    // Redirect with a session message
    header("Location: idcardprocessing.php");
    exit();
}
?>
