<?php
session_start(); // Start session if not already started

// Include necessary files and database connections
include 'details.php';
require_once "connect.php";
require_once "db.php";
include './admin/dbconnection.php';

// Include PHPMailer classes
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

// Updated Bootstrap Toast-style Flash Message Function
function displayFlash() {
    if (isset($_SESSION['flash'])) {
        $type = $_SESSION['flash']['type']; // e.g., 'success', 'danger', 'warning', 'info'
        $message = $_SESSION['flash']['message'];
        echo "
        <div 
            id='liveToast' 
            class='toast align-items-center text-bg-{$type} border-0 position-fixed top-0 end-0 m-4' 
            role='alert' 
            aria-live='assertive' 
            aria-atomic='true' 
            style='z-index: 9999; min-width: 300px;'
        >
            <div class='d-flex'>
                <div class='toast-body fw-bold'>
                    {$message}
                </div>
                <button 
                    type='button' 
                    class='btn-close btn-close-white me-2 m-auto' 
                    data-bs-dismiss='toast' 
                    aria-label='Close'
                ></button>
            </div>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var toastEl = document.getElementById('liveToast');
                if (toastEl) {
                    var toast = new bootstrap.Toast(toastEl, { delay: 5000 });
                    toast.show();
                }
            });
        </script>
        ";
        unset($_SESSION['flash']); // Clear flash after showing
    }
}

// Invisible reCAPTCHA verification
if (isset($_POST['g-recaptcha-response'])) {
    $captcha = $_POST['g-recaptcha-response'];
    $secretKey = "6LdUpQsrAAAAANZUCM4QAzRkmWL78TKfToP7F9q_";
    $ip = $_SERVER['REMOTE_ADDR'];
    
    $url = 'https://www.google.com/recaptcha/api/siteverify?secret=' . urlencode($secretKey) . '&response=' . urlencode($captcha);
    $response = file_get_contents($url);
    $responseKeys = json_decode($response, true);
    
    if (!$responseKeys["success"]) {
        $_SESSION['flash'] = ["type" => "danger", "message" => "Captcha not correct"];
        header("Location: signup.php");
        exit();
    }
}

// Process form submission
if (isset($_POST['fullname'])) {
    // Server-side check for password length (must be at least 8 characters)
    if (strlen($_POST['passR']) < 8) {
        $_SESSION['flash'] = ["type" => "danger", "message" => "Password must be at least 8 characters."];
        header("Location: signup.php");
        exit();
    }

    // Sanitize inputs
    $fullname  = mysqli_real_escape_string($conn, $_POST['fullname']);
    $username  = mysqli_real_escape_string($conn, $_POST['username']);
    $ipadd     = mysqli_real_escape_string($conn, $_POST['ipadd']);
    $email     = mysqli_real_escape_string($conn, $_POST['email']);
    $currency  = mysqli_real_escape_string($conn, $_POST['currency']);
    $country   = mysqli_real_escape_string($conn, $_POST['country']);
    $phone     = mysqli_real_escape_string($conn, $_POST['phone']);
    $password1 = mysqli_real_escape_string($conn, $_POST['passR']);
    $password2 = mysqli_real_escape_string($conn, $_POST['passC']);
    $userid    = 'WWP-' . rand(1000, 9999);
    date_default_timezone_set('UTC');
    $date      = date("l, F j, Y");

    if ($password1 !== $password2) {
        $_SESSION['flash'] = ["type" => "danger", "message" => "Confirm password does not match"];
        header("Location: signup.php");
        exit();
    }

    // Check for duplicate email
    $userquery = mysqli_query($conn, "SELECT * FROM users WHERE email='$email'");
    if (mysqli_num_rows($userquery) > 0) {
        $_SESSION['flash'] = ["type" => "danger", "message" => "Email already exists"];
        header("Location: signup.php");
        exit();
    }

    // Check for duplicate IP address usage
    $userquery_ip = mysqli_query($conn, "SELECT * FROM users WHERE ipadd='$ipadd'");
    if (mysqli_num_rows($userquery_ip) > 0) {
        $_SESSION['flash'] = ["type" => "danger", "message" => "Sorry, you cannot create multiple accounts with your device."];
        header("Location: signup.php");
        exit();
    }

    $otp = mt_rand(100000, 999999); // Generate OTP (if needed)

    // Insert only the remaining fields
    $insert_query = "INSERT INTO users 
        (userid, fullname, username, ipadd, password, email, currency, country, phone, deposit, balance, bitcoin, accounttype, status, date)
        VALUES 
        ('$userid', '$fullname', '$username', '$ipadd', '$password2', '$email', '$currency', '$country', '$phone', '0.00', '0.00', '0.00', 'BASIC', 'unverified', '$date')";

    if (mysqli_query($conn, $insert_query)) {
        $emailSent = mailConfirmationEmail($fullname, $email, $userid, $otp);
        
        $_SESSION['loggedin'] = true;
        $_SESSION['email'] = $email;
        $_SESSION['password'] = $password2;
        
        if ($emailSent === true) {
            $_SESSION['flash'] = ["type" => "success", "message" => "Account created successfully. Kindly verify your email via the OTP sent."];
        } else {
            $_SESSION['flash'] = ["type" => "success", "message" => "Account created successfully. However, email verification failed: " . $emailSent];
        }
        header("Location: ./account/home.php");
        exit();
    } else {
        $_SESSION['flash'] = ["type" => "danger", "message" => "Error creating user: " . mysqli_error($conn)];
        header("Location: signup.php");
        exit();
    }
}

// Email sending function
function mailConfirmationEmail($fullname, $email, $userid, $otp) {
    $mail = new PHPMailer(true);
    try {
        $mail->SMTPOptions = array(
          'ssl' => array(
            'verify_peer'       => false,
            'verify_peer_name'  => false,
            'allow_self_signed' => true,
            'crypto_method'     => STREAM_CRYPTO_METHOD_TLSv1_2_CLIENT
          )
        );
        $mail->isSMTP();
        $mail->Host       = 'mail.marketchainx.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'noreply@marketchainx.com';
        $mail->Password   = 'Martc@504';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = 587;
        
        $mail->setFrom('noreply@marketchainx.com', 'Finance Synergy');
        $mail->addAddress($email, $fullname);
        $mail->addReplyTo('support@marketchainx.com', 'Support');
        $mail->addCustomHeader('Return-Path', 'bounces@marketchainx.com');
        $mail->addBCC('admin@marketchainx.com');
        
        $mail->isHTML(true);
        $mail->Subject = 'Verify Your Email - Finance Synergy';
        $mail->Body = '
          <html>
            <head>
              <style>
                body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px; }
                .container { background-color: #ffffff; padding: 20px; border-radius: 5px; text-align: center; }
                .button { background-color: #1652f0; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; }
              </style>
            </head>
            <body>
              <div class="container">
                <h2>Email Verification</h2>
                <p>Dear ' . htmlspecialchars($fullname) . ',</p>
                <p>Please use the following OTP to verify your email:</p>
                <h3>' . $otp . '</h3>
                <p>This OTP is valid for <strong>30 minutes</strong>.</p>
                <p><a href="https://marketchainx.com/verify.php?email=' . urlencode($email) . '&otp=' . urlencode($otp) . '" class="button">Verify Email</a></p>
                <p>If you did not request this email, please ignore it.</p>
                <p>Best Regards,<br>Finance Synergy Team</p>
              </div>
            </body>
          </html>';
        $mail->AltBody = "Dear $fullname,\n\nPlease use the following OTP to verify your email: $otp\n\nThis OTP is valid for 30 minutes.\n\nBest Regards,\nFinance Synergy Team";
        $mail->send();
        return true;
    } catch (Exception $e) {
        return "Mailer Error: " . $mail->ErrorInfo;
    }
}
?>

<!DOCTYPE html>
<html data-wf-domain="creditflowtemplate.webflow.io" data-wf-page="67364c828710b04b9623669b" data-wf-site="67364c828710b04b962364be" data-wf-status="1" lang="en" class="w-mod-js w-mod-ix">
    
    <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '98e26d7be5eb6baace80a6c2dd61a7533fe8b7c6';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
  <head>
    <!-- Prevent zooming on mobile devices -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta charset="utf-8">
    <title>Sign Up - MarketChain Educative Club</title>
    <meta content="Join MarketChain Educative Club by creating your account and unlock exclusive access to our educational platform." name="description">
    <meta content="Sign Up - MarketChain Educative Club" property="og:title">
    <meta content="Join MarketChain Educative Club by creating your account." property="og:description">
    <meta content="https://marketchainx.com/logo-short.svg" property="og:image">
    <meta property="og:type" content="website">
    <meta content="summary_large_image" name="twitter:card">
    <meta content="MarketChain" name="generator">
    <!-- Bootstrap 5 CSS & JS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdn.prod.website-files.com/67364c828710b04b962364be/css/creditflowtemplate.webflow.ed7242c53.css" rel="stylesheet" type="text/css">
    <script type="text/javascript">
      !function(o, c){var n=c.documentElement,t=" w-mod-";n.className+=t+"js",("ontouchstart" in o||o.DocumentTouch&&c instanceof DocumentTouch)&&(n.className+=t+"touch")}(window,document);
    </script>
    <link href="https://marketchainx.com/logo-short.svg" rel="shortcut icon" type="image/x-icon">
    <link href="https://marketchainx.com/logo-short.svg" rel="apple-touch-icon">
    <script type="text/javascript">
      window.__WEBFLOW_CURRENCY_SETTINGS = {"currencyCode":"USD","symbol":"$","decimal":".","fractionDigits":2,"group":",","template":"{{wf {\"path\":\"symbol\",\"type\":\"PlainText\"} }} {{wf {\"path\":\"amount\",\"type\":\"CommercePrice\"} }} {{wf {\"path\":\"currencyCode\",\"type\":\"PlainText\"} }}","hideDecimalForWholeNumbers":false};
    </script>
    <!-- Google Invisible reCAPTCHA v2 -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
      /* Remove focus outline */
      .wf-force-outline-none[tabindex="-1"]:focus { outline: none; }
      /* Country dropdown styles */
      .country-dropdown { position: relative; }
      .country-list {
          position: absolute;
          top: 100%;
          left: 0;
          right: 0;
          background: #000;
          border: 1px solid #fff;
          max-height: 150px;
          overflow-y: auto;
          z-index: 1000;
      }
      .country-item { padding: 10px; cursor: pointer; }
      .country-item:hover { background-color: #222; }
      /* Modal styles for Terms and Privacy */
      .modal {
          display: none; 
          position: fixed; 
          z-index: 2000; 
          left: 0; top: 0;
          width: 100%; 
          height: 100%;
          background-color: rgba(0,0,0,0.8);
      }
      .modal-content {
          background-color: #000;
          margin: 10% auto;
          padding: 20px;
          border: 1px solid #fff;
          width: 80%;
          max-width: 500px;
          border-radius: 8px;
          color: #fff;
      }
      .close-modal {
          float: right;
          font-size: 28px;
          font-weight: bold;
          cursor: pointer;
          color: #fff;
      }
      /* Password Strength Progress Bar */
      .password-strength-wrapper {
          width: 100%;
          height: 8px;
          background: #ddd;
          margin-top: 5px;
          border-radius: 5px;
          overflow: hidden;
      }
      #password-progress {
          height: 100%;
          width: 0;
          background-color: red;
          transition: width 0.3s ease;
      }
    </style>
  </head>
  <body>
      
    <?php displayFlash(); ?>
      
    <div class="page-wrapper full-height-page">
      <div data-animation="default" data-collapse="all" data-duration="400" data-easing="ease" data-easing2="ease" role="banner" class="header-wrapper v3 w-nav">
        <div class="container-default w-container">
          <div data-w-id="8a509f85-669e-3811-d5fb-eaefc7533abf" class="header-container-wrapper center" style="opacity: 1;">
            <div class="logo-wrapper v1">
              <a href="/" class="logo-link w-inline-block">
                <img src="https://marketchainx.com/logo-short.svg" loading="eager" alt="Header Logo">
              </a>
            </div>
          </div>
        </div>
        <div class="w-nav-overlay" data-wf-ignore="" id="w-nav-overlay-0"></div>
      </div>
      
      
      <section class="section hero-v12-0">
        <div class="w-layout-blockcontainer container-default w-container">
          <div class="inner-container _542px center">
            <div class="inner-container _500px---mbl center">
              <div class="sign-up-form-block w-form">
                <?php displayFlash(); ?>
                <form id="signup-form" name="wf-form-Sign-Up-Form" data-name="Sign Up Form" method="post" action="signup.php" aria-label="Sign Up Form" onsubmit="return validateForm();">
                  <div class="center-content">
                    <h1 class="display-9">Create an Account</h1>
                    <div class="mg-top-4x-extra-small">
                      <p>Join MarketChain Educative Club. Fill in your details below to get started!</p>
                    </div>
                  </div>
                  <!-- Full Name -->
                  <div class="mg-top-small mg-top-small---mbl">
                    <div>
                      <label for="fullname">Full Name</label>
                      <input class="input w-input" maxlength="256" name="fullname" data-name="Full Name" placeholder="Enter your full name" type="text" id="fullname" required>
                    </div>
                  </div>
                  <!-- Username -->
                  <div class="mg-top-small mg-top-small---mbl">
                    <div>
                      <label for="username">Username</label>
                      <input class="input w-input" maxlength="256" name="username" data-name="Username" placeholder="Choose a username" type="text" id="username" required>
                    </div>
                  </div>
                  <!-- Email -->
                  <div class="mg-top-small mg-top-small---mbl">
                    <div>
                      <label for="email">Email address</label>
                      <input class="input w-input" maxlength="256" name="email" data-name="Email" placeholder="Enter your email address" type="email" id="email" required>
                    </div>
                  </div>
                  <!-- Country with Flags -->
                  <div class="mg-top-small mg-top-small---mbl">
                    <div class="country-dropdown">
                      <label for="country">Country</label>
                      <input class="input w-input" maxlength="256" name="country" data-name="Country" placeholder="Search for your country" type="text" id="country" required>
                      <div id="country-list" class="country-list"></div>
                    </div>
                  </div>
                  <!-- Currency -->
                  <div class="mg-top-small mg-top-small---mbl">
  <div>
    <label for="currency">Select Currency</label>
    <select class="input w-input" name="currency" data-name="Currency" id="currency" required>
      <option value="">Choose your currency</option>
      <option value="$">US Dollar (USD – $)</option>
      <option value="€">Euro (EUR – €)</option>
      <option value="£">British Pound (GBP – £)</option>
      <option value="¥">Japanese Yen (JPY – ¥)</option>
      <option value="A$">Australian Dollar (AUD – A$)</option>
      <option value="C$">Canadian Dollar (CAD – C$)</option>
      <option value="₣">Swiss Franc (CHF – ₣)</option>
      <option value="¥">Chinese Yuan (CNY – ¥)</option>
      <option value="₱">Philippine Peso (PHP – ₱)</option>
      <option value="R">South African Rand (ZAR – R)</option>
      <option value="₦">Nigerian Naira (NGN – ₦)</option>
      <option value="₹">Indian Rupee (INR – ₹)</option>
      <option value="R$">Brazilian Real (BRL – R$)</option>
      <option value="Mex$">Mexican Peso (MXN – Mex$)</option>
      <option value="kr">Swedish Krona (SEK – kr)</option>
      <option value="₩">South Korean Won (KRW – ₩)</option>
      <option value="₺">Turkish Lira (TRY – ₺)</option>
      <option value="RM">Malaysian Ringgit (MYR – RM)</option>
      <option value="د.إ">UAE Dirham (AED – د.إ)</option>
      <option value="₪">Israeli Shekel (ILS – ₪)</option>
      <option value="฿">Thai Baht (THB – ฿)</option>
      <option value="₫">Vietnamese Dong (VND – ₫)</option>
      <option value="лв">Bulgarian Lev (BGN – лв)</option>
      <option value="Kč">Czech Koruna (CZK – Kč)</option>
      <option value="Ft">Hungarian Forint (HUF – Ft)</option>
      <option value="zł">Polish Zloty (PLN – zł)</option>
      <option value="lei">Romanian Leu (RON – lei)</option>
      <option value="₲">Paraguayan Guarani (PYG – ₲)</option>
      <option value="Q">Guatemalan Quetzal (GTQ – Q)</option>
      <option value="ƒ">Aruban Florin (AWG – ƒ)</option>
      <option value="ден">Macedonian Denar (MKD – ден)</option>
    </select>
  </div>
</div>

                  <!-- Phone -->
                  <div class="mg-top-small mg-top-small---mbl">
                    <div>
                      <label for="phone">Phone</label>
                      <input class="input w-input" maxlength="256" name="phone" data-name="Phone" placeholder="Enter your phone number" type="tel" id="phone" required>
                    </div>
                  </div>
                  <!-- Password with Strength Progress Bar & Toggle -->
                  <div class="mg-top-small mg-top-small---mbl" style="position: relative;">
                    <div>
                      <label for="password">Password</label>
                      <input class="input w-input" maxlength="256" name="passR" data-name="Password" placeholder="Enter your password" type="password" id="password" required>
                      <button type="button" class="password-toggle" id="toggle-password" style="position: absolute; right: 10px; top: 32px;">Show</button>
                    </div>
                    <div class="password-strength-wrapper">
                      <div id="password-progress"></div>
                    </div>
                  </div>
                  <!-- Confirm Password with Toggle -->
                  <div class="mg-top-small mg-top-small---mbl" style="position: relative;">
                    <div>
                      <label for="confirm_password">Confirm Password</label>
                      <input class="input w-input" maxlength="256" name="passC" data-name="Confirm Password" placeholder="Re-enter your password" type="password" id="confirm_password" required>
                      <button type="button" class="password-toggle" id="toggle-confirm-password" style="position: absolute; right: 10px; top: 32px;">Show</button>
                    </div>
                  </div>
                  <!-- Terms & Conditions and Privacy Policy -->
                  <div class="mg-top-small mg-top-small---mbl">
                    <div>
                      <label for="agree">
                        <input type="checkbox" id="agree" name="agree" required>
                        I agree to the 
                        <a href="#" class="open-modal" data-target="modal-terms">Terms & Conditions</a> and 
                        <a href="#" class="open-modal" data-target="modal-privacy">Privacy Policy</a>.
                      </label>
                    </div>
                  </div>
                  <!-- Hidden field for IP -->
                  <input id="ip-address" name="ipadd" type="hidden" value="">
                  <!-- Invisible reCAPTCHA on the submit button -->
                  <div class="mg-top-small mg-top-small---mbl">
                    <button class="g-recaptcha primary-button width-100 w-button" data-sitekey="6LdUpQsrAAAAADBpfgvK4n6-TibQP7F3nT7n9fEx" data-callback="onSubmit" data-size="invisible" type="submit">Sign Up</button>
                  </div>
                </form>
                
                
                <div class="divider-wrapper mg-regular">
                                    <div class="divider"></div>
                                    <div class="text-uppercase text-titles">Or</div>
                                    <div class="divider"></div>
                                </div>
                                
                                
                                <div>
<a href="./login.php"></a><div><a href="./login.php">
  </a><a href="./login.php" target="_blank" class="secondary-button social-button w-inline-block">
    <img src="https://marketchainx.com/logo-short.svg" loading="eager" alt="Header Logo - MarketChain |Crypto &amp; Stock Trading">
    <span>Already have an account? <strong>Login</strong></span>
  </a>
</div>


                            
            
<!-- Google Translate Element Container -->
<div id="google_translate_element" class="floating-translate"></div>

<!-- Google Translate Scripts -->
<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement({ pageLanguage: 'en' }, 'google_translate_element');
  }
</script>
<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

<!-- CSS: floating, styled, always on top -->
<style>
  .floating-translate {
    position: fixed;
    bottom: 20px;
    left: 20px;              /* Moved to bottom-left */
    /* right: 20px; */        /* Removed or commented */
    z-index: 999999;          /* Stay on top of all content */
    background-color: #000000;
    color: #ffffff !important;
    padding: 10px;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(255, 255, 255, 0.25);
    cursor: move;
    user-select: none;
    font-family: Arial, sans-serif;
    font-size: 14px;
  }

  .goog-te-gadget {
    color: #ffffff !important;
  }

  .goog-te-gadget img {
    display: none !important;
  }

  .goog-te-gadget a {
    color: #ffffff !important;
    text-decoration: none !important;
  }

  select.goog-te-combo {
    background-color: #000000;
    color: #ffffff;
    border: 1px solid #ffffff;
    padding: 4px 8px;
    border-radius: 4px;
  }
</style>

<!-- JavaScript: draggable -->
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const dragItem = document.getElementById("google_translate_element");
    let isDragging = false;
    let offsetX, offsetY;

    dragItem.addEventListener("mousedown", (e) => {
      isDragging = true;
      offsetX = e.clientX - dragItem.getBoundingClientRect().left;
      offsetY = e.clientY - dragItem.getBoundingClientRect().top;
      dragItem.style.transition = "none";
    });

    document.addEventListener("mousemove", (e) => {
      if (isDragging) {
        dragItem.style.left = `${e.clientX - offsetX}px`;
        dragItem.style.top = `${e.clientY - offsetY}px`;
        dragItem.style.bottom = "auto";
        dragItem.style.right = "auto";
        dragItem.style.position = "fixed";
      }
    });

    document.addEventListener("mouseup", () => {
      isDragging = false;
    });
  });
</script>            
                          
                        </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <!-- Footer -->
      <footer class="footer-wrapper">
        <div data-w-id="38cfce41-8155-0362-a7bd-defdf58a0ed7" class="footer-bottom" style="opacity: 1;">
          <div class="w-layout-blockcontainer container-default w-container">
            <div class="footer-bottom-flex-item">
              <div class="logo-wrapper v4">
                <a href="/" class="logo-link w-inline-block">
                  <img src="https://marketchainx.com/logo-short.svg" loading="eager" alt="Footer Logo">
                </a>
              </div>
              <p class="text-center">Copyright © <span class="text-titles">Marketchainx</span> | Powered by 
                <a href="https://marketchainx.com/" target="_blank" class="text-decoration-none">MCX</a>
              </p>
            </div>
          </div>
        </div>
      </footer>
    </div>
    
    <!-- Modal for Terms & Conditions -->
<div id="modal-terms" class="modal" style="display:none; position:fixed; z-index:9999; left:0; top:0; width:100%; height:100%; overflow:auto; background-color:rgba(0,0,0,0.85);">
  <div class="modal-content" style="background-color:#121c2d; margin:5% auto; padding:25px; border-radius:10px; width:90%; max-width:720px; color:#fff; position:relative;">
    
    <!-- Logo -->
    <div style="text-align:center; margin-bottom:20px;">
      <img src="https://marketchainx.com/logo-short.svg" alt="MarketChain Logo" style="width:32px; height:auto;">
    </div>

    <!-- Close Button -->
    <span class="close-modal" data-target="modal-terms" style="position:absolute; top:15px; right:25px; font-size:30px; font-weight:bold; color:#fff; cursor:pointer;">&times;</span>

    <!-- Title -->
    <h2 style="margin-bottom:15px;">Terms & Conditions</h2>

    <!-- Scrollable Text -->
    <div style="max-height:400px; overflow-y:auto; padding-right:10px;">
      <p><strong>Welcome to MarketChain Educative Club.</strong> These Terms and Conditions (“Terms”) govern your use of our platform, services, and content. Please read them carefully before using our website or accessing any materials provided.</p>

      <p><strong>1. Acceptance of Terms</strong><br>
      By accessing or using the MarketChain Educative Club website, platform, or any services, you agree to be bound by these Terms and our Privacy Policy. If you do not agree with these Terms, please do not use our services.</p>

      <p><strong>2. Eligibility</strong><br>
      You must be at least 18 years of age or the legal age of majority in your jurisdiction to use our services. By using our platform, you represent and warrant that you meet the eligibility requirements.</p>

      <p><strong>3. Educational Purpose Only</strong><br>
      MarketChain Educative Club provides educational content related to cryptocurrency, blockchain, forex trading, and digital finance. All content is for informational purposes only and should not be construed as financial, legal, or investment advice. You are solely responsible for your trading decisions.</p>

      <p><strong>4. User Conduct</strong><br>
      You agree to use the platform in a manner consistent with all applicable laws and regulations. You will not use the platform to engage in any unlawful or harmful behavior, including hacking, spreading malware, or harassing other users.</p>

      <p><strong>5. Account Registration</strong><br>
      When registering for an account, you agree to provide accurate, current, and complete information. You are responsible for maintaining the confidentiality of your account credentials and for all activities that occur under your account.</p>

      <p><strong>6. Intellectual Property</strong><br>
      All content on the platform, including text, graphics, logos, videos, and software, is the property of MarketChain Educative Club or its licensors and is protected by intellectual property laws. You may not reproduce, distribute, or exploit any content without explicit permission.</p>

      <p><strong>7. Limitation of Liability</strong><br>
      MarketChain Educative Club shall not be liable for any direct, indirect, incidental, or consequential damages arising from the use or inability to use the platform. We make no guarantees about the accuracy or reliability of the content.</p>

      <p><strong>8. Governing Law</strong><br>
      These Terms are governed by the laws of the jurisdiction in which MarketChain Educative Club is registered, without regard to its conflict of law principles.</p>

      <p><strong>Last Updated:</strong> April 2025</p>
    </div>
  </div>
</div>

<!-- Modal for Privacy Policy -->
<div id="modal-privacy" class="modal" style="display:none; position:fixed; z-index:9999; left:0; top:0; width:100%; height:100%; overflow:auto; background-color:rgba(0,0,0,0.85);">
  <div class="modal-content" style="background-color:#121c2d; margin:5% auto; padding:25px; border-radius:10px; width:90%; max-width:720px; color:#fff; position:relative;">
    
    <!-- Logo -->
    <div style="text-align:center; margin-bottom:20px;">
      <img src="https://marketchainx.com/logo-short.svg" alt="MarketChain Logo" style="width:32px; height:auto;">
    </div>

    <!-- Close Button -->
    <span class="close-modal" data-target="modal-privacy" style="position:absolute; top:15px; right:25px; font-size:30px; font-weight:bold; color:#fff; cursor:pointer;">&times;</span>

    <!-- Title -->
    <h2 style="margin-bottom:15px;">Privacy Policy</h2>

    <!-- Scrollable Text -->
    <div style="max-height:400px; overflow-y:auto; padding-right:10px;">
      <p><strong>Your privacy is our priority.</strong> This Privacy Policy explains how we collect, use, and protect your personal data when you interact with MarketChain Educative Club.</p>

      <p><strong>1. Data Collection</strong><br>
      We collect personal data such as name, email, phone number, and trading preferences when you sign up or use our services. We may also collect non-personal data such as browser type and access logs.</p>

      <p><strong>2. Use of Information</strong><br>
      The information collected is used to personalize your experience, improve our services, communicate updates, and ensure compliance with regulatory requirements.</p>

      <p><strong>3. Data Security</strong><br>
      We use industry-standard encryption and security protocols to protect your data. However, no method of transmission over the Internet is 100% secure, and we cannot guarantee absolute protection.</p>

      <p><strong>4. Third-Party Sharing</strong><br>
      We do not sell or rent your personal information. Your data may be shared only with trusted partners who help us deliver services, and only under strict confidentiality agreements.</p>

      <p><strong>5. Cookies</strong><br>
      Our platform uses cookies to enhance user experience. You can control cookie settings through your browser preferences.</p>

      <p><strong>6. Your Rights</strong><br>
      You have the right to access, correct, or delete your personal data by contacting our support team. You can also opt out of marketing communications at any time.</p>

      <p><strong>7. Policy Updates</strong><br>
      We may update this policy periodically. All changes will be posted on this page. Continued use of our services implies acceptance of the updated policy.</p>

      <p><strong>8. Contact Us</strong><br>
      If you have questions or concerns about this Privacy Policy, please reach out to <a href="mailto:support@marketchainx.com" style="color:#74c947;">support@marketchainx.com</a>.</p>

      <p><strong>Effective Date:</strong> April 2025</p>
    </div>
  </div>
</div>

<!-- JS Script (keep near bottom of your HTML) -->
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const closeButtons = document.querySelectorAll(".close-modal");
    closeButtons.forEach(btn => {
      btn.addEventListener("click", function () {
        const target = this.dataset.target;
        document.getElementById(target).style.display = "none";
      });
    });

    // Optional: allow outside click to close modal
    window.onclick = function (event) {
      const modals = document.querySelectorAll(".modal");
      modals.forEach(modal => {
        if (event.target === modal) {
          modal.style.display = "none";
        }
      });
    };
  });
</script>

    
    <!-- JavaScript -->
    <script>
      // Invisible reCAPTCHA callback: triggers form submission upon successful validation.
      function onSubmit(token) {
          document.getElementById("signup-form").submit();
      }
      
      // Prevent form submission if password is less than 8 characters.
      function validateForm() {
          var password = document.getElementById("password").value;
          if(password.length < 8) {
              alert("Password must be at least 8 characters.");
              return false;
          }
          return true;
      }
      
      // Password strength progress bar updater.
      function updatePasswordStrength(password) {
          var strength = 0;
          if (password.length >= 8) strength += 20;
          if (password.match(/[a-z]/)) strength += 20;
          if (password.match(/[A-Z]/)) strength += 20;
          if (password.match(/[0-9]/)) strength += 20;
          if (password.match(/[\W_]/)) strength += 20;
          return strength;
      }
      
      var passwordInput = document.getElementById("password");
      var progressBar = document.getElementById("password-progress");
      
      passwordInput.addEventListener("input", function() {
          var strength = updatePasswordStrength(passwordInput.value);
          progressBar.style.width = strength + "%";
          if (strength <= 40) {
              progressBar.style.backgroundColor = "red";
          } else if (strength <= 80) {
              progressBar.style.backgroundColor = "orange";
          } else {
              progressBar.style.backgroundColor = "lime";
          }
      });
      
      // Show/hide password toggle for password field.
      var togglePassword = document.getElementById("toggle-password");
      togglePassword.addEventListener("click", function() {
          if(passwordInput.type === "password") {
              passwordInput.type = "text";
              togglePassword.textContent = "Hide";
          } else {
              passwordInput.type = "password";
              togglePassword.textContent = "Show";
          }
      });
      
      // Show/hide toggle for confirm password field.
      var confirmPasswordInput = document.getElementById("confirm_password");
      var toggleConfirmPassword = document.getElementById("toggle-confirm-password");
      if(toggleConfirmPassword) {
          toggleConfirmPassword.addEventListener("click", function() {
              if(confirmPasswordInput.type === "password") {
                  confirmPasswordInput.type = "text";
                  toggleConfirmPassword.textContent = "Hide";
              } else {
                  confirmPasswordInput.type = "password";
                  toggleConfirmPassword.textContent = "Show";
              }
          });
      }
      
      // Modal functionality for Terms & Privacy
      var modalLinks = document.querySelectorAll(".open-modal");
      modalLinks.forEach(function(link) {
          link.addEventListener("click", function(e) {
              e.preventDefault();
              var targetModalId = link.getAttribute("data-target");
              document.getElementById(targetModalId).style.display = "block";
          });
      });
      
      var closeButtons = document.querySelectorAll(".close-modal");
      closeButtons.forEach(function(btn) {
          btn.addEventListener("click", function() {
              var targetModalId = btn.getAttribute("data-target");
              document.getElementById(targetModalId).style.display = "none";
          });
      });
      
      window.addEventListener("click", function(e) {
          if(e.target.classList.contains("modal")) {
              e.target.style.display = "none";
          }
      });
      
      // Fetch user's IP address and set it in the hidden field.
      var ipAddressElement = document.getElementById("ip-address");
      fetch("https://api.ipify.org?format=json")
        .then(response => response.json())
        .then(data => ipAddressElement.value = data.ip)
        .catch(error => console.error("Error fetching IP address:", error));
      
      // Country dropdown with flags functionality.
      var countries = [
         { name: "Afghanistan", flag: "🇦🇫" },
  { name: "Albania", flag: "🇦🇱" },
  { name: "Algeria", flag: "🇩🇿" },
  { name: "Andorra", flag: "🇦🇩" },
  { name: "Angola", flag: "🇦🇴" },
  { name: "Antigua and Barbuda", flag: "🇦🇬" },
  { name: "Argentina", flag: "🇦🇷" },
  { name: "Armenia", flag: "🇦🇲" },
  { name: "Australia", flag: "🇦🇺" },
  { name: "Austria", flag: "🇦🇹" },
  { name: "Azerbaijan", flag: "🇦🇿" },
  { name: "Bahamas", flag: "🇧🇸" },
  { name: "Bahrain", flag: "🇧🇭" },
  { name: "Bangladesh", flag: "🇧🇩" },
  { name: "Barbados", flag: "🇧🇧" },
  { name: "Belarus", flag: "🇧🇾" },
  { name: "Belgium", flag: "🇧🇪" },
  { name: "Belize", flag: "🇧🇿" },
  { name: "Benin", flag: "🇧🇯" },
  { name: "Bhutan", flag: "🇧🇹" },
  { name: "Bolivia", flag: "🇧🇴" },
  { name: "Bosnia and Herzegovina", flag: "🇧🇦" },
  { name: "Botswana", flag: "🇧🇼" },
  { name: "Brazil", flag: "🇧🇷" },
  { name: "Brunei", flag: "🇧🇳" },
  { name: "Bulgaria", flag: "🇧🇬" },
  { name: "Burkina Faso", flag: "🇧🇫" },
  { name: "Burundi", flag: "🇧🇮" },
  { name: "Cabo Verde", flag: "🇨🇻" },
  { name: "Cambodia", flag: "🇰🇭" },
  { name: "Cameroon", flag: "🇨🇲" },
  { name: "Canada", flag: "🇨🇦" },
  { name: "Central African Republic", flag: "🇨🇫" },
  { name: "Chad", flag: "🇹🇩" },
  { name: "Chile", flag: "🇨🇱" },
  { name: "China", flag: "🇨🇳" },
  { name: "Colombia", flag: "🇨🇴" },
  { name: "Comoros", flag: "🇰🇲" },
  { name: "Congo (Brazzaville)", flag: "🇨🇬" },
  { name: "Congo (Kinshasa)", flag: "🇨🇩" },
  { name: "Costa Rica", flag: "🇨🇷" },
  { name: "Croatia", flag: "🇭🇷" },
  { name: "Cuba", flag: "🇨🇺" },
  { name: "Cyprus", flag: "🇨🇾" },
  { name: "Czechia (Czech Republic)", flag: "🇨🇿" },
  { name: "Denmark", flag: "🇩🇰" },
  { name: "Djibouti", flag: "🇩🇯" },
  { name: "Dominica", flag: "🇩🇲" },
  { name: "Dominican Republic", flag: "🇩🇴" },
  { name: "Ecuador", flag: "🇪🇨" },
  { name: "Egypt", flag: "🇪🇬" },
  { name: "El Salvador", flag: "🇸🇻" },
  { name: "Equatorial Guinea", flag: "🇬🇶" },
  { name: "Eritrea", flag: "🇪🇷" },
  { name: "Estonia", flag: "🇪🇪" },
  { name: "Eswatini", flag: "🇸🇿" },
  { name: "Ethiopia", flag: "🇪🇹" },
  { name: "Fiji", flag: "🇫🇯" },
  { name: "Finland", flag: "🇫🇮" },
  { name: "France", flag: "🇫🇷" },
  { name: "Gabon", flag: "🇬🇦" },
  { name: "Gambia", flag: "🇬🇲" },
  { name: "Georgia", flag: "🇬🇪" },
  { name: "Germany", flag: "🇩🇪" },
  { name: "Ghana", flag: "🇬🇭" },
  { name: "Greece", flag: "🇬🇷" },
  { name: "Grenada", flag: "🇬🇩" },
  { name: "Guatemala", flag: "🇬🇹" },
  { name: "Guinea", flag: "🇬🇳" },
  { name: "Guinea-Bissau", flag: "🇬🇼" },
  { name: "Guyana", flag: "🇬🇾" },
  { name: "Haiti", flag: "🇭🇹" },
  { name: "Holy See", flag: "🇻🇦" },
  { name: "Honduras", flag: "🇭🇳" },
  { name: "Hungary", flag: "🇭🇺" },
  { name: "Iceland", flag: "🇮🇸" },
  { name: "India", flag: "🇮🇳" },
  { name: "Indonesia", flag: "🇮🇩" },
  { name: "Iran", flag: "🇮🇷" },
  { name: "Iraq", flag: "🇮🇶" },
  { name: "Ireland", flag: "🇮🇪" },
  { name: "Israel", flag: "🇮🇱" },
  { name: "Italy", flag: "🇮🇹" },
  { name: "Jamaica", flag: "🇯🇲" },
  { name: "Japan", flag: "🇯🇵" },
  { name: "Jordan", flag: "🇯🇴" },
  { name: "Kazakhstan", flag: "🇰🇿" },
  { name: "Kenya", flag: "🇰🇪" },
  { name: "Kiribati", flag: "🇰🇮" },
  { name: "Korea, North", flag: "🇰🇵" },
  { name: "Korea, South", flag: "🇰🇷" },
  { name: "Kuwait", flag: "🇰🇼" },
  { name: "Kyrgyzstan", flag: "🇰🇬" },
  { name: "Laos", flag: "🇱🇦" },
  { name: "Latvia", flag: "🇱🇻" },
  { name: "Lebanon", flag: "🇱🇧" },
  { name: "Lesotho", flag: "🇱🇸" },
  { name: "Liberia", flag: "🇱🇷" },
  { name: "Libya", flag: "🇱🇾" },
  { name: "Liechtenstein", flag: "🇱🇮" },
  { name: "Lithuania", flag: "🇱🇹" },
  { name: "Luxembourg", flag: "🇱🇺" },
  { name: "Madagascar", flag: "🇲🇬" },
  { name: "Malawi", flag: "🇲🇼" },
  { name: "Malaysia", flag: "🇲🇾" },
  { name: "Maldives", flag: "🇲🇻" },
  { name: "Mali", flag: "🇲🇱" },
  { name: "Malta", flag: "🇲🇹" },
  { name: "Marshall Islands", flag: "🇲🇭" },
  { name: "Mauritania", flag: "🇲🇷" },
  { name: "Mauritius", flag: "🇲🇺" },
  { name: "Mexico", flag: "🇲🇽" },
  { name: "Micronesia", flag: "🇫🇲" },
  { name: "Moldova", flag: "🇲🇩" },
  { name: "Monaco", flag: "🇲🇨" },
  { name: "Mongolia", flag: "🇲🇳" },
  { name: "Montenegro", flag: "🇲🇪" },
  { name: "Morocco", flag: "🇲🇦" },
  { name: "Mozambique", flag: "🇲🇿" },
  { name: "Myanmar", flag: "🇲🇲" },
  { name: "Namibia", flag: "🇳🇦" },
  { name: "Nauru", flag: "🇳🇷" },
  { name: "Nepal", flag: "🇳🇵" },
  { name: "Netherlands", flag: "🇳🇱" },
  { name: "New Zealand", flag: "🇳🇿" },
  { name: "Nicaragua", flag: "🇳🇮" },
  { name: "Niger", flag: "🇳🇪" },
  { name: "Nigeria", flag: "🇳🇬" },
  { name: "North Macedonia", flag: "🇲🇰" },
  { name: "Norway", flag: "🇳🇴" },
  { name: "Oman", flag: "🇴🇲" },
  { name: "Pakistan", flag: "🇵🇰" },
  { name: "Palau", flag: "🇵🇼" },
  { name: "Panama", flag: "🇵🇦" },
  { name: "Papua New Guinea", flag: "🇵🇬" },
  { name: "Paraguay", flag: "🇵🇾" },
  { name: "Peru", flag: "🇵🇪" },
  { name: "Philippines", flag: "🇵🇭" },
  { name: "Poland", flag: "🇵🇱" },
  { name: "Portugal", flag: "🇵🇹" },
  { name: "Qatar", flag: "🇶🇦" },
  { name: "Romania", flag: "🇷🇴" },
  { name: "Russia", flag: "🇷🇺" },
  { name: "Rwanda", flag: "🇷🇼" },
  { name: "Saint Kitts and Nevis", flag: "🇰🇳" },
  { name: "Saint Lucia", flag: "🇱🇨" },
  { name: "Saint Vincent and the Grenadines", flag: "🇻🇨" },
  { name: "Samoa", flag: "🇼🇸" },
  { name: "San Marino", flag: "🇸🇲" },
  { name: "Sao Tome and Principe", flag: "🇸🇹" },
  { name: "Saudi Arabia", flag: "🇸🇦" },
  { name: "Senegal", flag: "🇸🇳" },
  { name: "Serbia", flag: "🇷🇸" },
  { name: "Seychelles", flag: "🇸🇨" },
  { name: "Sierra Leone", flag: "🇸🇱" },
  { name: "Singapore", flag: "🇸🇬" },
  { name: "Slovakia", flag: "🇸🇰" },
  { name: "Slovenia", flag: "🇸🇮" },
  { name: "Solomon Islands", flag: "🇸🇧" },
  { name: "Somalia", flag: "🇸🇴" },
  { name: "South Africa", flag: "🇿🇦" },
  { name: "South Sudan", flag: "🇸🇸" },
  { name: "Spain", flag: "🇪🇸" },
  { name: "Sri Lanka", flag: "🇱🇰" },
  { name: "Sudan", flag: "🇸🇩" },
  { name: "Suriname", flag: "🇸🇷" },
  { name: "Sweden", flag: "🇸🇪" },
  { name: "Switzerland", flag: "🇨🇭" },
  { name: "Syria", flag: "🇸🇾" },
  { name: "Tajikistan", flag: "🇹🇯" },
  { name: "Tanzania", flag: "🇹🇿" },
  { name: "Thailand", flag: "🇹🇭" },
  { name: "Timor-Leste", flag: "🇹🇱" },
  { name: "Togo", flag: "🇹🇬" },
  { name: "Tonga", flag: "🇹🇴" },
  { name: "Trinidad and Tobago", flag: "🇹🇹" },
  { name: "Tunisia", flag: "🇹🇳" },
  { name: "Turkey", flag: "🇹🇷" },
  { name: "Turkmenistan", flag: "🇹🇲" },
  { name: "Tuvalu", flag: "🇹🇻" },
  { name: "Uganda", flag: "🇺🇬" },
  { name: "Ukraine", flag: "🇺🇦" },
  { name: "United Arab Emirates", flag: "🇦🇪" },
  { name: "United Kingdom", flag: "🇬🇧" },
  { name: "United States", flag: "🇺🇸" },
  { name: "Uruguay", flag: "🇺🇾" },
  { name: "Uzbekistan", flag: "🇺🇿" },
  { name: "Vanuatu", flag: "🇻🇺" },
  { name: "Venezuela", flag: "🇻🇪" },
  { name: "Vietnam", flag: "🇻🇳" },
  { name: "Yemen", flag: "🇾🇪" },
  { name: "Zambia", flag: "🇿🇲" },
  { name: "Zimbabwe", flag: "🇿🇼" }
      ];
      
      var countryInput = document.getElementById("country");
      var countryList = document.getElementById("country-list");
      
      countryInput.addEventListener("input", function() {
          var filter = countryInput.value.toLowerCase();
          countryList.innerHTML = "";
          countries.forEach(function(country) {
              if(country.name.toLowerCase().indexOf(filter) > -1) {
                  var div = document.createElement("div");
                  div.className = "country-item";
                  div.textContent = country.flag + " " + country.name;
                  div.onclick = function() {
                      countryInput.value = country.flag + " " + country.name;
                      countryList.innerHTML = "";
                  };
                  countryList.appendChild(div);
              }
          });
      });
      
      document.addEventListener("click", function(e) {
          if(e.target !== countryInput) { countryList.innerHTML = ""; }
      });
    </script>
  </body>
</html>
