<?php
session_start();
include 'dbconnection.php';
include("checklogin.php");
check_login();

$msg = "";         // Toast message to be shown
$success = true;   // Flag for successful processing

if(isset($_POST['Submit'])) {
    // Sanitize and validate input data
    $newDepositAmount = isset($_POST['deposit']) ? floatval($_POST['deposit']) : 0;
    $userId           = isset($_POST['userid']) ? intval($_POST['userid']) : 0;
    $email            = isset($_POST['email']) ? mysqli_real_escape_string($con, $_POST['email']) : '';
    $profit           = isset($_POST['profit']) ? floatval($_POST['profit']) : 0;
    $status           = isset($_POST['status']) ? mysqli_real_escape_string($con, $_POST['status']) : '';
    $percentage       = isset($_POST['percentage']) ? mysqli_real_escape_string($con, $_POST['percentage']) : '';
    $description      = isset($_POST['description']) ? mysqli_real_escape_string($con, $_POST['description']) : '';
    
    // Set current date
    $date = date('Y-m-d');

    // Get uid from GET parameter
    $uid = isset($_GET['uid']) ? intval($_GET['uid']) : 0;
    if($uid <= 0) {
        $msg = "Invalid user id.";
        $success = false;
    }
    
    if($success) {
        // Update users table: add the new deposit to the existing deposit.
        $updateStmt = $con->prepare("UPDATE `users` SET `deposit` = `deposit` + ? WHERE `id` = ?");
        $updateStmt->bind_param("di", $newDepositAmount, $uid);
        if(!$updateStmt->execute()){
            $msg = "Error updating deposit.";
            $success = false;
        }
        $updateStmt->close();
    }
    
    if($success) {
        // Retrieve the updated deposit.
        $selectStmt = $con->prepare("SELECT `deposit` FROM `users` WHERE `id` = ?");
        $selectStmt->bind_param("i", $uid);
        $selectStmt->execute();
        // Instead of get_result(), use bind_result and fetch.
        $selectStmt->bind_result($deposit);
        if($selectStmt->fetch()){
            $newTotalDeposit = floatval($deposit);
        } else {
            $msg = "User not found.";
            $success = false;
        }
        $selectStmt->close();
    }
    
    if($success) {
        // Generate a unique transaction id.
        $transid = uniqid('TRX');
        $withdraw = '-'; // Placeholder
        
        // Insert into transaction table.
        $transStmt = $con->prepare("INSERT INTO `transaction` (`transdate`, `transid`, `email`, `deposit`, `profit`, `withdraw`, `balance`, `description`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $transStmt->bind_param("sssddsds", $date, $transid, $email, $newDepositAmount, $profit, $withdraw, $newTotalDeposit, $description);
        if(!$transStmt->execute()){
            $msg = "Error inserting into transaction.";
            $success = false;
        }
        $transStmt->close();
    }
    
    if($success) {
        // Insert into user_trans table.
        $transtype = "deposit";
        $credit = $newDepositAmount;
        $debit = 0;
        $amount = $newDepositAmount;
        $userTransStmt = $con->prepare("INSERT INTO `user_trans` (`transid`, `account`, `date`, `description`, `balance`, `transtype`, `status`, `credit`, `debit`, `amount`, `email`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $userTransStmt->bind_param("ssssdssddds", $transid, $email, $date, $description, $newTotalDeposit, $transtype, $status, $credit, $debit, $amount, $email);
        if(!$userTransStmt->execute()){
            $msg = "Error inserting into user_trans.";
            $success = false;
        }
        $userTransStmt->close();
    }
    
    if($success) {
        $msg = "Client Deposit Added successfully";
    }
}
?>
<!DOCTYPE html>
<html lang="en" x-data="{ sidebarOpen: false }">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin Deposit Update</title>
  <link rel="shortcut icon" type="image/png" href="assetss/images/logos/favicon.png">
  <!-- Tailwind CSS CDN -->
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  <!-- Boxicons CDN -->
  <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
  <!-- Alpine.js for interactivity -->
  <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.12.0/dist/cdn.min.js" defer></script>
  <style>
    #toast {
      transition: opacity 0.5s ease;
    }
  </style>
</head>
<body class="bg-gray-100">
  <!-- Toast Alert -->
  <?php if(!empty($msg)): ?>
    <div id="toast" class="fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded shadow-lg z-50">
      <?php echo $msg; ?>
    </div>
  <?php endif; ?>

  <div class="flex min-h-screen">
    <!-- Desktop Sidebar (for larger screens) -->
    <aside class="hidden md:block md:w-64 bg-white shadow-md">
      <div class="p-6">
        <a href="index.php" class="block mb-8">
          <img src="assetss/images/logos/dark-logo.svg" alt="Logo" class="w-48">
        </a>
        <nav>
          <ul class="space-y-4">
            <!-- Reordered nav items for desktop with active highlighting -->
            <li>
              <a href="manage-users.php" class="flex items-center <?php echo ($activePage=='manage-users.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-user text-2xl mr-3"></i> Manage Users
              </a>
            </li>
            <li>
              <a href="manage-deposit.php" class="flex items-center <?php echo ($activePage=='manage-deposit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-plus-circle text-2xl mr-3"></i> Add Deposit
              </a>
            </li>
            <li>
              <a href="deposit_mark.php" class="flex items-center <?php echo ($activePage=='deposit_mark.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-wallet-alt text-2xl mr-3"></i> View Deposit
              </a>
            </li>
            <li>
              <a href="manage-transaction.php" class="flex items-center <?php echo ($activePage=='manage-transaction.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-credit-card text-2xl mr-3"></i> View Transaction
              </a>
            </li>
            <li>
              <a href="manage-wallet.php" class="flex items-center <?php echo ($activePage=='manage-wallet.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-upload text-2xl mr-3"></i> Wallet Upload
              </a>
            </li>
            <li>
              <a href="manage-profit.php" class="flex items-center <?php echo ($activePage=='manage-profit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-dollar text-2xl mr-3"></i> Add Profit
              </a>
            </li>
            <li>
              <a href="manage-withdraw.php" class="flex items-center <?php echo ($activePage=='manage-withdraw.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-bank text-2xl mr-3"></i> View Withdrawal
              </a>
            </li>
            <li>
              <a href="manage-traders.php" class="flex items-center <?php echo ($activePage=='manage-traders.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-group text-2xl mr-3"></i> Manage Traders
              </a>
            </li>
            <li>
              <a href="manage-upgrade.php" class="flex items-center <?php echo ($activePage=='manage-upgrade.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-trending-up text-2xl mr-3"></i> Upgrade Client Account
              </a>
            </li>
            <li>
              <a href="manage-id.php" class="flex items-center <?php echo ($activePage=='manage-id.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-id-card text-2xl mr-3"></i> KYC
              </a>
            </li>
            <li>
              <a href="manage-limit.php" class="flex items-center <?php echo ($activePage=='manage-limit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-slider-alt text-2xl mr-3"></i> Withdrawal Limits
              </a>
            </li>
            <li>
              <a href="livechatupdate.php" class="flex items-center <?php echo ($activePage=='livechatupdate.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-chat text-2xl mr-3"></i> Livechat Update
              </a>
            </li>
            <li>
              <a href="change-password.php" class="flex items-center <?php echo ($activePage=='change-password.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-key text-2xl mr-3"></i> Change Password/MTC Code
              </a>
            </li>
            <li>
              <a href="support.php" class="flex items-center <?php echo ($activePage=='support.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-envelope text-2xl mr-3"></i> Send Email
              </a>
            </li>
            <li>
              <a href="logout.php" class="flex items-center <?php echo ($activePage=='logout.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-log-out text-2xl mr-3"></i> Logout
              </a>
            </li>
          </ul>
        </nav>
      </div>
    </aside>
    
    <!-- Mobile Sidebar (optional, if you want one on mobile as well) -->
    <aside class="md:hidden" x-show="sidebarOpen" x-transition>
      <div class="fixed inset-0 z-40 flex">
        <div x-show="sidebarOpen" x-transition.opacity class="fixed inset-0 bg-black bg-opacity-25" @click="sidebarOpen = false"></div>
        <div x-show="sidebarOpen" x-transition class="relative flex-1 flex flex-col max-w-xs w-full bg-white">
          <div class="absolute top-0 right-0 -mr-12 pt-2">
            <button @click="sidebarOpen = false" class="ml-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:bg-gray-600">
              <span class="sr-only">Close sidebar</span>
              <i class="bx bx-x text-2xl text-white"></i>
            </button>
          </div>
          <div class="p-6">
            <a href="index.php" class="block mb-8">
              <img src="assetss/images/logos/dark-logo.svg" alt="Logo" class="w-40">
            </a>
            <nav>
              <ul class="space-y-4">
                <!-- Mobile nav items, reordered by importance -->
                <li>
                  <a href="manage-users.php" class="flex items-center <?php echo ($activePage=='manage-users.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-user text-xl mr-2"></i> Manage Users
                  </a>
                </li>
                <li>
                  <a href="manage-deposit.php" class="flex items-center <?php echo ($activePage=='manage-deposit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-plus-circle text-xl mr-2"></i> Add Deposit
                  </a>
                </li>
                <li>
                  <a href="deposit_mark.php" class="flex items-center <?php echo ($activePage=='deposit_mark.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-wallet-alt text-xl mr-2"></i> View Deposit
                  </a>
                </li>
                <li>
                  <a href="manage-transaction.php" class="flex items-center <?php echo ($activePage=='manage-transaction.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-credit-card text-xl mr-2"></i> View Transaction
                  </a>
                </li>
                <li>
                  <a href="manage-wallet.php" class="flex items-center <?php echo ($activePage=='manage-wallet.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-upload text-xl mr-2"></i> Wallet Upload
                  </a>
                </li>
                <li>
                  <a href="manage-profit.php" class="flex items-center <?php echo ($activePage=='manage-profit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-dollar text-xl mr-2"></i> Add Profit
                  </a>
                </li>
                <li>
                  <a href="manage-withdraw.php" class="flex items-center <?php echo ($activePage=='manage-withdraw.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-bank text-xl mr-2"></i> View Withdrawal
                  </a>
                </li>
                <li>
                  <a href="manage-traders.php" class="flex items-center <?php echo ($activePage=='manage-traders.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-group text-xl mr-2"></i> Manage Traders
                  </a>
                </li>
                <li>
                  <a href="manage-upgrade.php" class="flex items-center <?php echo ($activePage=='manage-upgrade.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-trending-up text-xl mr-2"></i> Upgrade Client Account
                  </a>
                </li>
                <li>
                  <a href="manage-id.php" class="flex items-center <?php echo ($activePage=='manage-id.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-id-card text-xl mr-2"></i> KYC
                  </a>
                </li>
                <li>
                  <a href="manage-limit.php" class="flex items-center <?php echo ($activePage=='manage-limit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-slider-alt text-xl mr-2"></i> Withdrawal Limits
                  </a>
                </li>
                <li>
                  <a href="livechatupdate.php" class="flex items-center <?php echo ($activePage=='livechatupdate.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-chat text-xl mr-2"></i> Livechat Update
                  </a>
                </li>
                <li>
                  <a href="change-password.php" class="flex items-center <?php echo ($activePage=='change-password.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-key text-xl mr-2"></i> Change Password/MTC Code
                  </a>
                </li>
                <li>
                  <a href="logout.php" class="flex items-center <?php echo ($activePage=='logout.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                    <i class="bx bx-log-out text-xl mr-2"></i> Logout
                  </a>
                </li>
              </ul>
            </nav>
          </div>
        </div>
      </aside>
    
    <!-- Main Content Area -->
    <div class="flex-1 flex flex-col">
      <!-- Header (Left aligned) -->
      <header class="bg-white shadow-md w-full">
        <div class="flex items-center px-4 py-4">
          <button @click="sidebarOpen = true" class="md:hidden text-gray-500 hover:text-gray-700 focus:outline-none mr-4">
            <i class='bx bx-menu text-3xl'></i>
          </button>
          <h1 class="text-2xl font-bold text-gray-800">Manage Deposit</h1>
        </div>
      </header>

      <main class="flex-1 p-6 overflow-y-auto">
        <!-- Action Link -->
        <div class="mb-4">
          <a href="connwall.php" class="inline-block bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">View Connected Wallets</a>
        </div>
        <!-- Deposit Update Form -->
        <div class="bg-white shadow-lg rounded-lg p-8">
          <?php 
            // Retrieve user details using uid from GET parameter.
            $uid = isset($_GET['uid']) ? intval($_GET['uid']) : 0;
            $ret = mysqli_query($con, "SELECT * FROM `users` WHERE `id`='$uid'");
            while($row = mysqli_fetch_array($ret)) {
          ?>  
            <h2 class="text-2xl font-semibold text-gray-700 mb-6"><?php echo $row['fullname']; ?> - Deposit Update</h2>
            <form class="space-y-6" name="form1" method="post" action="">
              <!-- Hidden Fields -->
              <input type="hidden" name="userid" value="<?php echo $row['id']; ?>">
              <input type="hidden" name="email" value="<?php echo $row['email']; ?>">
              <input type="hidden" name="profit" value="0">
              <input type="hidden" name="status" value="active">
              <input type="hidden" name="percentage" value="0">
              <input type="hidden" name="description" value="Deposit update">
              
              <div>
                <label class="block text-gray-600 font-medium">Email Address</label>
                <input type="text" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-white" id="emailInput" value="<?php echo $row['email'];?>" readonly>
              </div>
              
              <div>
                <label class="block text-gray-600 font-medium">Old Deposit</label>
                <input type="number" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-gray-100" id="oldDeposit" value="<?php echo $row['deposit'];?>" disabled readonly>
              </div>

              <div>
                <label class="block text-gray-600 font-medium">New Deposit Amount</label>
                <input type="number" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-white" name="deposit" id="deposit" onkeyup="sum()" placeholder="Enter new deposit amount">
              </div>

              <div>
                <label class="block text-gray-600 font-medium">New Total Deposit</label>
                <input type="number" class="mt-1 block w-full border border-gray-300 rounded px-3 py-2 bg-gray-100" id="newTotalDeposit" value="<?php echo $row['deposit'];?>" disabled readonly>
              </div>

              <button type="submit" name="Submit" class="w-full bg-blue-500 hover:bg-blue-600 text-white py-3 rounded font-semibold">Submit</button>
            </form>
          <?php } // end while ?>
        </div>
      </main>
    </div>
  </div>

  <!-- JavaScript for Calculations and Toast Auto-Dismiss -->
  <script>
    function sum() {
      var oldDeposit = parseFloat(document.getElementById('oldDeposit').value) || 0;
      var newDeposit = parseFloat(document.getElementById('deposit').value) || 0;
      var result = oldDeposit + newDeposit;
      if (!isNaN(result)) {
        document.getElementById('newTotalDeposit').value = result;
      }
    }
    
    // Auto-dismiss the toast after 3 seconds
    document.addEventListener("DOMContentLoaded", function(){
      var toast = document.getElementById("toast");
      if(toast){
        setTimeout(function(){
          toast.classList.add("opacity-0");
          setTimeout(function(){ toast.remove(); }, 500);
        }, 3000);
      }
    });
  </script>
</body>
</html>
