<?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>

          <main
            class="w-full xl:px-[48px] px-6 pb-6 xl:pb-[48px] sm:pt-[156px] pt-[100px]"
          >
            <!-- write your code here-->
            <div class="grid grid-cols-1 xl:grid-cols-12 bg-white dark:bg-darkblack-600 rounded-xl">
              <!-- Sidebar -->
              <aside class="col-span-3 border-r border-bgray-200 dark:border-darkblack-400">
                <!-- Sidebar Tabs -->
              
                <div class="px-4 py-6">
                  <div
                    class="tab active flex gap-x-4 p-4 rounded-lg transition-all"
                    data-tab="tab1"
                  >
                    <div
                      class="w-12 tab-icon transition-all h-12 shrink-0 rounded-full inline-flex items-center justify-center bg-bgray-100 dark:bg-darkblack-500"
                    >
                      <svg
                   
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <ellipse
                          cx="12"
                          cy="17.5"
                          rx="7"
                          ry="3.5"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linejoin="round"
                        />
                        <circle
                          cx="12"
                          cy="7"
                          r="4"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linejoin="round"
                        />
                      </svg>
                    </div>
                    <div>
                      <h4 class="text-base font-bold text-bgray-900 dark:text-white">
                        Personal Informations
                      </h4>
                      <p class="text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">

                      </p>
                    </div>
                  </div>
                  <div
                    class="tab flex gap-x-4 p-4 rounded-lg transition-all"
                    data-tab="tab2"
                  >
                    <div
                      class="w-12 tab-icon transition-all h-12 shrink-0 rounded-full inline-flex items-center justify-center bg-bgray-100"
                    >
                      <svg
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M11.0717 4.06949C8.26334 4.49348 6.01734 6.81294 5.67964 9.79403L5.33476 12.8385C5.24906 13.595 4.94246 14.3069 4.45549 14.88C3.42209 16.0964 4.26081 18 5.83014 18H18.1699C19.7392 18 20.5779 16.0964 19.5445 14.88C19.0575 14.3069 18.7509 13.595 18.6652 12.8385L18.4373 10.8267M15 20C14.5633 21.1652 13.385 22 12 22C10.615 22 9.43668 21.1652 9 20M20 5C20 6.65685 18.6569 8 17 8C15.3431 8 14 6.65685 14 5C14 3.34315 15.3431 2 17 2C18.6569 2 20 3.34315 20 5Z"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linecap="round"
                        />
                      </svg>
                    </div>
                    <div>
                      <h4 class="text-base font-bold text-bgray-900 dark:text-white">
                        Notification Setting
                      </h4>
                      <p class="text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">

                      </p>
                    </div>
                  </div>
                  <div
                    data-tab="tab3"
                    class="tab flex gap-x-4 p-4 group  rounded-lg transition-all"
                  >
                    <div
                      class="w-12 tab-icon transition-all h-12 shrink-0 rounded-full inline-flex items-center justify-center bg-bgray-100"
                    >
                      <svg
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M2 6H6M2 12H6M2 18H6M18 6L10 6M14 10L10 10M8 22H18C20.2091 22 22 20.2091 22 18V6C22 3.79086 20.2091 2 18 2H8C5.79086 2 4 3.79086 4 6V18C4 20.2091 5.79086 22 8 22Z"
                          stroke-width="1.5"
                          stroke-linecap="round"
                          stroke="currentColor"
                        />
                      </svg>
                    </div>
                    <div>
                      <h4 class="text-base font-bold text-bgray-900 dark:text-white">
                        Program & Resources
                      </h4>
                      <p class="text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5 ">

                      </p>
                    </div>
                  </div>
                  <div
                    data-tab="tab4"
                    class="tab flex gap-x-4 p-4 group rounded-lg transition-all"
                  >
                    <div
                      class="w-12 tab-icon transition-all h-12 shrink-0 rounded-full inline-flex items-center justify-center bg-bgray-100"
                    >
                      <svg
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M18 15H12V7H18M18 15C19.1046 15 20 14.1046 20 13V9C20 7.89543 19.1046 7 18 7M18 15V20C18 21.1046 17.1046 22 16 22H8C6.89543 22 6 21.1046 6 20V4C6 2.89543 6.89543 2 8 2H16C17.1046 2 18 2.89543 18 4V7"
                          stroke-width="1.5"
                          stroke="currentColor"
                          stroke-linejoin="round"
                        />
                        <path
                          d="M13 19C13 19.5523 12.5523 20 12 20C11.4477 20 11 19.5523 11 19C11 18.4477 11.4477 18 12 18C12.5523 18 13 18.4477 13 19Z"
                          fill="currentColor"
                        />
                        <path
                          stroke="currentColor"
                          d="M20 10L12 10"
                          stroke-width="1.5"
                          stroke-linecap="round"
                          stroke-linejoin="round"
                        />
                      </svg>
                    </div>
                    <div>
                      <h4 class="text-base font-bold text-bgray-900 dark:text-white">
                        Payment Method
                      </h4>
                      <p class="text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">

                      </p>
                    </div>
                  </div>
                  <div
                    data-tab="tab5"
                    class="tab flex gap-x-4 p-4 rounded-lg transition-all"
                  >
                    <div
                      class="w-12 tab-icon transition-all h-12 shrink-0 rounded-full inline-flex items-center justify-center bg-bgray-100"
                    >
                      <svg
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          fill="currentColor"
                          d="M13.6831 10.0808L14.3138 10.4866L13.6831 10.0808ZM9.25 9C9.25 9.41421 9.58579 9.75 10 9.75C10.4142 9.75 10.75 9.41421 10.75 9H9.25ZM11.25 13.5C11.25 13.9142 11.5858 14.25 12 14.25C12.4142 14.25 12.75 13.9142 12.75 13.5H11.25ZM12.75 16C12.75 15.5858 12.4142 15.25 12 15.25C11.5858 15.25 11.25 15.5858 11.25 16H12.75ZM11.25 17C11.25 17.4142 11.5858 17.75 12 17.75C12.4142 17.75 12.75 17.4142 12.75 17H11.25ZM21.25 12C21.25 17.1086 17.1086 21.25 12 21.25V22.75C17.9371 22.75 22.75 17.9371 22.75 12H21.25ZM12 21.25C6.89137 21.25 2.75 17.1086 2.75 12H1.25C1.25 17.9371 6.06294 22.75 12 22.75V21.25ZM2.75 12C2.75 6.89137 6.89137 2.75 12 2.75V1.25C6.06294 1.25 1.25 6.06294 1.25 12H2.75ZM12 2.75C17.1086 2.75 21.25 6.89137 21.25 12H22.75C22.75 6.06294 17.9371 1.25 12 1.25V2.75ZM13.25 9C13.25 9.24996 13.1774 9.48068 13.0524 9.67495L14.3138 10.4866C14.5899 10.0576 14.75 9.54634 14.75 9H13.25ZM10.75 9C10.75 8.30964 11.3096 7.75 12 7.75V6.25C10.4812 6.25 9.25 7.48122 9.25 9H10.75ZM12 7.75C12.6904 7.75 13.25 8.30964 13.25 9H14.75C14.75 7.48122 13.5188 6.25 12 6.25V7.75ZM11.25 13V13.5H12.75V13H11.25ZM13.0524 9.67495C12.9265 9.87065 12.7688 10.0731 12.5836 10.3033C12.4063 10.5237 12.1979 10.7764 12.011 11.0333C11.6424 11.5398 11.25 12.2007 11.25 13H12.75C12.75 12.6947 12.9003 12.3605 13.2239 11.9158C13.383 11.697 13.558 11.4851 13.7523 11.2436C13.9387 11.0119 14.1409 10.7554 14.3138 10.4866L13.0524 9.67495ZM11.25 16V17H12.75V16H11.25Z"
                        />
                      </svg>
                    </div>
                    <div>
                      <h4 class="text-base font-bold text-bgray-900 dark:text-white">FAQ</h4>
                      <p class="text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">
                          Here are some frequently asked questions to help you understand better.
                      </p>
                    </div>
                  </div>
                  <div
                    data-tab="tab6"
                    class="tab flex gap-x-4 p-4 group rounded-lg transition-all"
                  >
                    <div
                      class="w-12 tab-icon transition-all h-12 shrink-0 rounded-full inline-flex items-center justify-center "
                    >
                      <svg
                        
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M16 8H8M16 8C18.2091 8 20 9.79086 20 12V18C20 20.2091 18.2091 22 16 22H8C5.79086 22 4 20.2091 4 18V12C4 9.79086 5.79086 8 8 8M16 8V6C16 3.79086 14.2091 2 12 2C9.79086 2 8 3.79086 8 6V8M14 15C14 16.1046 13.1046 17 12 17C10.8954 17 10 16.1046 10 15C10 13.8954 10.8954 13 12 13C13.1046 13 14 13.8954 14 15Z"
                          stroke="currentColor"
                          stroke-width="1.5"
                          stroke-linecap="round"
                          stroke-linejoin="round"
                        />
                      </svg>
                    </div>
                   <a href="./security-center.php">
  <div>
    <h4 class="text-base font-bold text-bgray-900 dark:text-white">
      Security
    </h4>
    <p class="text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">
  Follow these essential security tips to protect your account.
    </p>
  </div>
</a>

                  </div>
                  <div
                    data-tab="tab7"
                    class="tab flex gap-x-4 p-4 rounded-lg transition-all"
                  >
                    <div
                      class="w-12 tab-icon transition-all h-12 shrink-0 rounded-full inline-flex items-center justify-center bg-bgray-100"
                    >
                      <svg
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M9 14L10.7528 15.4023C11.1707 15.7366 11.7777 15.6826 12.1301 15.2799L15 12M16 4H17C19.2091 4 21 5.79086 21 8V18C21 20.2091 19.2091 22 17 22H7C4.79086 22 3 20.2091 3 18V8C3 5.79086 4.79086 4 7 4H8M16 4C16 5.10457 15.1046 6 14 6H10C8.89543 6 8 5.10457 8 4M16 4C16 2.89543 15.1046 2 14 2H10C8.89543 2 8 2.89543 8 4"
                          stroke-width="1.5"
                          stroke="currentColor"
                          stroke-linecap="round"
                        />
                      </svg>
                    </div>

                    <div>
                      <h4 class="text-base font-bold text-bgray-900 dark:text-white">
                        Terms & Conditions
                      </h4>
                      <p class="text-sm font-medium text-bgray-700 dark:text-darkblack-300 mt-0.5">
  Please read through our Terms and Conditions for important information.
                      </p>
                    </div>
                  </div>
                </div>
                <?php
require('connect.php');

// Check if session is not already active, then start it.
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// Initialize variables
$tradeSignalPercentage = 0;
$currency = '';
$totalBalanceFormatted = '0.00';

if (isset($_SESSION['email'])) {
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);

    // Fetch user data
    $query = "SELECT percent, currency FROM users WHERE email='$SEshopmail'";
    $userquery = mysqli_query($connection, $query) or die(mysqli_error($connection));

    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_assoc($userquery);
        $tradeSignalPercentage = (float)$row['percent'];
        $currency = $row['currency'];
    } else {
        die("User not found or query failed.");
    }

    // Fetch total balance
    $balanceQuery = mysqli_query($connection, "SELECT SUM(deposit + bitcoin + ethereum + tether) AS total FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $totalBalance = $balanceRow['total'];
        $totalBalanceFormatted = number_format($totalBalance, 2);
    } else {
        die("Balance query failed.");
    }
} else {
    die("User not logged in.");
}
?>

<!-- Progressbar -->
<div class="px-8">
  <div class="bg-bgray-200 dark:bg-darkblack-500 p-7 rounded-xl">
    <div class="flex-row space-x-6 2xl:flex-row 2xl:space-x-6 flex md:flex-col md:space-x-0 items-center">
      <div class="progess-bar flex justify-center md:mb-[13px] xl:mb-0 mb-0">
        <div class="bonus-per relative">
          <div class="bonus-outer">
            <div class="bonus-inner">
              <div class="number">
                <span class="text-sm font-medium text-bgray-900">
                  <?php echo htmlspecialchars($tradeSignalPercentage, ENT_QUOTES, 'UTF-8'); ?>%
                </span>
              </div>
            </div>
          </div>
          <svg xmlns="http://www.w3.org/2000/svg" width="80px" height="80px">
            <circle
              style="stroke-dashoffset: calc(215 - 215 * (<?php echo $tradeSignalPercentage; ?> / 100));"
              cx="40"
              cy="40"
              r="35"
              stroke-linecap="round"
            />
          </svg>
        </div>
      </div>
      <div class="flex flex-col md:items-center xl:items-start items-start">
        <h4 class="text-bgray-900 dark:text-white text-base font-bold">Complete profile</h4>
        <span class="text-xs font-medium text-bgray-700 dark:text-darkblack-300">
          Complete your profile to unlock all features
        </span>
        <span class="text-sm font-bold mt-2 text-success-300">
          <?php echo htmlspecialchars($currency, ENT_QUOTES, 'UTF-8') . $totalBalanceFormatted; ?>
        </span>
      </div>
    </div>
   <a href="signal.php" class="block mt-4">
  <button class="w-full bg-success-300 hover:bg-success-400 text-white font-bold text-xs py-3 rounded-lg transition-all">
    Boost Signal
  </button>
</a>

  </div>
</div>

              </aside>
              <!--Tab Content -->
              <div class="py-8 px-10 col-span-9 tab-content">
                <!-- Personal Information -->
                <div id="tab1" class="tab-pane active">
                  <div
                    class="xl:grid grid-cols-12 gap-12 flex 2xl:flex-row flex-col-reverse"
                  >
                    <div class="2xl:col-span-8 xl:col-span-7">
                      <h3
                        class="text-2xl font-bold pb-5 text-bgray-900 dark:text-white dark:border-darkblack-400 border-b border-bgray-200"
                      >
                        Personal Information's
                      </h3>
                      <div class="mt-8">
                        <form action="#">
                          <div class="grid 2xl:grid-cols-2 grid-cols-1 gap-6">
                            <div class="flex flex-col gap-2">
                              <label
                                for="fname"
                                class="text-base text-bgray-600 dark:text-bgray-50  font-medium"
                                >FullName</label
                              >
                              <input
                                type="text"
                                class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white p-4 rounded-lg h-14 border-0 focus:border focus:border-success-300 focus:ring-0"
                                placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['fullname'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                              />
                            </div>
                          
                            <div class="flex flex-col gap-2">
                              <label
                                for="email"
                                class="text-base text-bgray-600 dark:text-bgray-50  font-medium"
                                >Email</label
                              >
                              <input
                                type="text"
                                class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white p-4 rounded-lg h-14 border-0 focus:border focus:border-success-300 focus:ring-0"
                                placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['email'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                              />
                            </div>
                            <div class="flex flex-col gap-2">
                              <label
                                for="phone"
                                class="text-base text-bgray-600 dark:text-bgray-50  font-medium"
                                >Phone Number (Optional)</label
                              >
                              <input
                                type="text"
                                class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white p-4 rounded-lg h-14 border-0 focus:border focus:border-success-300 focus:ring-0"
                                placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['phone'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                              />
                            </div>
                          </div>
                          <h4
                            class="pt-8 pb-6 text-xl font-bold text-bgray-900 dark:text-white"
                          >
                            Personal Address
                          </h4>
                          <div class="grid 2xl:grid-cols-2 grid-cols-1 gap-6">
                            <div class="flex flex-col gap-2">
                              <label
                                for="country"
                                class="text-base text-bgray-600 dark:text-bgray-50  font-medium"
                                >Country or Region</label
                              >
                              <input
                                type="text"
                                class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white p-4 rounded-lg h-14 border-0 focus:border focus:border-success-300 focus:ring-0"
                                placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['country'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                              />
                            </div>
                           
                         
                         
                          </div>
                  
                          <div class="flex justify-end">
                            <a
  href="./change-name.php"
  class="rounded-lg bg-success-300 text-white font-semibold mt-10 py-3.5 px-4 inline-block"
>
  Modify Name
</a>

                          </div>
                        </form>
                      </div>
                    </div>
                    <div class="2xl:col-span-4 xl:col-span-5 2xl:mt-24">
                      <header class="mb-8">
                        
                        
                        
    <div class="text-center m-auto w-40 h-40 relative">
<i class="fas fa-user" 
   style="
     display: inline-flex;
     align-items: center;
     justify-content: center;
     width: 100px; /* Larger size for profile image */
     height: 100px; /* Larger size for profile image */
     color: #9ca3af;
     border-radius: 50%; /* Keeps it circular */
     font-size: 48px; /* Larger icon size */
     background-color: #e5e7eb; /* Optional: adds a background color */
     border: 2px solid #d1d5db; /* Optional: adds a border */
   "></i>
     <label for="fileInput" class="absolute right-4 bottom-1 cursor-pointer">
      
      </label>
    </div>
    <!-- Optional submit button -->
    <div class="text-center mt-4">
    </div>
                      </header>
                      <div>
                        <h4 class="font-bold text-lg text-bgray-800 dark:text-white mb-2">
                          Update Cover
                        </h4>
                        <p class="mb-4 text-bgray-500 dark:text-bgray-50">
                          Cover of at least Size
                          <span class="text-bgray-900">1170x920 </span>
                        </p>
                        <div class="relative w-full">
                          <img
                            src="assets/images/others/cover.jpg"
                            class="w-full"
                            alt=""
                          />
                          <button class="absolute right-2 bottom-2">
                            <svg
                              width="29"
                              height="29"
                              viewBox="0 0 29 29"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <circle
                                cx="14.2414"
                                cy="14.2414"
                                r="14.2414"
                                fill="#22C55E"
                              />
                              <path
                                d="M14.6994 10.2363C15.7798 11.3167 16.8434 12.3803 17.9171 13.454C17.7837 13.584 17.6403 13.7174 17.5036 13.8574C15.5497 15.8114 13.5924 17.7653 11.6385 19.7192C11.5118 19.8459 11.3884 19.9726 11.2617 20.0927C11.2317 20.1193 11.185 20.1427 11.145 20.1427C10.1281 20.146 9.11108 20.1427 8.0941 20.146C8.02408 20.146 8.01074 20.1193 8.01074 20.0593C8.01074 19.049 8.01074 18.0354 8.01408 17.0251C8.01408 16.9784 8.03742 16.9217 8.06743 16.8917C9.26779 15.688 10.4682 14.4876 11.6685 13.2873C12.6655 12.2903 13.6591 11.2967 14.6561 10.2997C14.6761 10.2797 14.6861 10.253 14.6994 10.2363Z"
                                fill="white"
                              />
                              <path
                                d="M18.6467 12.7197C17.573 11.646 16.506 10.579 15.4424 9.51537C15.6324 9.31864 15.8292 9.11858 16.0259 8.91852C16.256 8.68845 16.4894 8.45838 16.7228 8.22831C17.0162 7.93822 17.4197 7.93822 17.7097 8.22831C18.4466 8.9552 19.1802 9.68542 19.9171 10.4123C20.2038 10.6957 20.2138 11.0992 19.9371 11.3859C19.5136 11.8261 19.0868 12.2629 18.6634 12.703C18.66 12.7097 18.65 12.7163 18.6467 12.7197Z"
                                fill="white"
                              />
                            </svg>
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- Notification -->
                <div id="tab2" class="tab-pane">
                  <h3 class="text-2xl font-bold text-bgray-900 dark:text-white mb-5">
                    Notification
                  </h3>
                  <div class="space-y-5">
                    <div
                      class="flex sm:flex-row flex-col sm:items-center items-end justify-between pb-5 border-b border-bgray-300 dark:border-darkblack-400"
                    >
                      <div class="flex gap-x-4">
                        <span
                          ><svg
                            width="60"
                            height="60"
                            viewBox="0 0 60 60"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <circle cx="30" cy="30" r="30" fill="#22C55E" />
                            <path
                              d="M29.9703 43.7392C27.4494 43.7392 24.9286 43.7512 22.4077 43.7352C20.2721 43.7232 19.0338 42.51 19.0197 40.3809C18.9955 37.0226 18.9915 33.6643 19.0197 30.306C19.0378 28.2088 20.3265 26.9736 22.4481 26.9696C27.4212 26.9597 32.3964 26.9617 37.3695 26.9696C39.604 26.9736 40.8564 28.2208 40.8644 30.4457C40.8745 33.7381 40.8786 37.0306 40.8644 40.323C40.8544 42.506 39.6242 43.7252 37.43 43.7372C34.9434 43.7492 32.4569 43.7392 29.9703 43.7392ZM27.5321 33.7242C27.6108 33.9217 27.6592 34.5403 27.9919 34.7977C28.8954 35.4981 28.7542 36.404 28.7563 37.3159C28.7563 37.7469 28.6272 38.2538 28.8107 38.589C29.0467 39.018 29.5367 39.5827 29.9219 39.5867C30.3131 39.5907 30.8496 39.0499 31.0613 38.6229C31.261 38.2179 31.1319 37.6492 31.1319 37.1543C31.1319 36.3022 31.0936 35.522 31.868 34.8216C32.6041 34.1552 32.4871 32.8881 31.8841 32.062C31.2811 31.2359 30.2002 30.8807 29.2019 31.18C28.2521 31.4653 27.5483 32.4152 27.5321 33.7242Z"
                              fill="white"
                            />
                            <path
                              d="M37.5315 26.0269C36.3356 26.0269 35.2466 26.0269 34.0345 26.0269C34.0345 25.1629 34.0446 24.3447 34.0325 23.5246C33.9982 21.0822 32.2397 19.2345 29.9467 19.2225C27.6497 19.2105 25.8851 21.0423 25.8448 23.4967C25.8306 24.3188 25.8427 25.1429 25.8427 26.0249C24.6448 26.0249 23.5558 26.0249 22.4729 26.0249C21.7126 21.0942 23.5054 17.4326 27.7546 16.1136C32.5603 14.621 37.3984 18.127 37.5274 23.1096C37.5516 24.0634 37.5315 25.0192 37.5315 26.0269Z"
                              fill="white"
                            />
                          </svg>
                        </span>
                        <div class="flex-1">
                          <h4
                            class="text-lg font-bold text-bgray-900 dark:text-white"
                            id="availability-label"
                          >
                            All Notifcation update off
                          </h4>
                          <p
                            class="text-base text-bgray-500 dark:text-darkblack-300"
                            id="availability-description"
                          >
                            Unlockable content, only revealed by the owner of
                            the item.
                          </p>
                        </div>
                      </div>
                      <!-- Enabled: "bg-success-300", Not Enabled: "bg-[#9AA2B1]" -->
                      <button
                        type="button"
                        class="switch-btn text-center relative inline-flex h-5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none active"
                        role="switch"
                        aria-checked="false"
                        aria-labelledby="availability-label"
                        aria-describedby="availability-description"
                      >
                        <!-- Enabled: "translate-x-5", Not Enabled: "translate-x-0" -->
                        <span
                          aria-hidden="true"
                          class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                        ></span>
                      </button>
                    </div>
                    <div
                      class="flex sm:flex-row flex-col sm:items-center items-end justify-between pb-5 border-b border-bgray-300 dark:border-darkblack-400"
                    >
                      <div class="flex gap-x-4">
                        <div class="w-[60px]">
                          <svg
                            width="60"
                            height="60"
                            viewBox="0 0 60 60"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <circle cx="30" cy="30" r="30" fill="#FFC837" />
                            <path
                              d="M29.9407 27.7853C29.3978 27.6062 28.8874 27.5042 28.4342 27.2802C24.4201 25.2948 20.4135 23.2895 16.4044 21.2942C16.1106 21.1474 15.884 20.9583 15.879 20.6075C15.874 20.2418 16.1006 20.0378 16.4094 19.8835C20.3911 17.9006 24.3728 15.9127 28.352 13.9248C29.4974 13.3526 30.6255 13.4173 31.756 13.987C34.3133 15.2733 36.8806 16.5471 39.443 17.826C40.7503 18.4778 42.0551 19.1321 43.3599 19.7865C43.4346 19.8238 43.5093 19.8586 43.5865 19.896C43.8853 20.0353 44.092 20.2517 44.092 20.5976C44.092 20.9484 43.8704 21.1449 43.5766 21.2892C41.7214 22.2123 39.8688 23.1403 38.0136 24.0633C35.8721 25.1306 33.7406 26.2129 31.5866 27.2529C31.0737 27.5017 30.4935 27.6111 29.9407 27.7853Z"
                              fill="white"
                            />
                            <path
                              d="M28.9083 38.2601C28.9083 40.4844 28.9108 42.7086 28.9058 44.9329C28.9033 45.724 28.4576 46.0027 27.728 45.6668C24.0775 43.9874 20.4245 42.313 16.7814 40.6212C15.6086 40.0763 15.0109 39.1235 15.006 37.8347C14.996 33.5952 15.001 29.3557 15.0035 25.1162C15.0035 24.2976 15.4641 23.9941 16.1962 24.3325C19.9713 26.0716 23.7438 27.8206 27.5213 29.5522C28.48 29.9926 28.9232 30.7091 28.9158 31.7566C28.9008 33.9261 28.9108 36.0931 28.9108 38.2626C28.9108 38.2601 28.9108 38.2601 28.9083 38.2601Z"
                              fill="white"
                            />
                            <path
                              d="M31.0591 38.198C31.0591 36.016 31.0641 33.8341 31.0567 31.6521C31.0542 30.6669 31.5049 29.9877 32.3889 29.5797C36.1888 27.8281 39.9912 26.0816 43.7911 24.3325C44.4834 24.0141 44.959 24.3002 44.959 25.054C44.964 29.3358 44.9714 33.6151 44.954 37.8969C44.949 39.2081 44.2767 40.1237 43.0939 40.671C40.1406 42.0344 37.1848 43.3954 34.2316 44.7563C33.5991 45.0474 32.9691 45.3385 32.3391 45.6295C31.4825 46.0226 31.0567 45.7564 31.0567 44.8259C31.0567 42.6166 31.0567 40.4048 31.0567 38.1955C31.0591 38.198 31.0591 38.198 31.0591 38.198Z"
                              fill="white"
                            />
                          </svg>
                        </div>

                        <div class="flex-1">
                          <h4
                            class="text-lg font-bold text-bgray-900 dark:text-white"
                            id="availability-label"
                          >
                            When you upload products
                          </h4>
                          <p
                            class="text-base text-bgray-500 dark:text-darkblack-300"
                            id="availability-description"
                          >
                            Evey new products upload seccessfullly doen you can
                            get notifcation
                          </p>
                        </div>
                      </div>
                      <button
                        type="button"
                        class="switch-btn text-center relative inline-flex h-5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none"
                        role="switch"
                        aria-checked="false"
                        aria-labelledby="availability-label"
                        aria-describedby="availability-description"
                      >
                        <span
                          aria-hidden="true"
                          class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                        ></span>
                      </button>
                    </div>
                    <div
                      class="flex sm:flex-row flex-col sm:items-center items-end justify-between pb-5 border-b border-bgray-300 dark:border-darkblack-400"
                    >
                      <div class="flex gap-x-4">
                        <div class="w-[60px]">
                          <svg
                            width="60"
                            height="60"
                            viewBox="0 0 60 60"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <circle cx="30" cy="30" r="30" fill="#2DD4BF" />
                            <path
                              d="M41.8283 27.5958C41.4072 29.0508 41.0641 30.4376 40.5806 31.7718C40.4617 32.101 39.8846 32.4672 39.5142 32.4711C35.1806 32.5217 30.8469 32.5042 26.5133 32.5061C25.8719 32.5061 25.4625 32.1906 25.3163 31.577C24.6301 28.7099 23.9381 25.8428 23.283 22.9698C23.0842 22.1011 23.4799 21.5654 24.3182 21.5596C27.8506 21.5362 31.383 21.5499 35.0032 21.5499C34.9603 23.4236 35.4711 25.0617 36.8922 26.3102C38.2822 27.5393 39.9256 27.9055 41.8283 27.5958Z"
                              fill="white"
                            />
                            <path
                              d="M24.4176 33.5096C27.334 33.5096 30.1997 33.5096 33.0654 33.5096C34.9408 33.5096 36.8162 33.5057 38.6915 33.5116C39.5649 33.5135 40.0601 33.905 40.0835 34.5809C40.1069 35.2918 39.5961 35.7242 38.6877 35.7242C33.7224 35.7281 28.759 35.7281 23.7938 35.7242C22.7878 35.7242 22.5091 35.4788 22.2888 34.464C21.3452 30.1049 20.3939 25.7477 19.4679 21.3847C19.3587 20.8724 19.1579 20.5841 18.6296 20.4225C17.419 20.0524 16.2318 19.6044 15.0368 19.1837C14.0328 18.8292 13.6605 18.2877 13.9334 17.5924C14.2024 16.9048 14.7853 16.7295 15.7386 17.0606C17.2221 17.5748 18.692 18.128 20.1912 18.5955C20.9476 18.8311 21.3082 19.2577 21.4681 20.0212C22.3824 24.3589 23.3317 28.6889 24.2733 33.0207C24.3006 33.1493 24.3474 33.2778 24.4176 33.5096Z"
                              fill="white"
                            />
                            <path
                              d="M35.6934 22.2151C35.6798 19.5116 37.8729 17.3145 40.5788 17.3243C43.23 17.332 45.4134 19.533 45.4095 22.1957C45.4056 24.8505 43.2144 27.0456 40.5573 27.0515C37.9022 27.0573 35.7071 24.8758 35.6934 22.2151ZM42.6257 20.057C41.7465 20.9978 40.8848 21.921 39.8614 23.0176C39.3721 22.3534 38.9763 21.8197 38.524 21.2081C38.0698 21.6834 37.7696 21.997 37.5747 22.2034C38.4051 23.0605 39.1986 23.8766 39.9316 24.6343C41.1207 23.4422 42.345 22.2171 43.6726 20.8867C43.4562 20.7153 43.1969 20.5089 42.9357 20.3024C42.8538 20.2342 42.77 20.1719 42.6257 20.057Z"
                              fill="white"
                            />
                            <path
                              d="M37.4854 36.6242C39.2068 36.6086 40.6104 37.9603 40.6436 39.6666C40.6767 41.4021 39.2653 42.8259 37.5147 42.8259C35.805 42.8259 34.4072 41.4371 34.3994 39.7367C34.3936 38.0285 35.7699 36.6417 37.4854 36.6242ZM38.8929 39.7153C38.891 38.9615 38.2984 38.3499 37.5537 38.3343C36.7817 38.3168 36.1384 38.9537 36.1423 39.7309C36.1462 40.4769 36.7485 41.0963 37.4854 41.1157C38.2574 41.1352 38.8968 40.5002 38.8929 39.7153Z"
                              fill="white"
                            />
                            <path
                              d="M24.8751 42.825C23.1556 42.8113 21.7754 41.4304 21.7793 39.7261C21.7852 37.9672 23.179 36.6018 24.9491 36.6213C26.6569 36.6408 28.0273 38.0471 28.0078 39.7592C27.9864 41.4713 26.5906 42.8367 24.8751 42.825ZM26.2709 39.728C26.2728 38.945 25.6334 38.3159 24.8556 38.3353C24.1226 38.3548 23.4968 38.9879 23.4968 39.7163C23.4948 40.4467 24.1148 41.0876 24.8439 41.1129C25.6178 41.1401 26.2689 40.5071 26.2709 39.728Z"
                              fill="white"
                            />
                          </svg>
                        </div>

                        <div class="flex-1">
                          <h4
                            class="text-lg font-bold text-bgray-900 dark:text-white"
                            id="availability-label"
                          >
                            You got sell your prodcuts
                          </h4>
                          <p
                            class="text-base text-bgray-500 dark:text-darkblack-300"
                            id="availability-description"
                          >
                            Evey new prodcuts sell you can get notifcation
                          </p>
                        </div>
                      </div>
                      <button
                        type="button"
                        class="switch-btn text-center relative inline-flex h-5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none active"
                        role="switch"
                        aria-checked="false"
                        aria-labelledby="availability-label"
                        aria-describedby="availability-description"
                      >
                        <span
                          aria-hidden="true"
                          class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                        ></span>
                      </button>
                    </div>
                    <div
                      class="flex sm:flex-row flex-col sm:items-center items-end justify-between pb-5 border-b border-bgray-300 dark:border-darkblack-400"
                    >
                      <div class="flex gap-x-4">
                        <div class="w-[60px]">
                          <img src="assets/images/icons/follower.svg" alt="" />
                        </div>
                        <div class="flex-1">
                          <h4
                            class="text-lg font-bold text-bgray-900 dark:text-white"
                            id="availability-label"
                          >
                            Got new follower
                          </h4>
                          <p
                            class="text-base text-bgray-500 dark:text-darkblack-300"
                            id="availability-description"
                          >
                            Evey new follower you can get notifcation
                          </p>
                        </div>
                      </div>
                      <button
                        type="button"
                        class="switch-btn text-center relative inline-flex h-5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none"
                        role="switch"
                        aria-checked="false"
                        aria-labelledby="availability-label"
                        aria-describedby="availability-description"
                      >
                        <span
                          aria-hidden="true"
                          class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                        ></span>
                      </button>
                    </div>
                    <div
                      class="flex sm:flex-row flex-col sm:items-center items-end justify-between pb-5 border-b border-bgray-300 dark:border-darkblack-400"
                    >
                      <div class="flex gap-x-4">
                        <div class="w-[60px]">
                          <svg
                            width="60"
                            height="60"
                            viewBox="0 0 60 60"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <circle cx="30" cy="30" r="30" fill="#936DFF" />
                            <path
                              d="M37.9128 13.2706C38.2013 13.4189 38.2864 13.6656 38.2814 13.9739C38.2714 14.5905 38.2781 15.2088 38.2781 15.8655C38.4182 15.8655 38.5299 15.8655 38.6417 15.8655C40.1145 15.8671 41.5857 15.8671 43.0586 15.8688C43.9126 15.8705 44.2879 16.2605 44.2696 17.1121C44.2229 19.197 44.0077 21.2602 43.4005 23.2651C42.9368 24.8 42.283 26.2332 41.0787 27.3482C40.3331 28.0381 39.4523 28.4581 38.4415 28.5831C38.2514 28.6064 38.1863 28.6747 38.1463 28.8631C37.4691 32.0529 35.5742 34.1344 32.4467 35.0877C32.3116 35.1294 32.2032 35.161 32.2032 35.3494C32.2099 37.3242 32.2099 39.2991 32.2115 41.274C32.2115 41.304 32.2249 41.334 32.2399 41.394C32.345 41.399 32.4567 41.409 32.5685 41.409C33.2307 41.4107 33.8929 41.414 34.5551 41.4073C34.842 41.404 35.0538 41.5057 35.2206 41.7473C35.8878 42.7156 36.565 43.6789 37.2389 44.6422C37.3773 44.8405 37.5125 45.0721 37.3306 45.2721C37.2005 45.4138 36.9637 45.5304 36.7735 45.5321C32.4 45.5471 28.0248 45.5421 23.6513 45.5454C23.4178 45.5454 23.2109 45.5054 23.0858 45.2821C22.9524 45.0421 23.0491 44.8422 23.1892 44.6422C23.8581 43.6872 24.5287 42.7339 25.1875 41.7723C25.3677 41.5107 25.5945 41.404 25.9031 41.4073C26.6587 41.4157 27.4143 41.409 28.2033 41.409C28.21 41.274 28.22 41.1624 28.22 41.0507C28.2216 39.1908 28.2166 37.3326 28.225 35.4727C28.2266 35.2377 28.1633 35.1394 27.9214 35.0644C24.8823 34.1178 22.9974 32.0945 22.3119 28.9831C22.2502 28.7031 22.1551 28.6081 21.8598 28.5614C20.407 28.3364 19.3128 27.5315 18.4738 26.3532C17.5047 24.9916 16.9993 23.44 16.659 21.8285C16.3287 20.2636 16.1769 18.6753 16.1536 17.0754C16.1419 16.2388 16.5255 15.8655 17.3679 15.8638C18.8291 15.8621 20.2919 15.8605 21.7531 15.8605C21.8682 15.8605 21.9833 15.8605 22.1484 15.8605C22.1484 15.5655 22.1484 15.2872 22.1484 15.0089C22.1484 14.6622 22.1567 14.3156 22.1467 13.9689C22.1367 13.6606 22.2268 13.4123 22.5154 13.2656C27.6478 13.2706 32.7803 13.2706 37.9128 13.2706ZM30.2132 18.5787C29.8947 19.222 29.561 19.7753 29.3425 20.3719C29.109 21.0102 28.7154 21.2668 28.0482 21.2935C27.4177 21.3202 26.7922 21.4652 26.1116 21.5652C26.2217 21.6818 26.2901 21.7568 26.3635 21.8285C26.8972 22.3501 27.4393 22.8634 27.9581 23.3984C28.0548 23.4984 28.1165 23.69 28.1015 23.8284C28.0565 24.245 27.9631 24.655 27.8914 25.0683C27.8196 25.4933 27.7513 25.9199 27.6729 26.3999C28.4652 25.9832 29.2041 25.6083 29.9297 25.2083C30.1415 25.0916 30.3 25.1033 30.5051 25.2149C31.2307 25.6116 31.968 25.9882 32.7236 26.3832C32.7236 26.2899 32.7319 26.2282 32.7219 26.1716C32.5902 25.4066 32.4667 24.64 32.3183 23.8784C32.2749 23.6534 32.3233 23.5084 32.4884 23.355C32.9338 22.9401 33.3624 22.5051 33.8011 22.0818C33.9629 21.9251 34.1331 21.7768 34.3649 21.5668C33.4609 21.4368 32.6652 21.3135 31.8662 21.2102C31.6077 21.1768 31.4409 21.0968 31.3225 20.8335C30.9872 20.0969 30.6086 19.3736 30.2132 18.5787ZM42.2813 17.892C40.9219 17.892 39.6075 17.892 38.3014 17.892C38.3014 20.8019 38.3014 23.6834 38.3014 26.6449C38.6517 26.4965 38.9753 26.3999 39.2555 26.2315C40.1512 25.6932 40.6617 24.84 41.057 23.91C41.5991 22.6368 41.8943 21.2968 42.0745 19.9319C42.1612 19.2569 42.2112 18.5803 42.2813 17.892ZM22.1301 26.5865C22.1301 23.6717 22.1301 20.7819 22.1301 17.8854C20.8023 17.8854 19.4963 17.8854 18.1819 17.8854C18.1785 17.947 18.1719 17.987 18.1735 18.027C18.2753 19.6969 18.4988 21.3468 19.0142 22.9434C19.3278 23.9133 19.7198 24.855 20.4287 25.6199C20.8874 26.1166 21.4262 26.4749 22.1301 26.5865Z"
                              fill="white"
                            />
                          </svg>
                        </div>

                        <div class="flex-1">
                          <h4
                            class="text-lg font-bold text-bgray-900 dark:text-white"
                            id="availability-label"
                          >
                            Auther leavel up
                          </h4>
                          <p
                            class="text-base text-bgray-500 dark:text-darkblack-300"
                            id="availability-description"
                          >
                            Evey new prodcuts sell you can get notifcation
                          </p>
                        </div>
                      </div>

                      <button
                        type="button"
                        class="switch-btn text-center toggle-switch bg-gray-300 relative inline-flex h-5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none"
                        role="switch"
                        aria-checked="false"
                        aria-labelledby="availability-label"
                        aria-describedby="availability-description"
                      >
                        <span
                          aria-hidden="true"
                          class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                        ></span>
                      </button>
                    </div>
                  </div>
                </div>
                <!-- Program & Resources -->
                <div id="tab3" class="tab-pane">
                  <div class="grid grid-cols-12">
                    <div
                      class="2xl:col-span-9 col-span-12 2xl:border-r border-bgray-300"
                    >
                      <h3 class="text-2xl font-bold text-bgray-900 dark:text-white mb-3">
                        Folders
                      </h3>
                      <div class="flex flex-wrap lg:gap-x-0 gap-3 gap-y-5">
                        <div
                          class="flex flex-col items-center md:w-32 md:h-32 w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <svg
                            width="120"
                            height="120"
                            viewBox="0 0 120 120"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M7.56578 12.9268H36.2647C38.1443 12.9268 39.8804 13.9307 40.8183 15.5595L45.5417 22.0121C46.4796 23.6408 48.216 24.6448 50.0953 24.6448H120V98.3153C120 102.184 116.863 105.321 112.994 105.321H7.00587C3.13675 105.321 0 102.184 0 98.3153V32.8171C0 27.4018 0.836656 22.0188 2.4805 16.8589C3.08269 14.5432 5.17317 12.9268 7.56578 12.9268Z"
                              fill="#4ADE80"
                            />
                            <path
                              d="M103.16 23.4395H10.9199V62.4043H103.16V23.4395Z"
                              fill="#EBF0F3"
                            />
                            <path
                              d="M114.746 16.4297H85.825C83.7683 16.4297 81.9005 17.6297 81.0459 19.5003L76.097 30.3312C75.2421 32.2019 73.3746 33.4019 71.3179 33.4019H0V100.067C0 103.936 3.13675 107.072 7.00587 107.072H112.994C116.863 107.072 120 103.936 120 100.067V21.6841C120 18.7823 117.647 16.4297 114.746 16.4297Z"
                              fill="#22C55E"
                            />
                          </svg>
                          <h4 class="md:text-xl text-sm font-semibold dark:text-white">
                            2021 Invoice
                          </h4>
                          <span class="md:text-base text-xs text-bgray-600 dark:text-darkblack-300"
                            >120 MB</span
                          >
                        </div>
                        <div
                          class="flex flex-col items-center md:w-32 md:h-32 w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <svg
                            width="120"
                            height="120"
                            viewBox="0 0 120 120"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M7.56578 12.9268H36.2647C38.1443 12.9268 39.8804 13.9307 40.8183 15.5595L45.5417 22.0121C46.4796 23.6408 48.216 24.6448 50.0953 24.6448H120V98.3153C120 102.184 116.863 105.321 112.994 105.321H7.00587C3.13675 105.321 0 102.184 0 98.3153V32.8171C0 27.4018 0.836656 22.0188 2.4805 16.8589C3.08269 14.5432 5.17317 12.9268 7.56578 12.9268Z"
                              fill="#4ADE80"
                            />
                            <path
                              d="M103.16 23.4395H10.9199V62.4043H103.16V23.4395Z"
                              fill="#EBF0F3"
                            />
                            <path
                              d="M114.746 16.4297H85.825C83.7683 16.4297 81.9005 17.6297 81.0459 19.5003L76.097 30.3312C75.2421 32.2019 73.3746 33.4019 71.3179 33.4019H0V100.067C0 103.936 3.13675 107.072 7.00587 107.072H112.994C116.863 107.072 120 103.936 120 100.067V21.6841C120 18.7823 117.647 16.4297 114.746 16.4297Z"
                              fill="#22C55E"
                            />
                          </svg>
                          <h4 class="md:text-xl text-sm font-semibold dark:text-white">
                            2021 Invoice
                          </h4>
                          <span class="md:text-base text-xs text-bgray-600 dark:text-darkblack-300"
                            >120 MB</span
                          >
                        </div>
                        <div
                          class="flex flex-col items-center md:w-32 md:h-32 w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <svg
                            width="120"
                            height="120"
                            viewBox="0 0 120 120"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M7.56578 12.9268H36.2647C38.1443 12.9268 39.8804 13.9307 40.8183 15.5595L45.5417 22.0121C46.4796 23.6408 48.216 24.6448 50.0953 24.6448H120V98.3153C120 102.184 116.863 105.321 112.994 105.321H7.00587C3.13675 105.321 0 102.184 0 98.3153V32.8171C0 27.4018 0.836656 22.0188 2.4805 16.8589C3.08269 14.5432 5.17317 12.9268 7.56578 12.9268Z"
                              fill="#4ADE80"
                            />
                            <path
                              d="M103.16 23.4395H10.9199V62.4043H103.16V23.4395Z"
                              fill="#EBF0F3"
                            />
                            <path
                              d="M114.746 16.4297H85.825C83.7683 16.4297 81.9005 17.6297 81.0459 19.5003L76.097 30.3312C75.2421 32.2019 73.3746 33.4019 71.3179 33.4019H0V100.067C0 103.936 3.13675 107.072 7.00587 107.072H112.994C116.863 107.072 120 103.936 120 100.067V21.6841C120 18.7823 117.647 16.4297 114.746 16.4297Z"
                              fill="#22C55E"
                            />
                          </svg>
                          <h4 class="md:text-xl text-sm font-semibold dark:text-white">
                            2021 Invoice
                          </h4>
                          <span class="md:text-base text-xs text-bgray-600 dark:text-darkblack-300"
                            >120 MB</span
                          >
                        </div>
                        <div
                          class="flex flex-col items-center md:w-32 md:h-32 w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <svg
                            width="120"
                            height="120"
                            viewBox="0 0 120 120"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M7.56578 12.9268H36.2647C38.1443 12.9268 39.8804 13.9307 40.8183 15.5595L45.5417 22.0121C46.4796 23.6408 48.216 24.6448 50.0953 24.6448H120V98.3153C120 102.184 116.863 105.321 112.994 105.321H7.00587C3.13675 105.321 0 102.184 0 98.3153V32.8171C0 27.4018 0.836656 22.0188 2.4805 16.8589C3.08269 14.5432 5.17317 12.9268 7.56578 12.9268Z"
                              fill="#4ADE80"
                            />
                            <path
                              d="M103.16 23.4395H10.9199V62.4043H103.16V23.4395Z"
                              fill="#EBF0F3"
                            />
                            <path
                              d="M114.746 16.4297H85.825C83.7683 16.4297 81.9005 17.6297 81.0459 19.5003L76.097 30.3312C75.2421 32.2019 73.3746 33.4019 71.3179 33.4019H0V100.067C0 103.936 3.13675 107.072 7.00587 107.072H112.994C116.863 107.072 120 103.936 120 100.067V21.6841C120 18.7823 117.647 16.4297 114.746 16.4297Z"
                              fill="#22C55E"
                            />
                          </svg>
                          <h4 class="md:text-xl text-sm font-semibold dark:text-white">
                            2021 Invoice
                          </h4>
                          <span class="md:text-base text-xs text-bgray-600 dark:text-darkblack-300"
                            >120 MB</span
                          >
                        </div>
                        <div
                          class="flex flex-col items-center md:w-32 md:h-32 w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <svg
                            width="120"
                            height="120"
                            viewBox="0 0 120 120"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M7.56578 12.9268H36.2647C38.1443 12.9268 39.8804 13.9307 40.8183 15.5595L45.5417 22.0121C46.4796 23.6408 48.216 24.6448 50.0953 24.6448H120V98.3153C120 102.184 116.863 105.321 112.994 105.321H7.00587C3.13675 105.321 0 102.184 0 98.3153V32.8171C0 27.4018 0.836656 22.0188 2.4805 16.8589C3.08269 14.5432 5.17317 12.9268 7.56578 12.9268Z"
                              fill="#4ADE80"
                            />
                            <path
                              d="M103.16 23.4395H10.9199V62.4043H103.16V23.4395Z"
                              fill="#EBF0F3"
                            />
                            <path
                              d="M114.746 16.4297H85.825C83.7683 16.4297 81.9005 17.6297 81.0459 19.5003L76.097 30.3312C75.2421 32.2019 73.3746 33.4019 71.3179 33.4019H0V100.067C0 103.936 3.13675 107.072 7.00587 107.072H112.994C116.863 107.072 120 103.936 120 100.067V21.6841C120 18.7823 117.647 16.4297 114.746 16.4297Z"
                              fill="#22C55E"
                            />
                          </svg>
                          <h4 class="md:text-xl text-sm font-semibold dark:text-white">
                            2021 Invoice
                          </h4>
                          <span class="md:text-base text-xs text-bgray-600 dark:text-darkblack-300"
                            >120 MB</span
                          >
                        </div>
                        <div
                          class="flex flex-col items-center justify-center border-dashed border-2 border-bgray-300 dark:border-darkblack-400 rounded-lg md:w-32 md:h-32 w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <button class="flex flex-col items-center">
                            <span
                              class="w-10 h-10 rounded-lg items-center inline-flex justify-center bg-[#F8F8F8] dark:bg-darkblack-500"
                              ><svg
                                class="fill-bgray-900 dark:fill-white"
                                width="16"
                                height="16"
                                viewBox="0 0 16 16"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                              >
                                <path
                                  fill-rule="evenodd"
                                  clip-rule="evenodd"
                                  d="M8.79995 4.0002C8.79995 3.55837 8.44178 3.2002 7.99995 3.2002C7.55812 3.2002 7.19995 3.55837 7.19995 4.0002V7.2002H3.99995C3.55812 7.2002 3.19995 7.55837 3.19995 8.0002C3.19995 8.44202 3.55812 8.8002 3.99995 8.8002H7.19995V12.0002C7.19995 12.442 7.55812 12.8002 7.99995 12.8002C8.44178 12.8002 8.79995 12.442 8.79995 12.0002V8.8002H12C12.4418 8.8002 12.8 8.44202 12.8 8.0002C12.8 7.55837 12.4418 7.2002 12 7.2002H8.79995V4.0002Z"
                                 
                                /></svg>
                            
                          </span>
                            <span
                              class="block mt-4 text-bgray-500 font-medium text-base"
                              >Add Folder</span
                            >
                          </button>
                        </div>
                      </div>
                      <h3 class="text-3xl font-bold text-bgray-900 dark:text-white mb-5 mt-10">
                        Files
                      </h3>
                      <div
                        class="flex flex-wrap md:gap-x-10 gap-x-3 lg:gap-x-0 gap-y-5"
                      >
                        <div
                          class="flex flex-col items-center w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <div class="w-full flex justify-center">
                            <svg
                              width="67"
                              height="86"
                              viewBox="0 0 67 86"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M5.4032 0H46.9892L67 19.8123V80.625C67 83.5946 64.5796 86 61.5968 86H5.4032C2.42052 86 0 83.5946 0 80.625V5.37496C0 2.40536 2.4208 0 5.4032 0Z"
                                fill="white"
                              />
                              <path
                                d="M5.4032 0.5H46.7835L66.5 20.0208V80.625C66.5 83.3158 64.306 85.5 61.5968 85.5H5.4032C2.69405 85.5 0.5 83.3158 0.5 80.625V5.37496C0.5 2.68413 2.6943 0.5 5.4032 0.5Z"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M65.9198 20.4252H51.2864C48.6265 20.4252 46.468 18.2802 46.468 15.6368V1.0752"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M17.2903 31.0996C17.2903 30.5473 17.738 30.0996 18.2903 30.0996H48.7098C49.262 30.0996 49.7098 30.5473 49.7098 31.0996V63.4996C49.7098 64.0519 49.262 64.4996 48.7098 64.4996H18.2903C17.738 64.4996 17.2903 64.0519 17.2903 63.4996V31.0996Z"
                                fill="#304FFD"
                              />
                              <path
                                d="M40.6533 41.7275C40.7643 41.4409 40.9309 41.2259 41.153 41.0825C41.3874 40.9272 41.6465 40.8496 41.9303 40.8496C42.2881 40.8496 42.5904 40.9571 42.8372 41.1721C43.0963 41.3871 43.2259 41.6797 43.2259 42.05C43.2259 42.2292 43.1888 42.4263 43.1148 42.6413L39.2652 52.8359C39.1541 53.1225 38.9567 53.3495 38.6729 53.5167C38.4015 53.672 38.0992 53.7496 37.7661 53.7496C37.4329 53.7496 37.1306 53.672 36.8592 53.5167C36.5877 53.3495 36.3965 53.1225 36.2854 52.8359L33.5278 45.2929L30.6961 52.8359C30.585 53.1225 30.3938 53.3495 30.1223 53.5167C29.8509 53.672 29.5486 53.7496 29.2155 53.7496C28.8947 53.7496 28.5924 53.672 28.3086 53.5167C28.0371 53.3495 27.8459 53.1225 27.7348 52.8359L23.8852 42.6413C23.8112 42.4382 23.7742 42.2471 23.7742 42.0679C23.7742 41.6977 23.9099 41.405 24.1813 41.19C24.4528 40.9631 24.7736 40.8496 25.1437 40.8496C25.4399 40.8496 25.7051 40.9272 25.9396 41.0825C26.1864 41.2259 26.3653 41.4409 26.4763 41.7275L29.3265 49.6646L32.2878 41.7634C32.3988 41.4767 32.5715 41.2557 32.806 41.1004C33.0527 40.9452 33.3119 40.8675 33.5833 40.8675C33.8671 40.8675 34.1262 40.9452 34.3606 41.1004C34.5951 41.2557 34.7678 41.4827 34.8788 41.7813L37.7105 49.8079L40.6533 41.7275Z"
                                fill="white"
                              />
                            </svg>
                          </div>
                          <h4 class="md:text-base text-sm  dark:text-white font-semibold mt-2">
                            All Invoice
                          </h4>
                          <span class="text-base text-bgray-600 dark:text-bgray-50">1.4 MB</span>
                        </div>
                        <div
                          class="flex flex-col items-center w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <div class="w-full flex justify-center">
                            <svg
                              width="67"
                              height="86"
                              viewBox="0 0 67 86"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M5.4032 0H46.9892L67 19.8123V80.625C67 83.5946 64.5796 86 61.5968 86H5.4032C2.42052 86 0 83.5946 0 80.625V5.37496C0 2.40536 2.4208 0 5.4032 0Z"
                                fill="white"
                              />
                              <path
                                d="M5.4032 0.5H46.7835L66.5 20.0208V80.625C66.5 83.3158 64.306 85.5 61.5968 85.5H5.4032C2.69405 85.5 0.5 83.3158 0.5 80.625V5.37496C0.5 2.68413 2.6943 0.5 5.4032 0.5Z"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M65.9198 20.4252H51.2864C48.6265 20.4252 46.468 18.2802 46.468 15.6368V1.0752"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M34.7022 51.4466V48.8359H37.3266V46.2252H34.7022V43.6145H37.3266V41.0038H34.7022V38.3931H37.3266V35.7823H34.7022V33.1716H37.3266V30.5609H34.7022V27.9502H32.0777V30.5609H29.4533V33.1716H32.0777V35.7823H29.4533V38.3931H32.0777V41.0038H29.4533V43.6145H32.0777V46.2252H29.4533V48.8359H32.0777V51.4466H26.8289V57.9734C26.8289 61.5723 29.7722 64.5002 33.3899 64.5002C37.0077 64.5002 39.951 61.5723 39.951 57.9734V51.4466H34.7022ZM37.3266 57.9734C37.3266 60.1325 35.5603 61.8895 33.3899 61.8895C31.2195 61.8895 29.4533 60.1325 29.4533 57.9734V54.0573H37.3266V57.9734Z"
                                fill="#8A9099"
                              />
                              <path
                                d="M32.0778 59.2787H34.7023C35.4266 59.2787 36.0145 58.6952 36.0145 57.9733C36.0145 57.2515 35.4266 56.668 34.7023 56.668H32.0778C31.3535 56.668 30.7656 57.2515 30.7656 57.9733C30.7656 58.6952 31.3535 59.2787 32.0778 59.2787Z"
                                fill="#8A9099"
                              />
                            </svg>
                          </div>

                          <h4 class="md:text-base text-sm  dark:text-white font-semibold mt-2">
                            Bank Stat..
                          </h4>
                          <span class="text-sm text-bgray-600 dark:text-bgray-50">1.9 GB</span>
                        </div>
                        <div
                          class="flex flex-col items-center w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <div class="w-full flex justify-center">
                            <svg
                              width="67"
                              height="86"
                              viewBox="0 0 67 86"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M5.4032 0H46.9892L67 19.8123V80.625C67 83.5946 64.5796 86 61.5968 86H5.4032C2.42052 86 0 83.5946 0 80.625V5.37496C0 2.40536 2.4208 0 5.4032 0Z"
                                fill="white"
                              />
                              <path
                                d="M5.4032 0.5H46.7835L66.5 20.0208V80.625C66.5 83.3158 64.306 85.5 61.5968 85.5H5.4032C2.69405 85.5 0.5 83.3158 0.5 80.625V5.37496C0.5 2.68413 2.6943 0.5 5.4032 0.5Z"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M65.9198 20.4252H51.2864C48.6265 20.4252 46.468 18.2802 46.468 15.6368V1.0752"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M33.1393 41.8448C33.1393 43.1315 32.8209 44.3378 32.184 45.4636C31.5706 46.5895 30.5917 47.497 29.2471 48.1863C27.9262 48.8756 26.2513 49.2203 24.2227 49.2203H20.0828V58.4569H15.1292V34.4004H24.2227C26.1334 34.4004 27.761 34.7221 29.1056 35.3654C30.4502 36.0088 31.4527 36.8933 32.1132 38.0192C32.7973 39.1451 33.1393 40.4203 33.1393 41.8448ZM24.0104 45.3258C25.3785 45.3258 26.3929 45.0271 27.0534 44.4297C27.7139 43.8093 28.0441 42.9477 28.0441 41.8448C28.0441 39.5012 26.6995 38.3294 24.0104 38.3294H20.0828V45.3258H24.0104Z"
                                fill="#5889C4"
                              />
                              <path
                                d="M44.1576 58.7671C42.5536 58.7671 41.1147 58.4913 39.8409 57.9399C38.5671 57.3655 37.5527 56.5958 36.7979 55.6308C36.0666 54.6657 35.6656 53.5973 35.5949 52.4255H40.5839C40.6783 53.1608 41.0439 53.7697 41.6808 54.2522C42.3413 54.7347 43.1551 54.9759 44.1223 54.9759C45.0658 54.9759 45.7971 54.7921 46.316 54.4245C46.8586 54.0569 47.1299 53.5858 47.1299 53.0114C47.1299 52.3911 46.7996 51.9315 46.1391 51.6328C45.5022 51.3112 44.4761 50.9665 43.0608 50.5989C41.5982 50.2542 40.3952 49.8981 39.4517 49.5305C38.5317 49.1628 37.7297 48.5999 37.0456 47.8417C36.3851 47.0835 36.0548 46.061 36.0548 44.7743C36.0548 43.7174 36.3615 42.7524 36.9748 41.8793C37.6117 41.0062 38.5081 40.3169 39.664 39.8114C40.8434 39.3059 42.2234 39.0531 43.8038 39.0531C46.1391 39.0531 48.0026 39.6276 49.3944 40.7764C50.7861 41.9022 51.5528 43.4302 51.6943 45.3602H46.9529C46.8822 44.602 46.5519 44.0046 45.9622 43.568C45.3961 43.1085 44.6294 42.8787 43.6623 42.8787C42.7659 42.8787 42.07 43.0396 41.5747 43.3613C41.1029 43.6829 40.867 44.131 40.867 44.7054C40.867 45.3487 41.1972 45.8427 41.8577 46.1874C42.5182 46.5091 43.5443 46.8422 44.9361 47.1869C46.3514 47.5315 47.5191 47.8876 48.439 48.2553C49.359 48.6229 50.1492 49.1973 50.8097 49.9785C51.4938 50.7367 51.8476 51.7477 51.8712 53.0114C51.8712 54.1143 51.5528 55.1023 50.9159 55.9754C50.3026 56.8485 49.4062 57.5378 48.2267 58.0433C47.0709 58.5258 45.7145 58.7671 44.1576 58.7671Z"
                                fill="#5889C4"
                              />
                            </svg>
                          </div>

                          <h4 class="md:text-base text-sm  dark:text-white font-semibold mt-2">
                            vCard – Resume...
                          </h4>
                          <span class="text-base text-bgray-600 dark:text-bgray-50">1.4 MB</span>
                        </div>
                        <div
                          class="flex flex-col items-center w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <div class="w-full flex justify-center">
                            <svg
                              width="67"
                              height="86"
                              viewBox="0 0 67 86"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M5.4032 0H46.9892L67 19.8123V80.625C67 83.5946 64.5796 86 61.5968 86H5.4032C2.42052 86 0 83.5946 0 80.625V5.37496C0 2.40536 2.4208 0 5.4032 0Z"
                                fill="white"
                              />
                              <path
                                d="M5.4032 0.5H46.7835L66.5 20.0208V80.625C66.5 83.3158 64.306 85.5 61.5968 85.5H5.4032C2.69405 85.5 0.5 83.3158 0.5 80.625V5.37496C0.5 2.68413 2.6943 0.5 5.4032 0.5Z"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M65.9198 20.4252H51.2864C48.6265 20.4252 46.468 18.2802 46.468 15.6368V1.0752"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M17.2903 31.0996C17.2903 30.5473 17.738 30.0996 18.2903 30.0996H48.7098C49.262 30.0996 49.7098 30.5473 49.7098 31.0996V63.4996C49.7098 64.0519 49.262 64.4996 48.7098 64.4996H18.2903C17.738 64.4996 17.2903 64.0519 17.2903 63.4996V31.0996Z"
                                fill="#304FFD"
                              />
                              <path
                                d="M40.6533 41.7275C40.7643 41.4409 40.9309 41.2259 41.153 41.0825C41.3874 40.9272 41.6465 40.8496 41.9303 40.8496C42.2881 40.8496 42.5904 40.9571 42.8372 41.1721C43.0963 41.3871 43.2259 41.6797 43.2259 42.05C43.2259 42.2292 43.1888 42.4263 43.1148 42.6413L39.2652 52.8359C39.1541 53.1225 38.9567 53.3495 38.6729 53.5167C38.4015 53.672 38.0992 53.7496 37.7661 53.7496C37.4329 53.7496 37.1306 53.672 36.8592 53.5167C36.5877 53.3495 36.3965 53.1225 36.2854 52.8359L33.5278 45.2929L30.6961 52.8359C30.585 53.1225 30.3938 53.3495 30.1223 53.5167C29.8509 53.672 29.5486 53.7496 29.2155 53.7496C28.8947 53.7496 28.5924 53.672 28.3086 53.5167C28.0371 53.3495 27.8459 53.1225 27.7348 52.8359L23.8852 42.6413C23.8112 42.4382 23.7742 42.2471 23.7742 42.0679C23.7742 41.6977 23.9099 41.405 24.1813 41.19C24.4528 40.9631 24.7736 40.8496 25.1437 40.8496C25.4399 40.8496 25.7051 40.9272 25.9396 41.0825C26.1864 41.2259 26.3653 41.4409 26.4763 41.7275L29.3265 49.6646L32.2878 41.7634C32.3988 41.4767 32.5715 41.2557 32.806 41.1004C33.0527 40.9452 33.3119 40.8675 33.5833 40.8675C33.8671 40.8675 34.1262 40.9452 34.3606 41.1004C34.5951 41.2557 34.7678 41.4827 34.8788 41.7813L37.7105 49.8079L40.6533 41.7275Z"
                                fill="white"
                              />
                            </svg>
                          </div>
                          <h4 class="md:text-base text-sm  dark:text-white font-semibold mt-2">
                            Project Brief
                          </h4>
                          <span class="text-base text-bgray-600 dark:text-bgray-50">1.4 MB</span>
                        </div>
                        <div
                          class="flex flex-col items-center w-24 h-24 lg:w-44 lg:h-44"
                        >
                          <div class="w-full flex justify-center">
                            <svg
                              width="67"
                              height="86"
                              viewBox="0 0 67 86"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                fill-rule="evenodd"
                                clip-rule="evenodd"
                                d="M5.4032 0H46.9892L67 19.8123V80.625C67 83.5946 64.5796 86 61.5968 86H5.4032C2.42052 86 0 83.5946 0 80.625V5.37496C0 2.40536 2.4208 0 5.4032 0Z"
                                fill="white"
                              />
                              <path
                                d="M5.4032 0.5H46.7835L66.5 20.0208V80.625C66.5 83.3158 64.306 85.5 61.5968 85.5H5.4032C2.69405 85.5 0.5 83.3158 0.5 80.625V5.37496C0.5 2.68413 2.6943 0.5 5.4032 0.5Z"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M65.9198 20.4252H51.2864C48.6265 20.4252 46.468 18.2802 46.468 15.6368V1.0752"
                                stroke="#E8E9EB"
                              />
                              <path
                                d="M20.2338 64.4996C19.7451 64.4996 19.276 64.3525 18.8757 64.0751C17.4136 63.058 17.2169 61.9264 17.3096 61.1555C17.5652 59.0354 20.3926 56.8164 25.7157 54.5557C27.8281 50.2635 29.838 44.9751 31.036 40.5566C29.6343 37.7281 28.2719 34.0584 29.2649 31.9058C29.6132 31.1518 30.0472 30.5736 30.8577 30.3236C31.1779 30.2246 31.9869 30.0996 32.2847 30.0996C32.9925 30.0996 33.6147 30.9448 34.0558 31.4657C34.4701 31.9553 35.4097 32.9932 33.5319 40.3235C35.4252 43.9489 38.1078 47.6421 40.6781 50.1711C42.5194 49.8624 44.1037 49.7048 45.3945 49.7048C47.594 49.7048 48.9269 50.1802 49.4704 51.1595C49.9198 51.9694 49.7359 52.9162 48.9226 53.9723C48.1403 54.9867 47.0616 55.5233 45.8046 55.5233C44.0967 55.5233 42.1079 54.5231 39.8901 52.5476C35.9055 53.3199 31.2523 54.6976 27.491 56.2226C26.3168 58.5327 25.1918 60.3936 24.144 61.7584C22.7044 63.6271 21.4628 64.4996 20.2338 64.4996ZM23.9727 57.8243C20.9712 59.3883 19.7479 60.6736 19.6594 61.3977C19.6453 61.5175 19.6074 61.8326 20.2647 62.2988C20.474 62.2376 21.696 61.7206 23.9727 57.8243ZM43.1262 52.0398C44.2709 52.8563 44.5504 53.2691 45.299 53.2691C45.6276 53.2691 46.5644 53.2561 46.9984 52.6948C47.2077 52.4226 47.2892 52.2481 47.3215 52.1544C47.1487 52.0697 46.9198 51.8978 45.6712 51.8978C44.9619 51.8991 44.07 51.9278 43.1262 52.0398ZM32.6344 43.4684C31.6301 46.6902 30.3043 50.1684 28.8787 53.3186C31.8141 52.2625 35.0052 51.3405 38.0025 50.688C36.1064 48.6461 34.2117 46.0963 32.6344 43.4684ZM31.7818 32.4489C31.6442 32.4918 29.9138 34.7369 31.9167 36.6369C33.2496 33.8826 31.8422 32.4306 31.7818 32.4489Z"
                                fill="#E2574C"
                              />
                            </svg>
                          </div>
                          <h4 class="md:text-base text-sm  dark:text-white font-semibold mt-2">
                            Brand Styles Guide
                          </h4>
                          <span class="text-base text-bgray-600 dark:text-bgray-50">1.4 MB</span>
                        </div>
                      </div>
                    </div>
                    <div class="col-span-3 2xl:block hidden pl-11 pt-14">
                      <div class="flex flex-col items-center">
                        <svg
                          width="120"
                          height="120"
                          viewBox="0 0 120 120"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M7.56578 12.9268H36.2647C38.1443 12.9268 39.8804 13.9307 40.8183 15.5595L45.5417 22.0121C46.4796 23.6408 48.216 24.6448 50.0953 24.6448H120V98.3153C120 102.184 116.863 105.321 112.994 105.321H7.00587C3.13675 105.321 0 102.184 0 98.3153V32.8171C0 27.4018 0.836656 22.0188 2.4805 16.8589C3.08269 14.5432 5.17317 12.9268 7.56578 12.9268Z"
                            fill="#4ADE80"
                          />
                          <path
                            d="M103.16 23.4395H10.9199V62.4043H103.16V23.4395Z"
                            fill="#EBF0F3"
                          />
                          <path
                            d="M114.746 16.4297H85.825C83.7683 16.4297 81.9005 17.6297 81.0459 19.5003L76.097 30.3312C75.2421 32.2019 73.3746 33.4019 71.3179 33.4019H0V100.067C0 103.936 3.13675 107.072 7.00587 107.072H112.994C116.863 107.072 120 103.936 120 100.067V21.6841C120 18.7823 117.647 16.4297 114.746 16.4297Z"
                            fill="#22C55E"
                          />
                        </svg>
                        <h3 class="text-2xl text-bgray-600 dark:text-white font-semibold">
                          Projects
                        </h3>
                      </div>
                      <div>
                        <h4
                          class="font-semibold text-base uppercase text-bgray-900 dark:text-white mb-3"
                        >
                          Info
                        </h4>
                        <ul class="space-y-6">
                          <li class="flex justify-between">
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Type</span
                            >
                            <span
                              class="text-bgray-700 dark:text-bgray-50 text-base font-medium text-left"
                              >Folder</span
                            >
                          </li>
                          <li class="flex justify-between">
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Size</span
                            >
                            <span
                              class="text-bgray-700 dark:text-bgray-50 text-base font-medium text-left"
                              >500 MB</span
                            >
                          </li>
                          <li class="flex justify-between">
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Owner</span
                            >
                            <span
                              class="text-bgray-700 dark:text-bgray-50 text-base font-medium text-left"
                              >Marketchainx.</span
                            >
                          </li>
                          <li class="flex justify-between">
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Location</span
                            >
                            <span
                              class="text-bgray-700 dark:text-bgray-50 text-base font-medium text-left"
                              >My Files</span
                            >
                          </li>
                          <li class="flex justify-between">
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Modified</span
                            >
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Sep 17, 2020 4:25</span
                            >
                          </li>
                          <li class="flex justify-between">
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Created</span
                            >
                            <span class="text-bgray-700 dark:text-white text-base font-medium"
                              >Sep 10, 2020 2:25</span
                            >
                          </li>
                        </ul>
                      </div>
                      <div class="pt-7 border-t border-bgray-300 mt-8">
                        <h3
                          class="text-base font-semibold text-bgray-900 dark:text-white uppercase mb-4"
                        >
                          Settings
                        </h3>
                        <div class="flex flex-col space-y-5">
                          <div class="flex items-center justify-between">
                            <span
                              class="text-base font-medium text-bgray-800 dark:text-white capitalize"
                              id="availability-label"
                              >File Sharing</span
                            >
                            <button
                              type="button"
                              class="switch-btn text-center relative inline-flex h-5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none"
                              role="switch"
                              aria-checked="false"
                              aria-labelledby="availability-label"
                              aria-describedby="availability-description"
                            >
                              <span
                                aria-hidden="true"
                                class="translate-x-5 pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                              ></span>
                            </button>
                          </div>
                          <div class="flex items-center justify-between">
                            <span
                              class="text-base font-medium dark:text-white text-bgray-800 capitalize"
                              id="availability-label"
                              >Backup</span
                            >

                            <button
                              type="button"
                              class="switch-btn text-center bg-gray-200 relative inline-flex h-5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-0 active"
                              role="switch"
                              aria-checked="false"
                              aria-labelledby="availability-label"
                              aria-describedby="availability-description"
                            >
                              <span
                                aria-hidden="true"
                                class="translate-x-0 pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                              ></span>
                            </button>
                          </div>
                          <div class="flex items-center justify-between">
                            <span
                              class="text-base font-medium dark:text-white text-bgray-800 capitalize"
                              id="availability-label"
                              >Sync</span
                            >

                            <button
                              type="button"
                              class="switch-btn text-center bg-gray-200 relative inline-flex h-2/5 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-0"
                              role="switch"
                              aria-checked="false"
                              aria-labelledby="availability-label"
                              aria-describedby="availability-description"
                            >
                              <span
                                aria-hidden="true"
                                class="translate-x-0 pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"
                              ></span>
                            </button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- Payments -->
                <div id="tab4" class="tab-pane">
                  <!-- Cards -->
                  <div>
                    <h3 class="text-2xl font-bold pb-5 text-bgray-900 dark:text-white">
                      Payment and Billing
                    </h3>
                    <div
                      class="grid 2xl:grid-cols-3 sm:grid-cols-2 grid-cols-1 2xl:gap-10 gap-5 pb-14"
                    >
                      <div class="relative p-6 bg-gray-100 dark:bg-darkblack-500 rounded-lg">
  <div class="flex gap-x-2 mb-5">
    <img src="assets/images/payments/visa.svg" alt="Visa" />
    <img src="assets/images/payments/master.svg" alt="MasterCard" />
    <img src="assets/images/payments/ae.svg" alt="American Express" />
  </div>
  <h4 class="text-base font-bold text-bgray-900 dark:text-white mb-2">
    Credit or Debit Card
  </h4>
  <p class="text-sm dark:text-bgray-50">
    <a href="./recharge.php" class="text-blue-600 dark:text-blue-400 hover:underline">Click here to recharge</a> using your Credit or Debit card. We offer payment processing software for e-commerce websites and mobile applications, supporting deposits in <strong>Forex</strong>, <strong>Crypto</strong>, and <strong>Stocks</strong>.
  </p>
  <button class="absolute top-5 right-5">
    <svg
      class="stroke-bgray-600 dark:stroke-bgray-50"
      width="24"
      height="25"
      viewBox="0 0 24 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M12 14.2037C10.8954 14.2037 10 13.3074 10 12.2019C10 11.0964 10.8954 10.2002 12 10.2002C13.1046 10.2002 14 11.0964 14 12.2019C14 13.3074 13.1046 14.2037 12 14.2037Z"
        stroke-width="1.5"
      />
      <path
        d="M20 14.2037C18.8954 14.2037 18 13.3074 18 12.2019C18 11.0964 18.8954 10.2002 20 10.2002C21.1046 10.2002 22 11.0964 22 12.2019C22 13.3074 21.1046 14.2037 20 14.2037Z"
        stroke-width="1.5"
      />
      <path
        d="M4 14.2037C2.89543 14.2037 2 13.3074 2 12.2019C2 11.0964 2.89543 10.2002 4 10.2002C5.10457 10.2002 6 11.0964 6 12.2019C6 13.3074 5.10457 14.2037 4 14.2037Z"
        stroke-width="1.5"
      />
    </svg>
  </button>
</div>

                      
                      
                      
                      
                      <div class="relative p-6 bg-gray-100 dark:bg-darkblack-500 rounded-lg">
  <div class="mb-5">
    <img src="assets/images/payments/paypal.svg" alt="PayPal" />
  </div>
  <h4 class="text-base font-bold text-bgray-900 dark:text-white mb-2">
    PayPal
  </h4>
  <p class="text-sm dark:text-bgray-50">
    <a href="./recharge.php" class="text-blue-600 dark:text-blue-400 hover:underline">Click here to recharge</a> using PayPal. We offer secure and efficient payment processing for e-commerce websites and mobile applications, supporting deposits in <strong>Forex</strong>, <strong>Crypto</strong>, and <strong>Stocks</strong>.
  </p>
  <button class="absolute top-5 right-5">
    <svg
      class="stroke-bgray-600 dark:stroke-bgray-50"
      width="24"
      height="25"
      viewBox="0 0 24 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M12 14.2037C10.8954 14.2037 10 13.3074 10 12.2019C10 11.0964 10.8954 10.2002 12 10.2002C13.1046 10.2002 14 11.0964 14 12.2019C14 13.3074 13.1046 14.2037 12 14.2037Z"
        stroke-width="1.5"
      />
      <path
        d="M20 14.2037C18.8954 14.2037 18 13.3074 18 12.2019C18 11.0964 18.8954 10.2002 20 10.2002C21.1046 10.2002 22 11.0964 22 12.2019C22 13.3074 21.1046 14.2037 20 14.2037Z"
        stroke-width="1.5"
      />
      <path
        d="M4 14.2037C2.89543 14.2037 2 13.3074 2 12.2019C2 11.0964 2.89543 10.2002 4 10.2002C5.10457 10.2002 6 11.0964 6 12.2019C6 13.3074 5.10457 14.2037 4 14.2037Z"
        stroke-width="1.5"
      />
    </svg>
  </button>
</div>

                      
                      
                      
                     
                     
                     
                      <div class="relative p-6 bg-gray-100 dark:bg-darkblack-500 rounded-lg">
  <div class="mb-5">
    <img src="assets/images/payments/ae-l.svg" alt="American Express" />
  </div>
  <h4 class="text-base font-bold text-bgray-900 dark:text-white mb-2">
    American Express
  </h4>
  <p class="text-sm dark:text-bgray-50">
    <a href="./recharge.php" class="text-blue-600 dark:text-blue-400 hover:underline">Click here to recharge</a> using American Express. We offer secure payment processing for e-commerce websites and mobile applications, allowing deposits in <strong>Forex</strong>, <strong>Crypto</strong>, and <strong>Stocks</strong>.
  </p>
  <button class="absolute top-5 right-5">
    <svg
      class="stroke-bgray-600 dark:stroke-bgray-50"
      width="24"
      height="25"
      viewBox="0 0 24 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M12 14.2037C10.8954 14.2037 10 13.3074 10 12.2019C10 11.0964 10.8954 10.2002 12 10.2002C13.1046 10.2002 14 11.0964 14 12.2019C14 13.3074 13.1046 14.2037 12 14.2037Z"
        stroke-width="1.5"
      />
      <path
        d="M20 14.2037C18.8954 14.2037 18 13.3074 18 12.2019C18 11.0964 18.8954 10.2002 20 10.2002C21.1046 10.2002 22 11.0964 22 12.2019C22 13.3074 21.1046 14.2037 20 14.2037Z"
        stroke-width="1.5"
      />
      <path
        d="M4 14.2037C2.89543 14.2037 2 13.3074 2 12.2019C2 11.0964 2.89543 10.2002 4 10.2002C5.10457 10.2002 6 11.0964 6 12.2019C6 13.3074 5.10457 14.2037 4 14.2037Z"
        stroke-width="1.5"
      />
    </svg>
  </button>
</div>

                      <div class="relative p-6 bg-gray-100 dark:bg-darkblack-500 rounded-lg">
                        <div class="mb-5">
                          <img src="assets/images/payments/amazon.svg" class="block dark:hidden" alt="" />
                          <img src="assets/images/payments/amazon-white.svg" class="hidden dark:block" alt="" />
                        </div>
                        <h4 class="text-base font-bold text-bgray-900 dark:text-white mb-2">
                          Amazon
                        </h4>
                        <p class="text-sm dark:text-bgray-50">
                          Offers payment processing software for e-commerce
                          websites and mobile applications.
                        </p>
                        <button class="absolute top-5 right-5">
                          <svg
                          class="stroke-bgray-600 dark:stroke-bgray-50 "
                            width="24"
                            height="25"
                            viewBox="0 0 24 25"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M12 14.2037C10.8954 14.2037 10 13.3074 10 12.2019C10 11.0964 10.8954 10.2002 12 10.2002C13.1046 10.2002 14 11.0964 14 12.2019C14 13.3074 13.1046 14.2037 12 14.2037Z"
                              
                              stroke-width="1.5"
                            />
                            <path
                              d="M20 14.2037C18.8954 14.2037 18 13.3074 18 12.2019C18 11.0964 18.8954 10.2002 20 10.2002C21.1046 10.2002 22 11.0964 22 12.2019C22 13.3074 21.1046 14.2037 20 14.2037Z"
                              
                              stroke-width="1.5"
                            />
                            <path
                              d="M4 14.2037C2.89543 14.2037 2 13.3074 2 12.2019C2 11.0964 2.89543 10.2002 4 10.2002C5.10457 10.2002 6 11.0964 6 12.2019C6 13.3074 5.10457 14.2037 4 14.2037Z"
                              
                              stroke-width="1.5"
                            />
                          </svg>
                        </button>
                      </div>
                      <div class="relative p-6 bg-gray-100 dark:bg-darkblack-500 rounded-lg">
                        <div class="mb-5">
                          <img
                            src="assets/images/payments/payoner.svg" class="block dark:hidden"
                            alt=""
                          />
                          <img src="assets/images/payments/payoneer-white.svg" class="hidden dark:block" alt="" />
                        </div>
                        <h4 class="text-base font-bold text-bgray-900 dark:text-white mb-2">
                          Payoner
                        </h4>
                        <p class="text-sm dark:text-white">
                          Offers payment processing software for e-commerce
                          websites and mobile applications.
                        </p>
                        <button class="absolute top-5 right-5">
                          <svg
                          class="stroke-bgray-600 dark:stroke-bgray-50 "
                            width="24"
                            height="25"
                            viewBox="0 0 24 25"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M12 14.2037C10.8954 14.2037 10 13.3074 10 12.2019C10 11.0964 10.8954 10.2002 12 10.2002C13.1046 10.2002 14 11.0964 14 12.2019C14 13.3074 13.1046 14.2037 12 14.2037Z"
                              
                              stroke-width="1.5"
                            />
                            <path
                              d="M20 14.2037C18.8954 14.2037 18 13.3074 18 12.2019C18 11.0964 18.8954 10.2002 20 10.2002C21.1046 10.2002 22 11.0964 22 12.2019C22 13.3074 21.1046 14.2037 20 14.2037Z"
                              
                              stroke-width="1.5"
                            />
                            <path
                              d="M4 14.2037C2.89543 14.2037 2 13.3074 2 12.2019C2 11.0964 2.89543 10.2002 4 10.2002C5.10457 10.2002 6 11.0964 6 12.2019C6 13.3074 5.10457 14.2037 4 14.2037Z"
                              
                              stroke-width="1.5"
                            />
                          </svg>
                        </button>
                      </div>
                      <div
                        class="flex modal-open cursor-pointer flex-col justify-center items-center border-2 border-dashed border-bgray-500 rounded-lg p-6"
                      >
                        <svg
                          width="60"
                          height="60"
                          viewBox="0 0 24 24"
                          fill="none"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <path
                            d="M13.5005 9.25H2.00049C1.59049 9.25 1.25049 8.91 1.25049 8.5C1.25049 8.09 1.59049 7.75 2.00049 7.75H13.5005C13.9105 7.75 14.2505 8.09 14.2505 8.5C14.2505 8.91 13.9105 9.25 13.5005 9.25Z"
                            fill="#718096"
                          />
                          <path
                            d="M8.00049 17.25H6.00049C5.59049 17.25 5.25049 16.91 5.25049 16.5C5.25049 16.09 5.59049 15.75 6.00049 15.75H8.00049C8.41049 15.75 8.75049 16.09 8.75049 16.5C8.75049 16.91 8.41049 17.25 8.00049 17.25Z"
                            fill="#718096"
                          />
                          <path
                            d="M14.5005 17.25H10.5005C10.0905 17.25 9.75049 16.91 9.75049 16.5C9.75049 16.09 10.0905 15.75 10.5005 15.75H14.5005C14.9105 15.75 15.2505 16.09 15.2505 16.5C15.2505 16.91 14.9105 17.25 14.5005 17.25Z"
                            fill="#718096"
                          />
                          <path
                            d="M17.5605 21.25H6.44049C2.46049 21.25 1.25049 20.05 1.25049 16.11V7.89C1.25049 3.95 2.46049 2.75 6.44049 2.75H13.5005C13.9105 2.75 14.2505 3.09 14.2505 3.5C14.2505 3.91 13.9105 4.25 13.5005 4.25H6.44049C3.30049 4.25 2.75049 4.79 2.75049 7.89V16.1C2.75049 19.2 3.30049 19.74 6.44049 19.74H17.5505C20.6905 19.74 21.2405 19.2 21.2405 16.1V12.02C21.2405 11.61 21.5805 11.27 21.9905 11.27C22.4005 11.27 22.7405 11.61 22.7405 12.02V16.1C22.7505 20.05 21.5405 21.25 17.5605 21.25Z"
                            fill="#718096"
                          />
                          <path
                            d="M22.0005 7H16.5005C16.0905 7 15.7505 6.66 15.7505 6.25C15.7505 5.84 16.0905 5.5 16.5005 5.5H22.0005C22.4105 5.5 22.7505 5.84 22.7505 6.25C22.7505 6.66 22.4105 7 22.0005 7Z"
                            fill="#718096"
                          />
                          <path
                            d="M19.2505 9.75C18.8405 9.75 18.5005 9.41 18.5005 9V3.5C18.5005 3.09 18.8405 2.75 19.2505 2.75C19.6605 2.75 20.0005 3.09 20.0005 3.5V9C20.0005 9.41 19.6605 9.75 19.2505 9.75Z"
                            fill="#718096"
                          />
                        </svg>
                        <span class="text-lg text-bgray-600 font-medium"
                          >Add wallet</span
                        >
                      </div>
                    </div>
                    </a>
                  </div>
                  <!-- Slider -->
                  <div
                    class="lg:border-t border-bgray-300 dark:border-darkblack-400 lg:px-7 lg:py-10 px-0 py-0"
                  >
                    <div class="lg:flex justify-between items-center">
                      <div
                        class="2xl:w-[400px] lg:w-[250px] w-full flex flex-col items-center"
                      >
                        <div class="flex justify-between mb-4 w-full">
                          <h4 class="text-bgray-900 font-bold text-lg dark:text-white">
                            My Wallet
                          </h4>
                          <button>
                            <svg
                              width="20"
                              height="5"
                              viewBox="0 0 20 5"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                d="M8.90742 2.3381C8.90742 2.95199 9.40507 3.44964 10.019 3.44964C10.6328 3.44964 11.1305 2.95199 11.1305 2.3381C11.1305 1.72422 10.6328 1.22656 10.019 1.22656C9.40507 1.22656 8.90742 1.72422 8.90742 2.3381Z"
                                stroke="#CBD5E0"
                                stroke-width="2"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                              />
                              <path
                                d="M1.12665 2.3381C1.12665 2.95199 1.62431 3.44964 2.23819 3.44964C2.85208 3.44964 3.34973 2.95199 3.34973 2.3381C3.34973 1.72422 2.85208 1.22656 2.23819 1.22656C1.62431 1.22656 1.12665 1.72422 1.12665 2.3381Z"
                                stroke="#CBD5E0"
                                stroke-width="2"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                              />
                              <path
                                d="M16.6882 2.3381C16.6882 2.95199 17.1858 3.44964 17.7997 3.44964C18.4136 3.44964 18.9113 2.95199 18.9113 2.3381C18.9113 1.72422 18.4136 1.22656 17.7997 1.22656C17.1858 1.22656 16.6882 1.72422 16.6882 2.3381Z"
                                stroke="#CBD5E0"
                                stroke-width="2"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                              />
                            </svg>
                          </button>
                        </div>
                        <div class="card-slider w-full relative">
                          <div class="m-0 md:w-[400px] w-[280px]">
                            <img
                              src="assets/images/payments/pa-card.svg"
                              class="w-full"
                              alt="card"
                            />
                          </div>
                          <div class="m-0 md:w-[400px] w-[280px]">
                            <img
                              src="assets/images/payments/pa-card.svg"
                              class="w-full"
                              alt="card"
                            />
                          </div>
                          <div class="m-0 md:w-[400px] w-[280px]">
                            <img
                              src="assets/images/payments/pa-card.svg"
                              class="w-full"
                              alt="card"
                            />
                          </div>
                        </div>
                      </div>
                      <div
                        class="w-[4px] h-[220px] bg-bgray-200 dark:bg-darkblack-400 lg:block hidden rounded-lg"
                      ></div>
                     
                     
                    </div>
                  </div>
                </div>
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
               <!-- Faq -->
<div id="tab5" class="tab-pane">
  <div>
    <h3 class="text-2xl font-bold text-bgray-900 dark:text-white">FAQ</h3>
    <div>
      <!-- Faq 1 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-minus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm font-bold">
            What is cryptocurrency trading?
          </h2>
        </div>
        <div style="max-height: 164px" class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Cryptocurrency trading involves buying and selling digital assets like Bitcoin and Ethereum on specialized exchanges.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 2 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            How does forex trading work?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Forex trading involves the exchange of global currencies in a decentralized market where traders speculate on the price movements of currency pairs.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 3 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            What are the risks associated with stock trading?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Stock trading carries risks such as market volatility, liquidity challenges, and economic uncertainties which can impact your investments.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 4 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            What is the difference between crypto, forex, and stocks?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Cryptocurrencies are digital assets, forex trading involves currency pairs, and stocks represent equity ownership in companies.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 5 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            Which market is generally more volatile: crypto or forex?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Typically, the crypto market is more volatile due to its emerging nature and lower liquidity compared to the forex market.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 6 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            What strategies are effective for crypto trading?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Effective strategies include technical analysis, sound risk management, and staying updated with market trends and news.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 7 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            How can I start trading in the forex market?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Start by opening an account with a regulated forex broker, practicing with a demo account, and developing a well-thought-out trading plan.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 8 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            What factors influence stock market movements?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Market movements are driven by economic data, corporate earnings, global political events, and investor sentiment.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 9 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            Are there specific tools for analyzing market trends?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Yes, traders use charting software, technical indicators, and real-time news feeds to monitor trends in crypto, forex, and stock markets.
              </p>
            </div>
          </div>
        </div>
      </div>
      <!-- Faq 10 -->
      <div class="transition">
        <div class="accordion-header border-b border-bgray-300 dark:border-darkblack-400 cursor-pointer transition flex space-x-5 items-center h-16">
          <i class="fas fa-plus text-success-300 text-xl"></i>
          <h2 class="title transition-all text-bgray-900 dark:text-white md:text-lg text-sm">
            How important is risk management in trading?
          </h2>
        </div>
        <div class="accordion-content lg:pl-8 pl-4 pt-0 overflow-hidden max-h-0 space-y-4">
          <div class="flex flex-row py-6">
            <div class="flex h-[93] w-1 bg-success-300 rounded-lg"></div>
            <div class="flex-1">
              <p class="text-[#9AA2B1] pl-4 lg:text-base text-xs lg:leading-7">
                Risk management is crucial to safeguard your investments, including using stop-loss orders and diversifying your trading portfolio.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

                <!-- Security Password -->
               
               
              <!-- Privacy Policy -->
<div id="tab7" class="tab-pane">
  <div>
    <h3 class="text-2xl font-bold text-bgray-900 dark:text-white mb-3">
      Privacy Policy
    </h3>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        Introduction
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        This Privacy Policy outlines how marketchainx.com collects, uses, maintains, and discloses information gathered from users of our website ("Users").
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        1. Information Collection
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        We may collect personal identification information from Users in various ways, including when Users visit our site, register, place an order, subscribe to our newsletter, respond to surveys, fill out forms, and engage with other activities, services, features, or resources we make available on our Site. This information may include your name, email address, mailing address, phone number, and credit card information.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        2. How We Use Collected Information
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base mb-4">
        marketchainx.com may use your personal information for the following purposes:
      </p>
      <ul class="list-disc pl-8 text-[#9AA2B1] dark:text-white text-base">
        <li>To personalize user experience</li>
        <li>To improve our site</li>
        <li>To process transactions</li>
        <li>To send periodic emails</li>
      </ul>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        3. How We Protect Your Information
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        We adopt robust data collection, storage, and processing practices along with advanced security measures to protect against unauthorized access, alteration, disclosure, or destruction of your personal information, username, password, transaction information, and data stored on our Site.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        4. Sharing Your Personal Information
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        We do not sell, trade, or rent Users' personal identification information to others. We may share aggregated demographic information that is not linked to any personal identification details with our business partners, trusted affiliates, and advertisers.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        5. Third Party Websites
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        Our Site may contain links to third-party websites. We are not responsible for the privacy practices or content of those sites.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        6. Changes to This Privacy Policy
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        marketchainx.com reserves the right to update this Privacy Policy at any time. When we do, we will revise the updated date at the bottom of this page. We encourage Users to review this page periodically.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        7. Your Acceptance of These Terms
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        By using our Site, you acknowledge that you have read and agreed to this Privacy Policy. If you do not agree, please do not use our Site.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        8. Contacting Us
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        If you have any questions about this Privacy Policy or our practices, please contact us at:
        <br><br>
        <strong>marketchainx.com</strong>
        <br>
        <a href="mailto:support@marketchainx.com" class="text-success-300">support@marketchainx.com</a>
      </p>
    </article>
    <blockquote class="px-7 py-5 bg-bgray-100 dark:bg-darkblack-500 rounded-lg mb-8 text-lg text-bgray-800 dark:text-white">
      Authority Certification: This document certifies that the crypto exchange platform operates under strict regulations and guidelines set forth by financial regulatory authorities.
    </blockquote>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        9. License and Registration
      </h4>
      <p class="text-base text-[#9AA2B1] dark:text-white mb-4">
        The exchange is registered under the following licenses:
      </p>
      <ul class="list-disc pl-8 text-[#9AA2B1] dark:text-white text-base">
        <li>Financial Services License Number: 782378299</li>
        <li>Crypto Exchange Operating Permit: JSDJL-1234-EFGH-5678</li>
      </ul>
      <p class="text-[#9AA2B1] dark:text-white text-base mt-4">
        Our licensing demonstrates our commitment to the highest standards of financial regulation and operational integrity.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        10. Compliance and Security
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        We adhere to stringent security measures including advanced encryption, multi-factor authentication (MFA), intrusion detection systems (IDS), and regular security audits. Our compliance with AML (Anti-Money Laundering) and KYC (Know Your Customer) regulations ensures the protection of user funds and data.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        11. Transaction Monitoring
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        Our system employs advanced algorithms and machine learning to monitor transactions in real-time, detect anomalies, and prevent fraudulent activities such as market manipulation.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        12. User Protection
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        We provide insurance coverage for digital assets held on our platform to mitigate risks from cyberattacks or internal malfeasance. Additionally, we offer educational resources and enforce strict internal controls along with regular employee training to enhance account security.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        13. Regulatory Compliance
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        We work closely with regulatory authorities and legal experts to ensure our policies remain compliant with evolving global and local standards, including adhering to international frameworks such as FATF recommendations.
      </p>
    </article>
    <article class="mb-8">
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        14. Audit and Verification
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        Regular audits are conducted by independent third-party firms to verify our compliance with regulatory requirements. These audits review our financial statements, operational procedures, and security protocols to ensure transparency and continuous improvement.
      </p>
    </article>
    <article>
      <h4 class="text-bgray-800 dark:text-white text-lg font-bold mb-2">
        15. Transparency and Reporting
      </h4>
      <p class="text-[#9AA2B1] dark:text-white text-base">
        We are committed to maintaining transparency with our users. Regular reports detailing our compliance efforts, security measures, and financial performance are published. In addition, users can monitor their transaction history and account activity in real-time, ensuring accountability and trust.
      </p>
    </article>
  </div>
</div>

              </div>
            </div>
            <!-- write your code here-->
          </main>
        </div>
      </div>
    </div>
    <!-- layout end -->
    <!-- Modal -->
    <div
      class="modal hidden fixed inset-0 z-50 h-full overflow-y-auto flex items-center justify-center"
      id="multi-step-modal"
    >
      <div class="modal-overlay absolute inset-0 bg-gray-500 opacity-75 dark:bg-bgray-900 dark:opacity-50"></div>
      <div class="modal-content md:w-full max-w-3xl px-4">
        <div class="step-content step-1">
          <!-- My Content -->
          <div
            class="max-w-[750px] rounded-lg bg-white dark:bg-darkblack-600 p-6 pb-10 transition-all relative"
          >
            <header>
              <div>
                <h3 class="font-bold text-bgray-900 dark:text-white text-2xl mb-1">
                  Add new card
                </h3>
                <p class="text-sm text-bgray-600 dark:text-darkblack-300">
                  Manage where you collect taxes and duties. Check with a tax
                  expert if you're unsure where you have a tax obligation.
                </p>
              </div>
              <div class="absolute top-0 right-0 pt-5 pr-5">
                <button
                  type="button"
                  id="step-1-cancel"
                  class="rounded-md bg-white dark:bg-darkblack-500 focus:outline-none"
                >
                  <span class="sr-only">Close</span>
                  <!-- Cross Icon -->
                  <svg
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M6 6L18 18M6 18L18 6L6 18Z"
                      stroke="#747681"
                      stroke-width="2"
                      stroke-linecap="round"
                      stroke-linejoin="round"
                    />
                  </svg>
                </button>
              </div>
            </header>
            <div class="pt-4 pb-10">
              <table class="min-w-full ">
                <thead class="border-t border-b border-bgray-300 dark:border-darkblack-500">
                  <tr class="dark:bg-darkblack-600">
                    <th
                      scope="col"
                      class="py-4 pl-4 pr-3 dark:text-white text-left text-sm font-medium text-bgray-600 sm:pl-6"
                    >
                      Country or region
                    </th>
                    <th
                      scope="col"
                      class="px-3 py-4 dark:text-white text-left text-sm font-medium text-bgray-600"
                    >
                      Collecting
                    </th>
                    <th
                      scope="col"
                      class="px-3 py-4 dark:text-white text-left text-sm font-medium text-bgray-600"
                    >
                      Percentage
                    </th>
                  </tr>
                </thead>
                <tbody class="bg-white dark:bg-darkblack-600">
                  <tr class="border-b border-bgray-300 dark:border-darkblack-400">
                    <td
                      class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-gray-900 sm:pl-6"
                    >
                        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css">

                      <?php
require('connect.php'); // Include your database connection details

// Check if $SEshopmail is set
if (isset($SEshopmail)) {
    // Escape input to prevent SQL injection
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail);
    
    // Query to fetch user data based on email
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if exactly one user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Assuming the country field contains a country code like 'us', convert it to lowercase
        $country = strtolower($row['country']);
        
        // Build the flag image path dynamically
        $flag_path = "assets/images/flag/{$country}-sm.svg";
    } else {
        // If user not found or multiple users found, set default values
        $country = null;
        $flag_path = "assets/images/flag/default-sm.svg"; // You can set a default flag image here
    }
} else {
    // If $SEshopmail is not set, use default values
    $country = null;
    $flag_path = "assets/images/flag/default-sm.svg"; // Default flag image when email is not provided
}

// Close the database connection
mysqli_close($connection);
?>

<div class="flex gap-3 items-center">
    <!-- Dynamically display the country flag -->
    <img src="<?php echo $flag_path; ?>" alt="<?php echo $country ? ucfirst($country) . ' flag' : 'Default flag'; ?>" />
    <!-- Display the country code or a message if not found -->
    <span class="font-semibold text-sm text-bgray-900 dark:text-bgray-50 ">
        <?php echo $country ? ucfirst($country) : "User not found"; ?>
    </span>
</div>

                    </td>
                    <td
                      class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"
                    >
                      <div class="flex gap-2 items-center">
                        <span class="font-semibold text-sm text-bgray-900 dark:text-white"
                          >One time
                        </span>
                        <span
                          ><svg
                            width="24"
                            height="24"
                            viewBox="0 0 24 24"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              d="M7 10L12 14L17 10"
                              
                              stroke-width="1.5"
                              stroke-linecap="round"
                              stroke-linejoin="round"
                            />
                          </svg>
                        </span>
                      </div>
                    </td>
                    <td class="whitespace-nowrap px-3 py-4 text-sm">
                      <span class="font-semibold text-sm text-bgray-900 dark:text-white"
                        ><?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['percent'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>%</span
                      >
                    </td>
                  </tr>
                  <tr class="border-b border-bgray-300 dark:border-darkblack-400">
                    <td
                      class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-gray-900 sm:pl-6"
                    >
                      <div class="flex gap-3 items-center">
                        <svg class="stroke-bgray-900 dark:stroke-bgray-500" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M13.7857 6L14.5807 8.00215C13.8273 7.57761 12.9442 7.33333 12 7.33333C9.23858 7.33333 7 9.42267 7 12C7 12.4149 7.058 12.8171 7.16686 13.2M10.2143 18L9.41931 15.9978C10.1727 16.4224 11.0558 16.6667 12 16.6667C14.7614 16.6667 17 14.5773 17 12C17 11.5851 16.942 11.1829 16.8331 10.8" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                          <circle cx="12" cy="12" r="10" stroke-width="1.5"/>
                          </svg>
                          
                        <span class="font-semibold text-sm text-bgray-900 dark:text-white"
                          >Rest of History</span
                        >
                      </div>
                    </td>
                    <td class="whitespace-nowrap px-3 py-4">
                      <div class="flex gap-2 items-center ">
                        <span class="dark:text-white"> -</span>
                      </div>
                    </td>
                    <td class="whitespace-nowrap px-3 py-4">
                      <span class="dark:text-white">-</span>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
            <form action="#">
              <div class="grid grid-cols-2 gap-6">
                <div>
                  <label
                    for="chn"
                    class="block mb-3 text-base font-medium text-bgray-600 dark:text-darkblack-300"
                    >Email</label
                  >
                  <input
                    type="text"
                    class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white w-full font-medium border-0 rounded-xl p-4 h-14 placeholder:text-bgray-900 dark:placeholder:text-white"
                    placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['email'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                  />
                </div>
                <div>
                  <label
                    for="chn"
                    class="block mb-3 text-base font-medium text-bgray-600 dark:text-darkblack-300"
                    >Account Name</label
                  >
                  <input
                    type="text"
                    class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white w-full font-medium border-0 rounded-xl p-4 h-14 placeholder:text-bgray-900 dark:placeholder:text-white"
                    placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['fullname'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                  />
                </div>
                <div>
                  <label
                    for="chn"
                    class="block mb-3 text-base font-medium text-bgray-600 dark:text-darkblack-300"
                    >Valid Date</label
                  >
                  <input
                    type="text"
                    class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white w-full font-medium border-0 rounded-xl p-4 h-14 placeholder:text-bgray-900 dark:placeholder:text-white"
                    placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['date'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                  />
                </div>
                <div>
                  <label
                    for="chn"
                    class="block mb-3 text-base font-medium text-bgray-600 dark:text-darkblack-300"
                    >Phone</label
                  >
                  <input
                    type="text"
                    class="bg-bgray-50 dark:bg-darkblack-500 dark:text-white w-full font-medium border-0 rounded-xl p-4 h-14 placeholder:text-bgray-900 dark:placeholder:text-white"
                    placeholder="<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['phone'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>"
                  />
                </div>
              </div>
              <div class="flex justify-center pt-11">
                <button
                  class="bg-success-300 hover:bg-success-400 text-white font-semibold text-sm py-4 flex justify-center items-center rounded-lg px-20"
                >
                  Confirmed
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
    <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script>
      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });
    </script>
    <script>
      AOS.init();
    </script>
    <script src="assets/js/quill.min.js"></script>
    <script src="assets/js/chart.js"></script>
    <script src="assets/js/main.js"></script>
  </body>

<!--settings.php by /3.x [XR&CO'2014], Fri, 28 Mar 2025 18:01:38 GMT -->
</html>
