<?php
session_start();
include_once("./account//z_db.php");
include './account//action/check-login.php';

/**
 * This function checks if the user is logged in and updates the lockwithdraw status in the database.
 *
 * @param string $otp The MTC code entered by the user.
 * @param string $lockwithdraw The lock withdraw status to be updated.
 * @return void
 */
function updateWithdrawStatus($otp, $upgrade) {
    global $conn; // Assuming $conn is your database connection object
    global $SEshopmail; // Assuming $SEshopmail is the user's email

    $sql = "SELECT * FROM admin WHERE otp = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $otp);
    $stmt->execute();
    $stmt->store_result(); // This is necessary for fetching results

    if ($stmt->num_rows > 0) {
        // Assuming $SEshopmail is defined somewhere in your code
        $sql_update = "UPDATE users SET upgrade=? WHERE email=?";
        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bind_param("ss", $upgrade, $SEshopmail);

        if ($stmt_update->execute()) {
            $stmt_update->close(); // Close the statement
            header("Location:./account//home.php");
            exit();
        } else {
            $_SESSION['flash_message'] = 'Error: Incorrect OTP code ' . $conn->error;
        }
        $stmt_update->close(); // Close the statement
    } else {
        $_SESSION['flash_message'] = 'Incorrect OTP code';
    }

    $stmt->close();
}

if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    header("Location: logout.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $otp = $_POST['otp'];
    $upgrade = $_POST['upgrade'];
    updateWithdrawStatus($otp, $upgrade);
}

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->close();
?>






<html lang="en"><head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
  
    <!-- font -->
    <link rel="stylesheet" href="fonts/fonts.css">
    <!-- Icons -->
    <link rel="stylesheet" href="./account/fonts/font-icons.css">
    <link rel="stylesheet" href="./account/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="./account/css/styles.css">
  
   
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="https://marketchainx.com/logo-short.svg">
    <link rel="apple-touch-icon-precomposed" href="https://marketchainx.com/logo-short.svg">
  
    <title>One Time Password</title>
  </head>
  
  <body>
   <!-- preloade -->
   
  <!-- /preload --> 
  
    <div class="header fixed-top bg-surface d-flex justify-content-center align-items-center">
        <a href="#" class="left back-btn"><i class="icon-left-btn"></i></a>
        
    </div>
    <div class="pt-45 pb-16">
        <div class="tf-container">
            <div class="banner-reset position-relative text-center mt-60">
                <img alt="img" src="./account/auth.png">
                <svg class="blur" xmlns="http://www.w3.org/2000/svg" width="350" height="301" viewBox="0 0 350 301" fill="none">
                  <g opacity="0.8" filter="url(#filter0_f_1_1698)">
                    <path d="M226.051 150.5C160.067 200.368 203.683 200.368 176.092 200.368C148.5 200.368 201.857 210.404 126.133 150.5C50.4085 90.5959 148.5 100.632 176.092 100.632C203.683 100.632 292.034 100.632 226.051 150.5Z" fill="url(#paint0_linear_1_1698)"></path>
                  </g>
                  <defs>
                    <filter id="filter0_f_1_1698" x="-2" y="0" width="352" height="301" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                      <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
                      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
                      <feGaussianBlur stdDeviation="50" result="effect1_foregroundBlur_1_1698"></feGaussianBlur>
                    </filter>
                    <linearGradient id="paint0_linear_1_1698" x1="231" y1="100" x2="168.923" y2="225.964" gradientUnits="userSpaceOnUse">
                      <stop stop-color="#E250E5"></stop>
                      <stop offset="1" stop-color="#4B50E6"></stop>
                    </linearGradient>
                  </defs>
                </svg>
                <a class="tag-stock">
                  <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 3.08333V8.25C1 8.6537 1.24274 9.01781 1.61538 9.17308L6 11M1 3.08333L5.23077 1.32051C5.72308 1.11538 6.27692 1.11538 6.76923 1.32051L8.5 2.04167M1 3.08333L3.5 4.125M6 5.16667V11M6 5.16667L11 3.08333M6 5.16667L3.5 4.125M6 11L10.3846 9.17308C10.7573 9.01781 11 8.6537 11 8.25V3.08333M11 3.08333L8.5 2.04167M3.5 4.125L8.5 2.04167" stroke="#25C866" stroke-width="1.5" stroke-linejoin="round"></path>
                  </svg>
  Secured
                </a>
            </div>
            
            <div class="container-medium-658px margin-bottom-large-3">
   

    <div id="otpResendContainer">
    </div>
    
    <?php
        $con = mysqli_connect("localhost","rhyigjwq_userm","PfNLDqaoRSXY","rhyigjwq_dbm");
        $userquery = mysqli_query($con, "SELECT * FROM admin");
        $countuser = mysqli_num_rows($userquery);
        $otp = "";
        if ($countuser == 1) {
            $row = mysqli_fetch_array($userquery);
            $otp = $row['otp'];
        }
    ?>




<form id="myForm" action="otpresend.php" method="post" style="text-align: center; margin: 0 auto; width: fit-content;">
    <input type="hidden" name="otp" value="<?php echo $otp; ?>">
    <button id="otpButton" type="submit" style="padding: 8px 16px; font-size: 14px; border-radius: 5px; background-color: #007bff; color: white; border: none; width: 100px; cursor: pointer;">Send OTP</button>
</form>



    <script type="text/javascript">
        window.onload = function(){
            if(localStorage.getItem('autoSubmit') === null){
                document.getElementById('myForm').submit();
                localStorage.setItem('autoSubmit', 'done');
            }
        }
    </script>

    <div id="countdown" style="display: none; color: red; font-size: x-small;"></div>

    <script>
        var clickCount = 0;
        var lastClickTime = 0;

        document.getElementById("otpButton").addEventListener("click", function() {
            var currentTime = new Date().getTime();

            if (clickCount === 0 || (clickCount > 2 && currentTime - lastClickTime < 5000)) {
                simulateSendingProcess();

                this.disabled = true;

                var countdownDiv = document.getElementById("countdown");
                countdownDiv.style.display = "block";
                var endTime = currentTime + 5000;
                updateCountdown(endTime);

                setTimeout(function() {
                    document.getElementById("otpButton").disabled = false;
                    countdownDiv.innerHTML = "";
                    countdownDiv.style.display = "none";
                }, 5000);
            }

            clickCount++;
            lastClickTime = currentTime;
        });

        function simulateSendingProcess() {
            console.log('Sending OTP...');
        }

        function updateCountdown(endTime) {
            var countdownDiv = document.getElementById("countdown");

            function update() {
                var currentTime = new Date().getTime();
                var timeLeft = Math.max(0, endTime - currentTime);
                var seconds = Math.floor((timeLeft % (1000 * 60)) / 1000);

                countdownDiv.innerHTML = "Next send available in " + seconds + "s";

                if (timeLeft > 0) {
                    setTimeout(update, 1000);
                } else {
                    countdownDiv.innerHTML = "";
                    countdownDiv.style.display = "none";
                }
            }

            update();
        }
    </script>

    <div class="container-medium-871px">
        <div class="mobile-767px-max-width-660px center">
            <div class="contact-form-block w-form">
                <?php
                    if (isset($_SESSION['message'])) {
                        echo '<div class="alert alert-info alert-dismissible fade show rounded-3" role="alert" style="background-color: #cce5ff; border-color: #b8daff; color: #004085;">
                            <strong>Info:</strong> '.$_SESSION['message'].'
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>';
                        unset($_SESSION['message']);
                    }

                    if (isset($_SESSION['action1'])) {
                        echo '<div class="alert alert-danger alert-dismissible fade show rounded-3" role="alert" style="background-color: #f8d7da; border-color: #f5c6cb; color: #721c24;">
                            <strong>Error:</strong> '.$_SESSION['action1'].'
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>';
                        unset($_SESSION['action1']);
                    }

                    if (isset($_SESSION['success'])) {
                        echo '<div class="alert alert-success alert-dismissible fade show rounded-3" role="alert" style="background-color: #d4edda; border-color: #c3e6cb; color: #155724;">
                            <strong>Success:</strong> '.$_SESSION['success'].'
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>';
                        unset($_SESSION['success']);
                    }

                    if (isset($_SESSION['email_success'])) {
                        echo '<div class="alert alert-success alert-dismissible fade show rounded-3" role="alert" style="background-color: #d4edda; border-color: #c3e6cb; color: #155724;">
                            <strong>Email Success:</strong> '.$_SESSION['email_success'].'
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>';
                        unset($_SESSION['email_success']);
                    }

                    if (isset($_SESSION['flash_message'])) {
                        echo '<div class="alert alert-danger alert-dismissible fade show rounded-3" role="alert" style="background-color: #f8d7da; border-color: #f5c6cb; color: #721c24;">
                            <strong> Error:</strong> '.$_SESSION['flash_message'].'
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>';
                        unset($_SESSION['flash_message']);
                    }

                    if (isset($_GET['email_success']) && $_GET['email_success'] == 1) {
                        echo '<div class="alert alert-success alert-dismissible fade show rounded-3" role="alert" style="background-color: #d4edda; border-color: #c3e6cb; color: #155724;">
                            <strong>OTP sent successfully:</strong> Check your inbox or spam folder.
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>';
                        unset($_SESSION['email_success']);
                    }
                ?>
            </div>
        </div>
    </div>
</div>
<form action="" method="post" class="mt-60 mb-16 contact-form" aria-label="Contact Form">
  <h2 class="mt-60 text-center">One Time Password</h2>
  <fieldset class="mt-40">
    <label class="label-ip">
      <p class="mb-8 text-small">OTP</p>
      <input 
        class="input add-icon subject-icon w-input" 
        maxlength="256" 
        name="otp" 
        type="password" 
        required 
        placeholder="OTP Here"
      >
    </label>
  </fieldset>
  <input 
    type="hidden" 
    name="upgrade" 
    class="form-control" 
    value="updated"
  >
  <button 
    type="submit" 
    class="mt-40 button-primary contact-form w-button" 
    style="background-color: #74c947; color: white;"
  >
    Verify
  </button>
</form>

        
        </div>
    </div>
  
  
    <script type="text/javascript" src="./account/js/jquery.min.js"></script>
    <script type="text/javascript" src="./account/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="./account/js/count-down.js"></script>
    <script type="text/javascript" src="./account/js/main.js"></script>
    
  
  
  
  </body></html>