<?php
session_start();
include("dbconnection.php");
include("checklogin.php");
check_login();

// Process deletion if an ID is provided
if(isset($_GET['id'])) {
    $adminid = intval($_GET['id']);
    $msg = mysqli_query($con, "DELETE FROM users WHERE id='$adminid'");
    if($msg) {
        $_SESSION['toast'] = "Data deleted successfully";
    } else {
        $_SESSION['toast'] = "Error deleting data";
    }
    header("Location: manage-users.php");
    exit;
}

// Determine the current active page for nav highlighting
$activePage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en" x-data="{ sidebarOpen: false }">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Manage Users</title>
  <link rel="shortcut icon" type="image/png" href="assetss/images/logos/favicon.png">
  <!-- Tailwind CSS CDN -->
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  <!-- Boxicons CDN -->
  <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
  <!-- Alpine.js for interactivity -->
  <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.12.0/dist/cdn.min.js" defer></script>
  <style>
    /* Custom style for toast alert */
    #toast {
      transition: opacity 0.5s ease;
    }
  </style>
</head>
<body class="bg-gray-100 text-lg">
  <!-- Toast Alert -->
  <?php if(isset($_SESSION['toast'])): ?>
    <div id="toast" class="fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded shadow-lg z-50">
      <?php 
        echo $_SESSION['toast']; 
        unset($_SESSION['toast']);
      ?>
    </div>
  <?php endif; ?>

  <div class="flex min-h-screen">
    <!-- Mobile Sidebar -->
    <div x-show="sidebarOpen" class="fixed inset-0 z-40 flex md:hidden" role="dialog" aria-modal="true">
      <div x-show="sidebarOpen" x-transition.opacity class="fixed inset-0 bg-black bg-opacity-25" @click="sidebarOpen = false"></div>
      <div x-show="sidebarOpen" x-transition class="relative flex-1 flex flex-col max-w-xs w-full bg-white">
        <div class="absolute top-0 right-0 -mr-12 pt-2">
          <button @click="sidebarOpen = false" class="ml-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:bg-gray-600">
            <span class="sr-only">Close sidebar</span>
            <i class="bx bx-x text-2xl text-white"></i>
          </button>
        </div>
        <div class="p-6">
          <a href="index.php" class="block mb-8">
            <img src="assetss/images/logos/dark-logo.svg" alt="Logo" class="w-40">
          </a>
          <nav>
            <ul class="space-y-4">
              <!-- Mobile nav items, ordered by importance -->
              <li>
                <a href="manage-users.php" class="flex items-center <?php echo ($activePage=='manage-users.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-user text-xl mr-2"></i> Manage Users
                </a>
              </li>
              <li>
                <a href="manage-deposit.php" class="flex items-center <?php echo ($activePage=='manage-deposit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-plus-circle text-xl mr-2"></i> Add Deposit
                </a>
              </li>
              <li>
                <a href="deposit_mark.php" class="flex items-center <?php echo ($activePage=='deposit_mark.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-wallet-alt text-xl mr-2"></i> View Deposit
                </a>
              </li>
              <li>
                <a href="manage-transaction.php" class="flex items-center <?php echo ($activePage=='manage-transaction.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-credit-card text-xl mr-2"></i> View Transaction
                </a>
              </li>
              <li>
                <a href="manage-wallet.php" class="flex items-center <?php echo ($activePage=='manage-wallet.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-upload text-xl mr-2"></i> Wallet Upload
                </a>
              </li>
              <li>
                <a href="manage-profit.php" class="flex items-center <?php echo ($activePage=='manage-profit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-dollar text-xl mr-2"></i> Add Profit
                </a>
              </li>
              <li>
                <a href="manage-withdraw.php" class="flex items-center <?php echo ($activePage=='manage-withdraw.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-bank text-xl mr-2"></i> View Withdrawal
                </a>
              </li>
              <li>
                <a href="manage-traders.php" class="flex items-center <?php echo ($activePage=='manage-traders.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-group text-xl mr-2"></i> Manage Traders
                </a>
              </li>
              <li>
                <a href="manage-upgrade.php" class="flex items-center <?php echo ($activePage=='manage-upgrade.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-trending-up text-xl mr-2"></i> Upgrade Client Account
                </a>
              </li>
              <li>
                <a href="manage-id.php" class="flex items-center <?php echo ($activePage=='manage-id.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-id-card text-xl mr-2"></i> KYC
                </a>
              </li>
              <li>
                <a href="manage-limit.php" class="flex items-center <?php echo ($activePage=='manage-limit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-slider-alt text-xl mr-2"></i> Withdrawal Limits
                </a>
              </li>
              <li>
                <a href="livechatupdate.php" class="flex items-center <?php echo ($activePage=='livechatupdate.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-chat text-xl mr-2"></i> Livechat Update
                </a>
              </li>
              <li>
                <a href="change-password.php" class="flex items-center <?php echo ($activePage=='change-password.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-key text-xl mr-2"></i> Change Password/MTC Code
                </a>
              </li>
              <li>
                <a href="logout.php" class="flex items-center <?php echo ($activePage=='logout.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                  <i class="bx bx-log-out text-xl mr-2"></i> Logout
                </a>
              </li>
            </ul>
          </nav>
        </div>
      </div>
      <div class="flex-shrink-0 w-14"></div>
    </div>
    
    <!-- Desktop Sidebar -->
    <aside class="hidden md:block md:w-64 bg-white shadow-md">
      <div class="p-6">
        <a href="index.php" class="block mb-8">
          <img src="assetss/images/logos/dark-logo.svg" alt="Logo" class="w-48">
        </a>
        <nav>
          <ul class="space-y-4">
            <!-- Reordered nav items for desktop with active highlighting -->
            <li>
              <a href="manage-users.php" class="flex items-center <?php echo ($activePage=='manage-users.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-user text-xl mr-2"></i> Manage Users
              </a>
            </li>
            <li>
              <a href="manage-deposit.php" class="flex items-center <?php echo ($activePage=='manage-deposit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-plus-circle text-xl mr-2"></i> Add Deposit
              </a>
            </li>
            <li>
              <a href="deposit_mark.php" class="flex items-center <?php echo ($activePage=='deposit_mark.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-wallet-alt text-xl mr-2"></i> View Deposit
              </a>
            </li>
            <li>
              <a href="manage-transaction.php" class="flex items-center <?php echo ($activePage=='manage-transaction.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-credit-card text-xl mr-2"></i> View Transaction
              </a>
            </li>
            <li>
              <a href="manage-wallet.php" class="flex items-center <?php echo ($activePage=='manage-wallet.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-upload text-xl mr-2"></i> Wallet Upload
              </a>
            </li>
            <li>
              <a href="manage-profit.php" class="flex items-center <?php echo ($activePage=='manage-profit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-dollar text-xl mr-2"></i> Add Profit
              </a>
            </li>
            <li>
              <a href="manage-withdraw.php" class="flex items-center <?php echo ($activePage=='manage-withdraw.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-bank text-xl mr-2"></i> View Withdrawal
              </a>
            </li>
            <li>
              <a href="manage-traders.php" class="flex items-center <?php echo ($activePage=='manage-traders.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-group text-xl mr-2"></i> Manage Traders
              </a>
            </li>
            <li>
              <a href="manage-upgrade.php" class="flex items-center <?php echo ($activePage=='manage-upgrade.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-trending-up text-xl mr-2"></i> Upgrade Client Account
              </a>
            </li>
            <li>
              <a href="manage-id.php" class="flex items-center <?php echo ($activePage=='manage-id.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-id-card text-xl mr-2"></i> KYC
              </a>
            </li>
            <li>
              <a href="manage-limit.php" class="flex items-center <?php echo ($activePage=='manage-limit.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-slider-alt text-xl mr-2"></i> Withdrawal Limits
              </a>
            </li>
            <li>
              <a href="livechatupdate.php" class="flex items-center <?php echo ($activePage=='livechatupdate.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-chat text-xl mr-2"></i> Livechat Update
              </a>
            </li>
            <li>
              <a href="change-password.php" class="flex items-center <?php echo ($activePage=='change-password.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-key text-xl mr-2"></i> Change Password/MTC Code
              </a>
            </li>
            <li>
              <a href="support.php" class="flex items-center <?php echo ($activePage=='support.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-envelope text-xl mr-2"></i> Send Email
              </a>
            </li>
            <li>
              <a href="logout.php" class="flex items-center <?php echo ($activePage=='logout.php')?'text-blue-500 font-bold':'text-gray-700'; ?> hover:text-blue-500">
                <i class="bx bx-log-out text-xl mr-2"></i> Logout
              </a>
            </li>
          </ul>
        </nav>
      </div>
    </aside>
    
    <!-- Main Content Area -->
    <div class="flex-1 flex flex-col">
      <!-- Header (Full-width, left aligned) -->
      <header class="bg-white shadow-md w-full">
        <div class="flex items-center px-4 py-4">
          <button @click="sidebarOpen = true" class="md:hidden text-gray-500 hover:text-gray-700 focus:outline-none">
            <i class='bx bx-menu text-3xl'></i>
          </button>
          <h1 class="text-2xl font-bold text-gray-800 ml-4">Manage Users</h1>
          <!-- Optionally, you can move the logout button to the sidebar -->
          <a href="logout.php" class="ml-auto bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded hidden md:block">Logout</a>
        </div>
      </header>

      <main class="flex-1 p-6 overflow-y-auto">
        <!-- Action Link -->
        <div class="mb-4">
          <a href="connwall.php" class="inline-block bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">View Connected Wallets</a>
        </div>
        <!-- User Table -->
        <div class="bg-white shadow rounded-lg overflow-x-auto">
          <div class="p-4 border-b">
            <h2 class="text-xl font-semibold text-gray-700">All User Details</h2>
          </div>
          <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
              <tr>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Sno.</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">UserID</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Full Name</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Contact No.</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Password</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Deposit</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Country</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Account Type</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Currency</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Social Media</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Username</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Gender</th>
              </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
              <?php 
                $ret = mysqli_query($con, "SELECT * FROM users");
                $cnt = 1;
                while($row = mysqli_fetch_array($ret)) {
              ?>
              <tr>
                <td class="px-4 py-2">
                  <div class="flex space-x-2">
                    <a href="update-profile.php?userid=<?php echo $row['userid'];?>" title="Edit Profile">
                      <button class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-2 rounded">
                        <i class='bx bx-edit text-xl'></i>
                      </button>
                    </a>
                    <a href="manage-users.php?id=<?php echo $row['id'];?>" title="Delete" onclick="return confirm('Do you really want to delete?');">
                      <button class="bg-red-500 hover:bg-red-600 text-white px-3 py-2 rounded">
                        <i class='bx bx-trash text-xl'></i>
                      </button>
                    </a>
                  </div>
                </td>
                <td class="px-4 py-2"><?php echo $cnt; ?></td>
                <td class="px-4 py-2"><?php echo $row['userid']; ?></td>
                <td class="px-4 py-2"><?php echo $row['fullname']; ?></td>
                <td class="px-4 py-2"><?php echo $row['email']; ?></td>
                <td class="px-4 py-2"><?php echo $row['phone']; ?></td>
                <td class="px-4 py-2"><?php echo $row['password']; ?></td>
                <td class="px-4 py-2"><?php echo $row['deposit']; ?></td>
                <td class="px-4 py-2"><?php echo $row['country']; ?></td>
                <td class="px-4 py-2"><?php echo $row['accounttype']; ?></td>
                <td class="px-4 py-2"><?php echo $row['status']; ?></td>
                <td class="px-4 py-2"><?php echo $row['currency']; ?></td>
                <td class="px-4 py-2"><?php echo $row['mediauser']; ?></td>
                <td class="px-4 py-2"><?php echo $row['sname']; ?></td>
                <td class="px-4 py-2"><?php echo $row['sex']; ?></td>
              </tr>
              <?php $cnt++; } ?>
            </tbody>
          </table>
        </div>

        <!-- Footer -->
        <div class="py-6 px-6 text-center">
          <p class="mb-0 text-lg">Design and Developed by <a href="#" target="_blank" class="text-blue-500 underline">Prince</a></p>
        </div>
      </main>
    </div>
  </div>

  <!-- JavaScript for Toast Auto-Dismiss -->
  <script>
    document.addEventListener("DOMContentLoaded", function(){
      var toast = document.getElementById("toast");
      if(toast) {
        setTimeout(function(){
          toast.classList.add("opacity-0");
          setTimeout(function(){ toast.remove(); }, 500);
        }, 3000);
      }
    });
  </script>
</body>
</html>
