<?php
// trader_profile.php
include 'z_db.php'; // Include the database connection file (z_db.php should set up $con)
session_start(); // Start the session to access session variables

// Ensure the user is logged in
if (!isset($_SESSION['SEshopmail']) || empty($_SESSION['SEshopmail'])) {
    header('Location: login.php'); // Redirect to login if not logged in
    exit;
}

$email = $_SESSION['SEshopmail'];

// Ensure a trader ID is provided via GET; if not, redirect to the trader list page
if (!isset($_GET['traderid']) || empty($_GET['traderid'])) {
    header('Location: traders_list.php'); // This should be a separate page listing all traders
    exit;
}

$traderId = $_GET['traderid'];

// Fetch trader details using a safely escaped query
$traderQuery = mysqli_query(
    $con,
    "SELECT * FROM traders WHERE traderid = '" . mysqli_real_escape_string($con, $traderId) . "'"
);
$trader = mysqli_fetch_assoc($traderQuery);

// If no trader is found, redirect to the traders list page
if (!$trader) {
    header('Location: traders_list.php');
    exit;
}

// Fetch the logged-in user's status (e.g., whether they've copied this trader)
$userQuery = mysqli_query(
    $con,
    "SELECT trader, social FROM users WHERE email = '" . mysqli_real_escape_string($con, $email) . "'"
);
$userRow = mysqli_fetch_assoc($userQuery);

// Use traditional ternary operators for compatibility with older PHP versions
$copiedTraderId = isset($userRow['trader']) ? $userRow['trader'] : null;
$isCopied = ($traderId == $copiedTraderId);
$socialStatus = isset($userRow['social']) ? $userRow['social'] : 'copy';

// Fetch the 5 most recent trades for this trader using an escaped query
$tradesQuery = mysqli_query(
    $con,
    "SELECT * FROM trades WHERE traderid = '" . mysqli_real_escape_string($con, $traderId) . "' ORDER BY trade_date DESC LIMIT 5"
);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trader Profile</title>
    <!-- Bootstrap CSS for styling -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- jQuery for AJAX operations -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        /* Styling for the profile header and image */
        .profile-header {
            background: #f4f1e9;
            padding: 20px;
            border-radius: 10px;
        }
        .profile-img {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #ddd;
        }
        /* Styling for statistics boxes */
        .stats-box {
            text-align: center;
            background: #512eff;
            color: #fff;
            padding: 15px;
            border-radius: 10px;
        }
        .stats-box h5 {
            margin: 0;
            font-size: 20px;
        }
        .stats-box p {
            margin: 0;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container my-5">
        <!-- Trader Profile Header Section -->
        <div class="profile-header text-center">
            <!-- Display the trader's image -->
            <img src="../admin/imgtrader/<?php echo htmlspecialchars($trader['image']); ?>" alt="Trader Image" class="profile-img">
            <!-- Display the trader's name -->
            <h3 class="mt-3"><?php echo htmlspecialchars($trader['tradername']); ?></h3>
            <!-- Display the trader's bio -->
            <p><?php echo htmlspecialchars($trader['bio']); ?></p>
            <!-- Form for the Copy/Uncopy button -->
            <form method="POST" id="copyForm" class="d-inline-block mt-3">
                <input type="hidden" name="trader_id" value="<?php echo htmlspecialchars($traderId); ?>">
                <button type="button" id="copyBtn" class="btn btn-<?php echo $isCopied ? 'danger' : 'success'; ?> btn-sm">
                    <?php echo $isCopied ? 'Copied' : 'Copy'; ?>
                </button>
            </form>
        </div>

        <!-- Trader Statistics Section -->
        <div class="row my-5">
            <div class="col-md-4">
                <div class="stats-box">
                    <h5><?php echo htmlspecialchars($trader['followers']); ?></h5>
                    <p>Followers</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stats-box">
                    <h5><?php echo htmlspecialchars($trader['total_trades']); ?></h5>
                    <p>Total Trades</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stats-box">
                    <h5><?php echo htmlspecialchars($trader['success_rate']); ?>%</h5>
                    <p>Success Rate</p>
                </div>
            </div>
        </div>

        <!-- Recent Trades Table Section -->
        <h4>Recent Trades</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Asset</th>
                    <th>Volume</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                // Loop through each trade from the result set and display the data
                if ($tradesQuery) {
                    while ($trade = mysqli_fetch_assoc($tradesQuery)) { ?>
                        <tr>
                            <!-- Format and display the trade date -->
                            <td><?php echo date('d M Y', strtotime($trade['trade_date'])); ?></td>
                            <!-- Display the asset traded -->
                            <td><?php echo htmlspecialchars($trade['asset']); ?></td>
                            <!-- Display the trade volume -->
                            <td><?php echo htmlspecialchars($trade['volume']); ?></td>
                            <!-- Display the trade status (first letter capitalized) -->
                            <td><?php echo ucfirst(htmlspecialchars($trade['status'])); ?></td>
                        </tr>
                <?php }
                } ?>
            </tbody>
        </table>
    </div>

    <!-- AJAX script for handling Copy/Uncopy functionality -->
    <script>
        $(document).ready(function () {
            $('#copyBtn').click(function () {
                const button = $(this);
                const traderId = $("input[name='trader_id']").val(); // Get trader ID from the hidden input
                // Determine the action based on the current button text (copy or uncopy)
                const action = button.text().trim() === "Copy" ? "copy" : "uncopy";

                $.ajax({
                    url: "copy_trader.php", // Backend script to process the copy/uncopy request
                    type: "POST",
                    data: {
                        trader_id: traderId,
                        action: action
                    },
                    success: function (response) {
                        // If the AJAX call returns a success status, update the button's appearance and text
                        if (response.success) {
                            if (action === "copy") {
                                button.removeClass("btn-success").addClass("btn-danger").text("Copied");
                            } else {
                                button.removeClass("btn-danger").addClass("btn-success").text("Copy");
                            }
                        } else {
                            alert("Something went wrong. Please try again.");
                        }
                    }
                });
            });
        });
    </script>
</body>
</html>
