<?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>


  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  
  
<div class="w-full mb-[12px]" style="margin-top: -10px;">
  <div class="grid lg:grid-cols-3 grid-cols-1 gap-[24px]">
    <!-- Investment Capital Card -->
    <div class="p-5 rounded-lg bg-transparent">
      <div class="flex justify-between items-center mb-5">
        <div class="flex space-x-[7px] items-center">
          <div class="icon">
            <span> 
              <img src="assets/images/icons/total-earn.svg" alt="icon">
            </span>
          </div>
          <span class="text-lg text-bgray-900 dark:text-white font-semibold">
            Investment Capital
          </span>
        </div>
        <div>
          <img src="./icons.png" alt="members" style="width: 69px; height: 60px;">
        </div>
      </div>
      <div class="flex justify-between items-end">
        <div class="flex-1">
          <p class="text-bgray-900 dark:text-white font-bold text-3xl leading-[48px]">
            <span style="background-color: green; color: white; font-weight: bold; padding: 5px; border-radius: 5px;">₱429.17</span>
          </p>
          <div class="flex items-center space-x-1">
            <span>
              <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z" fill="#22C55E"></path>
                <path opacity="0.4" d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z" fill="#22C55E"></path>
              </svg>
            </span>
            <div class="icon-box">
              <a href="./recharger.php" class="icon-link receive" title="Receive Money">
                <i class="fas fa-download"></i>
              </a>
              <span class="icon-text">Deposit</span>
            </div>
          </div>
        </div>
        <div class="w-[106px]">
          <canvas id="totalEarn" height="102" width="159" style="display: block; box-sizing: border-box; height: 68px; width: 106px;"></canvas>
        </div>
      </div>
    </div>

    <!-- Accumulative Earnings Card -->
    <div class="p-5 rounded-lg bg-transparent">
      <div class="flex justify-between items-center mb-5">
        <div class="flex space-x-[7px] items-center">
          <div class="icon">
            <span>
              <img src="assets/images/icons/total-earn.svg" alt="icon">
            </span>
          </div>
          <span class="text-lg text-gray-900 dark:text-white font-semibold">
            Accumulative Earnings
          </span>
        </div>
        <div>
          <span class="badge">Live</span>
          <style>
            .badge {
              display: inline-block;
              padding: 0.25em 0.4em;
              font-size: 75%;
              font-weight: 700;
              color: #fff;
              background-color: #28a745; /* Green background */
              border-radius: 0.25rem;
              animation: blinker 1.5s linear infinite;
            }
            @keyframes blinker {
              50% {
                opacity: 0;
              }
            }
          </style>
        </div>
      </div>
      <div class="flex justify-between items-end">
        <div class="flex-1">
          <p class="text-bgray-900 dark:text-white font-bold text-3xl leading-[48px]">
            <span style="background-color: green; color: white; font-weight: bold; padding: 5px; border-radius: 5px;">₱0.00</span>
          </p>
          <div class="flex items-center space-x-1">
            <span>
              <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z" fill="#22C55E"></path>
                <path opacity="0.4" d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z" fill="#22C55E"></path>
              </svg>
            </span>
            <script>
              var userDate = 'Sunday, March 30, 2025';
            </script>
            <div class="icon-box">
              <a href="./withdrawal.php" class="icon-link send" title="Send Money">
                <i class="fas fa-paper-plane"></i>
              </a>
              <span class="icon-text">Withdraw</span>
            </div>
            <style>
              .text-success-300 { color: green; font-weight: bold; }
              .text-bgray-700 { color: gray; }
              .dark .text-bgray-50 { color: white; }
            </style>
            <span id="change-percent" class="text-success-300 text-sm font-medium">+ 2.0%</span>
          </div>
        </div>
        <div class="w-[106px]">
          <canvas id="totalSpending" height="102" width="159" style="display: block; box-sizing: border-box; height: 68px; width: 106px;"></canvas>
        </div>
      </div>
    </div>
    
    <!-- Total Market Cap Card -->
    <div class="p-5 rounded-lg bg-transparent">
      <div class="flex justify-between items-center mb-5">
        <div id="marketCapAlert" class="flex space-x-[7px] items-center">
          <div class="icon">
            <span>
              <img src="assets/images/icons/total-earn.svg" alt="icon">
            </span>
          </div>
          <span class="text-lg text-bgray-900 dark:text-white font-semibold">
            Total Market Cap
          </span>
        </div>
        <div>
          <div class="mt-4 flex justify-around">
            <a href="https://www.coingecko.com" target="_blank">
              <img src="https://support.coingecko.com/hc/article_attachments/4499575478169" alt="CoinGecko" class="w-6 h-6">
            </a>
            <a href="https://coinmarketcap.com" target="_blank">
              <img src="https://s3-eu-west-1.amazonaws.com/tpd/logos/5900cd240000ff0005a144b5/0x0.png" alt="CoinMarketCap" class="w-6 h-6">
            </a>
            <a href="https://www.tradingview.com" target="_blank">
              <img src="https://play-lh.googleusercontent.com/Rk0JFWIBX-NuOmOb5PnHw4jh_TCpPa3aZC8GgW5i3PMMs-G__jJwI0p1eXtiEBL5rdQ" alt="TradingView" class="w-6 h-6">
            </a>
          </div>
        </div>
      </div>
      <div class="flex justify-between items-end">
        <div class="flex-1">
          <!-- The market cap value is abbreviated and font size adjusts if too long -->
          <p id="marketCapValue" style="word-break: break-all; font-size: 2rem;" class="text-bgray-900 dark:text-white font-bold text-2xl leading-8">$2.77T</p>
          <div class="flex items-center space-x-1">
            <span>
              <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z" fill="#22C55E"></path>
                <path opacity="0.4" d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z" fill="#22C55E"></path>
              </svg>
            </span>
          </div>
        </div>
        <div class="w-[106px]">
          <canvas id="totalGoal" height="102" width="159" style="display: block; box-sizing: border-box; height: 68px; width: 106px;"></canvas>
        </div>
      </div>
      <!-- Data Sources Icons Row could go here -->
    </div>

    <!-- SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
      #marketCapValue {
        color: #00ff00; /* Green text */
        font-size: 2rem;
        font-weight: bold;
        cursor: pointer;
        text-shadow: 0 0 5px #00ff00;
      }
      #marketCapAlert {
        display: none; /* This ID is used for the SweetAlert */
      }
    </style>
    <script>
      function abbreviateNumber(num) {
        if (num >= 1e12) return (num / 1e12).toFixed(2) + "T";
        if (num >= 1e9) return (num / 1e9).toFixed(2) + "B";
        if (num >= 1e6) return (num / 1e6).toFixed(2) + "M";
        if (num >= 1e3) return (num / 1e3).toFixed(2) + "K";
        return num.toString();
      }
      function formatCurrency(value) {
        return '$' + abbreviateNumber(value);
      }
      function adjustFontSize() {
        const capEl = document.getElementById('marketCapValue');
        capEl.style.fontSize = capEl.textContent.length > 12 ? '1.5rem' : '2rem';
      }
      async function fetchMarketCap() {
        try {
          const response = await fetch('https://api.coingecko.com/api/v3/global');
          if (!response.ok) throw new Error('Network error');
          const data = await response.json();
          const marketCapUSD = data.data.total_market_cap.usd;
          document.getElementById('marketCapValue').textContent = formatCurrency(marketCapUSD);
          adjustFontSize();
        } catch (error) {
          console.error('Error fetching market cap:', error);
        }
      }
      document.addEventListener('DOMContentLoaded', function() {
        const capEl = document.getElementById('marketCapValue');
        if (capEl) {
          capEl.addEventListener('click', function() {
            Swal.fire({
              title: 'Market Cap Explained',
              text: 'Market Cap is the total value of all circulating cryptocurrencies, calculated by multiplying the price by supply.',
              icon: 'info',
              confirmButtonText: 'Got it',
              background: '#1a1a1a', /* Dark background */
              color: '#00ff00', /* Green text */
              confirmButtonColor: '#008000' /* Darker green button */
            });
          });
        }
      });
      fetchMarketCap();
    </script>
  </div>
</div>
  <script>
    // Helper functions
    function abbreviateNumber(num) {
      if (num >= 1e12) return (num / 1e12).toFixed(2) + "T";
      if (num >= 1e9) return (num / 1e9).toFixed(2) + "B";
      if (num >= 1e6) return (num / 1e6).toFixed(2) + "M";
      if (num >= 1e3) return (num / 1e3).toFixed(2) + "K";
      return num.toString();
    }

    function formatCurrency(value) {
      return '$' + abbreviateNumber(parseFloat(value));
    }

    function formatPercentage(value) {
      const num = parseFloat(value);
      return (num >= 0 ? '+' : '') + num.toFixed(2) + '%';
    }

    function getPercentageClass(value) {
      return parseFloat(value) >= 0 ? 'positive' : 'negative';
    }

    function createSimpleLineChart(ctx, data, color) {
      return new Chart(ctx, {
        type: 'line',
        data: {
          labels: Array(data.length).fill(''),
          datasets: [{
            data: data,
            borderColor: color,
            borderWidth: 2,
            pointRadius: 0,
            tension: 0.1,
            fill: false
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: { legend: { display: false } },
          scales: {
            x: { display: false },
            y: { display: false }
          },
          animation: false
        }
      });
    }

    // Update Fear & Greed Index based on a given value (0-100)
    function updateFearGreedIndex(value) {
      const indicator = document.getElementById('fearGreedIndicator');
      const valueEl = document.getElementById('fearGreedValue');
      const labelEl = document.getElementById('fearGreedLabel');
      valueEl.textContent = value;
      let label = '';
      if (value < 20) label = 'Extreme Fear';
      else if (value < 40) label = 'Fear';
      else if (value < 60) label = 'Neutral';
      else if (value < 80) label = 'Greed';
      else label = 'Extreme Greed';
      labelEl.textContent = label;
      // Adjust indicator position based on value (0-100 scale)
      const meter = document.querySelector('.fear-greed-meter');
      if(meter) {
        const meterWidth = meter.offsetWidth;
        const position = (value / 100) * meterWidth;
        indicator.style.left = `${position}px`;
      }
    }

    // Initialize charts with placeholder data
    const chartData = [65, 59, 80, 81, 56, 55, 40, 45, 60, 70, 75, 72];
    const btcChartCtx = document.getElementById('btcChart').getContext('2d');
    const mcapChartCtx = document.getElementById('mcapChart').getContext('2d');
    const volumeChartCtx = document.getElementById('volumeChart').getContext('2d');
    
    createSimpleLineChart(btcChartCtx, chartData, '#22C55E');
    createSimpleLineChart(mcapChartCtx, chartData, '#22C55E');
    createSimpleLineChart(volumeChartCtx, chartData, '#22C55E');

    // Fetch API data
    async function fetchGlobalData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/global');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Update market cap
        const marketCapUSD = data.data.total_market_cap.usd;
        document.getElementById('marketCap').textContent = formatCurrency(marketCapUSD);
        
        // Update market cap change
        const marketCapChange = data.data.market_cap_change_percentage_24h_usd;
        const marketCapChangeEl = document.getElementById('marketCapChange');
        marketCapChangeEl.textContent = formatPercentage(marketCapChange);
        marketCapChangeEl.className = getPercentageClass(marketCapChange) + ' text-sm font-medium';
        
        // Update trading volume
        const volumeUSD = data.data.total_volume.usd;
        document.getElementById('tradingVolume').textContent = formatCurrency(volumeUSD);
        
        // Placeholder for volume change since API doesn't provide it directly
        document.getElementById('volumeChange').textContent = '+3.25%';
        
        // Update Fear & Greed Index (using a random value for demonstration)
        updateFearGreedIndex(Math.floor(Math.random() * 100));
        
      } catch (error) {
        console.error('Error fetching global data:', error);
      }
    }

    async function fetchBitcoinData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/coins/bitcoin?localization=false&tickers=false&market_data=true&community_data=false&developer_data=false');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Update Bitcoin price
        const price = data.market_data.current_price.usd;
        document.getElementById('btcPrice').textContent = '$' + price.toLocaleString();
        
        // Update Bitcoin price change
        const priceChange = data.market_data.price_change_percentage_24h;
        const btcChangeEl = document.getElementById('btcChange');
        btcChangeEl.textContent = formatPercentage(priceChange);
        btcChangeEl.className = getPercentageClass(priceChange) + ' text-sm font-medium';
        
      } catch (error) {
        console.error('Error fetching Bitcoin data:', error);
      }
    }

    async function fetchMarketData() {
      try {
        const response = await fetch('https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&order=market_cap_desc&per_page=25&page=1&sparkline=false&price_change_percentage=1h,24h,7d');
        if (!response.ok) throw new Error('Network error');
        
        const data = await response.json();
        
        // Populate coins table
        renderCoinsTable(data);
        
        // Populate top gainers
        renderTopGainers(data);
        
      } catch (error) {
        console.error('Error fetching market data:', error);
      }
    }

    function renderCoinsTable(coins) {
      const container = document.getElementById('coinTableContainer');
      
      const table = document.createElement('table');
      table.className = 'market-table';
      
      // Create table header
      const thead = document.createElement('thead');
      thead.innerHTML = `
        <tr>
          <th>#</th>
          <th>Name</th>
          <th>Price</th>
          <th>1h %</th>
          <th>24h %</th>
          <th>7d %</th>
          <th>Market Cap</th>
          <th>Volume(24h)</th>
        </tr>
      `;
      table.appendChild(thead);
      
      // Create table body
      const tbody = document.createElement('tbody');
      
      coins.forEach((coin, index) => {
        const tr = document.createElement('tr');
        
        tr.innerHTML = `
          <td>${index + 1}</td>
          <td>
            <div class="coin-info">
              <img src="${coin.image}" alt="${coin.name}" class="coin-icon">
              <div>
                <div>${coin.name}</div>
                <div style="color: var(--text-gray);">${coin.symbol.toUpperCase()}</div>
              </div>
            </div>
          </td>
          <td>$${coin.current_price.toLocaleString()}</td>
          <td class="${getPercentageClass(coin.price_change_percentage_1h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_1h_in_currency)}
          </td>
          <td class="${getPercentageClass(coin.price_change_percentage_24h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_24h_in_currency)}
          </td>
          <td class="${getPercentageClass(coin.price_change_percentage_7d_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_7d_in_currency)}
          </td>
          <td>${formatCurrency(coin.market_cap)}</td>
          <td>${formatCurrency(coin.total_volume)}</td>
        `;
        
        tbody.appendChild(tr);
      });
      
      table.appendChild(tbody);
      
      // Replace loading message with table
      container.innerHTML = '';
      container.appendChild(table);
      
      // Add pagination
      const pagination = document.createElement('div');
      pagination.className = 'pagination';
      pagination.innerHTML = `
        <div class="page-btn">Prev</div>
        <div class="page-btn active">1</div>
        <div class="page-btn">2</div>
        <div class="page-btn">3</div>
        <div class="page-btn">4</div>
        <div class="page-btn">5</div>
        <div class="page-btn">Next</div>
      `;
      container.appendChild(pagination);
    }

    function renderTopGainers(coins) {
      // Sort coins by 24h price change
      const gainers = [...coins]
        .sort((a, b) => b.price_change_percentage_24h_in_currency - a.price_change_percentage_24h_in_currency)
        .slice(0, 5);
      
      const container = document.getElementById('gainersContainer');
      container.innerHTML = '';
      
      gainers.forEach(coin => {
        const gainItem = document.createElement('div');
        gainItem.style.display = 'flex';
        gainItem.style.justifyContent = 'space-between';
        gainItem.style.alignItems = 'center';
        gainItem.style.padding = '10px 0';
        gainItem.style.borderBottom = '1px solid rgba(255,255,255,0.1)';
        
        gainItem.innerHTML = `
          <div class="coin-info">
            <img src="${coin.image}" alt="${coin.name}" class="coin-icon">
            <div>
              <div>${coin.name}</div>
              <div style="color: var(--text-gray);">${coin.symbol.toUpperCase()}</div>
            </div>
          </div>
          <div class="${getPercentageClass(coin.price_change_percentage_24h_in_currency)}">
            ${formatPercentage(coin.price_change_percentage_24h_in_currency)}
          </div>
        `;
        container.appendChild(gainItem);
      });
    }

    // Initialize data fetching once the page loads
    window.addEventListener('load', () => {
      fetchGlobalData();
      fetchBitcoinData();
      fetchMarketData();
    });
  </script>
  
      <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/flatpickr.js"></script>
    <script>
      // min-calender
      $("#min-calender").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        inline: true,
      });
    </script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script>
      AOS.init();
    </script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/chart.js"></script>
    <script>
      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });


      //totalEarnBar
      const ctx_bids = document
              .getElementById("totalEarnBar")
              .getContext("2d");
      const bitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const bitsData = [10, 20, 15, 50, 40, 25];
      let totalEarnBar = new Chart(ctx_bids, {
        type: "bar",
        data: {
          labels: bitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: bitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //totalSpend
      let totalSpend = document
              .getElementById("totalSpendingBar")
              .getContext("2d");
      const SpendingCharbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const SpendingCharbitsData = [10, 20, 15, 50, 40, 25];
      const totalSpendingChartBar = new Chart(totalSpend, {
        type: "bar",
        data: {
          labels: SpendingCharbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: SpendingCharbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });


      // totalGoalBar
      let totalGoalBarSelect = document.getElementById("totalGoalBar").getContext("2d");
      const totalGoalBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const totalGoalBarbitsData = [10, 20, 15, 50, 40, 25];
      const totalGoalBar = new Chart(totalGoalBarSelect, {
        type: "bar",
        data: {
          labels: totalGoalBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: totalGoalBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //monthSpendingBar
      let monthSpendingBarSelect = document
              .getElementById("monthSpendingBar")
              .getContext("2d");
      const monthSpendingBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const monthSpendingBarbitsData = [10, 20, 15, 50, 40, 25];
      const monthSpendingBar = new Chart(monthSpendingBarSelect, {
        type: "bar",
        data: {
          labels: monthSpendingBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: monthSpendingBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //revenueFlowBar
      let revenueFlowElement = document
              .getElementById("revenueFlowBar")
              .getContext("2d");
      let revenueFlowBarmonth = [
        "Jan",
        "Feb",
        "Mar",
        "April",
        "May",
        "Jun",
        "July",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec",
      ];
      let revenueDark = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueLight = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueFlow = new Chart(revenueFlowElement, {
        type: "bar",
        data: {
          labels: revenueFlowBarmonth,
          datasets: revenueLight,
        },
        options: {
          maintainAspectRatio: false,
          scales: {
            y: {
              beginAtZero: true,
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
              ticks: {
                callback(value) {
                  return `${value}% `;
                },
              },
            },
            x: {
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
            },
          },
          plugins: {
            legend: {
              display: false,
            },
          },
          // x: {
          //   stacked: true,
          // },
          // y: {
          //   stacked: true,
          // },
        },
      });


      function pieChart() {
        let pieChart = document.getElementById("pie_chart").getContext("2d");

        const data = {
          labels: [10, 20, 30],
          datasets: [
            {
              label: "My First Dataset",
              data: [15, 20, 35, 40],
              backgroundColor: ["#1A202C", "#61C660", "#F8CC4B", "#EDF2F7"],
              borderColor: ["#ffffff", "#ffffff", "#ffffff", "#1A202C"],
              hoverOffset: 18,
              borderWidth: 0,
            },
          ],
        };
        const customDatalabels = {
          id: "customDatalabels",
          afterDatasetsDraw(chart, args, pluginOptions) {
            const {
              ctx,
              data,
              chartArea: { top, bottom, left, right, width, height },
            } = chart;
            ctx.save();
            data.datasets[0].data.forEach((datapoint, index) => {
              const { x, y } = chart
                .getDatasetMeta(0)
                .data[index].tooltipPosition();
              ctx.font = "bold 12px sans-serif";
              ctx.fillStyle = data.datasets[0].borderColor[index];
              ctx.textAlign = "center";
              ctx.textBaseline = "middle";
              ctx.fillText(`${datapoint}%`, x, y);
            });
          },
        };
        const config = {
          type: "doughnut",
          data,
          options: {
            maintainAspectRatio: false,
            layout: {
              padding: {
                left: 10,
                right: 10,
                top: 10,
                bottom: 10,
              },
            },
            plugins: {
              legend: {
                display: false,
              },
            },
          },
          plugins: [customDatalabels],
        };

        let pieChartConfiig = new Chart(pieChart, config);
      }
      pieChart();

      //dark chart

      let themeToggleSwitch = document.getElementById('theme-toggle');

      //onclick
      if(themeToggleSwitch){
        themeToggleSwitch.addEventListener('click', function() {
          if(document.documentElement.classList[0]==='dark' || localStorage.theme === 'dark'){
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            revenueFlow.data.datasets=revenueDark;
            revenueFlow.options.scales.y.ticks.color='white';
            revenueFlow.options.scales.x.ticks.color='white';
            revenueFlow.options.scales.x.grid.color='#222429';
            revenueFlow.options.scales.y.grid.color='#222429';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }else{
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            revenueFlow.data.datasets=revenueLight;
            revenueFlow.options.scales.y.ticks.color='black';
            revenueFlow.options.scales.x.ticks.color='black';
            revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
            revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }
        });
      }


      //initial load
      if (localStorage.theme === 'dark' || (window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        revenueFlow.data.datasets=revenueDark;
        revenueFlow.options.scales.y.ticks.color='white';
        revenueFlow.options.scales.x.ticks.color='white';
        revenueFlow.options.scales.x.grid.color='#222429';
        revenueFlow.options.scales.y.grid.color='#222429';
      } else {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        revenueFlow.data.datasets=revenueLight;
        revenueFlow.options.scales.y.ticks.color='black';
        revenueFlow.options.scales.x.ticks.color='black';
        revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
        revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
      }
      totalEarnBar.update();
      totalSpendingChartBar.update();

      totalGoalBar.update();
      monthSpendingBar.update();
      revenueFlow.update();

    </script>


</body>
</html>
