<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ID Card Generator | marketchainx</title>
    <link rel="icon" href="https://www.marketchainx.com/favicon.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/alpinejs/3.10.3/cdn.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
</head>

<body class="bg-slate-900 text-gray-100 min-h-screen" x-data="{ showNotification: false, message: '', notificationType: '' }">
    <!-- Top Navigation Bar -->
    <nav class="bg-slate-800 border-b border-slate-700 shadow-lg">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <div class="flex items-center space-x-3">
                <img src="https://www.marketchainx.com/favicon.png" alt="marketchainx Logo" class="h-10 w-10">
                <span class="text-xl font-bold bg-gradient-to-r from-green-400 to-blue-500 bg-clip-text text-transparent">marketchainx</span>
            </div>
            <div class="flex items-center space-x-4">
                <a href="#" class="text-gray-300 hover:text-white transition-colors">
                    <i class="fas fa-home mr-1"></i> Dashboard
                </a>
                <a href="#" class="text-gray-300 hover:text-white transition-colors">
                    <i class="fas fa-user-shield mr-1"></i> Profile
                </a>
                <a href="logout.php" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md transition-colors">
                    <i class="fas fa-sign-out-alt mr-1"></i> Logout
                </a>
            </div>
        </div>
    </nav>

    <!-- Page Content -->
    <div class="container mx-auto px-4 py-8">
        <!-- Alert Notification -->
        <div x-show="showNotification" 
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0 transform -translate-y-2"
             x-transition:enter-end="opacity-100 transform translate-y-0"
             x-transition:leave="transition ease-in duration-300"
             x-transition:leave-start="opacity-100 transform translate-y-0"
             x-transition:leave-end="opacity-0 transform -translate-y-2"
             :class="notificationType === 'success' ? 'bg-green-600' : 'bg-red-600'"
             class="mb-6 rounded-lg p-4 flex items-center justify-between">
            <div class="flex items-center">
                <i :class="notificationType === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-circle'" class="mr-3 text-xl"></i>
                <span x-text="message"></span>
            </div>
            <button @click="showNotification = false" class="text-white hover:text-gray-200">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <!-- Security Notice -->
        <div class="mb-6 bg-yellow-600 bg-opacity-20 border-l-4 border-yellow-500 text-yellow-100 p-4 rounded-r-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-shield-alt text-yellow-400 text-xl"></i>
                </div>
                <div class="ml-3">
                    <h3 class="text-lg font-medium text-yellow-300">Security Notice</h3>
                    <p class="mt-1">This ID card generator is secured with end-to-end encryption. Your personal information is protected.</p>
                </div>
            </div>
        </div>

        <!-- ID Card Generator Form -->
        <div class="max-w-xl mx-auto">
            <div class="bg-slate-800 rounded-xl shadow-2xl overflow-hidden">
                <div class="p-6 border-b border-slate-700">
                    <h2 class="text-2xl font-bold text-center bg-gradient-to-r from-green-400 to-blue-500 bg-clip-text text-transparent">ID Card Generator</h2>
                </div>

                <form id="idCardForm" action="idcard.php" method="POST" enctype="multipart/form-data" class="p-6 space-y-6">
                    <!-- Special Number Field -->
                    <div class="space-y-2">
                        <label for="special_number" class="block text-sm font-medium text-gray-300">
                            <i class="fas fa-hashtag mr-1 text-blue-400"></i> Special Number
                        </label>
                        <div class="relative rounded-md shadow-sm">
                            <input type="text" id="special_number" name="special_number" required
                                class="bg-slate-900 text-white placeholder-gray-400 block w-full pr-10 border-slate-600 rounded-md focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                placeholder="Enter your special number">
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                <i class="fas fa-fingerprint text-gray-400"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Image Upload -->
                    <div class="space-y-2">
                        <label for="image" class="block text-sm font-medium text-gray-300">
                            <i class="fas fa-camera mr-1 text-blue-400"></i> Upload Picture
                        </label>
                        <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-600 border-dashed rounded-md" id="dropzone">
                            <div class="space-y-1 text-center" id="preview-container">
                                <div id="preview-area" class="flex flex-col items-center">
                                    <i class="fas fa-cloud-upload-alt text-gray-400 text-3xl mb-3"></i>
                                    <p class="text-sm text-gray-400">
                                        <span class="font-medium text-blue-400 hover:text-blue-500">Click to upload</span> or drag and drop
                                    </p>
                                    <p class="text-xs text-gray-400">PNG, JPG, JPEG, WEBP or SVG (Max 2MB)</p>
                                </div>
                                <div id="image-preview" class="hidden mt-2">
                                    <img src="#" alt="Preview" class="h-40 w-40 object-cover rounded-md mx-auto">
                                    <button type="button" id="remove-image" class="mt-2 px-3 py-1 text-xs text-red-500 hover:text-red-700">
                                        <i class="fas fa-times mr-1"></i> Remove
                                    </button>
                                </div>
                            </div>
                            <input id="image" name="image" type="file" accept=".png,.jpg,.jpeg,.webp,.svg" class="hidden">
                        </div>
                    </div>

                    <!-- Hidden Fields and Email -->
                    <input type="hidden" name="bonus" value="0">
                    <div class="space-y-2">
                        <label for="email" class="block text-sm font-medium text-gray-300">
                            <i class="fas fa-envelope mr-1 text-blue-400"></i> Email
                        </label>
                        <div class="relative rounded-md shadow-sm">
                            <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($SEshopmail); ?>" readonly
                                class="bg-slate-900 text-green-400 block w-full pr-10 border-slate-600 rounded-md focus:ring-blue-500 focus:border-blue-500 sm:text-sm font-semibold opacity-70">
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                <i class="fas fa-lock text-gray-400"></i>
                            </div>
                        </div>
                        <p class="text-xs text-gray-500">Your email is secure and cannot be changed</p>
                    </div>

                    <!-- Submit Button -->
                    <div>
                        <button type="submit" id="submit-button" 
                            class="w-full flex justify-center py-3 px-4 rounded-md shadow-sm text-sm font-medium text-black bg-yellow-400 hover:bg-yellow-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 transition-colors">
                            <i class="fas fa-id-card mr-2"></i> Generate ID Card
                        </button>
                    </div>
                </form>
            </div>

            <!-- Security Features -->
            <div class="mt-6 grid grid-cols-2 gap-4 text-center">
                <div class="bg-slate-800 rounded-lg p-4">
                    <i class="fas fa-lock text-blue-400 text-2xl mb-2"></i>
                    <h3 class="text-sm font-medium">End-to-End Encryption</h3>
                </div>
                <div class="bg-slate-800 rounded-lg p-4">
                    <i class="fas fa-shield-alt text-green-400 text-2xl mb-2"></i>
                    <h3 class="text-sm font-medium">GDPR Compliant</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-slate-800 border-t border-slate-700 py-4 mt-8">
        <div class="container mx-auto px-4 text-center text-gray-400 text-sm">
            <p>&copy; <?php echo date('Y'); ?> marketchainx. All rights reserved.</p>
        </div>
    </footer>

    <script>
        // Initialize Alpine.js component with PHP notification data
        document.addEventListener('DOMContentLoaded', function() {
            // Check if PHP session notification exists
            <?php if (isset($_SESSION['notification_message'])): ?>
                window.Alpine.store('notification', {
                    message: '<?php echo $_SESSION['notification_message']; ?>',
                    type: '<?php echo $_SESSION['notification_color'] == 'green' ? 'success' : 'error'; ?>'
                });
                
                // Set Alpine.js data
                document.querySelector('body').__x.$data.showNotification = true;
                document.querySelector('body').__x.$data.message = '<?php echo $_SESSION['notification_message']; ?>';
                document.querySelector('body').__x.$data.notificationType = '<?php echo $_SESSION['notification_color'] == 'green' ? 'success' : 'error'; ?>';
                
                <?php 
                // Clear the notification
                unset($_SESSION['notification_message']);
                unset($_SESSION['notification_color']);
                ?>
            <?php endif; ?>
        });

        // Image Upload Preview
        const dropzone = document.getElementById('dropzone');
        const fileInput = document.getElementById('image');
        const previewArea = document.getElementById('preview-area');
        const imagePreview = document.getElementById('image-preview');
        const previewImg = imagePreview.querySelector('img');
        const removeButton = document.getElementById('remove-image');

        dropzone.addEventListener('click', () => fileInput.click());
        
        dropzone.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropzone.classList.add('border-blue-500');
        });
        
        dropzone.addEventListener('dragleave', () => {
            dropzone.classList.remove('border-blue-500');
        });
        
        dropzone.addEventListener('drop', (e) => {
            e.preventDefault();
            dropzone.classList.remove('border-blue-500');
            
            if (e.dataTransfer.files.length) {
                fileInput.files = e.dataTransfer.files;
                updatePreview(e.dataTransfer.files[0]);
            }
        });
        
        fileInput.addEventListener('change', (e) => {
            if (fileInput.files.length) {
                updatePreview(fileInput.files[0]);
            }
        });
        
        removeButton.addEventListener('click', () => {
            fileInput.value = '';
            previewArea.classList.remove('hidden');
            imagePreview.classList.add('hidden');
        });
        
        function updatePreview(file) {
            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();
                
                reader.onload = (e) => {
                    previewImg.src = e.target.result;
                    previewArea.classList.add('hidden');
                    imagePreview.classList.remove('hidden');
                };
                
                reader.readAsDataURL(file);
            }
        }

        // Form Validation
        const form = document.getElementById('idCardForm');
        const specialNumberInput = document.getElementById('special_number');
        const submitButton = document.getElementById('submit-button');

        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Basic validation
            let isValid = true;
            let errorMessage = '';
            
            if (!specialNumberInput.value.trim()) {
                isValid = false;
                errorMessage = 'Special number is required';
                specialNumberInput.classList.add('border-red-500');
            } else {
                specialNumberInput.classList.remove('border-red-500');
            }
            
            if (!fileInput.files.length) {
                isValid = false;
                errorMessage = errorMessage ? 'Please fill all required fields' : 'Please select an image';
                dropzone.classList.add('border-red-500');
            } else {
                dropzone.classList.remove('border-red-500');
                
                // Check file size (max 2MB)
                const fileSize = fileInput.files[0].size / 1024 / 1024; // size in MB
                if (fileSize > 2) {
                    isValid = false;
                    errorMessage = 'Image size must be less than 2MB';
                    dropzone.classList.add('border-red-500');
                }
            }
            
            if (isValid) {
                // Show loading state
                submitButton.disabled = true;
                submitButton.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Processing...';
                
                // Submit form
                setTimeout(() => {
                    form.submit();
                }, 1000);
            } else {
                // Show error notification
                document.querySelector('body').__x.$data.showNotification = true;
                document.querySelector('body').__x.$data.message = errorMessage;
                document.querySelector('body').__x.$data.notificationType = 'error';
                
                // Auto-hide after 5 seconds
                setTimeout(() => {
                    document.querySelector('body').__x.$data.showNotification = false;
                }, 5000);
            }
        });
    </script>
</body>
</html>