<?php include './includes/header.php'; ?>
<?php include './includes/navhead.php'; ?>
          <main
            class="w-full xl:px-[48px] px-6 pb-6 xl:pb-[48px] sm:pt-[156px] pt-[100px]"
          >
            <!-- write your code here-->
            <div class="2xl:flex 2xl:space-x-[48px]">
              <section class="2xl:flex-1 2xl:mb-0 mb-6">
                <div class="w-full mb-[24px] xl:flex xl:space-x-[24px]">
                  <div class="xl:w-66 w-full">
                    <div class="grid sm:grid-cols-2 sm:gap-[24px] gap-3">
                      <div class="p-5 rounded-lg bg-white dark:bg-darkblack-600">
                        <div class="flex justify-between items-center mb-5">
                          <div class="flex space-x-[7px] items-center">
                            <div class="icon">
                              <span>
                                <img
                                  src="assets/images/icons/total-earn.svg"
                                  alt="icon"
                                />
                              </span>
                            </div>
                            <span class="text-lg text-bgray-900 font-semibold dark:text-white"
                              >Total earnings</span
                            >
                          </div>
                          <div>
                            <img
                              src="assets/images/avatar/members-2.png"
                              alt="members"
                            />
                          </div>
                        </div>
                        <div class="flex justify-between items-end">
                          <div class="flex-1">
                            <p
                              class="text-bgray-900 font-bold text-3xl leading-[48px] dark:text-white"
                            >
  <?php
require('connect.php');

if (isset($_SESSION['email'])) {
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);

    // Fetch user data: trade signal percentage and currency
    $query = "SELECT percent, currency FROM users WHERE email='$SEshopmail'";
    $userquery = mysqli_query($connection, $query) or die(mysqli_error($connection));

    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_assoc($userquery);
        $tradeSignalPercentage = (float)$row['percent'];
        $currency = $row['currency'];
    } else {
        die("User not found or query failed.");
    }

    // Get total balance from all assets
    $balanceQuery = mysqli_query(
        $connection,
        "SELECT SUM(COALESCE(balance,0) + COALESCE(deposit,0) + COALESCE(bitcoin,0) + COALESCE(ethereum,0) + COALESCE(tether,0) + COALESCE(solana,0)) AS total 
         FROM users 
         WHERE email='$SEshopmail'"
    ) or die(mysqli_error($connection));

    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $totalBalance = $balanceRow['total'];

        if ($totalBalance === null || $totalBalance <= 0) {
            echo '<span style="color: orange;">$0.00</span>';
        } else {
            $totalBalanceFormatted = number_format($totalBalance, 2);
            echo '<span style="color: green;">' . $currency . ' ' . $totalBalanceFormatted . '</span>';
        }
    } else {
        die("Balance query failed.");
    }
} else {
    echo '<span style="color: red;">Email not found in session.</span>';
}

mysqli_close($connection);
?>
                                 </p>
                            <div class="flex items-center space-x-1">
                              <span>
                                <svg
                                  width="16"
                                  height="14"
                                  viewBox="0 0 16 14"
                                  fill="none"
                                  xmlns="http://www.w3.org/2000/svg"
                                >
                                  <path
                                    d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z"
                                    fill="#22C55E"
                                  />
                                  <path
                                    opacity="0.4"
                                    d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z"
                                    fill="#22C55E"
                                  />
                                </svg>
                              </span>
                              <span
                                class="text-success-300 text-sm font-medium"
                              >
                                + 3.5%
                              </span>
                            </div>
                          </div>
                          <div class="w-[136px]">
                            <canvas id="totalEarnBar" height="68"></canvas>
                          </div>
                        </div>
                      </div>
                      <div class="p-5 rounded-lg bg-white dark:bg-darkblack-600">
                        <div class="flex justify-between items-center mb-5">
                          <div class="flex space-x-[7px] items-center">
                            <div class="icon">
                              <span>
                                <img
                                  src="assets/images/icons/total-earn.svg"
                                  alt="icon"
                                />
                              </span>
                            </div>
                            <span class="text-lg text-bgray-900 font-semibold dark:text-white"
                              >Bitcoin Equivalent</span
                            >
                          </div>
                          <div>
                            <img
                              src="assets/images/avatar/members-2.png"
                              alt="members"
                            />
                          </div>
                        </div>
                        <div class="flex justify-between items-end">
                          <div class="flex-1">
                            <p
                              class="text-bgray-900 font-bold text-3xl leading-[48px] dark:text-white"
                            >
<?php
require('connect.php');
if (isset($_SESSION['email'])) {
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);
    // Fetch user percent and currency
    $query = "SELECT percent, currency FROM users WHERE email='$SEshopmail'";
    $userquery = mysqli_query($connection, $query) or die(mysqli_error($connection));
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_assoc($userquery);
        $tradeSignalPercentage = (float)$row['percent'];
        $userCurrencyRaw = trim($row['currency']);
        
        // Currency code mapping - maps from both symbols and codes to valid CoinGecko codes
        $currencyCodeMap = [
            // Common currency codes
            'USD' => 'usd', 'EUR' => 'eur', 'GBP' => 'gbp', 'JPY' => 'jpy',
            'AUD' => 'aud', 'CAD' => 'cad', 'CHF' => 'chf', 'CNY' => 'cny',
            'INR' => 'inr', 'BRL' => 'brl', 'PHP' => 'php', 'ZAR' => 'zar',
            'MXN' => 'mxn', 'NGN' => 'ngn',
            
            // Common symbols that might be stored in the database
            '$' => 'usd', '€' => 'eur', '£' => 'gbp', '¥' => 'jpy',
            'R' => 'zar', '₱' => 'php', '₦' => 'ngn', '₹' => 'inr',
            
            // Lowercase versions
            'usd' => 'usd', 'eur' => 'eur', 'gbp' => 'gbp', 'jpy' => 'jpy',
            'aud' => 'aud', 'cad' => 'cad', 'chf' => 'chf', 'cny' => 'cny',
            'inr' => 'inr', 'brl' => 'brl', 'php' => 'php', 'zar' => 'zar',
            'mxn' => 'mxn', 'ngn' => 'ngn'
        ];
        
        // Get the proper currency code for CoinGecko API
        if (isset($currencyCodeMap[$userCurrencyRaw])) {
            $userCurrency = $currencyCodeMap[$userCurrencyRaw];
        } else {
            // Default to USD if currency not recognized
            $userCurrency = 'usd';
            $userCurrencyRaw = 'USD';
            error_log("Currency not recognized: $userCurrencyRaw - defaulting to USD");
        }
    } else {
        die("User not found or query failed.");
    }
    
    // Fetch bitcoin balance only
    $balanceQuery = mysqli_query($connection, "SELECT bitcoin FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $btcBalance = (float)$balanceRow['bitcoin'];
        if ($btcBalance === null || $btcBalance <= 0) {
            echo '<span style="color: red;">No BTC balance available.</span>';
        } else {
            $btcBalanceFormatted = number_format($btcBalance, 8, '.', ',');
            
            // CoinGecko API call: BTC to user's currency
            $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=$userCurrency";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Add timeout to prevent hanging
            $api_response = curl_exec($ch);
            $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            if ($http_status == 200 && $api_response) {
                $price_data = json_decode($api_response, true);
                if (isset($price_data['bitcoin'][$userCurrency])) {
                    $btcToCurrencyRate = (float)$price_data['bitcoin'][$userCurrency];
                    $convertedAmount = $btcBalance * $btcToCurrencyRate;
                    
                    // Format based on currency
                    if ($userCurrency == 'jpy' || $userCurrency == 'cny') {
                        $convertedFormatted = number_format($convertedAmount, 0);
                    } else {
                        $convertedFormatted = number_format($convertedAmount, 2);
                    }
                    
                    // Currency symbols map
                    $currencySymbols = [
                        'usd' => '$',
                        'eur' => '€',
                        'gbp' => '£',
                        'zar' => 'R',
                        'mxn' => 'Mex$',
                        'cad' => 'C$',
                        'aud' => 'A$',
                        'jpy' => '¥',
                        'cny' => '¥',
                        'inr' => '₹',
                        'ngn' => '₦',
                        'php' => '₱',
                        'brl' => 'R$',
                        'chf' => 'Fr'
                        // add more if needed
                    ];
                    
                    // Choose symbol or fallback
                    $symbol = isset($currencySymbols[$userCurrency]) ? $currencySymbols[$userCurrency] : strtoupper($userCurrency) . ' ';
                    
                    // Output balance
                    echo '<div style="color: green; font-weight: bold;">';
                    echo '₿ ' . $btcBalanceFormatted . ' BTC<br>';
                    echo $symbol . $convertedFormatted . ' ' . strtoupper($userCurrency);
                    echo '</div>';
                } else {
                    echo '<span style="color: red;">Conversion rate not available for currency: ' . strtoupper($userCurrency) . '</span>';
                    error_log("CoinGecko API returned no data for currency: $userCurrency");
                }
            } else {
                // Add more detailed error logging
                $curl_error = curl_error($ch);
                echo '<span style="color: red;">Failed to fetch BTC conversion rate. HTTP Code: ' . $http_status . '</span>';
                error_log("CoinGecko API request failed. HTTP Code: $http_status, Error: $curl_error");
            }
        }
    } else {
        die("Bitcoin balance query failed.");
    }
} else {
    echo '<span style="color: red;">Email not found in session.</span>';
}
mysqli_close($connection);
?>
                            </p>
                            <div class="flex items-center space-x-1">
                              <span>
                                <svg
                                  width="16"
                                  height="14"
                                  viewBox="0 0 16 14"
                                  fill="none"
                                  xmlns="http://www.w3.org/2000/svg"
                                >
                                  <path
                                    d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z"
                                    fill="#22C55E"
                                  />
                                  <path
                                    opacity="0.4"
                                    d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z"
                                    fill="#22C55E"
                                  />
                                </svg>
                              </span>
                              <span
                                class="text-success-300 text-sm font-medium"
                              >
                                + 3.5%
                              </span>
                            </div>
                          </div>
                          <div class="w-[136px]">
                            <canvas id="totalSpendingBar" height="68"></canvas>
                          </div>
                        </div>
                      </div>
                      <div class="p-5 rounded-lg bg-white dark:bg-darkblack-600">
                        <div class="flex justify-between items-center mb-5">
                          <div class="flex space-x-[7px] items-center">
                            <div class="icon">
                              <span>
                                <img
                                  src="assets/images/icons/total-earn.svg"
                                  alt="icon"
                                />
                              </span>
                            </div>
                            <span class="text-lg text-bgray-900 font-semibold dark:text-white"
                              >Tether Equivalent</span
                            >
                          </div>
                          <div>
                            <img
                              src="assets/images/avatar/members-2.png"
                              alt="members"
                            />
                          </div>
                        </div>
                        <div class="flex justify-between items-end">
                          <div class="flex-1">
                            <p
                              class="text-bgray-900 font-bold text-3xl leading-[48px] dark:text-white"
                            >
<?php
require('connect.php');
if (isset($_SESSION['email'])) {
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);
    // Fetch user percent and currency
    $query = "SELECT percent, currency FROM users WHERE email='$SEshopmail'";
    $userquery = mysqli_query($connection, $query) or die(mysqli_error($connection));
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_assoc($userquery);
        $tradeSignalPercentage = (float)$row['percent'];
        $userCurrencyRaw = trim($row['currency']);
        
        // Currency code mapping - maps from both symbols and codes to valid CoinGecko codes
        $currencyCodeMap = [
            // Common currency codes
            'USD' => 'usd', 'EUR' => 'eur', 'GBP' => 'gbp', 'JPY' => 'jpy',
            'AUD' => 'aud', 'CAD' => 'cad', 'CHF' => 'chf', 'CNY' => 'cny',
            'INR' => 'inr', 'BRL' => 'brl', 'PHP' => 'php', 'ZAR' => 'zar',
            'MXN' => 'mxn', 'NGN' => 'ngn',
            
            // Common symbols that might be stored in the database
            '$' => 'usd', '€' => 'eur', '£' => 'gbp', '¥' => 'jpy',
            'R' => 'zar', '₱' => 'php', '₦' => 'ngn', '₹' => 'inr',
            
            // Lowercase versions
            'usd' => 'usd', 'eur' => 'eur', 'gbp' => 'gbp', 'jpy' => 'jpy',
            'aud' => 'aud', 'cad' => 'cad', 'chf' => 'chf', 'cny' => 'cny',
            'inr' => 'inr', 'brl' => 'brl', 'php' => 'php', 'zar' => 'zar',
            'mxn' => 'mxn', 'ngn' => 'ngn'
        ];
        
        // Get the proper currency code for CoinGecko API
        if (isset($currencyCodeMap[$userCurrencyRaw])) {
            $userCurrency = $currencyCodeMap[$userCurrencyRaw];
        } else {
            // Default to USD if currency not recognized
            $userCurrency = 'usd';
            $userCurrencyRaw = 'USD';
            error_log("Currency not recognized: $userCurrencyRaw - defaulting to USD");
        }
    } else {
        die("User not found or query failed.");
    }
    
    // Fetch tether balance
    $balanceQuery = mysqli_query($connection, "SELECT tether FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $usdtBalance = (float)$balanceRow['tether'];
        if ($usdtBalance === null || $usdtBalance <= 0) {
            echo '<span style="color: red;">No USDT balance available.</span>';
        } else {
            $usdtBalanceFormatted = number_format($usdtBalance, 2, '.', ',');
            
            // CoinGecko API call: Tether to user's currency
            $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=tether&vs_currencies=$userCurrency";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Add timeout to prevent hanging
            $api_response = curl_exec($ch);
            $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            if ($http_status == 200 && $api_response) {
                $price_data = json_decode($api_response, true);
                if (isset($price_data['tether'][$userCurrency])) {
                    $usdtToCurrencyRate = (float)$price_data['tether'][$userCurrency];
                    $convertedAmount = $usdtBalance * $usdtToCurrencyRate;
                    
                    // Format based on currency
                    if ($userCurrency == 'jpy' || $userCurrency == 'cny') {
                        $convertedFormatted = number_format($convertedAmount, 0);
                    } else {
                        $convertedFormatted = number_format($convertedAmount, 2);
                    }
                    
                    // Currency symbols map
                    $currencySymbols = [
                        'usd' => '$',
                        'eur' => '€',
                        'gbp' => '£',
                        'zar' => 'R',
                        'mxn' => 'Mex$',
                        'cad' => 'C$',
                        'aud' => 'A$',
                        'jpy' => '¥',
                        'cny' => '¥',
                        'inr' => '₹',
                        'ngn' => '₦',
                        'php' => '₱',
                        'brl' => 'R$',
                        'chf' => 'Fr'
                        // add more if needed
                    ];
                    
                    // Choose symbol or fallback
                    $symbol = isset($currencySymbols[$userCurrency]) ? $currencySymbols[$userCurrency] : strtoupper($userCurrency) . ' ';
                    
                    // Output balance
                    echo '<div style="color: green; font-weight: bold;">';
                    echo '₮ ' . $usdtBalanceFormatted . ' USDT<br>';
                    echo $symbol . $convertedFormatted . ' ' . strtoupper($userCurrency);
                    echo '</div>';
                } else {
                    echo '<span style="color: red;">Conversion rate not available for currency: ' . strtoupper($userCurrency) . '</span>';
                    error_log("CoinGecko API returned no data for currency: $userCurrency");
                }
            } else {
                // Add more detailed error logging
                $curl_error = curl_error($ch);
                echo '<span style="color: red;">Failed to fetch USDT conversion rate. HTTP Code: ' . $http_status . '</span>';
                error_log("CoinGecko API request failed. HTTP Code: $http_status, Error: $curl_error");
            }
        }
    } else {
        die("Tether balance query failed.");
    }
} else {
    echo '<span style="color: red;">Email not found in session.</span>';
}
mysqli_close($connection);
?>

                            </p>
                            <div class="flex items-center space-x-1">
                              <span>
                                <svg
                                  width="16"
                                  height="14"
                                  viewBox="0 0 16 14"
                                  fill="none"
                                  xmlns="http://www.w3.org/2000/svg"
                                >
                                  <path
                                    d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z"
                                    fill="#22C55E"
                                  />
                                  <path
                                    opacity="0.4"
                                    d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z"
                                    fill="#22C55E"
                                  />
                                </svg>
                              </span>
                              <span
                                class="text-success-300 text-sm font-medium"
                              >
                                + 3.5%
                              </span>
                            </div>
                          </div>
                          <div class="w-[136px]">
                            <canvas id="totalGoalBar" height="68"></canvas>
                          </div>
                        </div>
                      </div>
                      <div class="p-5 rounded-lg bg-white dark:bg-darkblack-600">
                        <div class="flex justify-between items-center mb-5">
                          <div class="flex space-x-[7px] items-center">
                            <div class="icon">
                              <span>
                                <img
                                  src="assets/images/icons/total-earn.svg"
                                  alt="icon"
                                />
                              </span>
                            </div>
                            <span class="text-lg text-bgray-900 font-semibold dark:text-white"
                              >Ethereum Equivalent</span
                            >
                          </div>
                          <div>
                            <img
                              src="assets/images/avatar/members-2.png"
                              alt="members"
                            />
                          </div>
                        </div>
                        <div class="flex justify-between items-end">
                          <div class="flex-1">
                            <p
                              class="text-bgray-900 font-bold text-3xl leading-[48px] dark:text-white"
                            >
                               <?php
require('connect.php');
if (isset($_SESSION['email'])) {
    $SEshopmail = mysqli_real_escape_string($connection, $_SESSION['email']);
    // Fetch user percent and currency
    $query = "SELECT percent, currency FROM users WHERE email='$SEshopmail'";
    $userquery = mysqli_query($connection, $query) or die(mysqli_error($connection));
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_assoc($userquery);
        $tradeSignalPercentage = (float)$row['percent'];
        $userCurrencyRaw = trim($row['currency']);
        
        // Currency code mapping - maps from both symbols and codes to valid CoinGecko codes
        $currencyCodeMap = [
            // Common currency codes
            'USD' => 'usd', 'EUR' => 'eur', 'GBP' => 'gbp', 'JPY' => 'jpy',
            'AUD' => 'aud', 'CAD' => 'cad', 'CHF' => 'chf', 'CNY' => 'cny',
            'INR' => 'inr', 'BRL' => 'brl', 'PHP' => 'php', 'ZAR' => 'zar',
            'MXN' => 'mxn', 'NGN' => 'ngn',
            
            // Common symbols that might be stored in the database
            '$' => 'usd', '€' => 'eur', '£' => 'gbp', '¥' => 'jpy',
            'R' => 'zar', '₱' => 'php', '₦' => 'ngn', '₹' => 'inr',
            
            // Lowercase versions
            'usd' => 'usd', 'eur' => 'eur', 'gbp' => 'gbp', 'jpy' => 'jpy',
            'aud' => 'aud', 'cad' => 'cad', 'chf' => 'chf', 'cny' => 'cny',
            'inr' => 'inr', 'brl' => 'brl', 'php' => 'php', 'zar' => 'zar',
            'mxn' => 'mxn', 'ngn' => 'ngn'
        ];
        
        // Get the proper currency code for CoinGecko API
        if (isset($currencyCodeMap[$userCurrencyRaw])) {
            $userCurrency = $currencyCodeMap[$userCurrencyRaw];
        } else {
            // Default to USD if currency not recognized
            $userCurrency = 'usd';
            $userCurrencyRaw = 'USD';
            error_log("Currency not recognized: $userCurrencyRaw - defaulting to USD");
        }
    } else {
        die("User not found or query failed.");
    }
    
    // Fetch ethereum balance
    $balanceQuery = mysqli_query($connection, "SELECT ethereum FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    if (mysqli_num_rows($balanceQuery) == 1) {
        $balanceRow = mysqli_fetch_assoc($balanceQuery);
        $ethBalance = (float)$balanceRow['ethereum'];
        if ($ethBalance === null || $ethBalance <= 0) {
            echo '<span style="color: red;">No ETH balance available.</span>';
        } else {
            $ethBalanceFormatted = number_format($ethBalance, 8, '.', ',');
            
            // CoinGecko API call: ETH to user's currency
            $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=ethereum&vs_currencies=$userCurrency";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Add timeout to prevent hanging
            $api_response = curl_exec($ch);
            $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            if ($http_status == 200 && $api_response) {
                $price_data = json_decode($api_response, true);
                if (isset($price_data['ethereum'][$userCurrency])) {
                    $ethToCurrencyRate = (float)$price_data['ethereum'][$userCurrency];
                    $convertedAmount = $ethBalance * $ethToCurrencyRate;
                    
                    // Format based on currency
                    if ($userCurrency == 'jpy' || $userCurrency == 'cny') {
                        $convertedFormatted = number_format($convertedAmount, 0);
                    } else {
                        $convertedFormatted = number_format($convertedAmount, 2);
                    }
                    
                    // Currency symbols map
                    $currencySymbols = [
                        'usd' => '$',
                        'eur' => '€',
                        'gbp' => '£',
                        'zar' => 'R',
                        'mxn' => 'Mex$',
                        'cad' => 'C$',
                        'aud' => 'A$',
                        'jpy' => '¥',
                        'cny' => '¥',
                        'inr' => '₹',
                        'ngn' => '₦',
                        'php' => '₱',
                        'brl' => 'R$',
                        'chf' => 'Fr'
                        // add more if needed
                    ];
                    
                    // Choose symbol or fallback
                    $symbol = isset($currencySymbols[$userCurrency]) ? $currencySymbols[$userCurrency] : strtoupper($userCurrency) . ' ';
                    
                    // Output balance
                    echo '<div style="color: green; font-weight: bold;">';
                    echo 'Ξ ' . $ethBalanceFormatted . ' ETH<br>';
                    echo $symbol . $convertedFormatted . ' ' . strtoupper($userCurrency);
                    echo '</div>';
                } else {
                    echo '<span style="color: red;">Conversion rate not available for currency: ' . strtoupper($userCurrency) . '</span>';
                    error_log("CoinGecko API returned no data for currency: $userCurrency");
                }
            } else {
                // Add more detailed error logging
                $curl_error = curl_error($ch);
                echo '<span style="color: red;">Failed to fetch ETH conversion rate. HTTP Code: ' . $http_status . '</span>';
                error_log("CoinGecko API request failed. HTTP Code: $http_status, Error: $curl_error");
            }
        }
    } else {
        die("Ethereum balance query failed.");
    }
} else {
    echo '<span style="color: red;">Email not found in session.</span>';
}
mysqli_close($connection);
?>

                   </p>
                            <div class="flex items-center space-x-1">
                              <span>
                                <svg
                                  width="16"
                                  height="14"
                                  viewBox="0 0 16 14"
                                  fill="none"
                                  xmlns="http://www.w3.org/2000/svg"
                                >
                                  <path
                                    d="M13.4318 0.522827L12.4446 0.522827L8.55575 0.522827L7.56859 0.522827C6.28227 0.522827 5.48082 1.91818 6.12896 3.02928L9.06056 8.05489C9.7037 9.1574 11.2967 9.1574 11.9398 8.05489L14.8714 3.02928C15.5196 1.91818 14.7181 0.522828 13.4318 0.522827Z"
                                    fill="#22C55E"
                                  />
                                  <path
                                    opacity="0.4"
                                    d="M2.16878 13.0485L3.15594 13.0485L7.04483 13.0485L8.03199 13.0485C9.31831 13.0485 10.1198 11.6531 9.47163 10.542L6.54002 5.5164C5.89689 4.41389 4.30389 4.41389 3.66076 5.5164L0.729153 10.542C0.0810147 11.6531 0.882466 13.0485 2.16878 13.0485Z"
                                    fill="#22C55E"
                                  />
                                </svg>
                              </span>
                              <span
                                class="text-success-300 text-sm font-medium"
                              >
                                + 3.5%
                              </span>
                            </div>
                          </div>
                          <div class="w-[136px]">
                            <canvas id="monthSpendingBar" height="68"></canvas>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                 <div class="flex-1 xl:block hidden">
                    <div class="bg-white dark:bg-darkblack-600 rounded-lg">
                      <div
                        class="flex px-[20px] py-[12px] justify-between items-center border-b border-bgray-300 dark:border-darkblack-400"
                      >
                        <h3 class="text-bgray-900 dark:text-white text-xl font-bold">
                          Trade Efficiency
                        </h3>
                        
                        
                        
                        
                        <?php
// Start a session if not already started
if (session_status() === PHP_SESSION_INACTIVE) {
    session_start();
}

// Include database connection
require('connect.php');

// Check for the session variable - using $SEshopmail directly as it seems to be your session variable
if (isset($SEshopmail)) {
    // Escape to prevent SQL injection
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail);
    
    // Fetch user data once
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    if (mysqli_num_rows($userquery) == 1) {
        $user = mysqli_fetch_array($userquery);
        
        // Define the selected value (default to 'balance' if not set)
        $selected = isset($_GET['view']) ? $_GET['view'] : 'balance';
        
        // Function to get the selected value
        function getSelectedValue($user, $selected) {
            switch ($selected) {
                case 'profit':
                    return $user['deposit'];
                case 'bonus':
                    return $user['bonus'];
                case 'balance':
                default:
                    return $user['balance'];
            }
        }
        
        // Get the current value based on selection
        $currentValue = getSelectedValue($user, $selected);
        
        // Create a JavaScript function to handle selection changes
        echo "
        <script>
            function updateSelection(value) {
                window.location.href = '?view=' + value;
            }
        </script>";
?>

<!-- Dropdown Menu -->
<div class="date-filter relative">
    <button 
        onclick="dateFilterAction('#month-filter')" 
        type="button"
        class="flex space-x-1 items-center">
        <span class="text-base font-semibold text-bgray-900 dark:text-white">
            <?php
                // Display the appropriate label
                switch ($selected) {
                    case 'profit':
                        echo 'Profit';
                        break;
                    case 'bonus':
                        echo 'Bonus';
                        break;
                    case 'balance':
                    default:
                        echo 'Balance';
                        break;
                }
            ?>
        </span>
        <span>
            <svg
                class="stroke-bgray-900 dark:stroke-bgray-50"
                width="16"
                height="17"
                viewBox="0 0 16 17"
                fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M4 6.5L8 10.5L12 6.5"
                    stroke-width="1.5"
                    stroke-linecap="round"
                    stroke-linejoin="round" />
            </svg>
        </span>
    </button>
    <div
        id="month-filter"
        class="rounded-lg shadow-lg bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-5 overflow-hidden hidden">
        <ul>
            <li
                onclick="updateSelection('balance'); dateFilterAction('#month-filter')"
                class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold dark:text-white hover:dark:bg-darkblack-600">
                Balance
            </li>
            <li
                onclick="updateSelection('profit'); dateFilterAction('#month-filter')"
                class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold dark:text-white hover:dark:bg-darkblack-600">
                Profit
            </li>
            <li
                onclick="updateSelection('bonus'); dateFilterAction('#month-filter')"
                class="text-sm text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold dark:text-white hover:dark:bg-darkblack-600">
                Bonus
            </li>
        </ul>
    </div>
</div>

<!-- Display the value with formatting -->
<p class="text-success-300 text-lg font-bold">
    <?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['currency'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?><?php echo number_format($currentValue, 2); ?>
</p>

<?php
    } else {
        echo "<p class='text-danger'>User not found</p>";
    }
} else {
    echo "<p class='text-danger'>Email not provided</p>";
}

// Close database connection
mysqli_close($connection);
?>
                        
                        
                        
                        
                       
                      </div>
                      <div class="px-[20px] py-[12px]">
                        <div class="flex space-x-8 items-center mb-4">
                          <div class="w-[180px] relative">
                            <canvas id="pie_chart" height="168"></canvas>
                            <div
                              class="w-[34px] h-[34px] bg-[#EDF2F7] absolute z-0 rounded-full"
                              style="
                                left: calc(50% - 17px);
                                top: calc(50% - 17px);
                              "
                            ></div>
                          </div>
                          <div class="counting">
                            <div class="mb-6">
                              <div class="flex items-center space-x-[2px]">
                                
                                <span
                                  ><svg
                                    width="14"
                                    height="12"
                                    viewBox="0 0 14 12"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                  >
                                    <path
                                      fill-rule="evenodd"
                                      clip-rule="evenodd"
                                      d="M10.7749 0.558058C10.5309 0.313981 10.1351 0.313981 9.89107 0.558058L7.39107 3.05806C7.14699 3.30214 7.14699 3.69786 7.39107 3.94194C7.63514 4.18602 8.03087 4.18602 8.27495 3.94194L9.70801 2.50888V11C9.70801 11.3452 9.98783 11.625 10.333 11.625C10.6782 11.625 10.958 11.3452 10.958 11V2.50888L12.3911 3.94194C12.6351 4.18602 13.0309 4.18602 13.2749 3.94194C13.519 3.69786 13.519 3.30214 13.2749 3.05806L10.7749 0.558058Z"
                                      fill="#22C55E"
                                    />
                                    <path
                                      opacity="0.4"
                                      fill-rule="evenodd"
                                      clip-rule="evenodd"
                                      d="M3.22407 11.4419C3.46815 11.686 3.86388 11.686 4.10796 11.4419L6.60796 8.94194C6.85203 8.69786 6.85203 8.30214 6.60796 8.05806C6.36388 7.81398 5.96815 7.81398 5.72407 8.05806L4.29102 9.49112L4.29101 1C4.29101 0.654823 4.01119 0.375001 3.66602 0.375001C3.32084 0.375001 3.04102 0.654823 3.04102 1L3.04102 9.49112L1.60796 8.05806C1.36388 7.81398 0.968151 7.81398 0.724074 8.05806C0.479996 8.30214 0.479996 8.69786 0.724074 8.94194L3.22407 11.4419Z"
                                      fill="#22C55E"
                                    />
                                  </svg>
                                </span>
                              </div>
                              <p class="text-bgray-600 text-base font-medium">
                                Arrival
                              </p>
                            </div>
                            <div>
                              <div class="flex items-center space-x-[2px]">
                                <p class="text-bgray-900 dark:text-white text-lg font-bold">
<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['currency'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?><?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT * FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_array($userquery);
        
        // Output the deposit amount as plain text, no formatting
        echo $row['deposit'];
    } else {
        echo "User not found or multiple users found"; // Provide appropriate error message if user not found or multiple users found
    }
} else {
    echo "Email not provided"; // Provide appropriate error message if $SEshopmail is not set
}

// Close database connection when done
mysqli_close($connection);
?>                                </p>
                                <span>
                                  <svg
                                    class="fill-bgray-900 dark:fill-bgray-50"
                                    width="14"
                                    height="12"
                                    viewBox="0 0 14 12"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                  >
                                    <path
                                      fill-rule="evenodd"
                                      clip-rule="evenodd"
                                      d="M10.7749 0.558058C10.5309 0.313981 10.1351 0.313981 9.89107 0.558058L7.39107 3.05806C7.14699 3.30214 7.14699 3.69786 7.39107 3.94194C7.63514 4.18602 8.03087 4.18602 8.27495 3.94194L9.70801 2.50888V11C9.70801 11.3452 9.98783 11.625 10.333 11.625C10.6782 11.625 10.958 11.3452 10.958 11V2.50888L12.3911 3.94194C12.6351 4.18602 13.0309 4.18602 13.2749 3.94194C13.519 3.69786 13.519 3.30214 13.2749 3.05806L10.7749 0.558058Z"
                                     
                                    />
                                    <path
                                      opacity="0.4"
                                      fill-rule="evenodd"
                                      clip-rule="evenodd"
                                      d="M3.22407 11.4419C3.46815 11.686 3.86388 11.686 4.10796 11.4419L6.60796 8.94194C6.85203 8.69786 6.85203 8.30214 6.60796 8.05806C6.36388 7.81398 5.96815 7.81398 5.72407 8.05806L4.29102 9.49112L4.29101 1C4.29101 0.654823 4.01119 0.375001 3.66602 0.375001C3.32084 0.375001 3.04102 0.654823 3.04102 1L3.04102 9.49112L1.60796 8.05806C1.36388 7.81398 0.968151 7.81398 0.724074 8.05806C0.479996 8.30214 0.479996 8.69786 0.724074 8.94194L3.22407 11.4419Z"
                                      
                                    />
                                  </svg>
                                </span>
                              </div>
                              <p class="text-bgray-600 dark:text-bgray-50 text-base font-medium">
                                Capital
                              </p>
                            </div>
                          </div>
                        </div>
                        <div class="status">
                          <div class="flex justify-between items-center mb-1.5">
                            <div class="flex space-x-3 items-center">
                              <div
                                class="w-2.5 h-2.5 rounded-full bg-success-300"
                              ></div>
                              <span class="text-sm text-bgray-600 dark:text-bgray-50 font-medium"
                                >Profit</span
                              >
                            </div>
                            <p class="text-bgray-900 font-bold text-sm dark:text-bgray-50">13%</p>
                          </div>
                          <div class="flex justify-between items-center mb-1.5">
                            <div class="flex space-x-3 items-center">
                              <div
                                class="w-2.5 h-2.5 rounded-full bg-warning-300"
                              ></div>
                              <span class="text-sm text-bgray-600 dark:text-white font-medium"
                                >Capital</span
                              >
                            </div>
                            <p class="text-bgray-900 font-bold text-sm dark:text-bgray-50">28%</p>
                          </div>
                          <div class="flex justify-between items-center mb-1.5">
                            <div class="flex space-x-3 items-center">
                              <div
                                class="w-2.5 h-2.5 rounded-full bg-bgray-200"
                              ></div>
                              <span class="text-sm text-bgray-600 dark:text-white font-medium"
                                >Others</span
                              >
                            </div>
                            <p class="text-bgray-900 font-bold text-sm dark:text-bgray-50">59%</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                
                    
                    
                    <div class="flex sm:flex-row flex-col sm:items-center items-end justify-between pb-5 border-b border-bgray-300 dark:border-darkblack-400">
                      <div class="flex gap-x-4">
                        <div class="w-[60px]">
                          <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="30" cy="30" r="30" fill="#936DFF"></circle>
                            <path d="M37.9128 13.2706C38.2013 13.4189 38.2864 13.6656 38.2814 13.9739C38.2714 14.5905 38.2781 15.2088 38.2781 15.8655C38.4182 15.8655 38.5299 15.8655 38.6417 15.8655C40.1145 15.8671 41.5857 15.8671 43.0586 15.8688C43.9126 15.8705 44.2879 16.2605 44.2696 17.1121C44.2229 19.197 44.0077 21.2602 43.4005 23.2651C42.9368 24.8 42.283 26.2332 41.0787 27.3482C40.3331 28.0381 39.4523 28.4581 38.4415 28.5831C38.2514 28.6064 38.1863 28.6747 38.1463 28.8631C37.4691 32.0529 35.5742 34.1344 32.4467 35.0877C32.3116 35.1294 32.2032 35.161 32.2032 35.3494C32.2099 37.3242 32.2099 39.2991 32.2115 41.274C32.2115 41.304 32.2249 41.334 32.2399 41.394C32.345 41.399 32.4567 41.409 32.5685 41.409C33.2307 41.4107 33.8929 41.414 34.5551 41.4073C34.842 41.404 35.0538 41.5057 35.2206 41.7473C35.8878 42.7156 36.565 43.6789 37.2389 44.6422C37.3773 44.8405 37.5125 45.0721 37.3306 45.2721C37.2005 45.4138 36.9637 45.5304 36.7735 45.5321C32.4 45.5471 28.0248 45.5421 23.6513 45.5454C23.4178 45.5454 23.2109 45.5054 23.0858 45.2821C22.9524 45.0421 23.0491 44.8422 23.1892 44.6422C23.8581 43.6872 24.5287 42.7339 25.1875 41.7723C25.3677 41.5107 25.5945 41.404 25.9031 41.4073C26.6587 41.4157 27.4143 41.409 28.2033 41.409C28.21 41.274 28.22 41.1624 28.22 41.0507C28.2216 39.1908 28.2166 37.3326 28.225 35.4727C28.2266 35.2377 28.1633 35.1394 27.9214 35.0644C24.8823 34.1178 22.9974 32.0945 22.3119 28.9831C22.2502 28.7031 22.1551 28.6081 21.8598 28.5614C20.407 28.3364 19.3128 27.5315 18.4738 26.3532C17.5047 24.9916 16.9993 23.44 16.659 21.8285C16.3287 20.2636 16.1769 18.6753 16.1536 17.0754C16.1419 16.2388 16.5255 15.8655 17.3679 15.8638C18.8291 15.8621 20.2919 15.8605 21.7531 15.8605C21.8682 15.8605 21.9833 15.8605 22.1484 15.8605C22.1484 15.5655 22.1484 15.2872 22.1484 15.0089C22.1484 14.6622 22.1567 14.3156 22.1467 13.9689C22.1367 13.6606 22.2268 13.4123 22.5154 13.2656C27.6478 13.2706 32.7803 13.2706 37.9128 13.2706ZM30.2132 18.5787C29.8947 19.222 29.561 19.7753 29.3425 20.3719C29.109 21.0102 28.7154 21.2668 28.0482 21.2935C27.4177 21.3202 26.7922 21.4652 26.1116 21.5652C26.2217 21.6818 26.2901 21.7568 26.3635 21.8285C26.8972 22.3501 27.4393 22.8634 27.9581 23.3984C28.0548 23.4984 28.1165 23.69 28.1015 23.8284C28.0565 24.245 27.9631 24.655 27.8914 25.0683C27.8196 25.4933 27.7513 25.9199 27.6729 26.3999C28.4652 25.9832 29.2041 25.6083 29.9297 25.2083C30.1415 25.0916 30.3 25.1033 30.5051 25.2149C31.2307 25.6116 31.968 25.9882 32.7236 26.3832C32.7236 26.2899 32.7319 26.2282 32.7219 26.1716C32.5902 25.4066 32.4667 24.64 32.3183 23.8784C32.2749 23.6534 32.3233 23.5084 32.4884 23.355C32.9338 22.9401 33.3624 22.5051 33.8011 22.0818C33.9629 21.9251 34.1331 21.7768 34.3649 21.5668C33.4609 21.4368 32.6652 21.3135 31.8662 21.2102C31.6077 21.1768 31.4409 21.0968 31.3225 20.8335C30.9872 20.0969 30.6086 19.3736 30.2132 18.5787ZM42.2813 17.892C40.9219 17.892 39.6075 17.892 38.3014 17.892C38.3014 20.8019 38.3014 23.6834 38.3014 26.6449C38.6517 26.4965 38.9753 26.3999 39.2555 26.2315C40.1512 25.6932 40.6617 24.84 41.057 23.91C41.5991 22.6368 41.8943 21.2968 42.0745 19.9319C42.1612 19.2569 42.2112 18.5803 42.2813 17.892ZM22.1301 26.5865C22.1301 23.6717 22.1301 20.7819 22.1301 17.8854C20.8023 17.8854 19.4963 17.8854 18.1819 17.8854C18.1785 17.947 18.1719 17.987 18.1735 18.027C18.2753 19.6969 18.4988 21.3468 19.0142 22.9434C19.3278 23.9133 19.7198 24.855 20.4287 25.6199C20.8874 26.1166 21.4262 26.4749 22.1301 26.5865Z" fill="white"></path>
                          </svg>
                        </div>

                        <div class="flex-1">
                          <h4 class="text-lg font-bold text-bgray-900 dark:text-white" id="availability-label">
                           <span class="text-lg text-bgray-900 dark:text-white" >Current plan</span>:<?php
require('connect.php'); // Include your database connection details

// Ensure $SEshopmail is properly set and escape it
if (isset($SEshopmail)) {
    $SEshopmail = mysqli_real_escape_string($connection, $SEshopmail); // Escape input to prevent SQL injection
    
    // Query to fetch data
    $userquery = mysqli_query($connection, "SELECT accounttype FROM users WHERE email='$SEshopmail'") or die(mysqli_error($connection));
    
    // Check if a single user is found
    if (mysqli_num_rows($userquery) == 1) {
        $row = mysqli_fetch_assoc($userquery);
        
        // Output the account type with green text
        echo '<span style="color: green;">' . htmlspecialchars($row['accounttype']) . '</span>';
    } else {
        echo '<span style="color: red;">User not found or multiple users found</span>'; // Error message in red
    }
} else {
    echo '<span style="color: red;">Email not provided</span>'; // Error message in red
}

// Close database connection when done
mysqli_close($connection);
?>

                          </h4>
                          <p class="text-base text-bgray-500 dark:text-darkblack-300" id="availability-description">
Each new plan presents a fresh opportunity</p>
                        </div>
                      </div>

                      
                    </div>
                    <!-- List Table -->
<div class="w-full py-[20px] px-[24px] rounded-lg bg-white dark:bg-darkblack-600">
  <div class="flex flex-col space-y-5">
    <!-- Search Bar -->
    <div class="">
      <div class="lg:w-88 sm:w-70 sm:block hidden border border-transparent focus-within:border-success-300 h-full dark:bg-darkblack-500 bg-bgray-100 rounded-lg px-[18px]">
        <div class="flex w-full h-full items-center space-x-[15px]">
          <span>
            <svg class="stroke-bgray-900 dark:stroke-white" width="21" height="22" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg">
              <circle cx="9.80204" cy="10.6761" r="8.98856" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
              <path d="M16.0537 17.3945L19.5777 20.9094" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
          </span>
          <label for="listSearch" class="w-full">
            <input 
              id="cryptoSearchInput" 
              type="text"
              placeholder="Search by name, crypto, or others..."
              class="search-input w-full dark:bg-darkblack-500 bg-bgray-100 border-none px-0 focus:outline-none focus:ring-0 text-sm placeholder:text-sm text-bgray-600 tracking-wide placeholder:font-medium placeholder:text-bgray-500"
            />
          </label>
        </div>
      </div>
      <div class="flex-1 h-full relative">
        <!-- Additional content if needed -->
      </div>
    </div>
    
    
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                  
                </div>
                <div class="w-full mb-[24px] flex space-x-[24px]">
                  <div
                    class="xl:w-66 w-full bg-white dark:bg-darkblack-600 flex flex-col justify-between rounded-lg px-[24px] py-3"
                  >
                    <div
                      class="flex justify-between items-center pb-2 mb-2 border-b border-bgray-300 dark:border-darkblack-400"
                    >
                      <h3 class="text-bgray-900 dark:text-white sm:text-2xl text-xl font-bold">
                        Summary
                      </h3>
                      <div class="sm:flex hidden space-x-[28px] items-center">
                        <div class="flex space-x-2 items-center">
                          <div class="w-3 h-3 bg-orange rounded-full"></div>
                          <span class="text-bgray-700 dark:text-white text-sm font-medium"
                            >Lost
                          </span>
                        </div>
                        <div class="flex space-x-2 items-center">
                          <div
                            class="w-3 h-3 bg-success-300 rounded-full"
                          ></div>
                          <span class="text-bgray-700 dark:text-white text-sm font-medium"
                            >Signed
                          </span>
                        </div>
                      </div>
                      <div class="date-filter relative">
                        <button
                          onclick="dateFilterAction('#date-filter-body')"
                          type="button"
                          class="px-3 py-2 bg-bgray-100 dark:bg-darkblack-500  flex space-x-1 items-center rounded-lg overflow-hidden"
                        >
                          <span class="text-sm font-medium text-bgray-900 dark:text-white"
                            >Jan 10 - Jan 16</span
                          >
                          <span>
                            <svg
                              class="stroke-bgray-900 dark:stroke-gray-50"
                              width="16"
                              height="17"
                              viewBox="0 0 16 17"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <path
                                d="M4 6.5L8 10.5L12 6.5"
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                              />
                            </svg>
                          </span>
                        </button>
                        <div
                          id="date-filter-body"
                          class="rounded-lg shadow-lg bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-[44px] hidden overflow-hidden"
                        >
                        <ul>
                          <li
                            onclick="dateFilterAction('#date-filter-body')"
                            class="text-sm  text-bgray-90 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold hover:dark:bg-darkblack-600"
                          >
                            Jan 10 - Jan 16
                          </li>
                          <li
                            onclick="dateFilterAction('#date-filter-body')"
                            class="text-sm  text-bgray-900 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold hover:dark:bg-darkblack-600"
                          >
                            Jan 10 - Jan 16
                          </li>
                          <li
                            onclick="dateFilterAction('#date-filter-body')"
                            class="text-sm text-bgray-900 dark:text-white cursor-pointer px-5 py-2 hover:bg-bgray-100 font-semibold hover:dark:bg-darkblack-600"
                          >
                            Jan 10 - Jan 16
                          </li>
                        </ul>
                        </div>
                      </div>
                    </div>
                    <div class="w-full">
                      <canvas id="revenueFlowBar" height="255"></canvas>
                    </div>
                  </div>
                  <div class="flex-1 xl:block hidden">
                    <div class="w-full p-5 rounded-lg bg-white dark:bg-darkblack-600 h-full">
                      <div class="flex justify-between items-center">
                        <h3 class="text-xl font-bold text-bgray-900 dark:text-white">
Active Users                        </h3>
                        <div class="flex space-x-1.5 items-center">
                            <span id="counter" class="text-2xl font-bold text-bgray-900 dark:text-white">0</span>

  <script>
    (function() {
      let target = 76345;
      let current = 0;
      let el = document.getElementById("counter");
      let maxStep = 200; // Maximum number to increase or decrease each time (slower increments)
      let minStep = 50;  // Minimum step size to make the count more varied

      function randomDirection() {
        return Math.random() > 0.5 ? 1 : -1;  // Randomly decide if it's up (+1) or down (-1)
      }

      function updateCounter() {
        let direction = randomDirection(); // Decide whether to increase or decrease
        let step = Math.floor(Math.random() * (maxStep - minStep + 1)) + minStep; // Random step within range
        
        // Apply the random direction and step to the counter
        current += step * direction;
        
        // Ensure that the number doesn't go below 0 or above the target
        if (current > target) {
          current = target;
        } else if (current < 0) {
          current = 0;
        }

        // Display the current value
        el.innerText = current.toLocaleString();

        // Set a random delay between updates (slower and more natural)
        let delay = Math.random() * 500 + 500; // Delay between 500ms and 1000ms

        // Call the updateCounter function again after a random delay
        setTimeout(updateCounter, delay);
      }

      // Start the oscillating count-up and count-down behavior
      updateCounter();
    })();
  </script>
                          <div
                            class="w-[60px] h-[22px] rounded-full bg-success-400 flex justify-center items-center"
                          >
                            <div class="flex space-x-1 items-center">
                              <span>
                                <svg
                                  width="10"
                                  height="7"
                                  viewBox="0 0 10 7"
                                  fill="none"
                                  xmlns="http://www.w3.org/2000/svg"
                                >
                                  <path
                                    d="M0.5 5.89575L3.5 2.89575L5.5 4.89575L9.5 0.895752"
                                    stroke="white"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                  />
                                  <path
                                    d="M6 0.895752H9.5V4.39575"
                                    stroke="white"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                  />
                                </svg>
                              </span>
                              <span class="text-white text-xs font-medium"
                                >12,00%</span
                              >
                            </div>
                          </div>
                        </div>
                      </div>
                      <p class="text-sm text-bgray-600 dark:text-bgray-50 mb-8">
                        Compared to last month
                      </p>
                      <div class="flex flex-col space-y-8">
                        <div class="flex space-x-5 items-center">
                          <div class="w-[30px]">
                            <img
                              src="assets/images/flag/fe.png"
                              class="w-full"
                              alt="flag"
                            />
                          </div>
                         
                         
                        </div>
                        <div class="flex space-x-5 items-center">
                         
                        </div>
                        <div class="flex space-x-5 items-center">
                          <div class="w-[30px]">
                            <img
                              src="assets/images/flag/italy.png"
                              class="w-full"
                              alt="flag"
                            />
                          </div>
                         
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- List Table -->
                <div class="w-full py-[20px] px-[24px] rounded-lg bg-white dark:bg-darkblack-600">
                  <div class="flex flex-col space-y-5">
                    <div class="w-full flex h-[56px] space-x-4">
                      <div
                        class="lg:w-88 sm:w-70 sm:block hidden border border-transparent focus-within:border-success-300 h-full dark:bg-darkblack-500 bg-bgray-100 rounded-lg px-[18px]"
                      >
                        <div
                          class="flex w-full h-full items-center space-x-[15px]"
                        >
                          <span>
                            <svg
                            class="stroke-bgray-900 dark:stroke-white"
                              width="21"
                              height="22"
                              viewBox="0 0 21 22"
                              fill="none"
                              xmlns="http://www.w3.org/2000/svg"
                            >
                              <circle
                                cx="9.80204"
                                cy="10.6761"
                                r="8.98856"
                             
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                              />
                              <path
                                d="M16.0537 17.3945L19.5777 20.9094"
                                
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                              />
                            </svg>
                          </span>
                          <label for="listSearch" class="w-full">
                            <input
                              type="text"
                              id="listSearch"
                              placeholder="Search by name, email, or others..."
                              class="search-input w-full dark:bg-darkblack-500 bg-bgray-100 border-none px-0 focus:outline-none focus:ring-0 text-sm placeholder:text-sm text-bgray-600 tracking-wide placeholder:font-medium placeholder:text-bgray-500 "
                            />
                          </label>
                        </div>
                      </div>
                      <div class="flex-1 h-full relative">
                        <button
                          onclick="dateFilterAction('#table-filter')"
                          type="button"
                          class="w-full h-full flex justify-center items-center bg-bgray-100 dark:bg-darkblack-500 border border-bgray-300 dark:border-darkblack-500 rounded-lg"
                        >
                          <div class="flex space-x-3 items-center">
                            <span>
                              <svg
                                class="stroke-bgray-900 dark:stroke-success-400"
                                width="18"
                                height="17"
                                viewBox="0 0 18 17"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                              >
                                <path
                                  d="M7.55169 13.5022H1.25098"
                                
                                  stroke-width="1.5"
                                  stroke-linecap="round"
                                  stroke-linejoin="round"
                                />
                                <path
                                  d="M10.3623 3.80984H16.663"
                                
                                  stroke-width="1.5"
                                  stroke-linecap="round"
                                  stroke-linejoin="round"
                                />
                                <path
                                  fill-rule="evenodd"
                                  clip-rule="evenodd"
                                  d="M5.94797 3.75568C5.94797 2.46002 4.88981 1.40942 3.58482 1.40942C2.27984 1.40942 1.22168 2.46002 1.22168 3.75568C1.22168 5.05133 2.27984 6.10193 3.58482 6.10193C4.88981 6.10193 5.94797 5.05133 5.94797 3.75568Z"
                                 
                                  stroke-width="1.5"
                                  stroke-linecap="round"
                                  stroke-linejoin="round"
                                />
                                <path
                                  fill-rule="evenodd"
                                  clip-rule="evenodd"
                                  d="M17.2214 13.4632C17.2214 12.1675 16.1641 11.1169 14.8591 11.1169C13.5533 11.1169 12.4951 12.1675 12.4951 13.4632C12.4951 14.7589 13.5533 15.8095 14.8591 15.8095C16.1641 15.8095 17.2214 14.7589 17.2214 13.4632Z"
                                
                                  stroke-width="1.5"
                                  stroke-linecap="round"
                                  stroke-linejoin="round"
                                />
                              </svg>
                            </span>
                            <span class="text-base text-success-300 font-medium"
                              >Filters</span
                            >
                          </div>
                        </button>
                        <div
                          id="table-filter"
                          class="rounded-lg w-full shadow-lg bg-white dark:bg-darkblack-500 absolute right-0 z-10 top-[60px] overflow-hidden hidden"
                        >
                          <ul>
                            <li
                              onclick="dateFilterAction('#table-filter')"
                              class="text-sm  text-bgray-90 cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 dark:text-white font-semibold"
                            >
                              January
                            </li>
                            <li
                              onclick="dateFilterAction('#table-filter')"
                              class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 dark:text-white font-semibold"
                            >
                              February
                            </li>

                            <li
                              onclick="dateFilterAction('#table-filter')"
                              class="text-sm  text-bgray-900 cursor-pointer px-5 py-2 hover:bg-bgray-100 hover:dark:bg-darkblack-600 dark:text-white font-semibold"
                            >
                              March
                            </li>
                          </ul>
                        </div>
                      </div>
                    </div>
                   
                   
                      
                      
                      </div>
                    </div>
                  </div>
                </div>
              </section>
             
             
            </div>
            <!-- write your code here-->
          </main>
        </div>
      </div>
    </div>
    <!-- layout end -->

    <!--scripts -->
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/flatpickr.js"></script>
    <script>
      // min-calender
      $("#min-calender").flatpickr({
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        inline: true,
      });
    </script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/aos.js"></script>
    <script>
      AOS.init();
    </script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/chart.js"></script>
    <script>
      $(".card-slider").slick({
        dots: true,
        infinite: true,
        autoplay: true,
        speed: 500,
        fade: true,
        cssEase: "linear",
        arrows: false,
      });


      //totalEarnBar
      const ctx_bids = document
              .getElementById("totalEarnBar")
              .getContext("2d");
      const bitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const bitsData = [10, 20, 15, 50, 40, 25];
      let totalEarnBar = new Chart(ctx_bids, {
        type: "bar",
        data: {
          labels: bitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: bitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //totalSpend
      let totalSpend = document
              .getElementById("totalSpendingBar")
              .getContext("2d");
      const SpendingCharbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const SpendingCharbitsData = [10, 20, 15, 50, 40, 25];
      const totalSpendingChartBar = new Chart(totalSpend, {
        type: "bar",
        data: {
          labels: SpendingCharbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: SpendingCharbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });


      // totalGoalBar
      let totalGoalBarSelect = document.getElementById("totalGoalBar").getContext("2d");
      const totalGoalBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const totalGoalBarbitsData = [10, 20, 15, 50, 40, 25];
      const totalGoalBar = new Chart(totalGoalBarSelect, {
        type: "bar",
        data: {
          labels: totalGoalBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: totalGoalBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //monthSpendingBar
      let monthSpendingBarSelect = document
              .getElementById("monthSpendingBar")
              .getContext("2d");
      const monthSpendingBarbitsMonth = ["Jan", "Feb", "Mar", "Afril", "May", "Jan"];
      const monthSpendingBarbitsData = [10, 20, 15, 50, 40, 25];
      const monthSpendingBar = new Chart(monthSpendingBarSelect, {
        type: "bar",
        data: {
          labels: monthSpendingBarbitsMonth,
          datasets: [
            {
              label: "Visitor",
              data: monthSpendingBarbitsData,
              backgroundColor: [
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(34, 197, 94, 1)",
                "rgba(237, 242, 247, 1)",
                "rgba(237, 242, 247, 1)",
              ],
              borderColor: "#22C55E",
              pointRadius: 0,
              pointBackgroundColor: "#fff",
              pointBorderColor: "#22C55E",
              fill: true,
              fillColor: "#fff",
              tension: 0.4,
              borderWidth: 0,
              borderRadius: 3,
            },
          ],
        },
        options: {
          layout: {
            padding: {
              bottom: -20,
            },
          },
          maintainAspectRatio: false,
          responsive: true,
          scales: {
            x: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
            y: {
              grid: {
                display: false,
                drawBorder: false,
              },
              ticks: {
                display: false,
              },
            },
          },

          plugins: {
            legend: {
              position: "top",
              display: false,
            },
            title: {
              display: false,
              text: "Visitor: 2k",
            },
            tooltip: {
              enabled: false,
            },
          },
        },
      });

      //revenueFlowBar
      let revenueFlowElement = document
              .getElementById("revenueFlowBar")
              .getContext("2d");
      let revenueFlowBarmonth = [
        "Jan",
        "Feb",
        "Mar",
        "April",
        "May",
        "Jun",
        "July",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec",
      ];
      let revenueDark = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
            "rgba(42, 49, 60, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueLight = [
        {
          label: "Dataset 1",
          data: [65, 75, 65, 55, 75, 55, 45, 65, 75, 65, 85, 75],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(255, 120, 75, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
        {
          label: "Dataset 2",
          data: [70, 80, 70, 65, 65, 65, 60, 70, 80, 70, 80, 65],
          backgroundColor: [
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(74, 222, 128, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
            "rgba(237, 242, 247, 1)",
          ],
          borderRadius: 3,
        },
      ];
      let revenueFlow = new Chart(revenueFlowElement, {
        type: "bar",
        data: {
          labels: revenueFlowBarmonth,
          datasets: revenueLight,
        },
        options: {
          maintainAspectRatio: false,
          scales: {
            y: {
              beginAtZero: true,
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
              ticks: {
                callback(value) {
                  return `${value}% `;
                },
              },
            },
            x: {
              grid: {
                color: "rgb(243 ,246, 255 ,1)",
                borderDash: [5, 5],
                borderDashOffset: 2,
              },
              gridLines: {
                zeroLineColor: "transparent",
              },
            },
          },
          plugins: {
            legend: {
              display: false,
            },
          },
          // x: {
          //   stacked: true,
          // },
          // y: {
          //   stacked: true,
          // },
        },
      });


      function pieChart() {
        let pieChart = document.getElementById("pie_chart").getContext("2d");

        const data = {
          labels: [10, 20, 30],
          datasets: [
            {
              label: "My First Dataset",
              data: [15, 20, 35, 40],
              backgroundColor: ["#1A202C", "#61C660", "#F8CC4B", "#EDF2F7"],
              borderColor: ["#ffffff", "#ffffff", "#ffffff", "#1A202C"],
              hoverOffset: 18,
              borderWidth: 0,
            },
          ],
        };
        const customDatalabels = {
          id: "customDatalabels",
          afterDatasetsDraw(chart, args, pluginOptions) {
            const {
              ctx,
              data,
              chartArea: { top, bottom, left, right, width, height },
            } = chart;
            ctx.save();
            data.datasets[0].data.forEach((datapoint, index) => {
              const { x, y } = chart
                .getDatasetMeta(0)
                .data[index].tooltipPosition();
              ctx.font = "bold 12px sans-serif";
              ctx.fillStyle = data.datasets[0].borderColor[index];
              ctx.textAlign = "center";
              ctx.textBaseline = "middle";
              ctx.fillText(`${datapoint}%`, x, y);
            });
          },
        };
        const config = {
          type: "doughnut",
          data,
          options: {
            maintainAspectRatio: false,
            layout: {
              padding: {
                left: 10,
                right: 10,
                top: 10,
                bottom: 10,
              },
            },
            plugins: {
              legend: {
                display: false,
              },
            },
          },
          plugins: [customDatalabels],
        };

        let pieChartConfiig = new Chart(pieChart, config);
      }
      pieChart();

      //dark chart

      let themeToggleSwitch = document.getElementById('theme-toggle');

      //onclick
      if(themeToggleSwitch){
        themeToggleSwitch.addEventListener('click', function() {
          if(document.documentElement.classList[0]==='dark' || localStorage.theme === 'dark'){
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(42, 49, 60, 1)",
              "rgba(42, 49, 60, 1)",
            ];
            revenueFlow.data.datasets=revenueDark;
            revenueFlow.options.scales.y.ticks.color='white';
            revenueFlow.options.scales.x.ticks.color='white';
            revenueFlow.options.scales.x.grid.color='#222429';
            revenueFlow.options.scales.y.grid.color='#222429';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }else{
            totalEarnBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalSpendingChartBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            totalGoalBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            monthSpendingBar.data.datasets[0].backgroundColor=[
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(34, 197, 94, 1)",
              "rgba(237, 242, 247, 1)",
              "rgba(237, 242, 247, 1)",
            ];
            revenueFlow.data.datasets=revenueLight;
            revenueFlow.options.scales.y.ticks.color='black';
            revenueFlow.options.scales.x.ticks.color='black';
            revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
            revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
            totalEarnBar.update();
            totalSpendingChartBar.update();

            totalGoalBar.update();
            monthSpendingBar.update();
            revenueFlow.update();
          }
        });
      }


      //initial load
      if (localStorage.theme === 'dark' || (window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(42, 49, 60, 1)",
          "rgba(42, 49, 60, 1)",
        ];
        revenueFlow.data.datasets=revenueDark;
        revenueFlow.options.scales.y.ticks.color='white';
        revenueFlow.options.scales.x.ticks.color='white';
        revenueFlow.options.scales.x.grid.color='#222429';
        revenueFlow.options.scales.y.grid.color='#222429';
      } else {
        totalEarnBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalSpendingChartBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        totalGoalBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        monthSpendingBar.data.datasets[0].backgroundColor=[
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(34, 197, 94, 1)",
          "rgba(237, 242, 247, 1)",
          "rgba(237, 242, 247, 1)",
        ];
        revenueFlow.data.datasets=revenueLight;
        revenueFlow.options.scales.y.ticks.color='black';
        revenueFlow.options.scales.x.ticks.color='black';
        revenueFlow.options.scales.x.grid.color='rgb(243 ,246, 255 ,1)';
        revenueFlow.options.scales.y.grid.color='rgb(243 ,246, 255 ,1)';
      }
      totalEarnBar.update();
      totalSpendingChartBar.update();

      totalGoalBar.update();
      monthSpendingBar.update();
      revenueFlow.update();

    </script>



  </body>

<!--crypto.php by /3.x [XR&CO'2014], Fri, 28 Mar 2025 18:00:31 GMT -->
</html>
